/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core.env;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.Assert;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.lease.SecretLeaseContainer;
import org.springframework.vault.core.lease.domain.RequestedSecret;
import org.springframework.vault.core.lease.event.BeforeSecretLeaseRevocationEvent;
import org.springframework.vault.core.lease.event.LeaseListener;
import org.springframework.vault.core.lease.event.LeaseListenerAdapter;
import org.springframework.vault.core.lease.event.SecretLeaseCreatedEvent;
import org.springframework.vault.core.lease.event.SecretLeaseEvent;
import org.springframework.vault.core.lease.event.SecretLeaseExpiredEvent;
import org.springframework.vault.core.util.PropertyTransformer;
import org.springframework.vault.core.util.PropertyTransformers;
import org.springframework.vault.support.JsonMapFlattener;

public class LeaseAwareVaultPropertySource
extends EnumerablePropertySource<VaultOperations> {
    private static final Log logger = LogFactory.getLog(LeaseAwareVaultPropertySource.class);
    private final SecretLeaseContainer secretLeaseContainer;
    private final RequestedSecret requestedSecret;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final PropertyTransformer propertyTransformer;
    private final LeaseListener leaseListener;

    public LeaseAwareVaultPropertySource(SecretLeaseContainer secretLeaseContainer, RequestedSecret requestedSecret) {
        this(requestedSecret.getPath(), secretLeaseContainer, requestedSecret);
    }

    public LeaseAwareVaultPropertySource(String name, SecretLeaseContainer secretLeaseContainer, RequestedSecret requestedSecret) {
        this(name, secretLeaseContainer, requestedSecret, PropertyTransformers.noop());
    }

    public LeaseAwareVaultPropertySource(String name, SecretLeaseContainer secretLeaseContainer, RequestedSecret requestedSecret, PropertyTransformer propertyTransformer) {
        super(name);
        Assert.notNull((Object)secretLeaseContainer, (String)"Path name must contain at least one character");
        Assert.notNull((Object)requestedSecret, (String)"SecretLeaseContainer must not be null");
        Assert.notNull((Object)propertyTransformer, (String)"PropertyTransformer must not be null");
        this.secretLeaseContainer = secretLeaseContainer;
        this.requestedSecret = requestedSecret;
        this.propertyTransformer = propertyTransformer.andThen(PropertyTransformers.removeNullProperties());
        this.leaseListener = new LeaseListenerAdapter(){

            @Override
            public void onLeaseEvent(SecretLeaseEvent leaseEvent) {
                LeaseAwareVaultPropertySource.this.handleLeaseEvent(leaseEvent, LeaseAwareVaultPropertySource.this.properties);
            }
        };
        this.loadProperties();
    }

    private void loadProperties() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Requesting secrets from Vault at %s using %s", new Object[]{this.requestedSecret.getPath(), this.requestedSecret.getMode()}));
        }
        this.secretLeaseContainer.addLeaseListener(this.leaseListener);
        this.secretLeaseContainer.addRequestedSecret(this.requestedSecret);
    }

    public RequestedSecret getRequestedSecret() {
        return this.requestedSecret;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    protected void handleLeaseEvent(SecretLeaseEvent leaseEvent, Map<String, Object> properties) {
        if (leaseEvent.getSource() != this.getRequestedSecret()) {
            return;
        }
        if (leaseEvent instanceof SecretLeaseExpiredEvent || leaseEvent instanceof BeforeSecretLeaseRevocationEvent || leaseEvent instanceof SecretLeaseCreatedEvent) {
            properties.clear();
        }
        if (leaseEvent instanceof SecretLeaseCreatedEvent) {
            SecretLeaseCreatedEvent created = (SecretLeaseCreatedEvent)leaseEvent;
            properties.putAll(this.doTransformProperties(this.flattenMap(created.getSecrets())));
        }
    }

    protected Map<String, Object> doTransformProperties(Map<String, Object> properties) {
        return this.propertyTransformer.transformProperties(properties);
    }

    @Deprecated
    protected Map<String, String> toStringMap(Map<String, Object> data) {
        return JsonMapFlattener.flattenToStringMap(data);
    }

    protected Map<String, Object> flattenMap(Map<String, Object> data) {
        return JsonMapFlattener.flatten(data);
    }
}

