/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;

public class AuthenticationSteps {
    private static final Node<Object> HEAD = new Node();
    final List<Node<?>> steps;

    public static AuthenticationSteps just(VaultToken token) {
        Assert.notNull((Object)token, (String)"Vault token must not be null");
        return new AuthenticationSteps(new SupplierStep<VaultToken>(() -> token, HEAD));
    }

    public static AuthenticationSteps just(HttpRequest<VaultResponse> request) {
        Assert.notNull(request, (String)"HttpRequest must not be null");
        return new AuthenticationSteps(new HttpRequestNode<VaultResponse>(request, HEAD));
    }

    public static <T> Node<T> fromSupplier(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null");
        return new SupplierStep<T>(supplier, HEAD);
    }

    public static <T> Node<T> fromHttpRequest(HttpRequest<T> request) {
        Assert.notNull(request, (String)"HttpRequest must not be null");
        return new HttpRequestNode<T>(request, HEAD);
    }

    AuthenticationSteps(PathAware pathAware) {
        this.steps = AuthenticationSteps.getChain(pathAware);
    }

    static List<Node<?>> getChain(PathAware pathAware) {
        ArrayList steps = new ArrayList();
        PathAware current = pathAware;
        do {
            if (!(current instanceof Node)) continue;
            steps.add((Node)((Object)current));
        } while (current.getPrevious() instanceof PathAware && !Objects.equals(current = (PathAware)((Object)current.getPrevious()), HEAD));
        Collections.reverse(steps);
        return steps;
    }

    public static class Pair<L, R> {
        private final L left;
        private final R right;

        private Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public static <L, R> Pair<L, R> of(L left, R right) {
            return new Pair<L, R>(left, right);
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            L this$left = this.getLeft();
            L other$left = other.getLeft();
            if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                return false;
            }
            R this$right = this.getRight();
            R other$right = other.getRight();
            return !(this$right == null ? other$right != null : !this$right.equals(other$right));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            L $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            R $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : $right.hashCode());
            return result;
        }

        public String toString() {
            return "AuthenticationSteps.Pair(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
        }
    }

    static interface PathAware {
        public Node<?> getPrevious();
    }

    static final class SupplierStep<T>
    extends Node<T>
    implements PathAware {
        @NonNull
        private final Supplier<T> supplier;
        @NonNull
        private final Node<?> previous;

        public T get() {
            return this.supplier.get();
        }

        public String toString() {
            return "Supplier: " + this.supplier.toString();
        }

        @NonNull
        public Supplier<T> getSupplier() {
            return this.supplier;
        }

        @Override
        @NonNull
        public Node<?> getPrevious() {
            return this.previous;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SupplierStep)) {
                return false;
            }
            SupplierStep other = (SupplierStep)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Supplier<T> this$supplier = this.getSupplier();
            Supplier<T> other$supplier = other.getSupplier();
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            Node<?> this$previous = this.getPrevious();
            Node<?> other$previous = other.getPrevious();
            return !(this$previous == null ? other$previous != null : !this$previous.equals(other$previous));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SupplierStep;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<T> $supplier = this.getSupplier();
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            Node<?> $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
            return result;
        }

        SupplierStep(@NonNull Supplier<T> supplier, @NonNull Node<?> previous) {
            if (supplier == null) {
                throw new NullPointerException("supplier is marked @NonNull but is null");
            }
            if (previous == null) {
                throw new NullPointerException("previous is marked @NonNull but is null");
            }
            this.supplier = supplier;
            this.previous = previous;
        }
    }

    static final class OnNextStep<T>
    extends Node<T>
    implements PathAware {
        @NonNull
        private final Consumer<? super T> consumer;
        @NonNull
        private final Node<?> previous;

        T apply(T in) {
            this.consumer.accept(in);
            return in;
        }

        public String toString() {
            return "Consumer: " + this.consumer.toString();
        }

        @NonNull
        public Consumer<? super T> getConsumer() {
            return this.consumer;
        }

        @Override
        @NonNull
        public Node<?> getPrevious() {
            return this.previous;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OnNextStep)) {
                return false;
            }
            OnNextStep other = (OnNextStep)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Consumer<T> this$consumer = this.getConsumer();
            Consumer<T> other$consumer = other.getConsumer();
            if (this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer)) {
                return false;
            }
            Node<?> this$previous = this.getPrevious();
            Node<?> other$previous = other.getPrevious();
            return !(this$previous == null ? other$previous != null : !this$previous.equals(other$previous));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OnNextStep;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<T> $consumer = this.getConsumer();
            result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
            Node<?> $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
            return result;
        }

        OnNextStep(@NonNull Consumer<? super T> consumer, @NonNull Node<?> previous) {
            if (consumer == null) {
                throw new NullPointerException("consumer is marked @NonNull but is null");
            }
            if (previous == null) {
                throw new NullPointerException("previous is marked @NonNull but is null");
            }
            this.consumer = consumer;
            this.previous = previous;
        }
    }

    static final class ZipStep<L, R>
    extends Node<Pair<L, R>>
    implements PathAware {
        @NonNull
        private final Node<?> left;
        @NonNull
        private final List<Node<?>> right;

        ZipStep(Node<?> left, PathAware right) {
            this.left = left;
            this.right = AuthenticationSteps.getChain(right);
        }

        @Override
        public Node<?> getPrevious() {
            return this.left;
        }

        public String toString() {
            return "Zip";
        }

        @NonNull
        public Node<?> getLeft() {
            return this.left;
        }

        @NonNull
        public List<Node<?>> getRight() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZipStep)) {
                return false;
            }
            ZipStep other = (ZipStep)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Node<?> this$left = this.getLeft();
            Node<?> other$left = other.getLeft();
            if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                return false;
            }
            List<Node<?>> this$right = this.getRight();
            List<Node<?>> other$right = other.getRight();
            return !(this$right == null ? other$right != null : !((Object)this$right).equals(other$right));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ZipStep;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Node<?> $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            List<Node<?>> $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
            return result;
        }
    }

    static final class MapStep<I, O>
    extends Node<O>
    implements PathAware {
        @NonNull
        private final Function<? super I, ? extends O> mapper;
        @NonNull
        private final Node<?> previous;

        O apply(I in) {
            return this.mapper.apply(in);
        }

        public String toString() {
            return "Map: " + this.mapper.toString();
        }

        @NonNull
        public Function<? super I, ? extends O> getMapper() {
            return this.mapper;
        }

        @Override
        @NonNull
        public Node<?> getPrevious() {
            return this.previous;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapStep)) {
                return false;
            }
            MapStep other = (MapStep)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Function<I, O> this$mapper = this.getMapper();
            Function<I, O> other$mapper = other.getMapper();
            if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
                return false;
            }
            Node<?> this$previous = this.getPrevious();
            Node<?> other$previous = other.getPrevious();
            return !(this$previous == null ? other$previous != null : !this$previous.equals(other$previous));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapStep;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<I, O> $mapper = this.getMapper();
            result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
            Node<?> $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
            return result;
        }

        MapStep(@NonNull Function<? super I, ? extends O> mapper, @NonNull Node<?> previous) {
            if (mapper == null) {
                throw new NullPointerException("mapper is marked @NonNull but is null");
            }
            if (previous == null) {
                throw new NullPointerException("previous is marked @NonNull but is null");
            }
            this.mapper = mapper;
            this.previous = previous;
        }
    }

    static final class HttpRequestNode<T>
    extends Node<T>
    implements PathAware {
        @NonNull
        private final HttpRequest<T> definition;
        @NonNull
        private final Node<?> previous;

        public String toString() {
            return this.definition.toString();
        }

        @NonNull
        public HttpRequest<T> getDefinition() {
            return this.definition;
        }

        @Override
        @NonNull
        public Node<?> getPrevious() {
            return this.previous;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpRequestNode)) {
                return false;
            }
            HttpRequestNode other = (HttpRequestNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            HttpRequest<T> this$definition = this.getDefinition();
            HttpRequest<T> other$definition = other.getDefinition();
            if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
                return false;
            }
            Node<?> this$previous = this.getPrevious();
            Node<?> other$previous = other.getPrevious();
            return !(this$previous == null ? other$previous != null : !this$previous.equals(other$previous));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpRequestNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HttpRequest<T> $definition = this.getDefinition();
            result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
            Node<?> $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
            return result;
        }

        HttpRequestNode(@NonNull HttpRequest<T> definition, @NonNull Node<?> previous) {
            if (definition == null) {
                throw new NullPointerException("definition is marked @NonNull but is null");
            }
            if (previous == null) {
                throw new NullPointerException("previous is marked @NonNull but is null");
            }
            this.definition = definition;
            this.previous = previous;
        }
    }

    public static class HttpRequest<T> {
        final HttpMethod method;
        @Nullable
        final URI uri;
        @Nullable
        final String uriTemplate;
        @Nullable
        final String[] urlVariables;
        @Nullable
        final HttpEntity<?> entity;
        final Class<T> responseType;

        HttpRequest(HttpRequestBuilder builder, Class<T> responseType) {
            this.method = builder.method;
            this.uri = builder.uri;
            this.uriTemplate = builder.uriTemplate;
            this.urlVariables = builder.urlVariables;
            this.entity = builder.entity;
            this.responseType = responseType;
        }

        public String toString() {
            return String.format("%s %s AS %s", this.getMethod(), this.getUri() != null ? this.getUri() : this.getUriTemplate(), this.getResponseType());
        }

        HttpMethod getMethod() {
            return this.method;
        }

        @Nullable
        URI getUri() {
            return this.uri;
        }

        @Nullable
        String getUriTemplate() {
            return this.uriTemplate;
        }

        @Nullable
        String[] getUrlVariables() {
            return this.urlVariables;
        }

        @Nullable
        HttpEntity<?> getEntity() {
            return this.entity;
        }

        Class<T> getResponseType() {
            return this.responseType;
        }
    }

    public static class HttpRequestBuilder {
        HttpMethod method;
        @Nullable
        URI uri;
        @Nullable
        String uriTemplate;
        @Nullable
        String[] urlVariables;
        @Nullable
        HttpEntity<?> entity;

        public static HttpRequestBuilder get(String uriTemplate, String ... uriVariables) {
            return new HttpRequestBuilder(HttpMethod.GET, uriTemplate, uriVariables);
        }

        public static HttpRequestBuilder get(URI uri) {
            return new HttpRequestBuilder(HttpMethod.GET, uri);
        }

        public static HttpRequestBuilder post(String uriTemplate, String ... uriVariables) {
            return new HttpRequestBuilder(HttpMethod.POST, uriTemplate, uriVariables);
        }

        public static HttpRequestBuilder post(URI uri) {
            return new HttpRequestBuilder(HttpMethod.POST, uri);
        }

        private HttpRequestBuilder(HttpMethod method, URI uri) {
            this.method = method;
            this.uri = uri;
        }

        private HttpRequestBuilder(HttpMethod method, @Nullable String uriTemplate, @Nullable String[] urlVariables) {
            this.method = method;
            this.uriTemplate = uriTemplate;
            this.urlVariables = urlVariables;
        }

        private HttpRequestBuilder(HttpMethod method, @Nullable URI uri, @Nullable String uriTemplate, @Nullable String[] urlVariables, @Nullable HttpEntity<?> entity) {
            this.method = method;
            this.uri = uri;
            this.uriTemplate = uriTemplate;
            this.urlVariables = urlVariables;
            this.entity = entity;
        }

        public HttpRequestBuilder with(HttpEntity<?> httpEntity) {
            Assert.notNull(httpEntity, (String)"HttpEntity must not be null");
            return new HttpRequestBuilder(this.method, this.uri, this.uriTemplate, this.urlVariables, httpEntity);
        }

        public HttpRequestBuilder with(HttpHeaders headers) {
            Assert.notNull((Object)headers, (String)"HttpHeaders must not be null");
            return new HttpRequestBuilder(this.method, this.uri, this.uriTemplate, this.urlVariables, new HttpEntity((MultiValueMap)headers));
        }

        public <T> HttpRequest<T> as(Class<T> type) {
            Assert.notNull(type, (String)"Result type must not be null");
            return new HttpRequest<T>(this, type);
        }
    }

    public static class Node<T> {
        public <R> Node<R> map(Function<? super T, ? extends R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null");
            return new MapStep<T, R>(mappingFunction, this);
        }

        public <R> Node<Pair<T, R>> zipWith(Node<? extends R> other) {
            Assert.notNull(other, (String)"Other node must not be null");
            Assert.isInstanceOf(PathAware.class, other, (String)"Other node must be PathAware");
            return new ZipStep(this, (PathAware)((Object)other));
        }

        public Node<T> onNext(Consumer<? super T> consumerFunction) {
            Assert.notNull(consumerFunction, (String)"Consumer function must not be null");
            return new OnNextStep<T>(consumerFunction, this);
        }

        public <R> Node<R> request(HttpRequest<R> request) {
            Assert.notNull(request, (String)"HttpRequest must not be null");
            return new HttpRequestNode<R>(request, this);
        }

        public AuthenticationSteps login(String uriTemplate, String ... uriVariables) {
            Assert.hasText((String)uriTemplate, (String)"URI template must not be null or empty");
            return this.login(HttpRequestBuilder.post(uriTemplate, uriVariables).as(VaultResponse.class));
        }

        public AuthenticationSteps login(HttpRequest<VaultResponse> request) {
            Assert.notNull(request, (String)"HttpRequest must not be null");
            return new AuthenticationSteps(new HttpRequestNode<VaultResponse>(request, this));
        }

        public AuthenticationSteps login(Function<? super T, ? extends VaultToken> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null");
            return new AuthenticationSteps(new MapStep<T, VaultToken>(mappingFunction, this));
        }
    }
}

