/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.TrustManager;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITDecorator;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncDone.SyncDoneValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateTypeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueDecorator;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl.SyncInfoValue;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl.SyncInfoValueDecorator;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaIT;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.ldap.model.message.controls.SortRequestControlImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.ConnectionClosedEventListener;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.SyncReplConfiguration;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.consumer.ReplicationStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ReplicationConsumerImpl
implements ConnectionClosedEventListener,
ReplicationConsumer {
    private static final Logger CONSUMER_LOG = LoggerFactory.getLogger((String)Loggers.CONSUMER_LOG.getName());
    private SyncReplConfiguration config;
    private byte[] syncCookie;
    private LdapNetworkConnection connection;
    private SearchRequest searchRequest;
    private DirectoryService directoryService;
    private SchemaManager schemaManager;
    private volatile boolean disconnected;
    private CoreSession session;
    private static final String[] MOD_IGNORE_AT = new String[]{"entryUUID", "entryDN", "createTimestamp", "creatorsName", "entryParentId", "collectiveAttributeSubentries", "contextCSN", "nbChildren", "nbSubordinates"};
    private byte[] lastSavedCookie;
    private volatile boolean reload = false;
    private static final PresenceNode ENTRY_UUID_PRESENCE_FILTER = new PresenceNode("entryUUID");
    private Modification cookieMod;
    private Modification ridMod;
    private AttributeType adsReplCookieAT;
    private AttributeType adsDsReplicaIdAT;
    private static final Map<String, Object> UUID_LOCK_MAP = new LRUMap(1000);

    @Override
    public SyncReplConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void init(DirectoryService directoryservice) throws Exception {
        this.directoryService = directoryservice;
        this.session = this.directoryService.getAdminSession();
        this.schemaManager = directoryservice.getSchemaManager();
        this.adsReplCookieAT = this.schemaManager.lookupAttributeTypeRegistry("ads-replCookie");
        this.adsDsReplicaIdAT = this.schemaManager.lookupAttributeTypeRegistry("ads-dsReplicaId");
        DefaultAttribute cookieAttr = new DefaultAttribute(this.adsReplCookieAT);
        this.cookieMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)cookieAttr);
        DefaultAttribute ridAttr = new DefaultAttribute(this.adsDsReplicaIdAT);
        this.ridMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)ridAttr);
        this.prepareSyncSearchRequest();
    }

    public boolean connect() {
        block7: {
            String providerHost = this.config.getRemoteHost();
            int port = this.config.getRemotePort();
            try {
                if (this.connection == null) {
                    this.connection = new LdapNetworkConnection(providerHost, port);
                    this.connection.setTimeOut(-1L);
                    this.connection.setSchemaManager(this.schemaManager);
                    if (this.config.isUseTls()) {
                        this.connection.getConfig().setTrustManagers(new TrustManager[]{this.config.getTrustManager()});
                        this.connection.getConfig().setUseTls(true);
                    }
                    this.connection.addConnectionClosedEventListener((ConnectionClosedEventListener)this);
                }
                if (this.connection.connect()) {
                    CONSUMER_LOG.info("Consumer {} connected to producer {}", (Object)this.config.getReplicaId(), (Object)this.config.getProducer());
                    try {
                        this.connection.bind(this.config.getReplUserDn(), Strings.utf8ToString((byte[])this.config.getReplUserPassword()));
                        this.disconnected = false;
                        return true;
                    }
                    catch (LdapException le) {
                        CONSUMER_LOG.warn("Failed to bind to the producer {} with the given bind Dn {}", (Object)this.config.getProducer(), (Object)this.config.getReplUserDn());
                        CONSUMER_LOG.warn("", (Throwable)le);
                        this.disconnected = true;
                        break block7;
                    }
                }
                CONSUMER_LOG.warn("Consumer {} cannot connect to producer {}", (Object)this.config.getReplicaId(), (Object)this.config.getProducer());
                this.disconnected = true;
                return false;
            }
            catch (Exception e) {
                CONSUMER_LOG.error("Failed to connect to the producer {}, cause : {}", (Object)this.config.getProducer(), (Object)e.getMessage());
                this.disconnected = true;
            }
        }
        return false;
    }

    private void prepareSyncSearchRequest() throws LdapException {
        String baseDn = this.config.getBaseDn();
        this.searchRequest = new SearchRequestImpl();
        this.searchRequest.setBase(new Dn(new String[]{baseDn}));
        this.searchRequest.setFilter(this.config.getFilter());
        this.searchRequest.setSizeLimit((long)this.config.getSearchSizeLimit());
        this.searchRequest.setTimeLimit(this.config.getSearchTimeout());
        this.searchRequest.setDerefAliases(this.config.getAliasDerefMode());
        this.searchRequest.setScope(this.config.getSearchScope());
        this.searchRequest.setTypesOnly(false);
        this.searchRequest.addAttributes(this.config.getAttributes());
        if (!this.config.isChaseReferrals()) {
            this.searchRequest.addControl((Control)new ManageDsaITDecorator(this.directoryService.getLdapCodecService(), (ManageDsaIT)new ManageDsaITImpl()));
        }
        if (CONSUMER_LOG.isDebugEnabled()) {
            MDC.put((String)"Replica", (String)Integer.toString(this.config.getReplicaId()));
            CONSUMER_LOG.debug("Configuring consumer {}", (Object)this.config);
        }
    }

    private ResultCodeEnum handleSearchResultDone(SearchResultDone searchDone) {
        CONSUMER_LOG.debug("///////////////// handleSearchDone //////////////////");
        SyncDoneValue ctrl = (SyncDoneValue)searchDone.getControls().get("1.3.6.1.4.1.4203.1.9.1.3");
        if (ctrl != null && ctrl.getCookie() != null) {
            this.syncCookie = ctrl.getCookie();
            CONSUMER_LOG.debug("assigning cookie from sync done value control: " + Strings.utf8ToString((byte[])this.syncCookie));
            this.storeCookie();
        }
        CONSUMER_LOG.debug("//////////////// END handleSearchDone//////////////////////");
        this.reload = false;
        return searchDone.getLdapResult().getResultCode();
    }

    private void handleSearchReference(SearchResultReference searchRef) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSearchResultEntry(SearchResultEntry syncResult) {
        CONSUMER_LOG.debug("------------- starting handleSearchResult ------------");
        SyncStateValue syncStateCtrl = (SyncStateValue)syncResult.getControl("1.3.6.1.4.1.4203.1.9.1.2");
        try {
            Object lock;
            DefaultEntry remoteEntry = new DefaultEntry(this.schemaManager, syncResult.getEntry());
            String uuid = remoteEntry.get(this.directoryService.getAtProvider().getEntryUUID()).getString();
            Object object = lock = this.getLockFor(uuid);
            synchronized (object) {
                int rid = -1;
                if (syncStateCtrl.getCookie() != null) {
                    this.syncCookie = syncStateCtrl.getCookie();
                    rid = LdapProtocolUtils.getReplicaId(Strings.utf8ToString((byte[])this.syncCookie));
                    CONSUMER_LOG.debug("assigning the cookie from sync state value control: {}", (Object)Strings.utf8ToString((byte[])this.syncCookie));
                }
                SyncStateTypeEnum state = syncStateCtrl.getSyncStateType();
                if (CONSUMER_LOG.isDebugEnabled()) {
                    CONSUMER_LOG.debug("state name {}", (Object)state.name());
                    CONSUMER_LOG.debug("entryUUID = {}", (Object)Strings.uuidToString((byte[])syncStateCtrl.getEntryUUID()));
                }
                Dn remoteDn = remoteEntry.getDn();
                switch (state) {
                    case ADD: {
                        boolean remoteDnExist = false;
                        try {
                            remoteDnExist = this.session.exists(remoteDn);
                        }
                        catch (LdapNoSuchObjectException lnsoe) {
                            CONSUMER_LOG.error(lnsoe.getMessage());
                        }
                        if (!remoteDnExist) {
                            CONSUMER_LOG.debug("adding entry with dn {}", (Object)remoteDn);
                            CONSUMER_LOG.debug(remoteEntry.toString());
                            AddOperationContext addContext = new AddOperationContext(this.session, (Entry)remoteEntry);
                            addContext.setReplEvent(true);
                            addContext.setRid(rid);
                            OperationManager operationManager = this.directoryService.getOperationManager();
                            operationManager.add(addContext);
                            break;
                        }
                        CONSUMER_LOG.debug("updating entry in refreshOnly mode {}", (Object)remoteDn);
                        this.modify((Entry)remoteEntry, rid);
                        break;
                    }
                    case MODIFY: {
                        CONSUMER_LOG.debug("modifying entry with dn {}", (Object)remoteEntry.getDn().getName());
                        this.modify((Entry)remoteEntry, rid);
                        break;
                    }
                    case MODDN: {
                        String entryUuid = Strings.uuidToString((byte[])syncStateCtrl.getEntryUUID()).toString();
                        this.applyModDnOperation((Entry)remoteEntry, entryUuid, rid);
                        break;
                    }
                    case DELETE: {
                        CONSUMER_LOG.debug("deleting entry with dn {}", (Object)remoteEntry.getDn().getName());
                        if (!this.session.exists(remoteDn)) {
                            CONSUMER_LOG.debug("looks like entry {} was already deleted in a prior update (possibly from another provider), skipping delete", (Object)remoteDn);
                            break;
                        }
                        this.deleteRecursive(remoteEntry.getDn(), rid);
                        break;
                    }
                    case PRESENT: {
                        CONSUMER_LOG.debug("entry present {}", (Object)remoteEntry);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected sync state " + state);
                    }
                }
                if (syncStateCtrl.getCookie() != null) {
                    this.storeCookie();
                }
            }
        }
        catch (Exception e) {
            CONSUMER_LOG.error(e.getMessage(), (Throwable)e);
        }
        CONSUMER_LOG.debug("------------- Ending handleSearchResult ------------");
    }

    private void handleSyncInfo(IntermediateResponse syncInfoResp) {
        try {
            CONSUMER_LOG.debug("............... inside handleSyncInfo ...............");
            byte[] syncInfoBytes = syncInfoResp.getResponseValue();
            if (syncInfoBytes == null) {
                return;
            }
            SyncInfoValueDecorator decorator = new SyncInfoValueDecorator(this.directoryService.getLdapCodecService());
            SyncInfoValue syncInfoValue = (SyncInfoValue)decorator.decode(syncInfoBytes);
            byte[] cookie = syncInfoValue.getCookie();
            if (CONSUMER_LOG.isDebugEnabled()) {
                CONSUMER_LOG.debug("Received a SyncInfoValue from producer {} : {}", (Object)this.config.getProducer(), (Object)syncInfoValue);
            }
            int replicaId = -1;
            if (cookie != null) {
                CONSUMER_LOG.debug("setting the cookie from the sync info: " + Strings.utf8ToString((byte[])cookie));
                CONSUMER_LOG.debug("setting the cookie from the sync info: " + Strings.utf8ToString((byte[])cookie));
                this.syncCookie = cookie;
                String cookieString = Strings.utf8ToString((byte[])this.syncCookie);
                replicaId = LdapProtocolUtils.getReplicaId(cookieString);
            }
            CONSUMER_LOG.info("refreshDeletes: " + syncInfoValue.isRefreshDeletes());
            List uuidList = syncInfoValue.getSyncUUIDs();
            if (syncInfoValue.isRefreshDeletes()) {
                this.deleteEntries(uuidList, false, replicaId);
            } else {
                this.deleteEntries(uuidList, true, replicaId);
            }
            CONSUMER_LOG.info("refreshDone: " + syncInfoValue.isRefreshDone());
            this.storeCookie();
        }
        catch (Exception de) {
            CONSUMER_LOG.error("Failed to handle syncinfo message", (Throwable)de);
        }
        CONSUMER_LOG.debug(".................... END handleSyncInfo ...............");
    }

    public void connectionClosed() {
        if (CONSUMER_LOG.isDebugEnabled()) {
            MDC.put((String)"Replica", (String)Integer.toString(this.config.getReplicaId()));
            CONSUMER_LOG.debug("Consumer {} session with {} has been closed ", (Object)this.config.getReplicaId(), (Object)this.config.getProducer());
        }
        this.disconnect();
    }

    @Override
    public ReplicationStatusEnum startSync() {
        CONSUMER_LOG.debug("Starting the SyncRepl process for consumer {}", (Object)this.config.getReplicaId());
        this.readCookie();
        if (this.config.isRefreshNPersist()) {
            try {
                CONSUMER_LOG.debug("==================== Refresh And Persist ==========");
                return this.doSyncSearch(SynchronizationModeEnum.REFRESH_AND_PERSIST, this.reload);
            }
            catch (Exception e) {
                CONSUMER_LOG.error("Failed to sync with refreshAndPersist mode", (Throwable)e);
                return ReplicationStatusEnum.DISCONNECTED;
            }
        }
        return this.doRefreshOnly();
    }

    private ReplicationStatusEnum doRefreshOnly() {
        while (!this.disconnected) {
            CONSUMER_LOG.debug("==================== Refresh Only ==========");
            try {
                this.doSyncSearch(SynchronizationModeEnum.REFRESH_ONLY, this.reload);
                CONSUMER_LOG.debug("--------------------- Sleep for {} seconds ------------------", (Object)(this.config.getRefreshInterval() / 1000L));
                Thread.sleep(this.config.getRefreshInterval());
                CONSUMER_LOG.debug("--------------------- syncing again ------------------");
            }
            catch (InterruptedException ie) {
                CONSUMER_LOG.warn("refresher thread interrupted");
                return ReplicationStatusEnum.DISCONNECTED;
            }
            catch (Exception e) {
                CONSUMER_LOG.error("Failed to sync with refresh only mode", (Throwable)e);
                return ReplicationStatusEnum.DISCONNECTED;
            }
        }
        return ReplicationStatusEnum.STOPPED;
    }

    @Override
    public void setConfig(ReplicationConsumerConfig config) {
        this.config = (SyncReplConfiguration)config;
    }

    @Override
    public boolean connect(boolean now) {
        boolean connected = false;
        if (now) {
            connected = this.connect();
        }
        while (!connected) {
            try {
                CONSUMER_LOG.debug("Consumer {} cannot connect to {}, wait 5 seconds.", (Object)this.config.getReplicaId(), (Object)this.config.getProducer());
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                CONSUMER_LOG.warn("Consumer {} Interrupted while trying to reconnect to the provider {}", (Object)this.config.getReplicaId(), (Object)this.config.getProducer());
            }
            connected = this.connect();
        }
        return connected;
    }

    @Override
    public void ping() {
        boolean connected = !this.disconnected;
        boolean restartSync = false;
        if (this.disconnected) {
            restartSync = connected = this.connect();
        }
        if (connected) {
            CONSUMER_LOG.debug("PING : The consumer {} is alive", (Object)this.config.getReplicaId());
            if (restartSync) {
                CONSUMER_LOG.warn("Restarting the disconnected consumer {}", (Object)this.config.getReplicaId());
                this.disconnected = false;
                this.startSync();
            }
        } else {
            CONSUMER_LOG.debug("PING : The consumer {} cannot be connected", (Object)this.config.getReplicaId());
        }
    }

    @Override
    public void stop() {
        if (!this.disconnected) {
            this.disconnect();
        }
    }

    @Override
    public String getId() {
        return String.valueOf(this.getConfig().getReplicaId());
    }

    private ReplicationStatusEnum doSyncSearch(SynchronizationModeEnum syncType, boolean reloadHint) throws Exception {
        CONSUMER_LOG.debug("Starting synchronization mode {}, reloadHint {}", (Object)syncType, (Object)reloadHint);
        SyncRequestValueDecorator syncReq = new SyncRequestValueDecorator(this.directoryService.getLdapCodecService());
        syncReq.setMode(syncType);
        syncReq.setReloadHint(reloadHint);
        if (this.syncCookie != null) {
            CONSUMER_LOG.debug("searching on {} with searchRequest, cookie '{}'", (Object)this.config.getProducer(), (Object)Strings.utf8ToString((byte[])this.syncCookie));
            syncReq.setCookie(this.syncCookie);
        } else {
            CONSUMER_LOG.debug("searching on {} with searchRequest, no cookie", (Object)this.config.getProducer());
        }
        this.searchRequest.addControl((Control)syncReq);
        SearchFuture sf = this.connection.searchAsync(this.searchRequest);
        Response resp = sf.get();
        CONSUMER_LOG.debug("Response from {} : {}", (Object)this.config.getProducer(), (Object)resp);
        while (!(resp instanceof SearchResultDone || sf.isCancelled() || this.disconnected)) {
            if (resp instanceof SearchResultEntry) {
                SearchResultEntry result = (SearchResultEntry)resp;
                this.handleSearchResultEntry(result);
            } else if (resp instanceof SearchResultReference) {
                this.handleSearchReference((SearchResultReference)resp);
            } else if (resp instanceof IntermediateResponse) {
                this.handleSyncInfo((IntermediateResponse)resp);
            }
            resp = sf.get();
            CONSUMER_LOG.debug("Response from {} : {}", (Object)this.config.getProducer(), (Object)resp);
        }
        if (sf.isCancelled()) {
            CONSUMER_LOG.debug("Search sync on {} has been canceled ", (Object)this.config.getProducer(), (Object)sf.getCause());
            return ReplicationStatusEnum.DISCONNECTED;
        }
        if (this.disconnected) {
            CONSUMER_LOG.debug("Disconnected from {}", (Object)this.config.getProducer());
            return ReplicationStatusEnum.DISCONNECTED;
        }
        ResultCodeEnum resultCode = this.handleSearchResultDone((SearchResultDone)resp);
        CONSUMER_LOG.debug("Rsultcode of Sync operation from {} : {}", (Object)this.config.getProducer(), (Object)resultCode);
        if (resultCode == ResultCodeEnum.NO_SUCH_OBJECT) {
            CONSUMER_LOG.warn("The base Dn {} is not found on provider {}", (Object)this.config.getBaseDn(), (Object)this.config.getProducer());
            CONSUMER_LOG.warn("Disconnecting the Refresh&Persist consumer from provider {}", (Object)this.config.getProducer());
            this.disconnect();
            return ReplicationStatusEnum.DISCONNECTED;
        }
        if (resultCode == ResultCodeEnum.E_SYNC_REFRESH_REQUIRED) {
            CONSUMER_LOG.warn("Full SYNC_REFRESH required from {}", (Object)this.config.getProducer());
            this.reload = true;
            try {
                CONSUMER_LOG.debug("Deleting baseDN {}", (Object)this.config.getBaseDn());
                this.deleteRecursive(new Dn(new String[]{this.config.getBaseDn()}), -1000);
            }
            catch (Exception e) {
                CONSUMER_LOG.error("Failed to delete the replica base as part of handling E_SYNC_REFRESH_REQUIRED, disconnecting the consumer", (Throwable)e);
            }
            this.removeCookie();
            CONSUMER_LOG.debug("Re-doing a syncRefresh from producer {}", (Object)this.config.getProducer());
            return ReplicationStatusEnum.REFRESH_REQUIRED;
        }
        CONSUMER_LOG.debug("Got result code {} from producer {}. Replication stopped", (Object)resultCode, (Object)this.config.getProducer());
        return ReplicationStatusEnum.DISCONNECTED;
    }

    private void disconnect() {
        this.disconnected = true;
        try {
            if (this.connection != null && this.connection.isConnected()) {
                this.connection.unBind();
                CONSUMER_LOG.info("Unbound from the server {}", (Object)this.config.getProducer());
                if (CONSUMER_LOG.isDebugEnabled()) {
                    MDC.put((String)"Replica", (String)Integer.toString(this.config.getReplicaId()));
                    CONSUMER_LOG.info("Unbound from the server {}", (Object)this.config.getProducer());
                }
                this.connection.close();
                CONSUMER_LOG.info("Connection closed for the server {}", (Object)this.config.getProducer());
                this.connection = null;
            }
        }
        catch (Exception e) {
            CONSUMER_LOG.error("Failed to close the connection", (Throwable)e);
        }
        finally {
            this.storeCookie();
            this.syncCookie = null;
        }
    }

    private void storeCookie() {
        CONSUMER_LOG.debug("Storing the cookie '{}'", (Object)Strings.utf8ToString((byte[])this.syncCookie));
        if (this.syncCookie == null) {
            return;
        }
        if (this.lastSavedCookie != null && Arrays.equals(this.syncCookie, this.lastSavedCookie)) {
            return;
        }
        try {
            Attribute attr = this.cookieMod.getAttribute();
            attr.clear();
            attr.add((byte[][])new byte[][]{this.syncCookie});
            String cookieString = Strings.utf8ToString((byte[])this.syncCookie);
            int replicaId = LdapProtocolUtils.getReplicaId(cookieString);
            Attribute ridAt = this.ridMod.getAttribute();
            ridAt.clear();
            ridAt.add(new String[]{String.valueOf(replicaId)});
            CONSUMER_LOG.debug("Storing the cookie in the DIT : {}", (Object)this.config.getConfigEntryDn());
            this.session.modify(this.config.getConfigEntryDn(), new Modification[]{this.cookieMod});
            CONSUMER_LOG.debug("stored the cookie in entry {}", (Object)this.config.getConfigEntryDn());
            this.lastSavedCookie = new byte[this.syncCookie.length];
            System.arraycopy(this.syncCookie, 0, this.lastSavedCookie, 0, this.syncCookie.length);
        }
        catch (Exception e) {
            CONSUMER_LOG.error("Failed to store the cookie in consumer entry {}", (Object)this.config.getConfigEntryDn(), (Object)e);
        }
    }

    private void readCookie() {
        try {
            Entry entry = this.session.lookup(this.config.getConfigEntryDn(), new String[]{"ads-replCookie"});
            if (entry != null) {
                Attribute attr = entry.get(this.adsReplCookieAT);
                if (attr != null) {
                    this.syncCookie = attr.getBytes();
                    this.lastSavedCookie = this.syncCookie;
                    String syncCookieString = Strings.utf8ToString((byte[])this.syncCookie);
                    CONSUMER_LOG.debug("Loaded cookie {} for consumer {}", (Object)syncCookieString, (Object)this.config.getReplicaId());
                } else {
                    CONSUMER_LOG.debug("No cookie found for consumer {}", (Object)this.config.getReplicaId());
                }
            } else {
                CONSUMER_LOG.debug("Cannot find the configuration '{}' in the DIT for consumer {}", (Object)this.config.getConfigEntryDn(), (Object)this.config.getReplicaId());
            }
        }
        catch (Exception e) {
            CONSUMER_LOG.debug("Failed to read the cookie, cannot find the entry '{}' in the DIT for consumer {}", (Object)this.config.getConfigEntryDn(), (Object)this.config.getReplicaId());
        }
    }

    private void removeCookie() {
        try {
            DefaultAttribute cookieAttr = new DefaultAttribute(this.adsReplCookieAT);
            DefaultModification deleteCookieMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, (Attribute)cookieAttr);
            this.session.modify(this.config.getConfigEntryDn(), new Modification[]{deleteCookieMod});
            CONSUMER_LOG.info("resetting sync cookie of the consumer with config entry Dn {}", (Object)this.config.getConfigEntryDn());
        }
        catch (Exception e) {
            CONSUMER_LOG.warn("Failed to delete the cookie from the consumer with config entry Dn {}", (Object)this.config.getConfigEntryDn());
            CONSUMER_LOG.warn("{}", (Throwable)e);
        }
        this.syncCookie = null;
        this.lastSavedCookie = null;
    }

    private void applyModDnOperation(Entry remoteEntry, String entryUuid, int rid) throws Exception {
        boolean deleteOldRdn;
        Csn remoteCsn;
        Csn localCsn;
        CONSUMER_LOG.debug("MODDN for entry {}, new entry : {}", (Object)entryUuid, (Object)remoteEntry);
        String filter = "(entryUuid=" + entryUuid + ")";
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(new Dn(this.schemaManager, new String[]{this.config.getBaseDn()}));
        searchRequest.setFilter(filter);
        searchRequest.setScope(SearchScope.SUBTREE);
        searchRequest.addAttributes(new String[]{"entryUUID", "entryCSN", "*"});
        Cursor cursor = this.session.search((SearchRequest)searchRequest);
        cursor.beforeFirst();
        Entry localEntry = null;
        if (cursor.next()) {
            localEntry = (Entry)cursor.get();
        }
        cursor.close();
        if (localEntry == null) {
            return;
        }
        if (this.config.isMmrMode() && (localCsn = new Csn(localEntry.get("entryCSN").getString())).compareTo(remoteCsn = new Csn(remoteEntry.get("entryCSN").getString())) >= 0) {
            CONSUMER_LOG.debug("local modification is latest, discarding the modDn operation dn {}", (Object)remoteEntry.getDn());
            return;
        }
        Dn localDn = localEntry.getDn();
        Dn remoteDn = this.directoryService.getDnFactory().create(remoteEntry.getDn().getName());
        Dn localParentDn = localDn.getParent();
        Dn remoteParentDn = this.directoryService.getDnFactory().create(remoteDn.getParent().getName());
        Rdn localRdn = localDn.getRdn();
        Rdn remoteRdn = this.directoryService.getDnFactory().create(remoteDn.getRdn().getName()).getRdn();
        boolean bl = deleteOldRdn = !remoteEntry.contains(localRdn.getNormType(), new String[]{localRdn.getValue()});
        if (localRdn.equals((Object)remoteRdn)) {
            CONSUMER_LOG.debug("moving {} to the new parent {}", (Object)localDn, (Object)remoteParentDn);
            MoveOperationContext movCtx = new MoveOperationContext(this.session, localDn, remoteParentDn);
            movCtx.setReplEvent(true);
            movCtx.setRid(rid);
            this.directoryService.getOperationManager().move(movCtx);
        } else if (localParentDn.equals((Object)remoteParentDn)) {
            CONSUMER_LOG.debug("renaming the Dn {} with new Rdn {} and deleteOldRdn flag set to {}", new Object[]{localDn.getName(), remoteRdn.getName(), String.valueOf(deleteOldRdn)});
            RenameOperationContext renCtx = new RenameOperationContext(this.session, localDn, remoteRdn, deleteOldRdn);
            renCtx.setReplEvent(true);
            renCtx.setRid(rid);
            this.directoryService.getOperationManager().rename(renCtx);
        } else {
            CONSUMER_LOG.debug("moveAndRename on the Dn {} with new newParent Dn {}, new Rdn {} and deleteOldRdn flag set to {}", new Object[]{localDn.getName(), remoteParentDn.getName(), remoteRdn.getName(), String.valueOf(deleteOldRdn)});
            MoveAndRenameOperationContext movRenCtx = new MoveAndRenameOperationContext(this.session, localDn, remoteParentDn, remoteRdn, deleteOldRdn);
            movRenCtx.setReplEvent(true);
            movRenCtx.setRid(rid);
            this.directoryService.getOperationManager().moveAndRename(movRenCtx);
        }
    }

    private void modify(Entry remoteEntry, int rid) throws Exception {
        Csn remoteCsn;
        Csn localCsn;
        Entry localEntry;
        String[] attributes = this.computeAttributes(this.config.getAttributes(), "+");
        LookupOperationContext lookupCtx = new LookupOperationContext(this.session, remoteEntry.getDn(), attributes);
        lookupCtx.setSyncreplLookup(true);
        Partition partition = this.session.getDirectoryService().getPartitionNexus().getPartition(remoteEntry.getDn());
        try (PartitionReadTxn partitionTxn = partition.beginReadTransaction();){
            lookupCtx.setTransaction((PartitionTxn)partitionTxn);
            localEntry = this.session.getDirectoryService().getOperationManager().lookup(lookupCtx);
        }
        if (this.config.isMmrMode() && (localCsn = new Csn(localEntry.get("entryCSN").getString())).compareTo(remoteCsn = new Csn(remoteEntry.get("entryCSN").getString())) >= 0) {
            CONSUMER_LOG.debug("local modification is latest, discarding the modification of dn {}", (Object)remoteEntry.getDn());
            return;
        }
        remoteEntry.removeAttributes(MOD_IGNORE_AT);
        localEntry.removeAttributes(MOD_IGNORE_AT);
        ArrayList<DefaultModification> mods = new ArrayList<DefaultModification>();
        for (Attribute localAttr : localEntry) {
            DefaultModification mod;
            String attrId = localAttr.getId();
            Attribute remoteAttr = remoteEntry.get(attrId);
            if (remoteAttr != null) {
                mod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, remoteAttr);
                remoteEntry.remove(new Attribute[]{remoteAttr});
            } else {
                mod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, localAttr);
            }
            mods.add(mod);
        }
        if (remoteEntry.size() > 0) {
            Iterator itr = remoteEntry.iterator();
            while (itr.hasNext()) {
                mods.add(new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, (Attribute)itr.next()));
            }
        }
        ArrayList<DefaultModification> serverModifications = new ArrayList<DefaultModification>(mods.size());
        for (DefaultModification mod : mods) {
            serverModifications.add(new DefaultModification(this.directoryService.getSchemaManager(), (Modification)mod));
        }
        ModifyOperationContext modifyContext = new ModifyOperationContext(this.session, remoteEntry.getDn(), serverModifications);
        modifyContext.setReplEvent(true);
        modifyContext.setRid(rid);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(modifyContext);
    }

    private String[] computeAttributes(String[] attributes, String addedAttribute) {
        if (attributes != null) {
            if (addedAttribute != null) {
                String[] combinedAttributes = new String[attributes.length + 1];
                System.arraycopy(attributes, 0, combinedAttributes, 0, attributes.length);
                combinedAttributes[attributes.length] = addedAttribute;
                return combinedAttributes;
            }
            return attributes;
        }
        if (addedAttribute != null) {
            return new String[]{addedAttribute};
        }
        return StringConstants.EMPTY_STRINGS;
    }

    private void deleteEntries(List<byte[]> uuidList, boolean isRefreshPresent, int replicaId) throws Exception {
        int i;
        if (uuidList == null || uuidList.isEmpty()) {
            return;
        }
        if (isRefreshPresent) {
            CONSUMER_LOG.debug("refresh present syncinfo list has {} UUIDs", (Object)uuidList.size());
            this.processDelete(uuidList, isRefreshPresent, replicaId);
            return;
        }
        int nodeLimit = 10;
        int count = uuidList.size() / nodeLimit;
        int startIndex = 0;
        for (i = 0; i < count; ++i) {
            startIndex = i * nodeLimit;
            this.processDelete(uuidList.subList(startIndex, startIndex + nodeLimit), isRefreshPresent, replicaId);
        }
        if (uuidList.size() % nodeLimit != 0) {
            if (count > 0) {
                startIndex = i * nodeLimit;
            }
            this.processDelete(uuidList.subList(startIndex, uuidList.size()), isRefreshPresent, replicaId);
        }
    }

    private void processDelete(List<byte[]> limitedUuidList, boolean isRefreshPresent, int replicaId) throws Exception {
        Object filter = null;
        int size = limitedUuidList.size();
        if (size == 1) {
            String uuid = Strings.uuidToString((byte[])limitedUuidList.get(0));
            filter = new EqualityNode("entryUUID", new Value(uuid).getValue());
            if (isRefreshPresent) {
                filter = new NotNode((ExprNode)filter);
            }
        } else {
            filter = isRefreshPresent ? new AndNode() : new OrNode();
            for (int i = 0; i < size; ++i) {
                String uuid = Strings.uuidToString((byte[])limitedUuidList.get(i));
                EqualityNode uuidEqNode = new EqualityNode("entryUUID", new Value(uuid).getValue());
                if (isRefreshPresent) {
                    uuidEqNode = new NotNode((ExprNode)uuidEqNode);
                    filter.addNode((ExprNode)uuidEqNode);
                    continue;
                }
                ((OrNode)filter).addNode((ExprNode)uuidEqNode);
            }
        }
        Dn dn = new Dn(this.schemaManager, new String[]{this.config.getBaseDn()});
        CONSUMER_LOG.debug("selecting entries to be deleted using filter {}", (Object)filter.toString());
        SearchRequestImpl req = new SearchRequestImpl();
        req.setBase(dn);
        req.setFilter((ExprNode)filter);
        req.setScope(SearchScope.SUBTREE);
        req.setDerefAliases(AliasDerefMode.NEVER_DEREF_ALIASES);
        req.addAttributes(new String[]{"entryDN"});
        SortKey sk = new SortKey("entryDN", "2.5.13.1");
        SortRequestControlImpl ctrl = new SortRequestControlImpl();
        ctrl.addSortKey(sk);
        req.addControl((Control)ctrl);
        OperationManager operationManager = this.directoryService.getOperationManager();
        Cursor cursor = this.session.search((SearchRequest)req);
        cursor.beforeFirst();
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            DeleteOperationContext ctx = new DeleteOperationContext(this.session);
            ctx.setReplEvent(true);
            ctx.setRid(replicaId);
            if (this.reload) {
                ctx.setGenerateNoReplEvt(true);
            }
            ctx.setDn(entry.getDn());
            operationManager.delete(ctx);
        }
        cursor.close();
    }

    private synchronized Object getLockFor(String uuid) {
        Object lock = UUID_LOCK_MAP.get(uuid);
        if (lock == null) {
            lock = new Object();
            UUID_LOCK_MAP.put(uuid, lock);
        }
        return lock;
    }

    private void deleteRecursive(Dn rootDn, int rid) throws Exception {
        CONSUMER_LOG.debug("searching for Dn {} and its children before deleting", (Object)rootDn.getName());
        try (Cursor cursor = null;){
            SearchRequestImpl req = new SearchRequestImpl();
            req.setBase(rootDn);
            req.setFilter((ExprNode)ENTRY_UUID_PRESENCE_FILTER);
            req.setScope(SearchScope.SUBTREE);
            req.setDerefAliases(AliasDerefMode.NEVER_DEREF_ALIASES);
            req.addAttributes(new String[]{"entryDN"});
            SortKey sk = new SortKey("entryDN", "2.5.13.1");
            SortRequestControlImpl ctrl = new SortRequestControlImpl();
            ctrl.addSortKey(sk);
            req.addControl((Control)ctrl);
            cursor = this.session.search((SearchRequest)req);
            cursor.beforeFirst();
            OperationManager operationManager = this.directoryService.getOperationManager();
            while (cursor.next()) {
                Entry e = (Entry)cursor.get();
                DeleteOperationContext ctx = new DeleteOperationContext(this.session);
                ctx.setReplEvent(true);
                ctx.setRid(rid);
                if (this.reload) {
                    ctx.setGenerateNoReplEvt(true);
                }
                ctx.setDn(e.getDn());
                operationManager.delete(ctx);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Consumer ").append(this.config);
        return sb.toString();
    }
}

