/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapReferralException;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ReferralImpl;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.ResultResponseRequest;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.shared.DefaultCoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LdapRequestHandler<T extends Request>
implements MessageHandler<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(LdapRequestHandler.class);
    protected LdapServer ldapServer;

    public final LdapServer getLdapServer() {
        return this.ldapServer;
    }

    public final void setLdapServer(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    public final boolean isConfidentialityRequirementSatisfied(IoSession session) {
        if (!this.ldapServer.isConfidentialityRequired()) {
            return true;
        }
        IoFilterChain chain = session.getFilterChain();
        return chain.contains("sslFilter");
    }

    public void rejectWithoutConfidentiality(IoSession session, ResultResponse resp) {
        LdapResult result = resp.getLdapResult();
        result.setResultCode(ResultCodeEnum.CONFIDENTIALITY_REQUIRED);
        result.setDiagnosticMessage("Confidentiality (TLS secured connection) is required.");
        session.write((Object)resp);
    }

    public final void handleMessage(IoSession session, T message) throws Exception {
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().getLdapSession(session);
        if (ldapSession == null) {
            LOG.info("ignoring the message {} received from null session", message);
            return;
        }
        if (ldapSession.isAuthPending() && (!(message instanceof BindRequest) || ((BindRequest)message).isSimple() || ldapSession.isSimpleAuthPending())) {
            LOG.error(I18n.err((I18n)I18n.ERR_732, (Object[])new Object[0]));
            BindResponseImpl bindResponse = new BindResponseImpl(message.getMessageId());
            LdapResult bindResult = bindResponse.getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
            bindResult.setDiagnosticMessage(I18n.err((I18n)I18n.ERR_732, (Object[])new Object[0]));
            ldapSession.getIoSession().write((Object)bindResponse);
            return;
        }
        ldapSession.setLdapServer(this.ldapServer);
        if (!this.isConfidentialityRequirementSatisfied(session)) {
            if (message instanceof ExtendedRequest) {
                ExtendedRequest req = (ExtendedRequest)message;
                if (!req.getRequestName().equals("1.3.6.1.4.1.1466.20037")) {
                    this.rejectWithoutConfidentiality(session, req.getResultResponse());
                    return;
                }
            } else {
                if (message instanceof ResultResponseRequest) {
                    this.rejectWithoutConfidentiality(session, ((ResultResponseRequest)message).getResultResponse());
                    return;
                }
                return;
            }
        }
        if (!(message instanceof BindRequest)) {
            CoreSession coreSession = null;
            if (ldapSession.isAuthenticated()) {
                coreSession = ldapSession.getCoreSession();
                this.handle(ldapSession, message);
                return;
            }
            coreSession = this.getLdapServer().getDirectoryService().getSession();
            ldapSession.setCoreSession(coreSession);
            ((DefaultCoreSession)coreSession).setIoSession(ldapSession.getIoSession());
            if (message instanceof AbandonRequest) {
                return;
            }
            this.handle(ldapSession, message);
            return;
        }
        this.handle(ldapSession, message);
    }

    public abstract void handle(LdapSession var1, T var2) throws Exception;

    public void handleException(LdapSession session, ResultResponseRequest req, Exception e) {
        LdapResult result = req.getResultResponse().getLdapResult();
        ResultCodeEnum code = e instanceof LdapOperationException ? ((LdapOperationException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
        result.setResultCode(code);
        String msg = code.toString() + ": failed for " + req + ": " + e.getLocalizedMessage();
        LOG.debug(msg, (Throwable)e);
        if (LOG.isDebugEnabled() || code == ResultCodeEnum.OTHER) {
            msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
        result.setDiagnosticMessage(msg);
        if (e instanceof LdapOperationException) {
            boolean setMatchedDn;
            LdapOperationException ne = (LdapOperationException)e;
            boolean bl = setMatchedDn = code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            if (ne.getResolvedDn() != null && setMatchedDn) {
                result.setMatchedDn(ne.getResolvedDn());
            }
            if (e instanceof LdapReferralException) {
                ReferralImpl referrals = new ReferralImpl();
                do {
                    String ref = ((LdapReferralException)e).getReferralInfo();
                    referrals.addLdapUrl(ref);
                } while (((LdapReferralException)e).skipReferral());
                result.setReferral((Referral)referrals);
            }
        }
        session.getIoSession().write((Object)req.getResultResponse());
    }
}

