/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jclouds.rackspace.cloudbigdata.v1.internal;

import java.util.Properties;

import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.openstack.keystone.config.KeystoneProperties;
import org.jclouds.rackspace.cloudbigdata.v1.CloudBigDataApi;

/**
 * Tests behavior of CLoud Big Data live.
 */
public class BaseCloudBigDataApiLiveTest extends BaseApiLiveTest<CloudBigDataApi> {

   /**
    * Base Live Test
    */
   public BaseCloudBigDataApiLiveTest() {
      provider = "rackspace-cloudbigdata";
   }

   @Override
   protected Properties setupProperties() {
      Properties props = super.setupProperties();
      setIfTestSystemPropertyPresent(props, KeystoneProperties.CREDENTIAL_TYPE);
      setIfTestSystemPropertyPresent(props, KeystoneProperties.SERVICE_TYPE);
      return props;
   }
}
