/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jclouds.openstack.marconi.v1.functions;

import com.google.common.base.Function;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.marconi.v1.domain.Queue;
import org.jclouds.openstack.marconi.v1.domain.Queues;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;

import javax.inject.Inject;

import static com.google.common.base.Preconditions.checkNotNull;

public class ParseQueues implements Function<HttpResponse, PaginatedCollection<Queue>> {

   private final ParseJson<Queues> json;

   @Inject
   ParseQueues(ParseJson<Queues> json) {
      this.json = checkNotNull(json, "json");
   }

   @Override
   public PaginatedCollection<Queue> apply(HttpResponse response) {
      // An empty message stream has a 204 response code
      if (response.getStatusCode() == 204) {
         return Queues.EMPTY;
      }

      return json.apply(response);
   }
}
