/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class OrderLimitMap<K extends Comparable<K>, V extends Comparable<V>>
extends TreeMap<K, V> {
    private static final long serialVersionUID = 756490437953358633L;
    private final int capacity;
    private final Map<K, V> valueMap;

    private static <V extends Comparable<V>> Ordering<? super V> incr() {
        return Ordering.from((o1, o2) -> o1.compareTo(o2));
    }

    private static <V extends Comparable<V>> Ordering<? super V> decr() {
        return Ordering.from((o1, o2) -> -o1.compareTo(o2));
    }

    public OrderLimitMap(int capacity) {
        this(capacity, false);
    }

    public OrderLimitMap(int capacity, boolean incr) {
        this(capacity, incr ? OrderLimitMap.incr() : OrderLimitMap.decr(), new HashMap());
    }

    private OrderLimitMap(int capacity, Ordering<? super V> ordering, HashMap<K, V> valueMap) {
        super(ordering.onResultOf(Functions.forMap(valueMap)).compound(Ordering.natural()));
        E.checkArgument(capacity > 0, "The capacity must be > 0", new Object[0]);
        this.capacity = capacity;
        this.valueMap = valueMap;
    }

    @Override
    public V put(K k, V v) {
        if (this.valueMap.containsKey(k)) {
            super.remove(k);
        } else if (this.valueMap.size() >= this.capacity) {
            Comparable key = (Comparable)super.lastKey();
            super.remove(key);
            this.valueMap.remove(key);
        }
        this.valueMap.put(k, v);
        return (V)((Comparable)super.put(k, v));
    }

    @Override
    public V get(Object key) {
        return (V)((Comparable)this.valueMap.get(key));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return (V)((Comparable)this.valueMap.getOrDefault(key, defaultValue));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.valueMap.containsKey(key);
    }

    public Map<K, V> topN(int n) {
        E.checkArgument(n > 0, "'N' Must be positive, but got '%s'", n);
        Map<Comparable, Comparable> top = InsertionOrderUtil.newMap();
        int i = 0;
        for (Map.Entry entry : this.entrySet()) {
            top.put((Comparable)entry.getKey(), (Comparable)entry.getValue());
            if (++i < n) continue;
            break;
        }
        return top;
    }
}

