/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.WeightedPaths;
import org.apache.hugegraph.util.E;

public class SingleSourceShortestPathAPI
extends TraversersAPI {
    public SingleSourceShortestPathAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "singlesourceshortestpath";
    }

    public WeightedPaths get(Object sourceId, Direction direction, String label, String weight, long degree, long skipDegree, long capacity, int limit, boolean withVertex) {
        this.client.checkApiVersion("0.51", "single source shortest path");
        String source = GraphAPI.formatVertexId(sourceId, false);
        E.checkNotNull(weight, "weight");
        SingleSourceShortestPathAPI.checkDegree(degree);
        SingleSourceShortestPathAPI.checkCapacity(capacity);
        SingleSourceShortestPathAPI.checkSkipDegree(skipDegree, degree, capacity);
        SingleSourceShortestPathAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("weight", weight);
        params.put("max_degree", degree);
        params.put("skip_degree", skipDegree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        params.put("with_vertex", withVertex);
        RestResult result = this.client.get(this.path(), params);
        return result.readObject(WeightedPaths.class);
    }
}

