/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.AuthGrpc;
import io.etcd.jetcd.api.AuthenticateRequest;
import io.etcd.jetcd.api.AuthenticateResponse;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.AbstractStub;
import io.netty.channel.ChannelOption;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnectionManager.class);
    private static final Metadata.Key<String> TOKEN = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Object lock = new Object();
    private final ClientBuilder builder;
    private final ExecutorService executorService;
    private volatile ManagedChannel managedChannel;
    private volatile String token;

    ClientConnectionManager(ClientBuilder builder) {
        this(builder, null);
    }

    ClientConnectionManager(ClientBuilder builder, ManagedChannel managedChannel) {
        this.builder = builder;
        this.managedChannel = managedChannel;
        this.executorService = builder.executorService() == null ? Executors.newCachedThreadPool() : builder.executorService();
    }

    private static ListenableFuture<AuthenticateResponse> authenticate(@Nonnull Channel channel, @Nonnull ByteSequence username, @Nonnull ByteSequence password) {
        ByteString user = username.getByteString();
        ByteString pass = password.getByteString();
        Preconditions.checkArgument((!user.isEmpty() ? 1 : 0) != 0, (Object)"username can not be empty.");
        Preconditions.checkArgument((!pass.isEmpty() ? 1 : 0) != 0, (Object)"password can not be empty.");
        return AuthGrpc.newFutureStub(channel).authenticate(AuthenticateRequest.newBuilder().setNameBytes(user).setPasswordBytes(pass).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedChannel getChannel() {
        if (this.managedChannel == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.managedChannel == null) {
                    this.managedChannel = this.defaultChannelBuilder().build();
                }
            }
        }
        return this.managedChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getToken(Channel channel) {
        if (this.token == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.token == null) {
                    this.token = this.generateToken(channel);
                }
            }
        }
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceTokenRefresh() {
        Object object = this.lock;
        synchronized (object) {
            this.token = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshToken(Channel channel) {
        Object object = this.lock;
        synchronized (object) {
            this.token = this.generateToken(channel);
        }
    }

    ByteSequence getNamespace() {
        return this.builder.namespace();
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> supplier) {
        return (T)((AbstractStub)supplier.apply(this.getChannel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.managedChannel != null) {
                this.managedChannel.shutdownNow();
            }
        }
        this.executorService.shutdownNow();
    }

    <T extends AbstractStub<T>, R> CompletableFuture<R> withNewChannel(URI endpoint, Function<ManagedChannel, T> stubCustomizer, Function<T, CompletableFuture<R>> stubConsumer) {
        ManagedChannel channel = this.defaultChannelBuilder(Collections.singletonList(endpoint)).build();
        AbstractStub stub = (AbstractStub)stubCustomizer.apply(channel);
        try {
            return stubConsumer.apply(stub).whenComplete((r, t) -> channel.shutdown());
        }
        catch (Exception e) {
            channel.shutdown();
            throw EtcdExceptionFactory.toEtcdException((Throwable)e);
        }
    }

    @VisibleForTesting
    protected ManagedChannelBuilder<?> defaultChannelBuilder() {
        return this.defaultChannelBuilder(this.builder.endpoints());
    }

    @VisibleForTesting
    protected ManagedChannelBuilder<?> defaultChannelBuilder(Collection<URI> endpoints) {
        String target;
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException("At least one endpoint should be provided");
        }
        if (this.builder.discovery()) {
            if (endpoints.size() != 1) {
                throw new IllegalArgumentException("When configured for discovery, there should be only a single endpoint");
            }
            target = String.format("%s:///%s", "dns+srv", Iterables.get(endpoints, (int)0));
        } else {
            target = String.format("%s://%s/%s", "ip", this.builder.authority() != null ? this.builder.authority() : "", endpoints.stream().map(e -> e.getHost() + ":" + e.getPort()).collect(Collectors.joining(",")));
        }
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)target);
        if (this.builder.authority() != null) {
            channelBuilder.overrideAuthority(this.builder.authority());
        }
        if (this.builder.maxInboundMessageSize() != null) {
            channelBuilder.maxInboundMessageSize(this.builder.maxInboundMessageSize().intValue());
        }
        if (this.builder.sslContext() != null) {
            channelBuilder.negotiationType(NegotiationType.TLS);
            channelBuilder.sslContext(this.builder.sslContext());
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        if (this.builder.keepaliveTimeMs() != null) {
            channelBuilder.keepAliveTime(this.builder.keepaliveTimeMs().longValue(), TimeUnit.MILLISECONDS);
        }
        if (this.builder.keepaliveTimeoutMs() != null) {
            channelBuilder.keepAliveTimeout(this.builder.keepaliveTimeoutMs().longValue(), TimeUnit.MILLISECONDS);
        }
        if (this.builder.keepaliveWithoutCalls() != null) {
            channelBuilder.keepAliveWithoutCalls(this.builder.keepaliveWithoutCalls().booleanValue());
        }
        if (this.builder.connectTimeoutMs() != null) {
            channelBuilder.withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.builder.connectTimeoutMs());
        }
        if (this.builder.loadBalancerPolicy() != null) {
            channelBuilder.defaultLoadBalancingPolicy(this.builder.loadBalancerPolicy());
        } else {
            channelBuilder.defaultLoadBalancingPolicy("pick_first");
        }
        channelBuilder.intercept(new ClientInterceptor[]{new AuthTokenInterceptor()});
        if (this.builder.headers() != null) {
            channelBuilder.intercept(new ClientInterceptor[]{new ClientInterceptor(){

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                    return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                            ClientConnectionManager.this.builder.headers().forEach((arg_0, arg_1) -> ((Metadata)headers).put(arg_0, arg_1));
                            super.start(responseListener, headers);
                        }
                    };
                }
            }});
        }
        if (this.builder.interceptors() != null) {
            channelBuilder.intercept(this.builder.interceptors());
        }
        return channelBuilder;
    }

    @Nullable
    private String generateToken(Channel channel) {
        if (this.builder.user() != null && this.builder.password() != null) {
            try {
                return ((AuthenticateResponse)ClientConnectionManager.authenticate(channel, this.builder.user(), this.builder.password()).get()).getToken();
            }
            catch (InterruptedException ite) {
                throw EtcdExceptionFactory.handleInterrupt((InterruptedException)ite);
            }
            catch (ExecutionException exee) {
                throw EtcdExceptionFactory.toEtcdException((Throwable)exee);
            }
        }
        return null;
    }

    public <S, T> CompletableFuture<T> execute(Callable<ListenableFuture<S>> task, Function<S, T> resultConvert) {
        return this.execute(task, resultConvert, Util::isRetryable);
    }

    public <S, T> CompletableFuture<T> execute(Callable<ListenableFuture<S>> task, Function<S, T> resultConvert, Predicate<Throwable> doRetry) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf(doRetry)).onRetriesExceeded(e -> LOGGER.warn("maximum number of auto retries reached")).withBackoff(this.builder.retryDelay(), this.builder.retryMaxDelay(), this.builder.retryChronoUnit());
        if (this.builder.retryMaxDuration() != null) {
            retryPolicy = retryPolicy.withMaxDuration(Duration.parse(this.builder.retryMaxDuration()));
        }
        return Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).with(this.executorService).getAsyncExecution(execution -> {
            CompletableFuture wrappedFuture = new CompletableFuture();
            ListenableFuture future = (ListenableFuture)task.call();
            future.addListener(() -> {
                try {
                    wrappedFuture.complete(future.get());
                    if (!execution.complete((Object)wrappedFuture)) return;
                }
                catch (Exception error) {
                    if (execution.retryOn((Throwable)error)) return;
                    wrappedFuture.completeExceptionally(error);
                }
            }, (Executor)this.executorService);
            return wrappedFuture;
        }).thenCompose(f -> f.thenApply(resultConvert));
    }

    private class AuthTokenInterceptor
    implements ClientInterceptor {
        private AuthTokenInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, final Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    String token = ClientConnectionManager.this.getToken(next);
                    if (token != null) {
                        headers.put(TOKEN, (Object)token);
                    }
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            if (Util.isInvalidTokenError(status)) {
                                try {
                                    ClientConnectionManager.this.refreshToken(next);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

