/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.jdbc.JDBCSource;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class RowFetcher {
    private static final Logger LOG = Log.logger(RowFetcher.class);
    private final JDBCSource source;
    private final Connection conn;
    private String[] columns;
    private String[] primaryKeys;
    private Line nextStartRow;
    private boolean fullyFetched;

    public RowFetcher(JDBCSource source) throws SQLException {
        this.source = source;
        this.conn = this.connect();
        this.columns = null;
        this.primaryKeys = null;
        this.nextStartRow = null;
        this.fullyFetched = false;
    }

    private Connection connect() throws SQLException {
        String url = this.source.vendor().buildUrl(this.source);
        LOG.info("Connect to database {}", (Object)url);
        String driverName = this.source.driver();
        String username = this.source.username();
        String password = this.source.password();
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new LoadException("Invalid driver class '%s'", (Throwable)e, driverName);
        }
        return DriverManager.getConnection(url, username, password);
    }

    public String[] readHeader() throws SQLException {
        String sql = this.source.vendor().buildGetHeaderSql(this.source);
        LOG.debug("The sql for reading headers is: {}", (Object)sql);
        try (Statement stmt = this.conn.createStatement();
             ResultSet result = stmt.executeQuery(sql);){
            ArrayList<String> columns = new ArrayList<String>();
            while (result.next()) {
                columns.add(result.getString("COLUMN_NAME"));
            }
            this.columns = columns.toArray(new String[0]);
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        E.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])this.columns), (String)"The columns of the table '%s' shouldn't be empty", (Object[])new Object[]{this.source.table()});
        return this.columns;
    }

    private String[] readHeader(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            columns.add(metaData.getColumnName(i));
        }
        this.columns = columns.toArray(new String[0]);
        return this.columns;
    }

    public void readPrimaryKey() throws SQLException {
        String sql = this.source.vendor().buildGetPrimaryKeySql(this.source);
        LOG.debug("The sql for reading primary keys is: {}", (Object)sql);
        try (Statement stmt = this.conn.createStatement();
             ResultSet result = stmt.executeQuery(sql);){
            ArrayList<String> columns = new ArrayList<String>();
            while (result.next()) {
                columns.add(result.getString("COLUMN_NAME"));
            }
            this.primaryKeys = columns.toArray(new String[0]);
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        E.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])this.primaryKeys), (String)"The primary keys of the table '%s' shouldn't be empty", (Object[])new Object[]{this.source.table()});
    }

    public List<Line> nextBatch() throws SQLException {
        if (this.fullyFetched) {
            return null;
        }
        String select = this.source.existsCustomSQL() ? this.source.customSQL() : this.source.vendor().buildSelectSql(this.source, this.nextStartRow);
        LOG.debug("The sql for select is: {}", (Object)select);
        ArrayList<Line> batch = new ArrayList<Line>(this.source.batchSize() + 1);
        try (Statement stmt = this.conn.createStatement();
             ResultSet result = stmt.executeQuery(select);){
            if (this.source.existsCustomSQL()) {
                this.readHeader(result);
            }
            while (result.next()) {
                Object[] values = new Object[this.columns.length];
                int n = this.columns.length;
                for (int i = 1; i <= n; ++i) {
                    Object value = result.getObject(i);
                    if (value == null) {
                        value = "NULL";
                    }
                    values[i - 1] = value;
                }
                String rawLine = StringUtils.join((Object[])values, (String)",");
                Line line = new Line(rawLine, this.columns, values);
                batch.add(line);
            }
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        if (this.source.existsCustomSQL() || batch.size() != this.source.batchSize() + 1) {
            this.fullyFetched = true;
        } else {
            Line lastLine = (Line)batch.remove(batch.size() - 1);
            lastLine.retainAll(this.primaryKeys);
            this.nextStartRow = lastLine;
        }
        return batch;
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            LOG.warn("Failed to close connection", (Throwable)e);
        }
    }
}

