/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.receiver.message;

import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.combiner.MessageValueCombiner;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.network.message.MessageType;
import org.apache.hugegraph.computer.core.receiver.MessageRecvPartition;
import org.apache.hugegraph.computer.core.sort.flusher.CombineKvOuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.KvOuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.OuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.sorting.SortManager;
import org.apache.hugegraph.computer.core.store.SuperstepFileGenerator;

public class ComputeMessageRecvPartition
extends MessageRecvPartition {
    private static final String TYPE = MessageType.MSG.name().toLowerCase();
    private final OuterSortFlusher flusher;

    public ComputeMessageRecvPartition(ComputerContext context, SuperstepFileGenerator fileGenerator, SortManager sortManager) {
        super(context.config(), fileGenerator, sortManager, false);
        Config config = context.config();
        Combiner combiner = (Combiner)config.createObject(ComputerOptions.WORKER_COMBINER_CLASS, false);
        if (combiner == null) {
            this.flusher = new KvOuterSortFlusher();
        } else {
            MessageValueCombiner pointerCombiner = new MessageValueCombiner(context);
            this.flusher = new CombineKvOuterSortFlusher(pointerCombiner);
        }
    }

    @Override
    protected OuterSortFlusher outerSortFlusher() {
        return this.flusher;
    }

    @Override
    protected String type() {
        return TYPE;
    }
}

