/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.aggregator;

import java.util.Map;
import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.aggregator.Aggregators;
import org.apache.hugegraph.computer.core.aggregator.RegisterAggregators;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.rpc.AggregateRpcService;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class MasterAggrManager
implements Manager {
    public static final String NAME = "master_aggr";
    private static final Logger LOG = Log.logger(MasterAggrManager.class);
    private final RegisterAggregators registerAggregators = new RegisterAggregators();
    private final MasterAggregateHandler aggregatorsHandler = new MasterAggregateHandler();

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void inited(Config config) {
        this.aggregatorsHandler.resetAggregators(this.registerAggregators);
    }

    @Override
    public void close(Config config) {
        this.aggregatorsHandler.clearAggregators();
        this.registerAggregators.clear();
    }

    @Override
    public void beforeSuperstep(Config config, int superstep) {
        this.aggregatorsHandler.resetAggregators(this.registerAggregators);
    }

    public AggregateRpcService handler() {
        return this.aggregatorsHandler;
    }

    public <V extends Value> void registerAggregator(String name, Aggregator<V> aggr) {
        this.registerAggregators.put(name, aggr);
    }

    public <V extends Value> void aggregatedAggregator(String name, V value) {
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"Can't set value to null for aggregator '%s'", (Object[])new Object[]{name});
        Aggregator aggr = this.aggregatorsHandler.getAggregator(name);
        aggr.aggregatedValue(value);
    }

    public <V extends Value> V aggregatedValue(String name) {
        Aggregator aggr = this.aggregatorsHandler.getAggregator(name);
        return (V)aggr.aggregatedValue();
    }

    private class MasterAggregateHandler
    implements AggregateRpcService {
        private final Aggregators aggregators = new Aggregators();

        @Override
        public RegisterAggregators registeredAggregators() {
            return MasterAggrManager.this.registerAggregators;
        }

        @Override
        public Map<String, Value> listAggregators() {
            return this.aggregators.values();
        }

        @Override
        public void aggregateAggregators(Map<String, Value> aggregators) {
            for (Map.Entry<String, Value> aggr : aggregators.entrySet()) {
                this.aggregateAggregator(aggr.getKey(), aggr.getValue());
            }
            LOG.info("Master aggregate aggregators: {}", aggregators);
        }

        @Override
        public <V extends Value> Aggregator<V> getAggregator(String name) {
            Aggregator aggr = this.aggregators.get(name, null);
            assert (aggr != null);
            Aggregator aggregator = aggr;
            return aggregator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V extends Value> void aggregateAggregator(String name, V value) {
            Aggregator<V> aggr;
            Aggregator<V> aggregator = aggr = this.getAggregator(name);
            synchronized (aggregator) {
                aggr.aggregateValue(value);
            }
        }

        public void resetAggregators(RegisterAggregators register) {
            this.aggregators.reset(register);
        }

        public void clearAggregators() {
            this.aggregators.clear();
        }
    }
}

