/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.reactive.ReactiveDataProducer;
import org.reactivestreams.Publisher;

@Contract(threading=ThreadingBehavior.SAFE)
public final class ReactiveEntityProducer
implements AsyncEntityProducer {
    private final ReactiveDataProducer reactiveDataProducer;
    private final long contentLength;
    private final ContentType contentType;
    private final String contentEncoding;

    public ReactiveEntityProducer(Publisher<ByteBuffer> publisher, long contentLength, ContentType contentType, String contentEncoding) {
        this.reactiveDataProducer = new ReactiveDataProducer(publisher);
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    public int available() {
        return this.reactiveDataProducer.available();
    }

    public void produce(DataStreamChannel channel) throws IOException {
        this.reactiveDataProducer.produce(channel);
    }

    public void releaseResources() {
        this.reactiveDataProducer.releaseResources();
    }

    public boolean isRepeatable() {
        return false;
    }

    public void failed(Exception cause) {
        this.releaseResources();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public boolean isChunked() {
        return this.contentLength == -1L;
    }

    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }
}

