/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.IOException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.fluent.Content;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class ContentResponseHandler
extends AbstractHttpClientResponseHandler<Content> {
    private static final int MAX_MESSAGE_LENGTH = 256;

    public Content handleEntity(HttpEntity entity) throws IOException {
        return entity != null ? new Content(EntityUtils.toByteArray((HttpEntity)entity), ContentType.parse((CharSequence)entity.getContentType())) : Content.NO_CONTENT;
    }

    public Content handleResponse(ClassicHttpResponse response) throws IOException {
        int statusCode = response.getCode();
        HttpEntity entity = response.getEntity();
        byte[] contentBytes = entity != null ? EntityUtils.toByteArray((HttpEntity)entity, (int)256) : new byte[]{};
        ContentType contentType = entity != null && entity.getContentType() != null ? ContentType.parse((CharSequence)entity.getContentType()) : ContentType.DEFAULT_BINARY;
        Content content = new Content(contentBytes, contentType);
        if (statusCode >= 300) {
            throw new HttpResponseException(statusCode, response.getReasonPhrase(), contentBytes, contentType);
        }
        return content;
    }
}

