/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.cli.CliSessionState;

public class OptionsProcessor {
    protected static final Log l4j = LogFactory.getLog((String)OptionsProcessor.class.getName());
    private final Options options = new Options();
    private CommandLine commandLine;
    Map<String, String> hiveVariables = new HashMap<String, String>();

    public OptionsProcessor() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"databasename");
        OptionBuilder.withLongOpt((String)"database");
        OptionBuilder.withDescription((String)"Specify the database to use");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"quoted-query-string");
        OptionBuilder.withDescription((String)"SQL from command line");
        this.options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)"SQL from files");
        this.options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)"Initialization SQL file");
        this.options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.withDescription((String)"Variable subsitution to apply to hive commands. e.g. -d A=B or --define A=B");
        this.options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"hivevar");
        OptionBuilder.withDescription((String)"Variable subsitution to apply to hive commands. e.g. --hivevar A=B");
        this.options.addOption(OptionBuilder.create());
        this.options.addOption(new Option("S", "silent", false, "Silent mode in interactive shell"));
        this.options.addOption(new Option("v", "verbose", false, "Verbose mode (echo executed SQL to the console)"));
        this.options.addOption(new Option("H", "help", false, "Print help information"));
    }

    public boolean process_stage1(String[] argv) {
        try {
            this.commandLine = new GnuParser().parse(this.options, argv);
            Properties confProps = this.commandLine.getOptionProperties("hiveconf");
            for (String string : confProps.stringPropertyNames()) {
                System.setProperty(string, confProps.getProperty(string));
            }
            Properties hiveVars = this.commandLine.getOptionProperties("define");
            for (String propKey : hiveVars.stringPropertyNames()) {
                this.hiveVariables.put(propKey, hiveVars.getProperty(propKey));
            }
            Properties properties = this.commandLine.getOptionProperties("hivevar");
            for (String propKey : properties.stringPropertyNames()) {
                this.hiveVariables.put(propKey, properties.getProperty(propKey));
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            return false;
        }
        return true;
    }

    public boolean process_stage2(CliSessionState ss) {
        ss.getConf();
        if (this.commandLine.hasOption('H')) {
            this.printUsage();
            return false;
        }
        ss.setIsSilent(this.commandLine.hasOption('S'));
        ss.database = this.commandLine.getOptionValue("database");
        ss.execString = this.commandLine.getOptionValue('e');
        ss.fileName = this.commandLine.getOptionValue('f');
        ss.setIsVerbose(this.commandLine.hasOption('v'));
        String[] initFiles = this.commandLine.getOptionValues('i');
        if (null != initFiles) {
            ss.initFiles = Arrays.asList(initFiles);
        }
        if (ss.execString != null && ss.fileName != null) {
            System.err.println("The '-e' and '-f' options cannot be specified simultaneously");
            this.printUsage();
            return false;
        }
        if (this.commandLine.hasOption("hiveconf")) {
            Properties confProps = this.commandLine.getOptionProperties("hiveconf");
            for (String propKey : confProps.stringPropertyNames()) {
                ss.cmdProperties.setProperty(propKey, confProps.getProperty(propKey));
            }
        }
        return true;
    }

    private void printUsage() {
        new HelpFormatter().printHelp("hive", this.options);
    }

    public Map<String, String> getHiveVariables() {
        return this.hiveVariables;
    }
}

