/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.log4j.Logger;
import org.apache.thrift.transport.TSSLTransportFactory;

public class SslConnectionParams {
    private static final Logger log = Logger.getLogger(SslConnectionParams.class);
    private boolean useJsse = false;
    private boolean clientAuth = false;
    private boolean keyStoreSet;
    private String keyStorePath;
    private String keyStorePass;
    private String keyStoreType;
    private boolean trustStoreSet;
    private String trustStorePath;
    private String trustStorePass;
    private String trustStoreType;

    public static SslConnectionParams forConfig(AccumuloConfiguration conf, boolean server) {
        if (!conf.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
            return null;
        }
        SslConnectionParams result = new SslConnectionParams();
        boolean requireClientAuth = conf.getBoolean(Property.INSTANCE_RPC_SSL_CLIENT_AUTH);
        if (server) {
            result.setClientAuth(requireClientAuth);
        }
        if (conf.getBoolean(Property.RPC_USE_JSSE)) {
            result.setUseJsse(true);
            return result;
        }
        try {
            if (!server || requireClientAuth) {
                result.setTrustStoreFromConf(conf);
            }
            if (server || requireClientAuth) {
                result.setKeyStoreFromConf(conf);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not load configured keystore file", e);
        }
        return result;
    }

    private static String passwordFromConf(AccumuloConfiguration conf, String defaultPassword, Property passwordOverrideProperty) {
        String keystorePassword = conf.get(passwordOverrideProperty);
        if (!keystorePassword.isEmpty()) {
            log.debug((Object)("Using explicit SSL private key password from " + passwordOverrideProperty.getKey()));
        } else {
            keystorePassword = defaultPassword;
        }
        return keystorePassword;
    }

    private static String storePathFromConf(AccumuloConfiguration conf, Property pathProperty) throws FileNotFoundException {
        return SslConnectionParams.findKeystore(conf.getPath(pathProperty));
    }

    public void setKeyStoreFromConf(AccumuloConfiguration conf) throws FileNotFoundException {
        this.keyStoreSet = true;
        this.keyStorePath = SslConnectionParams.storePathFromConf(conf, Property.RPC_SSL_KEYSTORE_PATH);
        this.keyStorePass = SslConnectionParams.passwordFromConf(conf, conf.get(Property.INSTANCE_SECRET), Property.RPC_SSL_KEYSTORE_PASSWORD);
        this.keyStoreType = conf.get(Property.RPC_SSL_KEYSTORE_TYPE);
    }

    public void setTrustStoreFromConf(AccumuloConfiguration conf) throws FileNotFoundException {
        this.trustStoreSet = true;
        this.trustStorePath = SslConnectionParams.storePathFromConf(conf, Property.RPC_SSL_TRUSTSTORE_PATH);
        this.trustStorePass = SslConnectionParams.passwordFromConf(conf, "", Property.RPC_SSL_TRUSTSTORE_PASSWORD);
        this.trustStoreType = conf.get(Property.RPC_SSL_TRUSTSTORE_TYPE);
    }

    public static SslConnectionParams forServer(AccumuloConfiguration configuration) {
        return SslConnectionParams.forConfig(configuration, true);
    }

    public static SslConnectionParams forClient(AccumuloConfiguration configuration) {
        return SslConnectionParams.forConfig(configuration, false);
    }

    private static String findKeystore(String keystorePath) throws FileNotFoundException {
        try {
            URL url;
            File file = new File(keystorePath);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            if (!file.isAbsolute() && (url = SslConnectionParams.class.getClassLoader().getResource(keystorePath)) != null && (file = new File(url.toURI())).exists()) {
                return file.getAbsolutePath();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception finding keystore", (Throwable)e);
        }
        throw new FileNotFoundException("Failed to load SSL keystore from " + keystorePath);
    }

    public void setUseJsse(boolean useJsse) {
        this.useJsse = useJsse;
    }

    public boolean useJsse() {
        return this.useJsse;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean isClientAuth() {
        return this.clientAuth;
    }

    public TSSLTransportFactory.TSSLTransportParameters getTTransportParams() {
        if (this.useJsse) {
            throw new IllegalStateException("Cannot get TTransportParams for JSEE configuration.");
        }
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.requireClientAuth(this.clientAuth);
        if (this.keyStoreSet) {
            params.setKeyStore(this.keyStorePath, this.keyStorePass, null, this.keyStoreType);
        }
        if (this.trustStoreSet) {
            params.setTrustStore(this.trustStorePath, this.trustStorePass, null, this.trustStoreType);
        }
        return params;
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + (this.clientAuth ? 0 : 1);
        hash = 31 * hash + (this.useJsse ? 0 : 1);
        if (this.useJsse) {
            return hash;
        }
        hash = 31 * hash + (this.keyStoreSet ? 0 : 1);
        hash = 31 * hash + (this.trustStoreSet ? 0 : 1);
        if (this.keyStoreSet) {
            hash = 31 * hash + this.keyStorePath.hashCode();
        }
        if (this.trustStoreSet) {
            hash = 31 * hash + this.trustStorePath.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SslConnectionParams)) {
            return false;
        }
        SslConnectionParams other = (SslConnectionParams)obj;
        if (this.clientAuth != other.clientAuth) {
            return false;
        }
        if (this.useJsse) {
            return other.useJsse;
        }
        if (this.keyStoreSet) {
            if (!other.keyStoreSet) {
                return false;
            }
            if (!(this.keyStorePath.equals(other.keyStorePath) && this.keyStorePass.equals(other.keyStorePass) && this.keyStoreType.equals(other.keyStoreType))) {
                return false;
            }
        }
        if (this.trustStoreSet) {
            if (!other.trustStoreSet) {
                return false;
            }
            if (!(this.trustStorePath.equals(other.trustStorePath) && this.trustStorePass.equals(other.trustStorePass) && this.trustStoreType.equals(other.trustStoreType))) {
                return false;
            }
        }
        return true;
    }
}

