/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.tabletserver.log;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;

public class LogEntry {
    public KeyExtent extent;
    public long timestamp;
    public String server;
    public String filename;
    public int tabletId;
    public Collection<String> logSet;
    private static final Text EMPTY_TEXT = new Text();

    public LogEntry() {
    }

    public LogEntry(LogEntry le) {
        this.extent = le.extent;
        this.timestamp = le.timestamp;
        this.server = le.server;
        this.filename = le.filename;
        this.tabletId = le.tabletId;
        this.logSet = new ArrayList<String>(le.logSet);
    }

    public String toString() {
        return this.extent.toString() + " " + this.filename + " (" + this.tabletId + ")";
    }

    public String getName() {
        return this.server + "/" + this.filename;
    }

    public byte[] toBytes() throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        this.extent.write((DataOutput)out);
        out.writeLong(this.timestamp);
        out.writeUTF(this.server);
        out.writeUTF(this.filename);
        out.write(this.tabletId);
        out.write(this.logSet.size());
        for (String s : this.logSet) {
            out.writeUTF(s);
        }
        return Arrays.copyOf(out.getData(), out.getLength());
    }

    public void fromBytes(byte[] bytes) throws IOException {
        DataInputBuffer inp = new DataInputBuffer();
        inp.reset(bytes, bytes.length);
        this.extent = new KeyExtent();
        this.extent.readFields((DataInput)inp);
        this.timestamp = inp.readLong();
        this.server = inp.readUTF();
        this.filename = inp.readUTF();
        this.tabletId = inp.read();
        int count = inp.read();
        ArrayList<String> logSet = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            logSet.add(inp.readUTF());
        }
        this.logSet = logSet;
    }

    public static LogEntry fromKeyValue(Key key, Value value) {
        LogEntry result = new LogEntry();
        result.extent = new KeyExtent(key.getRow(), EMPTY_TEXT);
        String[] parts = key.getColumnQualifier().toString().split("/", 2);
        result.server = parts[0];
        result.filename = parts[1];
        parts = value.toString().split("\\|");
        result.tabletId = Integer.parseInt(parts[1]);
        result.logSet = Arrays.asList(parts[0].split(";"));
        result.timestamp = key.getTimestamp();
        return result;
    }

    public Text getRow() {
        return this.extent.getMetadataEntry();
    }

    public Text getColumnFamily() {
        return MetadataSchema.TabletsSection.LogColumnFamily.NAME;
    }

    public Text getColumnQualifier() {
        return new Text(this.server + "/" + this.filename);
    }

    public Value getValue() {
        return new Value((StringUtil.join(this.logSet, ";") + "|" + this.tabletId).getBytes());
    }
}

