/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.crypto;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.crypto.BlockedInputStream;
import org.apache.accumulo.core.security.crypto.BlockedOutputStream;
import org.apache.accumulo.core.security.crypto.CryptoModule;
import org.apache.accumulo.core.security.crypto.CryptoModuleFactory;
import org.apache.accumulo.core.security.crypto.CryptoModuleParameters;
import org.apache.accumulo.core.security.crypto.DefaultCryptoModuleUtils;
import org.apache.accumulo.core.security.crypto.DiscardCloseOutputStream;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategy;
import org.apache.log4j.Logger;

public class DefaultCryptoModule
implements CryptoModule {
    private static final String ENCRYPTION_HEADER_MARKER_V1 = "---Log File Encrypted (v1)---";
    private static final String ENCRYPTION_HEADER_MARKER_V2 = "---Log File Encrypted (v2)---";
    private static Logger log = Logger.getLogger(DefaultCryptoModule.class);

    @Override
    public CryptoModuleParameters initializeCipher(CryptoModuleParameters params) {
        String cipherTransformation = this.getCipherTransformation(params);
        log.trace((Object)String.format("Using cipher suite \"%s\" with key length %d with RNG \"%s\" and RNG provider \"%s\" and key encryption strategy \"%s\"", cipherTransformation, params.getKeyLength(), params.getRandomNumberGenerator(), params.getRandomNumberGeneratorProvider(), params.getKeyEncryptionStrategyClass()));
        if (params.getSecureRandom() == null) {
            SecureRandom secureRandom = DefaultCryptoModuleUtils.getSecureRandom(params.getRandomNumberGenerator(), params.getRandomNumberGeneratorProvider());
            params.setSecureRandom(secureRandom);
        }
        Cipher cipher = DefaultCryptoModuleUtils.getCipher(cipherTransformation);
        if (params.getInitializationVector() == null) {
            try {
                cipher.init(1, (Key)new SecretKeySpec(params.getPlaintextKey(), params.getAlgorithmName()), params.getSecureRandom());
            }
            catch (InvalidKeyException e) {
                log.error((Object)"Accumulo encountered an unknown error in generating the secret key object (SecretKeySpec) for an encrypted stream");
                throw new RuntimeException(e);
            }
            params.setInitializationVector(cipher.getIV());
        } else {
            try {
                cipher.init(1, (Key)new SecretKeySpec(params.getPlaintextKey(), params.getAlgorithmName()), new IvParameterSpec(params.getInitializationVector()));
            }
            catch (InvalidKeyException e) {
                log.error((Object)"Accumulo encountered an unknown error in generating the secret key object (SecretKeySpec) for an encrypted stream");
                throw new RuntimeException(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                log.error((Object)"Accumulo encountered an unknown error in setting up the initialization vector for an encrypted stream");
                throw new RuntimeException(e);
            }
        }
        params.setCipher(cipher);
        return params;
    }

    private String getCipherTransformation(CryptoModuleParameters params) {
        String cipherSuite = params.getAlgorithmName() + "/" + params.getEncryptionMode() + "/" + params.getPadding();
        return cipherSuite;
    }

    private String[] parseCipherSuite(String cipherSuite) {
        return cipherSuite.split("/");
    }

    private boolean validateNotEmpty(String givenValue, boolean allIsWell, StringBuffer buf, String errorMessage) {
        if (givenValue == null || givenValue.equals("")) {
            buf.append(errorMessage);
            buf.append("\n");
            return false;
        }
        return allIsWell;
    }

    private boolean validateNotNull(Object givenValue, boolean allIsWell, StringBuffer buf, String errorMessage) {
        if (givenValue == null) {
            buf.append(errorMessage);
            buf.append("\n");
            return false;
        }
        return allIsWell;
    }

    private boolean validateNotZero(int givenValue, boolean allIsWell, StringBuffer buf, String errorMessage) {
        if (givenValue == 0) {
            buf.append(errorMessage);
            buf.append("\n");
            return false;
        }
        return allIsWell;
    }

    private boolean validateParamsObject(CryptoModuleParameters params, int cipherMode) {
        if (cipherMode == 1) {
            StringBuffer errorBuf = new StringBuffer("The following problems were found with the CryptoModuleParameters object you provided for an encrypt operation:\n");
            boolean allIsWell = true;
            allIsWell = this.validateNotEmpty(params.getAlgorithmName(), allIsWell, errorBuf, "No algorithm name was specified.");
            if (allIsWell && params.getAlgorithmName().equals("NullCipher")) {
                return true;
            }
            allIsWell = this.validateNotEmpty(params.getPadding(), allIsWell, errorBuf, "No padding was specified.");
            allIsWell = this.validateNotZero(params.getKeyLength(), allIsWell, errorBuf, "No key length was specified.");
            allIsWell = this.validateNotEmpty(params.getEncryptionMode(), allIsWell, errorBuf, "No encryption mode was specified.");
            allIsWell = this.validateNotEmpty(params.getRandomNumberGenerator(), allIsWell, errorBuf, "No random number generator was specified.");
            allIsWell = this.validateNotEmpty(params.getRandomNumberGeneratorProvider(), allIsWell, errorBuf, "No random number generate provider was specified.");
            allIsWell = this.validateNotNull(params.getPlaintextOutputStream(), allIsWell, errorBuf, "No plaintext output stream was specified.");
            if (!allIsWell) {
                log.error((Object)"CryptoModulesParameters object is not valid.");
                log.error((Object)errorBuf.toString());
                throw new RuntimeException("CryptoModulesParameters object is not valid.");
            }
            return allIsWell;
        }
        if (cipherMode == 2) {
            StringBuffer errorBuf = new StringBuffer("The following problems were found with the CryptoModuleParameters object you provided for a decrypt operation:\n");
            boolean allIsWell = true;
            allIsWell = this.validateNotEmpty(params.getPadding(), allIsWell, errorBuf, "No padding was specified.");
            allIsWell = this.validateNotZero(params.getKeyLength(), allIsWell, errorBuf, "No key length was specified.");
            allIsWell = this.validateNotEmpty(params.getEncryptionMode(), allIsWell, errorBuf, "No encryption mode was specified.");
            allIsWell = this.validateNotEmpty(params.getRandomNumberGenerator(), allIsWell, errorBuf, "No random number generator was specified.");
            allIsWell = this.validateNotEmpty(params.getRandomNumberGeneratorProvider(), allIsWell, errorBuf, "No random number generate provider was specified.");
            allIsWell = this.validateNotNull(params.getEncryptedInputStream(), allIsWell, errorBuf, "No encrypted input stream was specified.");
            allIsWell = this.validateNotNull(params.getInitializationVector(), allIsWell, errorBuf, "No initialization vector was specified.");
            allIsWell = this.validateNotNull(params.getEncryptedKey(), allIsWell, errorBuf, "No encrypted key was specified.");
            if (params.getKeyEncryptionStrategyClass() != null && !params.getKeyEncryptionStrategyClass().equals("NullSecretKeyEncryptionStrategy")) {
                allIsWell = this.validateNotEmpty(params.getOpaqueKeyEncryptionKeyID(), allIsWell, errorBuf, "No opqaue key encryption ID was specified.");
            }
            if (!allIsWell) {
                log.error((Object)"CryptoModulesParameters object is not valid.");
                log.error((Object)errorBuf.toString());
                throw new RuntimeException("CryptoModulesParameters object is not valid.");
            }
            return allIsWell;
        }
        return false;
    }

    @Override
    public CryptoModuleParameters getEncryptingOutputStream(CryptoModuleParameters params) throws IOException {
        SecretKeyEncryptionStrategy keyEncryptionStrategy;
        log.trace((Object)"Initializing crypto output stream (new style)");
        boolean allParamsOK = this.validateParamsObject(params, 1);
        if (!allParamsOK) {
            log.error((Object)"CryptoModuleParameters was not valid.");
            throw new RuntimeException("Invalid CryptoModuleParameters");
        }
        if (params.getAlgorithmName().equals("NullCipher")) {
            params.setEncryptedOutputStream(params.getPlaintextOutputStream());
            return params;
        }
        SecureRandom secureRandom = DefaultCryptoModuleUtils.getSecureRandom(params.getRandomNumberGenerator(), params.getRandomNumberGeneratorProvider());
        if (params.getPlaintextKey() == null) {
            byte[] randomKey = new byte[params.getKeyLength() / 8];
            secureRandom.nextBytes(randomKey);
            params.setPlaintextKey(randomKey);
        }
        if (!(params = (keyEncryptionStrategy = CryptoModuleFactory.getSecretKeyEncryptionStrategy(params.getKeyEncryptionStrategyClass())).encryptSecretKey(params)).getCloseUnderylingStreamAfterCryptoStreamClose()) {
            params.setPlaintextOutputStream(new DiscardCloseOutputStream(params.getPlaintextOutputStream()));
        }
        if (params.getCipher() == null) {
            this.initializeCipher(params);
        }
        CipherOutputStream cipherOutputStream = new CipherOutputStream(params.getPlaintextOutputStream(), params.getCipher());
        BlockedOutputStream blockedOutputStream = new BlockedOutputStream(cipherOutputStream, params.getCipher().getBlockSize(), params.getBlockStreamSize());
        params.setEncryptedOutputStream(blockedOutputStream);
        if (params.getRecordParametersToStream()) {
            DataOutputStream dataOut = new DataOutputStream(params.getPlaintextOutputStream());
            dataOut.writeUTF(ENCRYPTION_HEADER_MARKER_V2);
            dataOut.writeInt(params.getAllOptions().size());
            for (String key : params.getAllOptions().keySet()) {
                dataOut.writeUTF(key);
                dataOut.writeUTF(params.getAllOptions().get(key));
            }
            dataOut.writeUTF(this.getCipherTransformation(params));
            dataOut.writeUTF(params.getAlgorithmName());
            dataOut.writeInt(params.getInitializationVector().length);
            dataOut.write(params.getInitializationVector());
            dataOut.writeUTF(params.getOpaqueKeyEncryptionKeyID());
            dataOut.writeInt(params.getEncryptedKey().length);
            dataOut.write(params.getEncryptedKey());
            dataOut.writeInt(params.getBlockStreamSize());
        }
        return params;
    }

    @Override
    public CryptoModuleParameters getDecryptingInputStream(CryptoModuleParameters params) throws IOException {
        boolean allParamsOK;
        log.trace((Object)"About to initialize decryption stream (new style)");
        if (params.getRecordParametersToStream()) {
            DataInputStream dataIn = new DataInputStream(params.getEncryptedInputStream());
            log.trace((Object)"About to read encryption parameters from underlying stream");
            String marker = dataIn.readUTF();
            if (marker.equals(ENCRYPTION_HEADER_MARKER_V1) || marker.equals(ENCRYPTION_HEADER_MARKER_V2)) {
                HashMap<String, String> paramsFromFile = new HashMap<String, String>();
                int paramsCount = dataIn.readInt();
                for (int i = 0; i < paramsCount; ++i) {
                    String key = dataIn.readUTF();
                    String value = dataIn.readUTF();
                    paramsFromFile.put(key, value);
                }
                String cipherSuiteFromFile = dataIn.readUTF();
                String algorithmNameFromFile = dataIn.readUTF();
                String[] cipherSuiteParts = this.parseCipherSuite(cipherSuiteFromFile);
                params.setAlgorithmName(algorithmNameFromFile);
                params.setEncryptionMode(cipherSuiteParts[1]);
                params.setPadding(cipherSuiteParts[2]);
                int initVectorLength = dataIn.readInt();
                byte[] initVector = new byte[initVectorLength];
                dataIn.readFully(initVector);
                params.setInitializationVector(initVector);
                String opaqueId = dataIn.readUTF();
                params.setOpaqueKeyEncryptionKeyID(opaqueId);
                int encryptedSecretKeyLength = dataIn.readInt();
                byte[] encryptedSecretKey = new byte[encryptedSecretKeyLength];
                dataIn.readFully(encryptedSecretKey);
                params.setEncryptedKey(encryptedSecretKey);
                if (params.getOverrideStreamsSecretKeyEncryptionStrategy()) {
                    for (String name : paramsFromFile.keySet()) {
                        if (name.equals(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey())) continue;
                        params.getAllOptions().put(name, (String)paramsFromFile.get(name));
                    }
                    params.setKeyEncryptionStrategyClass(params.getAllOptions().get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey()));
                } else {
                    params = CryptoModuleFactory.fillParamsObjectFromStringMap(params, paramsFromFile);
                }
                SecretKeyEncryptionStrategy keyEncryptionStrategy = CryptoModuleFactory.getSecretKeyEncryptionStrategy(params.getKeyEncryptionStrategyClass());
                params = keyEncryptionStrategy.decryptSecretKey(params);
                if (marker.equals(ENCRYPTION_HEADER_MARKER_V2)) {
                    params.setBlockStreamSize(dataIn.readInt());
                } else {
                    params.setBlockStreamSize(0);
                }
            } else {
                log.trace((Object)"Read something off of the encrypted input stream that was not the encryption header marker, so pushing back bytes and returning the given stream");
                ByteArrayOutputStream tempByteOut = new ByteArrayOutputStream();
                DataOutputStream tempOut = new DataOutputStream(tempByteOut);
                tempOut.writeUTF(marker);
                byte[] bytesToPutBack = tempByteOut.toByteArray();
                PushbackInputStream pushbackStream = new PushbackInputStream(params.getEncryptedInputStream(), bytesToPutBack.length);
                pushbackStream.unread(bytesToPutBack);
                params.setPlaintextInputStream(pushbackStream);
                return params;
            }
        }
        if (!(allParamsOK = this.validateParamsObject(params, 2))) {
            log.error((Object)"CryptoModuleParameters object failed validation for decrypt");
            throw new RuntimeException("CryptoModuleParameters object failed validation for decrypt");
        }
        Cipher cipher = DefaultCryptoModuleUtils.getCipher(this.getCipherTransformation(params));
        try {
            cipher.init(2, (Key)new SecretKeySpec(params.getPlaintextKey(), params.getAlgorithmName()), new IvParameterSpec(params.getInitializationVector()));
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Error when trying to initialize cipher with secret key");
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error((Object)"Error when trying to initialize cipher with initialization vector");
            throw new RuntimeException(e);
        }
        InputStream blockedDecryptingInputStream = new CipherInputStream(params.getEncryptedInputStream(), cipher);
        if (params.getBlockStreamSize() > 0) {
            blockedDecryptingInputStream = new BlockedInputStream(blockedDecryptingInputStream, cipher.getBlockSize(), params.getBlockStreamSize());
        }
        log.trace((Object)("Initialized cipher input stream with transformation [" + this.getCipherTransformation(params) + "]"));
        params.setPlaintextInputStream(blockedDecryptingInputStream);
        return params;
    }

    @Override
    public CryptoModuleParameters generateNewRandomSessionKey(CryptoModuleParameters params) {
        if (params.getSecureRandom() == null) {
            params.setSecureRandom(DefaultCryptoModuleUtils.getSecureRandom(params.getRandomNumberGenerator(), params.getRandomNumberGeneratorProvider()));
        }
        byte[] newSessionKey = new byte[params.getKeyLength() / 8];
        params.getSecureRandom().nextBytes(newSessionKey);
        params.setPlaintextKey(newSessionKey);
        return params;
    }
}

