/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.util.SortedMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.metadata.ServicerForMetadataTable;
import org.apache.accumulo.core.metadata.ServicerForRootTable;
import org.apache.accumulo.core.metadata.ServicerForUserTables;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.ArgumentChecker;

public abstract class MetadataServicer {
    public static MetadataServicer forTableName(Instance instance, Credentials credentials, String tableName) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(tableName);
        Connector conn = instance.getConnector(credentials.getPrincipal(), credentials.getToken());
        return MetadataServicer.forTableId(instance, credentials, conn.tableOperations().tableIdMap().get(tableName));
    }

    public static MetadataServicer forTableId(Instance instance, Credentials credentials, String tableId) {
        ArgumentChecker.notNull(tableId);
        if ("+r".equals(tableId)) {
            return new ServicerForRootTable(instance, credentials);
        }
        if ("!0".equals(tableId)) {
            return new ServicerForMetadataTable(instance, credentials);
        }
        return new ServicerForUserTables(instance, credentials, tableId);
    }

    public abstract String getServicedTableId();

    public abstract void getTabletLocations(SortedMap<KeyExtent, String> var1) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;
}

