/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;

public class LargeRowFilter
implements SortedKeyValueIterator<Key, Value>,
OptionDescriber {
    public static final Value SUPPRESS_ROW_VALUE = new Value("SUPPRESS_ROW".getBytes(Constants.UTF8));
    private static final ByteSequence EMPTY = new ArrayByteSequence(new byte[0]);
    private static final String MAX_COLUMNS = "max_columns";
    private SortedKeyValueIterator<Key, Value> source;
    private ArrayList<Key> keys = new ArrayList();
    private ArrayList<Value> values = new ArrayList();
    private int currentPosition;
    private int maxColumns;
    private boolean propogateSuppression = false;
    private Range range;
    private Collection<ByteSequence> columnFamilies;
    private boolean inclusive;
    private boolean dropEmptyColFams;

    private boolean isSuppressionMarker(Key key, Value val) {
        return key.getColumnFamilyData().length() == 0 && key.getColumnQualifierData().length() == 0 && key.getColumnVisibilityData().length() == 0 && val.equals(SUPPRESS_ROW_VALUE);
    }

    private void reseek(Key key) throws IOException {
        if (this.range.afterEndKey(key)) {
            this.range = new Range(this.range.getEndKey(), true, this.range.getEndKey(), this.range.isEndKeyInclusive());
            this.source.seek(this.range, this.columnFamilies, this.inclusive);
        } else {
            this.range = new Range(key, true, this.range.getEndKey(), this.range.isEndKeyInclusive());
            this.source.seek(this.range, this.columnFamilies, this.inclusive);
        }
    }

    private void consumeRow(ByteSequence row) throws IOException {
        int count = 0;
        while (this.source.hasTop() && this.source.getTopKey().getRowData().equals(row)) {
            this.source.next();
            if (++count < 10) continue;
            Key nextRowStart = new Key(new Text(row.toArray())).followingKey(PartialKey.ROW);
            this.reseek(nextRowStart);
            count = 0;
        }
    }

    private void addKeyValue(Key k, Value v) {
        if (this.dropEmptyColFams && k.getColumnFamilyData().equals(EMPTY)) {
            return;
        }
        this.keys.add(new Key(k));
        this.values.add(new Value(v));
    }

    private void bufferNextRow() throws IOException {
        this.keys.clear();
        this.values.clear();
        this.currentPosition = 0;
        while (this.source.hasTop() && this.keys.size() == 0) {
            this.addKeyValue(this.source.getTopKey(), this.source.getTopValue());
            if (this.isSuppressionMarker(this.source.getTopKey(), this.source.getTopValue())) {
                this.consumeRow(this.source.getTopKey().getRowData());
                continue;
            }
            ByteSequence currentRow = this.keys.get(0).getRowData();
            this.source.next();
            while (this.source.hasTop() && this.source.getTopKey().getRowData().equals(currentRow)) {
                this.addKeyValue(this.source.getTopKey(), this.source.getTopValue());
                if (this.keys.size() > this.maxColumns) {
                    this.keys.clear();
                    this.values.clear();
                    this.addKeyValue(new Key(new Text(currentRow.toArray())), SUPPRESS_ROW_VALUE);
                    this.consumeRow(currentRow);
                    continue;
                }
                this.source.next();
            }
        }
    }

    private void readNextRow() throws IOException {
        this.bufferNextRow();
        while (!this.propogateSuppression && this.currentPosition < this.keys.size() && this.isSuppressionMarker(this.keys.get(0), this.values.get(0))) {
            this.bufferNextRow();
        }
    }

    private LargeRowFilter(SortedKeyValueIterator<Key, Value> source, boolean propogateSuppression, int maxColumns) {
        this.source = source;
        this.propogateSuppression = propogateSuppression;
        this.maxColumns = maxColumns;
    }

    public LargeRowFilter() {
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source = source;
        this.maxColumns = Integer.parseInt(options.get(MAX_COLUMNS));
        this.propogateSuppression = env.getIteratorScope() != IteratorUtil.IteratorScope.scan;
    }

    @Override
    public boolean hasTop() {
        return this.currentPosition < this.keys.size();
    }

    @Override
    public void next() throws IOException {
        if (this.currentPosition >= this.keys.size()) {
            throw new IllegalStateException("Called next() when hasTop() is false");
        }
        ++this.currentPosition;
        if (this.currentPosition == this.keys.size()) {
            this.readNextRow();
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        if (inclusive && !columnFamilies.contains(EMPTY)) {
            columnFamilies = new HashSet<ByteSequence>(columnFamilies);
            columnFamilies.add(EMPTY);
            this.dropEmptyColFams = true;
        } else if (!inclusive && columnFamilies.contains(EMPTY)) {
            columnFamilies = new HashSet<ByteSequence>(columnFamilies);
            columnFamilies.remove(EMPTY);
            this.dropEmptyColFams = true;
        } else {
            this.dropEmptyColFams = false;
        }
        this.range = range;
        this.columnFamilies = columnFamilies;
        this.inclusive = inclusive;
        if (range.getStartKey() != null) {
            Range newRange = new Range(new Key(range.getStartKey().getRow()), true, range.getEndKey(), range.isEndKeyInclusive());
            this.source.seek(newRange, columnFamilies, inclusive);
            this.readNextRow();
            while (this.currentPosition < this.keys.size() && range.beforeStartKey(this.keys.get(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (this.currentPosition == this.keys.size()) {
                this.readNextRow();
            }
        } else {
            this.source.seek(range, columnFamilies, inclusive);
            this.readNextRow();
        }
    }

    @Override
    public Key getTopKey() {
        return this.keys.get(this.currentPosition);
    }

    @Override
    public Value getTopValue() {
        return this.values.get(this.currentPosition);
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new LargeRowFilter(this.source.deepCopy(env), this.propogateSuppression, this.maxColumns);
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        String description = "This iterator suppresses rows that exceed a specified number of columns. Once\na row exceeds the threshold, a marker is emitted and the row is always\nsuppressed by this iterator after that point in time.\n This iterator works in a similar way to the RowDeletingIterator. See its\n javadoc about locality groups.\n";
        return new OptionDescriber.IteratorOptions(this.getClass().getSimpleName(), description, Collections.singletonMap(MAX_COLUMNS, "Number Of Columns To Begin Suppression"), null);
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (options == null || options.size() < 1) {
            throw new IllegalArgumentException("Bad # of options, must supply: max_columns as value");
        }
        if (!options.containsKey(MAX_COLUMNS)) {
            throw new IllegalArgumentException("Bad # of options, must supply: max_columns as value");
        }
        try {
            this.maxColumns = Integer.parseInt(options.get(MAX_COLUMNS));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad integer max_columns:" + options.get(MAX_COLUMNS));
        }
        return true;
    }

    public static void setMaxColumns(IteratorSetting is, int maxColumns) {
        is.addOption(MAX_COLUMNS, Integer.toString(maxColumns));
    }
}

