/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotEmptyException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.impl.NamespaceOperationsHelper;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.mock.MockAccumulo;
import org.apache.accumulo.core.client.mock.MockNamespace;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;

class MockNamespaceOperations
extends NamespaceOperationsHelper {
    private final MockAccumulo acu;
    private final String username;

    MockNamespaceOperations(MockAccumulo acu, String username) {
        this.acu = acu;
        this.username = username;
    }

    @Override
    public SortedSet<String> list() {
        return new TreeSet<String>(this.acu.namespaces.keySet());
    }

    @Override
    public boolean exists(String namespace) {
        return this.acu.namespaces.containsKey(namespace);
    }

    @Override
    public void create(String namespace) throws AccumuloException, AccumuloSecurityException, NamespaceExistsException {
        if (!namespace.matches("^\\w*$")) {
            throw new IllegalArgumentException();
        }
        if (this.exists(namespace)) {
            throw new NamespaceExistsException(namespace, namespace, "");
        }
        this.acu.createNamespace(this.username, namespace);
    }

    @Override
    public void delete(String namespace) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceNotEmptyException {
        if (this.acu.namespaces.get(namespace).getTables(this.acu).size() > 0) {
            throw new NamespaceNotEmptyException(null, namespace, null);
        }
        this.acu.namespaces.remove(namespace);
    }

    @Override
    public void rename(String oldNamespaceName, String newNamespaceName) throws AccumuloSecurityException, NamespaceNotFoundException, AccumuloException, NamespaceExistsException {
        if (!this.exists(oldNamespaceName)) {
            throw new NamespaceNotFoundException(oldNamespaceName, oldNamespaceName, "");
        }
        if (this.exists(newNamespaceName)) {
            throw new NamespaceExistsException(newNamespaceName, newNamespaceName, "");
        }
        MockNamespace n = this.acu.namespaces.get(oldNamespaceName);
        for (String t : n.getTables(this.acu)) {
            String tt = newNamespaceName + "." + Tables.qualify(t).getSecond();
            this.acu.tables.put(tt, this.acu.tables.remove(t));
        }
        this.acu.namespaces.put(newNamespaceName, this.acu.namespaces.remove(oldNamespaceName));
    }

    @Override
    public void setProperty(String namespace, String property, String value) throws AccumuloException, AccumuloSecurityException {
        this.acu.namespaces.get((Object)namespace).settings.put(property, value);
    }

    @Override
    public void removeProperty(String namespace, String property) throws AccumuloException, AccumuloSecurityException {
        this.acu.namespaces.get((Object)namespace).settings.remove(property);
    }

    @Override
    public Iterable<Map.Entry<String, String>> getProperties(String namespace) throws NamespaceNotFoundException {
        if (!this.exists(namespace)) {
            throw new NamespaceNotFoundException(namespace, namespace, "");
        }
        return this.acu.namespaces.get((Object)namespace).settings.entrySet();
    }

    @Override
    public Map<String, String> namespaceIdMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String table : this.acu.tables.keySet()) {
            result.put(table, table);
        }
        return result;
    }

    @Override
    public boolean testClassLoad(String namespace, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        try {
            AccumuloVFSClassLoader.loadClass((String)className, Class.forName(asTypeName));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

