/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.Lexicoder;

public class ULongLexicoder
implements Lexicoder<Long> {
    @Override
    public byte[] encode(Long l) {
        int index;
        int shift = 56;
        int prefix = l < 0L ? 255 : 0;
        for (index = 0; index < 8 && (l >>> shift & 0xFFL) == (long)prefix; ++index) {
            shift -= 8;
        }
        byte[] ret = new byte[9 - index];
        ret[0] = (byte)(8 - index);
        for (index = 1; index < ret.length; ++index) {
            ret[index] = (byte)(l >>> shift);
            shift -= 8;
        }
        if (l < 0L) {
            ret[0] = (byte)(16 - ret[0]);
        }
        return ret;
    }

    @Override
    public Long decode(byte[] data) {
        long l = 0L;
        int shift = 0;
        if (data[0] < 0 || data[0] > 16) {
            throw new IllegalArgumentException("Unexpected length " + (0xFF & data[0]));
        }
        for (int i = data.length - 1; i >= 1; --i) {
            l += ((long)data[i] & 0xFFL) << shift;
            shift += 8;
        }
        if (data[0] > 8) {
            l |= -1L << (16 - data[0] << 3);
        }
        return l;
    }
}

