/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;

public class TableNotFoundException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String tableName;

    public TableNotFoundException(String tableId, String tableName, String description) {
        super("Table" + (tableName != null && !tableName.isEmpty() ? " " + tableName : "") + (tableId != null && !tableId.isEmpty() ? " (Id=" + tableId + ")" : "") + " does not exist" + (description != null && !description.isEmpty() ? " (" + description + ")" : ""));
        this.tableName = tableName;
    }

    public TableNotFoundException(String tableId, String tableName, String description, Throwable cause) {
        this(tableId, tableName, description);
        super.initCause(cause);
    }

    public TableNotFoundException(ThriftTableOperationException e) {
        this(e.getTableId(), e.getTableName(), e.getDescription(), (Throwable)((Object)e));
    }

    public TableNotFoundException(String tableName, NamespaceNotFoundException e) {
        this(null, tableName, "Namespace " + Tables.qualify(tableName).getFirst() + " does not exist.", e);
    }

    public String getTableName() {
        return this.tableName;
    }
}

