/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Shell;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.ExecBean;
import org.apache.hive.hcatalog.templeton.ExecService;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.MaxByteArrayOutputStream;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.StreamOutputWriter;

public class ExecServiceImpl
implements ExecService {
    private static final Log LOG = LogFactory.getLog(ExecServiceImpl.class);
    private static AppConfig appConf = Main.getAppConfigInstance();
    private static volatile ExecServiceImpl theSingleton;
    private static final Object WindowsProcessLaunchLock;
    private Semaphore avail = new Semaphore(appConf.getInt("templeton.exec.max-procs", 16));

    public static synchronized ExecServiceImpl getInstance() {
        if (theSingleton == null) {
            theSingleton = new ExecServiceImpl();
        }
        return theSingleton;
    }

    private ExecServiceImpl() {
    }

    @Override
    public ExecBean run(String program, List<String> args, Map<String, String> env) throws NotAuthorizedException, BusyException, ExecuteException, IOException {
        boolean aquired = false;
        try {
            aquired = this.avail.tryAcquire();
            if (aquired) {
                ExecBean execBean = this.runUnlimited(program, args, env);
                return execBean;
            }
            throw new BusyException();
        }
        finally {
            if (aquired) {
                this.avail.release();
            }
        }
    }

    @Override
    public ExecBean runUnlimited(String program, List<String> args, Map<String, String> env) throws NotAuthorizedException, ExecuteException, IOException {
        try {
            return this.auxRun(program, args, env);
        }
        catch (IOException e) {
            File cwd = new File(".");
            if (cwd.canRead() && cwd.canWrite()) {
                throw e;
            }
            throw new IOException("Invalid permissions on Templeton directory: " + cwd.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecBean auxRun(String program, List<String> args, Map<String, String> env) throws NotAuthorizedException, ExecuteException, IOException {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValues(null);
        int nbytes = appConf.getInt("templeton.exec.max-output-bytes", -1);
        MaxByteArrayOutputStream outStream = new MaxByteArrayOutputStream(nbytes);
        MaxByteArrayOutputStream errStream = new MaxByteArrayOutputStream(nbytes);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outStream, (OutputStream)errStream));
        int timeout = appConf.getInt("templeton.exec.timeout", 0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)timeout);
        executor.setWatchdog(watchdog);
        CommandLine cmd = this.makeCommandLine(program, args);
        LOG.info((Object)("Running: " + cmd));
        ExecBean res = new ExecBean();
        if (Shell.WINDOWS) {
            Process proc;
            Map.Entry<String, String> kv2;
            env = this.execEnv(env);
            String[] envVals = new String[env.size()];
            int i = 0;
            for (Map.Entry<String, String> kv2 : env.entrySet()) {
                envVals[i++] = kv2.getKey() + "=" + kv2.getValue();
                LOG.info((Object)("Setting " + kv2.getKey() + "=" + kv2.getValue()));
            }
            kv2 = WindowsProcessLaunchLock;
            synchronized (kv2) {
                proc = Runtime.getRuntime().exec(cmd.toStrings(), envVals);
            }
            StreamOutputWriter errorGobbler = new StreamOutputWriter(proc.getErrorStream(), "ERROR", errStream);
            StreamOutputWriter outputGobbler = new StreamOutputWriter(proc.getInputStream(), "OUTPUT", outStream);
            errorGobbler.start();
            outputGobbler.start();
            try {
                res.exitcode = proc.waitFor();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            errorGobbler.out.flush();
            outputGobbler.out.flush();
        } else {
            res.exitcode = executor.execute(cmd, this.execEnv(env));
        }
        String enc = appConf.get("templeton.exec.encoding");
        res.stdout = outStream.toString(enc);
        res.stderr = errStream.toString(enc);
        try {
            watchdog.checkException();
        }
        catch (Exception ex) {
            LOG.error((Object)("Command: " + cmd + " failed. res=" + res), (Throwable)ex);
        }
        if (watchdog.killedProcess()) {
            String msg = " was terminated due to timeout(" + timeout + "ms).  See " + "templeton.exec.timeout" + " property";
            LOG.warn((Object)("Command: " + cmd + msg + " res=" + res));
            res.stderr = res.stderr + " Command " + msg;
        }
        if (res.exitcode != 0) {
            LOG.info((Object)("Command: " + cmd + " failed. res=" + res));
        }
        return res;
    }

    private CommandLine makeCommandLine(String program, List<String> args) throws NotAuthorizedException, IOException {
        String path = this.validateProgram(program);
        CommandLine cmd = new CommandLine(path);
        if (args != null) {
            for (String arg : args) {
                cmd.addArgument(arg, false);
            }
        }
        return cmd;
    }

    public Map<String, String> execEnv(Map<String, String> env) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String key : appConf.getStrings("templeton.exec.envs")) {
            String val = System.getenv(key);
            if (val == null) continue;
            res.put(key, val);
        }
        if (env != null) {
            res.putAll(env);
        }
        for (Map.Entry entry : res.entrySet()) {
            LOG.info((Object)("Env " + (String)entry.getKey() + "=" + (String)entry.getValue()));
        }
        return res;
    }

    public String validateProgram(String path) throws NotAuthorizedException, IOException {
        File f = new File(path);
        if (f.canExecute()) {
            return f.getCanonicalPath();
        }
        throw new NotAuthorizedException("Unable to access program: " + path);
    }

    static {
        WindowsProcessLaunchLock = new Object();
    }
}

