/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate.compare;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;

public class IntCompare
implements PrimitiveComparison {
    private int constant;

    @Override
    public void init(byte[] constant) {
        this.constant = this.serialize(constant);
    }

    @Override
    public boolean isEqual(byte[] value) {
        return this.serialize(value) == this.constant;
    }

    @Override
    public boolean isNotEqual(byte[] value) {
        return this.serialize(value) != this.constant;
    }

    @Override
    public boolean greaterThanOrEqual(byte[] value) {
        return this.serialize(value) >= this.constant;
    }

    @Override
    public boolean greaterThan(byte[] value) {
        return this.serialize(value) > this.constant;
    }

    @Override
    public boolean lessThanOrEqual(byte[] value) {
        return this.serialize(value) <= this.constant;
    }

    @Override
    public boolean lessThan(byte[] value) {
        return this.serialize(value) < this.constant;
    }

    @Override
    public boolean like(byte[] value) {
        throw new UnsupportedOperationException("Like not supported for " + this.getClass().getName());
    }

    @Override
    public Integer serialize(byte[] value) {
        try {
            return ByteBuffer.wrap(value).asIntBuffer().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString() + " occurred trying to build int value. " + "Make sure the value type for the byte[] is int ");
        }
    }
}

