/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.hive.accumulo.AccumuloHiveConstants;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.InvalidColumnMappingException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.log4j.Logger;

public class ColumnMappingFactory {
    private static final Logger log = Logger.getLogger(ColumnMappingFactory.class);

    public static ColumnMapping get(String columnSpec, ColumnEncoding defaultEncoding, String columnName, TypeInfo columnType) {
        Preconditions.checkNotNull((Object)columnSpec);
        Preconditions.checkNotNull((Object)columnName);
        Preconditions.checkNotNull((Object)columnType);
        ColumnEncoding encoding = defaultEncoding;
        if (ColumnEncoding.hasColumnEncoding(columnSpec)) {
            String columnEncodingStr = ColumnEncoding.getColumnEncoding(columnSpec);
            if (":rowID".equalsIgnoreCase(columnSpec = ColumnEncoding.stripCode(columnSpec))) {
                return new HiveAccumuloRowIdColumnMapping(columnSpec, ColumnEncoding.get(columnEncodingStr), columnName, columnType.getTypeName());
            }
            Map.Entry<String, String> pair = ColumnMappingFactory.parseMapping(columnSpec);
            if (ColumnMappingFactory.isPrefix(pair.getValue())) {
                if (!ColumnEncoding.isMapEncoding(columnEncodingStr)) {
                    throw new IllegalArgumentException("Expected map encoding for a map specification, " + columnSpec + " with encoding " + columnEncodingStr);
                }
                Map.Entry<ColumnEncoding, ColumnEncoding> encodings = ColumnEncoding.getMapEncoding(columnEncodingStr);
                return new HiveAccumuloMapColumnMapping(pair.getKey(), pair.getValue(), encodings.getKey(), encodings.getValue(), columnName, columnType.getTypeName());
            }
            return new HiveAccumuloColumnMapping(pair.getKey(), pair.getValue(), ColumnEncoding.getFromMapping(columnEncodingStr), columnName, columnType.getTypeName());
        }
        if (":rowID".equalsIgnoreCase(columnSpec)) {
            return new HiveAccumuloRowIdColumnMapping(columnSpec, defaultEncoding, columnName, columnType.getTypeName());
        }
        Map.Entry<String, String> pair = ColumnMappingFactory.parseMapping(columnSpec);
        boolean isPrefix = ColumnMappingFactory.isPrefix(pair.getValue());
        String cq = pair.getValue();
        if (-1 != cq.indexOf(AccumuloHiveConstants.ESCAPED_ASTERISK)) {
            cq = cq.replaceAll(AccumuloHiveConstants.ESCAPED_ASERTISK_REGEX, Character.toString('*'));
        }
        if (isPrefix) {
            return new HiveAccumuloMapColumnMapping(pair.getKey(), cq.substring(0, cq.length() - 1), defaultEncoding, defaultEncoding, columnName, columnType.getTypeName());
        }
        return new HiveAccumuloColumnMapping(pair.getKey(), cq, encoding, columnName, columnType.getTypeName());
    }

    public static ColumnMapping getMap(String columnSpec, ColumnEncoding keyEncoding, ColumnEncoding valueEncoding, String columnName, TypeInfo columnType) {
        Map.Entry<String, String> pair = ColumnMappingFactory.parseMapping(columnSpec);
        return new HiveAccumuloMapColumnMapping(pair.getKey(), pair.getValue(), keyEncoding, valueEncoding, columnName, columnType.toString());
    }

    public static boolean isPrefix(String maybePrefix) {
        Preconditions.checkNotNull((Object)maybePrefix);
        if ('*' == maybePrefix.charAt(maybePrefix.length() - 1)) {
            if (maybePrefix.length() > 1) {
                return '\\' != maybePrefix.charAt(maybePrefix.length() - 2);
            }
            return true;
        }
        return false;
    }

    public static Map.Entry<String, String> parseMapping(String columnSpec) throws InvalidColumnMappingException {
        int index = 0;
        while (true) {
            char testChar;
            if (index >= columnSpec.length()) {
                log.error((Object)("Cannot parse '" + columnSpec + "' as colon-separated column configuration"));
                throw new InvalidColumnMappingException("Columns must be provided as colon-separated family and qualifier pairs");
            }
            if (-1 == (index = columnSpec.indexOf(58, index))) {
                log.error((Object)("Cannot parse '" + columnSpec + "' as colon-separated column configuration"));
                throw new InvalidColumnMappingException("Columns must be provided as colon-separated family and qualifier pairs");
            }
            if (index - 1 <= 0 || '\\' != (testChar = columnSpec.charAt(index - 1))) break;
            ++index;
        }
        String cf = columnSpec.substring(0, index);
        String cq = columnSpec.substring(index + 1);
        if (-1 != cf.indexOf(AccumuloHiveConstants.ESCAPED_COLON)) {
            cf = cf.replaceAll(AccumuloHiveConstants.ESCAPED_COLON_REGEX, Character.toString(':'));
        }
        if (-1 != cq.indexOf(AccumuloHiveConstants.ESCAPED_COLON)) {
            cq = cq.replaceAll(AccumuloHiveConstants.ESCAPED_COLON_REGEX, Character.toString(':'));
        }
        return Maps.immutableEntry((Object)cf, (Object)cq);
    }
}

