/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.testutils.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class HiveBurnInClient {
    private static String driverName = "org.apache.hive.jdbc.HiveDriver";
    private static final int NUM_QUERY_ITERATIONS = 80000;

    public static void createTables(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        String tableName = "table1";
        String sql = "drop table if exists " + tableName;
        HiveBurnInClient.executeQuery(stmt, sql, false);
        sql = "create table " + tableName + " (key int, value string)";
        HiveBurnInClient.executeQuery(stmt, sql, false);
        String filepath = "./examples/files/kv1.txt";
        sql = "load data local inpath '" + filepath + "' into table " + tableName;
        HiveBurnInClient.executeQuery(stmt, sql, false);
        tableName = "table2";
        sql = "drop table if exists " + tableName;
        HiveBurnInClient.executeQuery(stmt, sql, false);
        sql = "create table " + tableName + " (key int, value string)";
        HiveBurnInClient.executeQuery(stmt, sql, false);
        filepath = "./examples/files/kv2.txt";
        sql = "load data local inpath '" + filepath + "' into table " + tableName;
        HiveBurnInClient.executeQuery(stmt, sql, false);
    }

    private static void executeQuery(Statement stmt, String sql, boolean resultSet) throws SQLException {
        System.out.println("Running: " + sql);
        long startTime = System.currentTimeMillis();
        if (resultSet) {
            ResultSet res = stmt.executeQuery(sql);
            while (res.next()) {
                res.getString(1);
            }
        } else {
            stmt.execute(sql);
        }
        long endTime = System.currentTimeMillis();
        long msElapsedTime = endTime - startTime;
        System.out.printf("Time taken for query = %d ms \n", msElapsedTime);
    }

    public static void runQueries(Connection con, int numberOfQueryIterations) throws SQLException {
        Statement stmt = con.createStatement();
        for (int i = 0; i < numberOfQueryIterations; ++i) {
            System.out.println("Iteration #" + i);
            String sql = "from table1 SELECT * group by table1.key order by table1.key desc";
            HiveBurnInClient.executeQuery(stmt, sql, true);
            sql = "select count(*) from table1";
            HiveBurnInClient.executeQuery(stmt, sql, true);
            sql = "select t1.key,count(t1.key) as cnt from table1 t1 join table2 t2 on (t1.key = t2.key) group by t1.key having cnt > 5 order by cnt desc";
            HiveBurnInClient.executeQuery(stmt, sql, true);
            sql = "select table1.value, table2.value from table1 full outer join table2 on (table1.key = table2.key)";
            HiveBurnInClient.executeQuery(stmt, sql, true);
        }
    }

    public static void main(String[] args) throws SQLException, ClassNotFoundException {
        Class.forName(driverName);
        int numberOfQueryIterations = 80000;
        if (args.length > 0) {
            numberOfQueryIterations = Integer.parseInt(args[0]);
        }
        if (numberOfQueryIterations < 0) {
            numberOfQueryIterations = 80000;
        }
        Connection con = DriverManager.getConnection("jdbc:hive2://localhost:10000/default", "hive", "");
        HiveBurnInClient.createTables(con);
        HiveBurnInClient.runQueries(con, numberOfQueryIterations);
    }
}

