/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptQuery;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.LoptOptimizeJoinRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.SemiJoinFilterTransposeRule;
import org.apache.calcite.rel.rules.SemiJoinJoinTransposeRule;
import org.apache.calcite.rel.rules.SemiJoinProjectTransposeRule;
import org.apache.calcite.rel.rules.UnionMergeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveConfigContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveDefaultRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveAlgorithmsConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveVolcanoPlanner;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSort;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveExpandDistinctAggregatesRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterSetOpTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveInsertExchange4JoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinAddNotNullRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinCommuteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinPushTransitivePredicatesRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinToMultiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePartitionPruneRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePreFilteringRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelFieldTrimmer;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveWindowingFixRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.JoinCondTypeCheckProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.JoinTypeCheckCtx;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.PlanModifierForReturnPath;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.RexNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class CalcitePlanner
extends SemanticAnalyzer {
    private final AtomicInteger noColsMissingStats = new AtomicInteger(0);
    private List<FieldSchema> topLevelFieldSchema;
    private SemanticException semanticException;
    private boolean runCBO = true;

    public CalcitePlanner(HiveConf conf) throws SemanticException {
        super(conf);
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_CBO_ENABLED)) {
            this.runCBO = false;
        }
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (this.runCBO) {
            PreCboCtx cboCtx = new PreCboCtx();
            super.analyzeInternal(ast, cboCtx);
        } else {
            super.analyzeInternal(ast);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Operator genOPTree(ASTNode ast, SemanticAnalyzer.PlannerContext plannerCtx) throws SemanticException {
        Operator sinkOp = null;
        boolean skipCalcitePlan = false;
        if (!this.runCBO) {
            skipCalcitePlan = true;
        } else {
            PreCboCtx cboCtx = (PreCboCtx)plannerCtx;
            ASTNode queryForCbo = ast;
            if (cboCtx.type == PreCboCtx.Type.CTAS) {
                queryForCbo = cboCtx.nodeOfInterest;
            }
            this.runCBO = this.canCBOHandleAst(queryForCbo, this.getQB(), cboCtx);
            if (this.runCBO) {
                this.disableJoinMerge = true;
                boolean reAnalyzeAST = false;
                try {
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                        sinkOp = this.getOptimizedHiveOPDag();
                    }
                    ASTNode newAST = this.getOptimizedAST();
                    newAST = this.fixUpCtasAndInsertAfterCbo(ast, newAST, cboCtx);
                    this.init(false);
                    if (cboCtx.type == PreCboCtx.Type.CTAS) {
                        this.setAST(newAST);
                        newAST = this.reAnalyzeCtasAfterCbo(newAST);
                    }
                    SemanticAnalyzer.Phase1Ctx ctx_1 = this.initPhase1Ctx();
                    if (!this.doPhase1(newAST, this.getQB(), ctx_1, null)) {
                        throw new RuntimeException("Couldn't do phase1 on CBO optimized query plan");
                    }
                    this.getMetaData(this.getQB());
                    this.disableJoinMerge = false;
                    sinkOp = this.genPlan(this.getQB());
                    this.LOG.info((Object)"CBO Succeeded; optimized logical plan.");
                    this.ctx.setCboInfo("Plan optimized by CBO.");
                    this.ctx.setCboSucceeded(true);
                    this.LOG.debug((Object)newAST.dump());
                }
                catch (Exception e) {
                    boolean isMissingStats;
                    boolean bl = isMissingStats = this.noColsMissingStats.get() > 0;
                    if (isMissingStats) {
                        this.LOG.error((Object)"CBO failed due to missing column stats (see previous errors), skipping CBO");
                        this.ctx.setCboInfo("Plan not optimized by CBO due to missing statistics. Please check log for more details.");
                    } else {
                        this.LOG.error((Object)"CBO failed, skipping CBO. ", (Throwable)e);
                        if (e instanceof CalciteSemanticException) {
                            CalciteSemanticException calciteSemanticException = (CalciteSemanticException)e;
                            CalciteSemanticException.UnsupportedFeature unsupportedFeature = calciteSemanticException.getUnsupportedFeature();
                            if (unsupportedFeature != null) {
                                this.ctx.setCboInfo("Plan not optimized by CBO due to missing feature [" + (Object)((Object)unsupportedFeature) + "].");
                            } else {
                                this.ctx.setCboInfo("Plan not optimized by CBO.");
                            }
                        } else {
                            this.ctx.setCboInfo("Plan not optimized by CBO.");
                        }
                    }
                    if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) || isMissingStats || e instanceof CalciteSemanticException) {
                        reAnalyzeAST = true;
                    }
                    if (e instanceof SemanticException) {
                        throw (SemanticException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new SemanticException(e);
                }
                finally {
                    this.runCBO = false;
                    this.disableJoinMerge = false;
                    if (reAnalyzeAST) {
                        this.init(true);
                        this.prunedPartitions.clear();
                        super.genResolvedParseTree(ast, new SemanticAnalyzer.PlannerContext());
                        skipCalcitePlan = true;
                    }
                }
            } else {
                this.ctx.setCboInfo("Plan not optimized by CBO.");
                skipCalcitePlan = true;
            }
        }
        if (skipCalcitePlan) {
            sinkOp = super.genOPTree(ast, plannerCtx);
        }
        return sinkOp;
    }

    boolean canCBOHandleAst(ASTNode ast, QB qb, PreCboCtx cboCtx) {
        boolean result;
        int root = ast.getToken().getType();
        boolean needToLogMessage = STATIC_LOG.isInfoEnabled();
        boolean isSupportedRoot = root == 809 || root == 695 || qb.isCTAS();
        boolean isSupportedType = qb.getIsQuery() || qb.isCTAS() || cboCtx.type == PreCboCtx.Type.INSERT;
        boolean noBadTokens = HiveCalciteUtil.validateASTForUnsupportedTokens(ast);
        boolean bl = result = isSupportedRoot && isSupportedType && this.getCreateViewDesc() == null && noBadTokens;
        if (!result) {
            if (needToLogMessage) {
                String msg = "";
                if (!isSupportedRoot) {
                    msg = msg + "doesn't have QUERY or EXPLAIN as root and not a CTAS; ";
                }
                if (!isSupportedType) {
                    msg = msg + "is not a query, CTAS, or insert; ";
                }
                if (this.getCreateViewDesc() != null) {
                    msg = msg + "has create view; ";
                }
                if (!noBadTokens) {
                    msg = msg + "has unsupported tokens; ";
                }
                if (msg.isEmpty()) {
                    msg = msg + "has some unspecified limitations; ";
                }
                STATIC_LOG.info((Object)("Not invoking CBO because the statement " + msg.substring(0, msg.length() - 2)));
            }
            return false;
        }
        String msg = CalcitePlanner.canHandleQbForCbo(this.queryProperties, this.conf, true, needToLogMessage, qb);
        if (msg == null) {
            return true;
        }
        if (needToLogMessage) {
            STATIC_LOG.info((Object)("Not invoking CBO because the statement " + msg.substring(0, msg.length() - 2)));
        }
        return false;
    }

    static String canHandleQbForCbo(QueryProperties queryProperties, HiveConf conf, boolean topLevelQB, boolean verbose, QB qb) {
        boolean hasEnoughJoins;
        boolean isInTest = conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
        boolean isStrictTest = isInTest && !conf.getVar(HiveConf.ConfVars.HIVEMAPREDMODE).equalsIgnoreCase("nonstrict");
        boolean bl = hasEnoughJoins = !topLevelQB || queryProperties.getJoinCount() > 1 || isInTest || CalcitePlanner.distinctExprsExists(qb);
        if (!(isStrictTest || !hasEnoughJoins || queryProperties.hasClusterBy() || queryProperties.hasDistributeBy() || queryProperties.hasSortBy() || queryProperties.hasPTF() || queryProperties.usesScript() || queryProperties.hasMultiDestQuery() || queryProperties.hasLateralViews())) {
            return null;
        }
        String msg = "";
        if (verbose) {
            if (isStrictTest) {
                msg = msg + "is in test running in mode other than nonstrict; ";
            }
            if (!hasEnoughJoins) {
                msg = msg + "has too few joins; ";
            }
            if (queryProperties.hasClusterBy()) {
                msg = msg + "has cluster by; ";
            }
            if (queryProperties.hasDistributeBy()) {
                msg = msg + "has distribute by; ";
            }
            if (queryProperties.hasSortBy()) {
                msg = msg + "has sort by; ";
            }
            if (queryProperties.hasPTF()) {
                msg = msg + "has PTF; ";
            }
            if (queryProperties.usesScript()) {
                msg = msg + "uses scripts; ";
            }
            if (queryProperties.hasMultiDestQuery()) {
                msg = msg + "is a multi-destination query; ";
            }
            if (queryProperties.hasLateralViews()) {
                msg = msg + "has lateral views; ";
            }
            if (msg.isEmpty()) {
                msg = msg + "has some unspecified limitations; ";
            }
        }
        return msg;
    }

    @Override
    boolean continueJoinMerge() {
        return !this.runCBO;
    }

    @Override
    String fixCtasColumnName(String colName) {
        if (this.runCBO) {
            int lastDot = colName.lastIndexOf(46);
            if (lastDot < 0) {
                return colName;
            }
            String nqColumnName = colName.substring(lastDot + 1);
            STATIC_LOG.debug((Object)("Replacing " + colName + " (produced by CBO) by " + nqColumnName));
            return nqColumnName;
        }
        return super.fixCtasColumnName(colName);
    }

    ASTNode fixUpCtasAndInsertAfterCbo(ASTNode originalAst, ASTNode newAst, PreCboCtx cboCtx) throws SemanticException {
        switch (cboCtx.type) {
            case NONE: {
                return newAst;
            }
            case CTAS: {
                CalcitePlanner.replaceASTChild(cboCtx.nodeOfInterest, newAst);
                return originalAst;
            }
            case INSERT: {
                ASTNode newDest = new ASTSearcher().simpleBreadthFirstSearch(newAst, 809, 729, 682);
                if (newDest == null) {
                    this.LOG.error((Object)("Cannot find destination after CBO; new ast is " + newAst.dump()));
                    throw new SemanticException("Cannot find destination after CBO");
                }
                CalcitePlanner.replaceASTChild(newDest, cboCtx.nodeOfInterest);
                return newAst;
            }
        }
        throw new AssertionError((Object)("Unexpected type " + (Object)((Object)cboCtx.type)));
    }

    ASTNode reAnalyzeCtasAfterCbo(ASTNode newAst) throws SemanticException {
        if ((newAst = this.analyzeCreateTable(newAst, this.getQB(), null)) == null) {
            this.LOG.error((Object)("analyzeCreateTable failed to initialize CTAS after CBO; new ast is " + this.getAST().dump()));
            throw new SemanticException("analyzeCreateTable failed to initialize CTAS after CBO");
        }
        return newAst;
    }

    private static void replaceASTChild(ASTNode child, ASTNode newChild) {
        ASTNode parent = (ASTNode)child.parent;
        int childIndex = child.childIndex;
        parent.deleteChild(childIndex);
        parent.insertChild(childIndex, newChild);
    }

    ASTNode getOptimizedAST() throws SemanticException {
        ASTNode optiqOptimizedAST = null;
        RelNode optimizedOptiqPlan = null;
        CalcitePlannerAction calcitePlannerAction = new CalcitePlannerAction(this.prunedPartitions);
        try {
            optimizedOptiqPlan = (RelNode)Frameworks.withPlanner((Frameworks.PlannerAction)calcitePlannerAction, (FrameworkConfig)Frameworks.newConfigBuilder().typeSystem((RelDataTypeSystem)new HiveTypeSystemImpl()).build());
        }
        catch (Exception e) {
            this.rethrowCalciteException(e);
            throw new AssertionError((Object)("rethrowCalciteException didn't throw for " + e.getMessage()));
        }
        optiqOptimizedAST = ASTConverter.convert(optimizedOptiqPlan, this.topLevelFieldSchema);
        return optiqOptimizedAST;
    }

    Operator getOptimizedHiveOPDag() throws SemanticException {
        RelNode optimizedOptiqPlan = null;
        CalcitePlannerAction calcitePlannerAction = new CalcitePlannerAction(this.prunedPartitions);
        try {
            optimizedOptiqPlan = (RelNode)Frameworks.withPlanner((Frameworks.PlannerAction)calcitePlannerAction, (FrameworkConfig)Frameworks.newConfigBuilder().typeSystem((RelDataTypeSystem)new HiveTypeSystemImpl()).build());
        }
        catch (Exception e) {
            this.rethrowCalciteException(e);
            throw new AssertionError((Object)("rethrowCalciteException didn't throw for " + e.getMessage()));
        }
        RelNode modifiedOptimizedOptiqPlan = PlanModifierForReturnPath.convertOpTree(this.introduceProjectIfNeeded(optimizedOptiqPlan), this.topLevelFieldSchema);
        this.LOG.debug((Object)("Translating the following plan:\n" + RelOptUtil.toString((RelNode)modifiedOptimizedOptiqPlan)));
        Operator hiveRoot = new HiveOpConverter(this, this.conf, this.unparseTranslator, this.topOps, this.conf.getVar(HiveConf.ConfVars.HIVEMAPREDMODE).equalsIgnoreCase("strict")).convert(modifiedOptimizedOptiqPlan);
        RowResolver hiveRootRR = this.genRowResolver(hiveRoot, this.getQB());
        this.opParseCtx.put(hiveRoot, new OpParseContext(hiveRootRR));
        return this.genFileSinkPlan(this.getQB().getParseInfo().getClauseNames().iterator().next(), this.getQB(), hiveRoot);
    }

    private RelNode introduceProjectIfNeeded(RelNode optimizedOptiqPlan) throws CalciteSemanticException {
        RelNode parent = null;
        RelNode input = optimizedOptiqPlan;
        RelNode newRoot = optimizedOptiqPlan;
        while (!(input instanceof Project) && input instanceof Sort) {
            parent = input;
            input = input.getInput(0);
        }
        if (!(input instanceof Project)) {
            HiveProject hpRel = HiveProject.create(input, HiveCalciteUtil.getProjsFromBelowAsInputRef(input), input.getRowType().getFieldNames());
            if (input == optimizedOptiqPlan) {
                newRoot = hpRel;
            } else {
                parent.replaceInput(0, (RelNode)hpRel);
            }
        }
        return newRoot;
    }

    private void rethrowCalciteException(Exception e) throws SemanticException {
        Throwable first = this.semanticException != null ? this.semanticException : e;
        Throwable current = first;
        Throwable cause = current.getCause();
        while (cause != null) {
            Throwable causeOfCause = cause.getCause();
            if (current == first && causeOfCause == null && this.isUselessCause(first)) {
                first = cause;
                break;
            }
            if (causeOfCause != null && this.isUselessCause(cause) && ExceptionHelper.resetCause(current, causeOfCause)) {
                cause = causeOfCause;
                continue;
            }
            current = cause;
            cause = current.getCause();
        }
        if (first instanceof RuntimeException) {
            throw (RuntimeException)first;
        }
        if (first instanceof SemanticException) {
            throw (SemanticException)first;
        }
        throw new RuntimeException(first);
    }

    private boolean isUselessCause(Throwable t) {
        return t instanceof RuntimeException || t instanceof InvocationTargetException || t instanceof UndeclaredThrowableException;
    }

    private RowResolver genRowResolver(Operator op, QB qb) {
        RowResolver rr = new RowResolver();
        String subqAlias = qb.getAliases().size() == 1 && qb.getSubqAliases().size() == 1 ? qb.getAliases().get(0) : null;
        for (ColumnInfo ci : op.getSchema().getSignature()) {
            try {
                rr.putWithCheck(subqAlias != null ? subqAlias : ci.getTabAlias(), ci.getAlias() != null ? ci.getAlias() : ci.getInternalName(), ci.getInternalName(), new ColumnInfo(ci));
            }
            catch (SemanticException e) {
                throw new RuntimeException(e);
            }
        }
        return rr;
    }

    private class CalcitePlannerAction
    implements Frameworks.PlannerAction<RelNode> {
        private RelOptCluster cluster;
        private RelOptSchema relOptSchema;
        private final Map<String, PrunedPartitionList> partitionCache;
        LinkedHashMap<RelNode, RowResolver> relToHiveRR = new LinkedHashMap();
        LinkedHashMap<RelNode, ImmutableMap<String, Integer>> relToHiveColNameCalcitePosMap = new LinkedHashMap();

        CalcitePlannerAction(Map<String, PrunedPartitionList> partitionCache) {
            this.partitionCache = partitionCache;
        }

        public RelNode apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
            RelNode calciteGenPlan = null;
            RelNode calcitePreCboPlan = null;
            RelNode calciteOptimizedPlan = null;
            Double maxSplitSize = HiveConf.getLongVar(CalcitePlanner.this.conf, HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
            Double maxMemory = HiveConf.getLongVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
            HiveAlgorithmsConf algorithmsConf = new HiveAlgorithmsConf(maxSplitSize, maxMemory);
            HiveConfigContext confContext = new HiveConfigContext(algorithmsConf);
            RelOptPlanner planner = HiveVolcanoPlanner.createPlanner(confContext);
            RelOptQuery query = new RelOptQuery(planner);
            RexBuilder rexBuilder = cluster.getRexBuilder();
            this.cluster = cluster = query.createCluster(rexBuilder.getTypeFactory(), rexBuilder);
            this.relOptSchema = relOptSchema;
            try {
                calciteGenPlan = this.genLogicalPlan(CalcitePlanner.this.getQB(), true);
                CalcitePlanner.this.topLevelFieldSchema = SemanticAnalyzer.convertRowSchemaToResultSetSchema(this.relToHiveRR.get(calciteGenPlan), HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_RESULTSET_USE_UNIQUE_COLUMN_NAMES));
            }
            catch (SemanticException e) {
                CalcitePlanner.this.semanticException = e;
                throw new RuntimeException(e);
            }
            HiveDefaultRelMetadataProvider mdProvider = new HiveDefaultRelMetadataProvider(CalcitePlanner.this.conf);
            calcitePreCboPlan = this.applyPreJoinOrderingTransforms(calciteGenPlan, mdProvider.getMetadataProvider());
            ArrayList<RelMetadataProvider> list = Lists.newArrayList();
            list.add(mdProvider.getMetadataProvider());
            RelTraitSet desiredTraits = cluster.traitSetOf(new RelTrait[]{HiveRelNode.CONVENTION, RelCollations.EMPTY});
            HepProgram hepPgm = null;
            HepProgramBuilder hepPgmBldr = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance((RelOptRule)new JoinToMultiJoinRule(HiveJoin.class));
            hepPgmBldr.addRuleInstance((RelOptRule)new LoptOptimizeJoinRule(HiveJoin.HIVE_JOIN_FACTORY, HiveProject.DEFAULT_PROJECT_FACTORY, HiveFilter.DEFAULT_FILTER_FACTORY));
            hepPgmBldr.addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE);
            hepPgmBldr.addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
            hepPgmBldr.addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE);
            hepPgmBldr.addRuleInstance((RelOptRule)ProjectRemoveRule.INSTANCE);
            hepPgmBldr.addRuleInstance((RelOptRule)UnionMergeRule.INSTANCE);
            hepPgmBldr.addRuleInstance((RelOptRule)new ProjectMergeRule(false, HiveProject.DEFAULT_PROJECT_FACTORY));
            hepPgm = hepPgmBldr.build();
            HepPlanner hepPlanner = new HepPlanner(hepPgm);
            hepPlanner.registerMetadataProviders(list);
            RelMetadataProvider chainedProvider = ChainedRelMetadataProvider.of(list);
            cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)hepPlanner));
            RelNode rootRel = calcitePreCboPlan;
            hepPlanner.setRoot(rootRel);
            if (!calcitePreCboPlan.getTraitSet().equals((Object)desiredTraits)) {
                rootRel = hepPlanner.changeTraits(calcitePreCboPlan, desiredTraits);
            }
            hepPlanner.setRoot(rootRel);
            calciteOptimizedPlan = hepPlanner.findBestExp();
            hepPgmBldr = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP);
            hepPgmBldr.addRuleInstance((RelOptRule)HiveJoinCommuteRule.INSTANCE);
            hepPlanner = new HepPlanner(hepPgmBldr.build());
            hepPlanner.registerMetadataProviders(list);
            cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)hepPlanner));
            hepPlanner.setRoot(calciteOptimizedPlan);
            calciteOptimizedPlan = hepPlanner.findBestExp();
            hepPgmBldr = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP);
            hepPgmBldr.addRuleInstance((RelOptRule)HiveWindowingFixRule.INSTANCE);
            hepPlanner = new HepPlanner(hepPgmBldr.build());
            hepPlanner.registerMetadataProviders(list);
            cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)hepPlanner));
            hepPlanner.setRoot(calciteOptimizedPlan);
            calciteOptimizedPlan = hepPlanner.findBestExp();
            if (HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                hepPgmBldr = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP);
                hepPgmBldr.addRuleInstance((RelOptRule)HiveJoinToMultiJoinRule.INSTANCE);
                hepPlanner = new HepPlanner(hepPgmBldr.build());
                hepPlanner.registerMetadataProviders(list);
                cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)hepPlanner));
                hepPlanner.setRoot(calciteOptimizedPlan);
                calciteOptimizedPlan = hepPlanner.findBestExp();
                hepPgmBldr = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP);
                hepPgmBldr.addRuleInstance((RelOptRule)HiveInsertExchange4JoinRule.EXCHANGE_BELOW_JOIN);
                hepPgmBldr.addRuleInstance((RelOptRule)HiveInsertExchange4JoinRule.EXCHANGE_BELOW_MULTIJOIN);
                hepPlanner = new HepPlanner(hepPgmBldr.build());
                hepPlanner.registerMetadataProviders(list);
                cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)hepPlanner));
                hepPlanner.setRoot(calciteOptimizedPlan);
                calciteOptimizedPlan = hepPlanner.findBestExp();
            }
            if (CalcitePlanner.this.LOG.isDebugEnabled() && !CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                CalcitePlanner.this.LOG.debug((Object)"CBO Planning details:\n");
                CalcitePlanner.this.LOG.debug((Object)("Original Plan:\n" + RelOptUtil.toString((RelNode)calciteGenPlan)));
                CalcitePlanner.this.LOG.debug((Object)("Plan After PPD, PartPruning, ColumnPruning:\n" + RelOptUtil.toString((RelNode)calcitePreCboPlan)));
                CalcitePlanner.this.LOG.debug((Object)("Plan After Join Reordering:\n" + RelOptUtil.toString((RelNode)calciteOptimizedPlan, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES)));
            }
            return calciteOptimizedPlan;
        }

        private RelNode applyPreJoinOrderingTransforms(RelNode basePlan, RelMetadataProvider mdProvider) {
            if (CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTIMIZEDISTINCTREWRITE)) {
                basePlan = this.hepPlan(basePlan, true, mdProvider, HiveExpandDistinctAggregatesRule.INSTANCE);
            }
            basePlan = this.hepPlan(basePlan, true, mdProvider, new RelOptRule[]{SemiJoinJoinTransposeRule.INSTANCE, SemiJoinFilterTransposeRule.INSTANCE, SemiJoinProjectTransposeRule.INSTANCE});
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                basePlan = this.hepPlan(basePlan, true, mdProvider, HiveJoinAddNotNullRule.INSTANCE);
            }
            basePlan = this.hepPlan(basePlan, true, mdProvider, new RelOptRule[]{ReduceExpressionsRule.PROJECT_INSTANCE, ReduceExpressionsRule.FILTER_INSTANCE, ReduceExpressionsRule.JOIN_INSTANCE, HivePreFilteringRule.INSTANCE, new HiveFilterProjectTransposeRule(Filter.class, HiveFilter.DEFAULT_FILTER_FACTORY, HiveProject.class, HiveProject.DEFAULT_PROJECT_FACTORY), new HiveFilterSetOpTransposeRule(HiveFilter.DEFAULT_FILTER_FACTORY), HiveFilterJoinRule.JOIN, HiveFilterJoinRule.FILTER_ON_JOIN, new FilterAggregateTransposeRule(Filter.class, HiveFilter.DEFAULT_FILTER_FACTORY, Aggregate.class)});
            basePlan = this.hepPlan(basePlan, false, mdProvider, new HiveJoinPushTransitivePredicatesRule(Join.class, HiveFilter.DEFAULT_FILTER_FACTORY), new HivePartitionPruneRule(CalcitePlanner.this.conf));
            HiveRelFieldTrimmer fieldTrimmer = new HiveRelFieldTrimmer(null, HiveProject.DEFAULT_PROJECT_FACTORY, HiveFilter.DEFAULT_FILTER_FACTORY, HiveJoin.HIVE_JOIN_FACTORY, RelFactories.DEFAULT_SEMI_JOIN_FACTORY, HiveSort.HIVE_SORT_REL_FACTORY, HiveAggregate.HIVE_AGGR_REL_FACTORY, HiveUnion.UNION_REL_FACTORY);
            basePlan = fieldTrimmer.trim(basePlan);
            basePlan = this.hepPlan(basePlan, true, mdProvider, new RelOptRule[]{new FilterProjectTransposeRule(Filter.class, HiveFilter.DEFAULT_FILTER_FACTORY, HiveProject.class, HiveProject.DEFAULT_PROJECT_FACTORY)});
            return basePlan;
        }

        private RelNode hepPlan(RelNode basePlan, boolean followPlanChanges, RelMetadataProvider mdProvider, RelOptRule ... rules) {
            RelNode optimizedRelNode = basePlan;
            HepProgramBuilder programBuilder = new HepProgramBuilder();
            if (followPlanChanges) {
                programBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
                programBuilder = programBuilder.addRuleCollection(ImmutableList.copyOf(rules));
            } else {
                for (RelOptRule r : rules) {
                    programBuilder.addRuleInstance(r);
                }
            }
            HepPlanner planner = new HepPlanner(programBuilder.build());
            ArrayList<RelMetadataProvider> list = Lists.newArrayList();
            list.add(mdProvider);
            planner.registerMetadataProviders(list);
            RelMetadataProvider chainedProvider = ChainedRelMetadataProvider.of(list);
            basePlan.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)planner));
            RexExecutorImpl executor = new RexExecutorImpl(Schemas.createDataContext(null));
            basePlan.getCluster().getPlanner().setExecutor((RelOptPlanner.Executor)executor);
            planner.setRoot(basePlan);
            optimizedRelNode = planner.findBestExp();
            return optimizedRelNode;
        }

        private RelNode genUnionLogicalPlan(String unionalias, String leftalias, RelNode leftRel, String rightalias, RelNode rightRel) throws SemanticException {
            HiveUnion unionRel = null;
            RowResolver leftRR = this.relToHiveRR.get(leftRel);
            RowResolver rightRR = this.relToHiveRR.get(rightRel);
            HashMap<String, ColumnInfo> leftmap = leftRR.getFieldMap(leftalias);
            HashMap<String, ColumnInfo> rightmap = rightRR.getFieldMap(rightalias);
            if (leftmap.size() != rightmap.size()) {
                throw new SemanticException("Schema of both sides of union should match.");
            }
            ASTNode tabref = CalcitePlanner.this.getQB().getAliases().isEmpty() ? null : CalcitePlanner.this.getQB().getParseInfo().getSrcForAlias(CalcitePlanner.this.getQB().getAliases().get(0));
            RowResolver unionoutRR = new RowResolver();
            Iterator<Map.Entry<String, ColumnInfo>> lIter = leftmap.entrySet().iterator();
            Iterator<Map.Entry<String, ColumnInfo>> rIter = rightmap.entrySet().iterator();
            while (lIter.hasNext()) {
                Map.Entry<String, ColumnInfo> lEntry = lIter.next();
                Map.Entry<String, ColumnInfo> rEntry = rIter.next();
                ColumnInfo lInfo = lEntry.getValue();
                ColumnInfo rInfo = rEntry.getValue();
                String field = lEntry.getKey();
                TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType());
                if (commonTypeInfo == null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of union should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table"));
                }
                ColumnInfo unionColInfo = new ColumnInfo(lInfo);
                unionColInfo.setType(FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType()));
                unionoutRR.put(unionalias, field, unionColInfo);
            }
            boolean leftNeedsTypeCast = false;
            boolean rightNeedsTypeCast = false;
            ArrayList<RexNode> leftProjs = new ArrayList<RexNode>();
            ArrayList<RexNode> rightProjs = new ArrayList<RexNode>();
            List leftRowDT = leftRel.getRowType().getFieldList();
            List rightRowDT = rightRel.getRowType().getFieldList();
            for (int i = 0; i < leftRowDT.size(); ++i) {
                RelDataType rightFieldDT;
                RelDataType leftFieldDT = ((RelDataTypeField)leftRowDT.get(i)).getType();
                if (!leftFieldDT.equals(rightFieldDT = ((RelDataTypeField)rightRowDT.get(i)).getType())) {
                    RelDataType unionFieldDT = TypeConverter.convert(unionoutRR.getColumnInfos().get(i).getType(), this.cluster.getTypeFactory());
                    if (!unionFieldDT.equals(leftFieldDT)) {
                        leftNeedsTypeCast = true;
                    }
                    leftProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(leftFieldDT, i), true));
                    if (!unionFieldDT.equals(rightFieldDT)) {
                        rightNeedsTypeCast = true;
                    }
                    rightProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(rightFieldDT, i), true));
                    continue;
                }
                leftProjs.add(this.cluster.getRexBuilder().ensureType(leftFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(leftFieldDT, i), true));
                rightProjs.add(this.cluster.getRexBuilder().ensureType(rightFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(rightFieldDT, i), true));
            }
            RelNode unionLeftInput = leftRel;
            RelNode unionRightInput = rightRel;
            if (leftNeedsTypeCast) {
                unionLeftInput = HiveProject.create(leftRel, leftProjs, leftRel.getRowType().getFieldNames());
            }
            if (rightNeedsTypeCast) {
                unionRightInput = HiveProject.create(rightRel, rightProjs, rightRel.getRowType().getFieldNames());
            }
            ImmutableList.Builder bldr = new ImmutableList.Builder();
            bldr.add(unionLeftInput);
            bldr.add(unionRightInput);
            unionRel = new HiveUnion(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)((Object)bldr.build()));
            this.relToHiveRR.put((RelNode)unionRel, unionoutRR);
            this.relToHiveColNameCalcitePosMap.put((RelNode)unionRel, this.buildHiveToCalciteColumnMap(unionoutRR, (RelNode)unionRel));
            return unionRel;
        }

        private RelNode genJoinRelNode(RelNode leftRel, RelNode rightRel, JoinType hiveJoinType, ASTNode joinCond) throws SemanticException {
            JoinRelType calciteJoinType;
            HiveJoin joinRel = null;
            RowResolver leftRR = this.relToHiveRR.get(leftRel);
            RowResolver rightRR = this.relToHiveRR.get(rightRel);
            RowResolver joinRR = null;
            if (hiveJoinType != JoinType.LEFTSEMI) {
                joinRR = RowResolver.getCombinedRR(leftRR, rightRR);
            } else {
                joinRR = new RowResolver();
                if (!RowResolver.add(joinRR, leftRR)) {
                    CalcitePlanner.this.LOG.warn((Object)"Duplicates detected when adding columns to RR: see previous message");
                }
            }
            RexLiteral calciteJoinCond = null;
            if (joinCond != null) {
                JoinTypeCheckCtx jCtx = new JoinTypeCheckCtx(leftRR, rightRR, hiveJoinType);
                Map<ASTNode, ExprNodeDesc> exprNodes = JoinCondTypeCheckProcFactory.genExprNode(joinCond, jCtx);
                if (jCtx.getError() != null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(jCtx.getErrorSrcNode(), jCtx.getError()));
                }
                ExprNodeDesc joinCondnExprNode = exprNodes.get(joinCond);
                ArrayList<RelNode> inputRels = new ArrayList<RelNode>();
                inputRels.add(leftRel);
                inputRels.add(rightRel);
                calciteJoinCond = RexNodeConverter.convert(this.cluster, joinCondnExprNode, inputRels, this.relToHiveRR, this.relToHiveColNameCalcitePosMap, false);
            } else {
                calciteJoinCond = this.cluster.getRexBuilder().makeLiteral(true);
            }
            boolean leftSemiJoin = false;
            switch (hiveJoinType) {
                case LEFTOUTER: {
                    calciteJoinType = JoinRelType.LEFT;
                    break;
                }
                case RIGHTOUTER: {
                    calciteJoinType = JoinRelType.RIGHT;
                    break;
                }
                case FULLOUTER: {
                    calciteJoinType = JoinRelType.FULL;
                    break;
                }
                case LEFTSEMI: {
                    calciteJoinType = JoinRelType.INNER;
                    leftSemiJoin = true;
                    break;
                }
                default: {
                    calciteJoinType = JoinRelType.INNER;
                }
            }
            if (leftSemiJoin) {
                ArrayList<RelDataTypeField> sysFieldList = new ArrayList<RelDataTypeField>();
                ArrayList<RexNode> leftJoinKeys = new ArrayList<RexNode>();
                ArrayList<RexNode> rightJoinKeys = new ArrayList<RexNode>();
                RexNode nonEquiConds = HiveRelOptUtil.splitJoinCondition(sysFieldList, leftRel, rightRel, (RexNode)calciteJoinCond, leftJoinKeys, rightJoinKeys, null, null);
                if (!nonEquiConds.isAlwaysTrue()) {
                    throw new SemanticException("Non equality condition not supported in Semi-Join" + nonEquiConds);
                }
                RelNode[] inputRels = new RelNode[]{leftRel, rightRel};
                ArrayList<Integer> leftKeys = new ArrayList<Integer>();
                ArrayList<Integer> rightKeys = new ArrayList<Integer>();
                calciteJoinCond = HiveCalciteUtil.projectNonColumnEquiConditions(HiveProject.DEFAULT_PROJECT_FACTORY, inputRels, leftJoinKeys, rightJoinKeys, 0, leftKeys, rightKeys);
                joinRel = new SemiJoin(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), inputRels[0], inputRels[1], (RexNode)calciteJoinCond, ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys));
            } else {
                joinRel = HiveJoin.getJoin(this.cluster, leftRel, rightRel, (RexNode)calciteJoinCond, calciteJoinType, leftSemiJoin);
            }
            this.relToHiveColNameCalcitePosMap.put(joinRel, this.buildHiveToCalciteColumnMap(joinRR, joinRel));
            this.relToHiveRR.put(joinRel, joinRR);
            return joinRel;
        }

        private RelNode genJoinLogicalPlan(ASTNode joinParseTree, Map<String, RelNode> aliasToRel) throws SemanticException {
            RelNode leftRel = null;
            RelNode rightRel = null;
            JoinType hiveJoinType = null;
            if (joinParseTree.getToken().getType() == 914) {
                String msg = String.format("UNIQUE JOIN is currently not supported in CBO, turn off cbo to use UNIQUE JOIN.", new Object[0]);
                CalcitePlanner.this.LOG.debug((Object)msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Unique_join);
            }
            switch (joinParseTree.getToken().getType()) {
                case 748: {
                    hiveJoinType = JoinType.LEFTOUTER;
                    break;
                }
                case 821: {
                    hiveJoinType = JoinType.RIGHTOUTER;
                    break;
                }
                case 704: {
                    hiveJoinType = JoinType.FULLOUTER;
                    break;
                }
                case 749: {
                    hiveJoinType = JoinType.LEFTSEMI;
                    break;
                }
                default: {
                    hiveJoinType = JoinType.INNER;
                }
            }
            ASTNode left = (ASTNode)joinParseTree.getChild(0);
            if (left.getToken().getType() == 898 || left.getToken().getType() == 863 || left.getToken().getType() == 808) {
                String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)left.getChild(0)).toLowerCase();
                String leftTableAlias = left.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(left.getChild(left.getChildCount() - 1).getText().toLowerCase());
                leftTableAlias = left.getToken().getType() == 808 ? SemanticAnalyzer.unescapeIdentifier(left.getChild(1).getText().toLowerCase()) : leftTableAlias;
                leftRel = aliasToRel.get(leftTableAlias);
            } else if (SemanticAnalyzer.isJoinToken(left)) {
                leftRel = this.genJoinLogicalPlan(left, aliasToRel);
            } else assert (false);
            ASTNode right = (ASTNode)joinParseTree.getChild(1);
            if (right.getToken().getType() == 898 || right.getToken().getType() == 863 || right.getToken().getType() == 808) {
                String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)right.getChild(0)).toLowerCase();
                String rightTableAlias = right.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(right.getChild(right.getChildCount() - 1).getText().toLowerCase());
                rightTableAlias = right.getToken().getType() == 808 ? SemanticAnalyzer.unescapeIdentifier(right.getChild(1).getText().toLowerCase()) : rightTableAlias;
                rightRel = aliasToRel.get(rightTableAlias);
            } else assert (false);
            ASTNode joinCond = (ASTNode)joinParseTree.getChild(2);
            return this.genJoinRelNode(leftRel, rightRel, hiveJoinType, joinCond);
        }

        private RelNode genTableLogicalPlan(String tableAlias, QB qb) throws SemanticException {
            RowResolver rr = new RowResolver();
            HiveTableScan tableRel = null;
            try {
                ColumnInfo colInfo;
                String colName;
                if (qb.getParseInfo().getTabSample(tableAlias) != null || CalcitePlanner.this.getNameToSplitSampleMap().containsKey(tableAlias)) {
                    String msg = String.format("Table Sample specified for %s. Currently we don't support Table Sample clauses in CBO, turn off cbo for queries on tableSamples.", tableAlias);
                    CalcitePlanner.this.LOG.debug((Object)msg);
                    throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Table_sample_clauses);
                }
                Table tabMetaData = qb.getMetaData().getSrcForAlias(tableAlias);
                StructObjectInspector rowObjectInspector = (StructObjectInspector)tabMetaData.getDeserializer().getObjectInspector();
                List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
                ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
                for (int i = 0; i < fields.size(); ++i) {
                    colName = fields.get(i).getFieldName();
                    colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), tableAlias, false);
                    colInfo.setSkewedCol(SemanticAnalyzer.isSkewedCol(tableAlias, qb, colName));
                    rr.put(tableAlias, colName, colInfo);
                    cInfoLst.add(colInfo);
                }
                ArrayList<ColumnInfo> nonPartitionColumns = new ArrayList<ColumnInfo>(cInfoLst);
                ArrayList<ColumnInfo> partitionColumns = new ArrayList<ColumnInfo>();
                for (FieldSchema part_col : tabMetaData.getPartCols()) {
                    colName = part_col.getName();
                    colInfo = new ColumnInfo(colName, TypeInfoFactory.getPrimitiveTypeInfo(part_col.getType()), tableAlias, true);
                    rr.put(tableAlias, colName, colInfo);
                    cInfoLst.add(colInfo);
                    partitionColumns.add(colInfo);
                }
                ArrayList<VirtualColumn> virtualCols = new ArrayList<VirtualColumn>();
                for (VirtualColumn vc : VirtualColumn.getRegistry(CalcitePlanner.this.conf)) {
                    colInfo = new ColumnInfo(vc.getName(), vc.getTypeInfo(), tableAlias, true, vc.getIsHidden());
                    rr.put(tableAlias, vc.getName(), colInfo);
                    cInfoLst.add(colInfo);
                    virtualCols.add(vc);
                }
                RelDataType rowType = TypeConverter.getType(this.cluster, rr, null);
                String fullyQualifiedTabName = tabMetaData.getDbName();
                fullyQualifiedTabName = fullyQualifiedTabName != null && !fullyQualifiedTabName.isEmpty() ? fullyQualifiedTabName + "." + tabMetaData.getTableName() : tabMetaData.getTableName();
                RelOptHiveTable optTable = new RelOptHiveTable(this.relOptSchema, fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, this.partitionCache, CalcitePlanner.this.noColsMissingStats);
                tableRel = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP));
                ImmutableMap<String, Integer> hiveToCalciteColMap = this.buildHiveToCalciteColumnMap(rr, tableRel);
                this.relToHiveRR.put(tableRel, rr);
                this.relToHiveColNameCalcitePosMap.put(tableRel, hiveToCalciteColMap);
            }
            catch (Exception e) {
                if (e instanceof SemanticException) {
                    throw (SemanticException)e;
                }
                throw new RuntimeException(e);
            }
            return tableRel;
        }

        private RelNode genFilterRelNode(ASTNode filterExpr, RelNode srcRel) throws SemanticException {
            ExprNodeDesc filterCondn = CalcitePlanner.this.genExprNodeDesc(filterExpr, this.relToHiveRR.get(srcRel));
            if (filterCondn instanceof ExprNodeConstantDesc && !filterCondn.getTypeString().equals("boolean")) {
                throw new CalciteSemanticException("Filter expression with non-boolean return type.", CalciteSemanticException.UnsupportedFeature.Filter_expression_with_non_boolean_return_type);
            }
            ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
            RexNode convertedFilterExpr = new RexNodeConverter(this.cluster, srcRel.getRowType(), hiveColNameCalcitePosMap, 0, true).convert(filterCondn);
            RexNode factoredFilterExpr = RexUtil.pullFactors((RexBuilder)this.cluster.getRexBuilder(), (RexNode)convertedFilterExpr);
            HiveFilter filterRel = new HiveFilter(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), srcRel, factoredFilterExpr);
            this.relToHiveColNameCalcitePosMap.put(filterRel, hiveColNameCalcitePosMap);
            this.relToHiveRR.put(filterRel, this.relToHiveRR.get(srcRel));
            this.relToHiveColNameCalcitePosMap.put(filterRel, hiveColNameCalcitePosMap);
            return filterRel;
        }

        private RelNode genFilterRelNode(QB qb, ASTNode searchCond, RelNode srcRel, Map<String, RelNode> aliasToRel, boolean forHavingClause) throws SemanticException {
            int numSrcColumns = srcRel.getRowType().getFieldCount();
            List<ASTNode> subQueriesInOriginalTree = SubQueryUtils.findSubQueries(searchCond);
            if (subQueriesInOriginalTree.size() > 0) {
                RowResolver inputRR;
                if (qb.getSubQueryPredicateDef() != null) {
                    throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(subQueriesInOriginalTree.get(0), "Nested SubQuery expressions are not supported."));
                }
                if (subQueriesInOriginalTree.size() > 1) {
                    throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(subQueriesInOriginalTree.get(1), "Only 1 SubQuery expression is supported."));
                }
                ASTNode clonedSearchCond = (ASTNode)SubQueryUtils.adaptor.dupTree((Object)searchCond);
                List<ASTNode> subQueries = SubQueryUtils.findSubQueries(clonedSearchCond);
                RowResolver outerQBRR = inputRR = this.relToHiveRR.get(srcRel);
                ImmutableMap<String, Integer> outerQBPosMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
                for (int i = 0; i < subQueries.size(); ++i) {
                    ASTNode subQueryAST = subQueries.get(i);
                    ASTNode originalSubQueryAST = subQueriesInOriginalTree.get(i);
                    int sqIdx = qb.incrNumSubQueryPredicates();
                    clonedSearchCond = SubQueryUtils.rewriteParentQueryWhere(clonedSearchCond, subQueryAST);
                    QBSubQuery subQuery = SubQueryUtils.buildSubQuery(qb.getId(), sqIdx, subQueryAST, originalSubQueryAST, CalcitePlanner.this.ctx);
                    if (!forHavingClause) {
                        qb.setWhereClauseSubQueryPredicate(subQuery);
                    } else {
                        qb.setHavingClauseSubQueryPredicate(subQuery);
                    }
                    String havingInputAlias = null;
                    if (forHavingClause) {
                        havingInputAlias = "gby_sq" + sqIdx;
                        aliasToRel.put(havingInputAlias, srcRel);
                    }
                    subQuery.validateAndRewriteAST(inputRR, forHavingClause, havingInputAlias, aliasToRel.keySet());
                    QB qbSQ = new QB(subQuery.getOuterQueryId(), subQuery.getAlias(), true);
                    qbSQ.setSubQueryDef(subQuery.getSubQuery());
                    SemanticAnalyzer.Phase1Ctx ctx_1 = CalcitePlanner.this.initPhase1Ctx();
                    CalcitePlanner.this.doPhase1(subQuery.getSubQueryAST(), qbSQ, ctx_1, null);
                    CalcitePlanner.this.getMetaData(qbSQ);
                    RelNode subQueryRelNode = this.genLogicalPlan(qbSQ, false);
                    aliasToRel.put(subQuery.getAlias(), subQueryRelNode);
                    RowResolver sqRR = this.relToHiveRR.get(subQueryRelNode);
                    if (subQuery.getOperator().getType() != QBSubQuery.SubQueryType.EXISTS && subQuery.getOperator().getType() != QBSubQuery.SubQueryType.NOT_EXISTS && sqRR.getColumnInfos().size() - subQuery.getNumOfCorrelationExprsAddedToSQSelect() > 1) {
                        throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg(subQueryAST, "SubQuery can contain only 1 item in Select List."));
                    }
                    if (subQuery.getNotInCheck() != null) {
                        QBSubQuery.NotInCheck notInCheck = subQuery.getNotInCheck();
                        notInCheck.setSQRR(sqRR);
                        QB qbSQ_nic = new QB(subQuery.getOuterQueryId(), notInCheck.getAlias(), true);
                        qbSQ_nic.setSubQueryDef(notInCheck.getSubQuery());
                        ctx_1 = CalcitePlanner.this.initPhase1Ctx();
                        CalcitePlanner.this.doPhase1(notInCheck.getSubQueryAST(), qbSQ_nic, ctx_1, null);
                        CalcitePlanner.this.getMetaData(qbSQ_nic);
                        RelNode subQueryNICRelNode = this.genLogicalPlan(qbSQ_nic, false);
                        aliasToRel.put(notInCheck.getAlias(), subQueryNICRelNode);
                        srcRel = this.genJoinRelNode(srcRel, subQueryNICRelNode, JoinType.INNER, notInCheck.getJoinConditionAST());
                        inputRR = this.relToHiveRR.get(srcRel);
                        if (forHavingClause) {
                            aliasToRel.put(havingInputAlias, srcRel);
                        }
                    }
                    subQuery.buildJoinCondition(inputRR, sqRR, forHavingClause, havingInputAlias);
                    srcRel = this.genJoinRelNode(srcRel, subQueryRelNode, subQuery.getJoinType(), subQuery.getJoinConditionAST());
                    searchCond = subQuery.updateOuterQueryFilter(clonedSearchCond);
                    srcRel = this.genFilterRelNode(searchCond, srcRel);
                    if (subQuery.getOperator().getType() == QBSubQuery.SubQueryType.NOT_EXISTS && subQuery.getOperator().getType() == QBSubQuery.SubQueryType.NOT_IN) continue;
                    srcRel = this.projectLeftOuterSide(srcRel, numSrcColumns);
                }
                this.relToHiveRR.put(srcRel, outerQBRR);
                this.relToHiveColNameCalcitePosMap.put(srcRel, outerQBPosMap);
                return srcRel;
            }
            return this.genFilterRelNode(searchCond, srcRel);
        }

        private RelNode projectLeftOuterSide(RelNode srcRel, int numColumns) throws SemanticException {
            RowResolver iRR = this.relToHiveRR.get(srcRel);
            RowResolver oRR = new RowResolver();
            RowResolver.add(oRR, iRR, numColumns);
            ArrayList<RexInputRef> calciteColLst = new ArrayList<RexInputRef>();
            ArrayList<String> oFieldNames = new ArrayList<String>();
            RelDataType iType = srcRel.getRowType();
            for (int i = 0; i < iType.getFieldCount(); ++i) {
                RelDataTypeField fType = (RelDataTypeField)iType.getFieldList().get(i);
                String fName = (String)iType.getFieldNames().get(i);
                calciteColLst.add(this.cluster.getRexBuilder().makeInputRef(fType.getType(), i));
                oFieldNames.add(fName);
            }
            HiveProject selRel = HiveProject.create(srcRel, calciteColLst, oFieldNames);
            this.relToHiveColNameCalcitePosMap.put(selRel, this.buildHiveToCalciteColumnMap(oRR, selRel));
            this.relToHiveRR.put(selRel, oRR);
            return selRel;
        }

        private RelNode genFilterLogicalPlan(QB qb, RelNode srcRel, Map<String, RelNode> aliasToRel, boolean forHavingClause) throws SemanticException {
            RelNode filterRel = null;
            Iterator<ASTNode> whereClauseIterator = this.getQBParseInfo(qb).getDestToWhereExpr().values().iterator();
            if (whereClauseIterator.hasNext()) {
                filterRel = this.genFilterRelNode(qb, (ASTNode)whereClauseIterator.next().getChild(0), srcRel, aliasToRel, forHavingClause);
            }
            return filterRel;
        }

        private AggregateCall convertGBAgg(AggInfo agg, RelNode input, List<RexNode> gbChildProjLst, RexNodeConverter converter, HashMap<String, Integer> rexNodeToPosMap, Integer childProjLstIndx) throws SemanticException {
            RelDataType aggFnRetType = TypeConverter.convert(agg.m_returnType, this.cluster.getTypeFactory());
            ArrayList<Integer> argList = new ArrayList<Integer>();
            RexNode rexNd = null;
            RelDataTypeFactory dtFactory = this.cluster.getTypeFactory();
            ImmutableList.Builder aggArgRelDTBldr = new ImmutableList.Builder();
            for (ExprNodeDesc expr : agg.m_aggParams) {
                rexNd = converter.convert(expr);
                Integer inputIndx = rexNodeToPosMap.get(rexNd.toString());
                if (inputIndx == null) {
                    gbChildProjLst.add(rexNd);
                    rexNodeToPosMap.put(rexNd.toString(), childProjLstIndx);
                    inputIndx = childProjLstIndx;
                    Integer n = childProjLstIndx;
                    Integer n2 = childProjLstIndx = Integer.valueOf(childProjLstIndx + 1);
                }
                argList.add(inputIndx);
                aggArgRelDTBldr.add(TypeConverter.convert(expr.getTypeInfo(), dtFactory));
            }
            SqlAggFunction aggregation = SqlFunctionConverter.getCalciteAggFn(agg.m_udfName, (ImmutableList<RelDataType>)aggArgRelDTBldr.build(), aggFnRetType);
            return new AggregateCall(aggregation, agg.m_distinct, argList, aggFnRetType, null);
        }

        private RelNode genGBRelNode(List<ExprNodeDesc> gbExprs, List<AggInfo> aggInfoLst, List<Integer> groupSets, RelNode srcRel) throws SemanticException {
            Object object;
            ImmutableMap<String, Integer> posMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
            RexNodeConverter converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), posMap, 0, false);
            boolean hasGroupSets = groupSets != null && !groupSets.isEmpty();
            ArrayList<RexNode> gbChildProjLst = Lists.newArrayList();
            HashMap<String, Integer> rexNodeToPosMap = new HashMap<String, Integer>();
            ArrayList<Integer> groupSetPositions = Lists.newArrayList();
            Integer gbIndx = 0;
            for (ExprNodeDesc key : gbExprs) {
                RexNode rnd = converter.convert(key);
                gbChildProjLst.add(rnd);
                groupSetPositions.add(gbIndx);
                rexNodeToPosMap.put(rnd.toString(), gbIndx);
                Integer n = gbIndx;
                gbIndx = gbIndx + 1;
                object = gbIndx;
            }
            ImmutableBitSet groupSet = ImmutableBitSet.of(groupSetPositions);
            ArrayList<ImmutableBitSet> transformedGroupSets = null;
            if (hasGroupSets) {
                HashSet<ImmutableBitSet> setTransformedGroupSets = new HashSet<ImmutableBitSet>(groupSets.size());
                object = groupSets.iterator();
                while (object.hasNext()) {
                    int val = (Integer)object.next();
                    setTransformedGroupSets.add(this.convert(val));
                }
                transformedGroupSets = new ArrayList<ImmutableBitSet>(setTransformedGroupSets);
                Collections.sort(transformedGroupSets, ImmutableBitSet.COMPARATOR);
            }
            ArrayList<AggregateCall> aggregateCalls = Lists.newArrayList();
            for (AggInfo agg : aggInfoLst) {
                aggregateCalls.add(this.convertGBAgg(agg, srcRel, gbChildProjLst, converter, rexNodeToPosMap, gbChildProjLst.size()));
            }
            if (hasGroupSets) {
                AggregateCall aggCall = new AggregateCall(HiveGroupingID.INSTANCE, false, (List)((Object)new ImmutableList.Builder().build()), this.cluster.getTypeFactory().createSqlType(SqlTypeName.INTEGER), HiveGroupingID.INSTANCE.getName());
                aggregateCalls.add(aggCall);
            }
            if (gbChildProjLst.isEmpty()) {
                gbChildProjLst.add((RexNode)this.cluster.getRexBuilder().makeInputRef(srcRel, 0));
            }
            HiveProject gbInputRel = HiveProject.create(srcRel, gbChildProjLst, null);
            HiveAggregate aggregateRel = null;
            try {
                aggregateRel = new HiveAggregate(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), gbInputRel, transformedGroupSets != null, groupSet, transformedGroupSets, aggregateCalls);
            }
            catch (InvalidRelException e) {
                throw new SemanticException(e);
            }
            return aggregateRel;
        }

        private ImmutableBitSet convert(int value) {
            BitSet bits = new BitSet();
            int index = 0;
            while ((long)value != 0L) {
                if (value % 2 != 0) {
                    bits.set(index);
                }
                ++index;
                value >>>= 1;
            }
            return (ImmutableBitSet)ImmutableBitSet.FROM_BIT_SET.apply(bits);
        }

        private void addAlternateGByKeyMappings(ASTNode gByExpr, ColumnInfo colInfo, RowResolver gByInputRR, RowResolver gByRR) {
            if (gByExpr.getType() == 17 && gByExpr.getChild(0).getType() == 894) {
                String tab_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getChild(0).getText());
                String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(1).getText());
                gByRR.put(tab_alias, col_alias, colInfo);
            } else if (gByExpr.getType() == 894) {
                String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getText());
                String tab_alias = null;
                try {
                    ColumnInfo pColInfo = gByInputRR.get(tab_alias, col_alias);
                    tab_alias = pColInfo == null ? null : pColInfo.getTabAlias();
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
                gByRR.put(tab_alias, col_alias, colInfo);
            }
        }

        private void addToGBExpr(RowResolver groupByOutputRowResolver, RowResolver groupByInputRowResolver, ASTNode grpbyExpr, ExprNodeDesc grpbyExprNDesc, List<ExprNodeDesc> gbExprNDescLst, List<String> outputColumnNames) {
            int i = gbExprNDescLst.size();
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            gbExprNDescLst.add(grpbyExprNDesc);
            ColumnInfo oColInfo = new ColumnInfo(field, grpbyExprNDesc.getTypeInfo(), null, false);
            groupByOutputRowResolver.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, groupByInputRowResolver, groupByOutputRowResolver);
        }

        private AggInfo getHiveAggInfo(ASTNode aggAst, int aggFnLstArgIndx, RowResolver inputRR) throws SemanticException {
            AggInfo aInfo = null;
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            for (int i = 1; i <= aggFnLstArgIndx; ++i) {
                ASTNode paraExpr = (ASTNode)aggAst.getChild(i);
                ExprNodeDesc paraExprNode = CalcitePlanner.this.genExprNodeDesc(paraExpr, inputRR);
                aggParameters.add(paraExprNode);
            }
            boolean isDistinct = aggAst.getType() == 706;
            TypeInfo udafRetType = null;
            String aggName = SemanticAnalyzer.unescapeIdentifier(aggAst.getChild(0).getText());
            if (FunctionRegistry.isRankingFunction(aggName)) {
                udafRetType = aggName.equalsIgnoreCase("percent_rank") ? TypeInfoFactory.doubleTypeInfo : TypeInfoFactory.intTypeInfo;
            } else {
                try {
                    boolean isAllColumns = aggAst.getType() == 707;
                    GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                    GenericUDAFEvaluator genericUDAFEvaluator = null;
                    if (aggName.toLowerCase().equals("lead") || aggName.toLowerCase().equals("lag")) {
                        ArrayList<ObjectInspector> originalParameterTypeInfos = SemanticAnalyzer.getWritableObjectInspector(aggParameters);
                        genericUDAFEvaluator = FunctionRegistry.getGenericWindowingEvaluator(aggName, originalParameterTypeInfos, isDistinct, isAllColumns);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        udafRetType = ((ListTypeInfo)udaf.returnType).getListElementTypeInfo();
                    } else {
                        genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, aggAst, isDistinct, isAllColumns);
                        assert (genericUDAFEvaluator != null);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        udafRetType = FunctionRegistry.pivotResult(aggName) ? ((ListTypeInfo)udaf.returnType).getListElementTypeInfo() : udaf.returnType;
                    }
                }
                catch (Exception e) {
                    CalcitePlanner.this.LOG.debug((Object)("CBO: Couldn't Obtain UDAF evaluators for " + aggName + ", trying to translate to GenericUDF"));
                }
                if (udafRetType == null) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    tcCtx.setAllowDistinctFunctions(false);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc((ASTNode)aggAst.getChild(0), inputRR, tcCtx);
                    udafRetType = exp.getTypeInfo();
                }
            }
            aInfo = new AggInfo(aggParameters, udafRetType, aggName, isDistinct);
            return aInfo;
        }

        private RelNode genGBLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            boolean cubeRollupGrpSetPresent;
            ASTNode node;
            RelNode gbRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String detsClauseName = qbp.getClauseNames().iterator().next();
            ASTNode selExprList = qb.getParseInfo().getSelForClause(detsClauseName);
            if (selExprList.getToken().getType() == 826 && selExprList.getChildCount() == 1 && selExprList.getChild(0).getChildCount() == 1 && (node = (ASTNode)selExprList.getChild(0).getChild(0)).getToken().getType() == 606) {
                srcRel = this.genSelectLogicalPlan(qb, srcRel, srcRel);
                RowResolver rr = this.relToHiveRR.get(srcRel);
                qbp.setSelExprForClause(detsClauseName, SemanticAnalyzer.genSelectDIAST(rr));
            }
            List<ASTNode> grpByAstExprs = SemanticAnalyzer.getGroupByForClause(qbp, detsClauseName);
            HashMap<String, ASTNode> aggregationTrees = qbp.getAggregationExprsForClause(detsClauseName);
            boolean hasGrpByAstExprs = grpByAstExprs != null && !grpByAstExprs.isEmpty();
            boolean hasAggregationTrees = aggregationTrees != null && !aggregationTrees.isEmpty();
            boolean bl = cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) && qbp.getDistinctFuncExprsForClause(detsClauseName).size() > 1) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
            }
            if (cubeRollupGrpSetPresent) {
                if (!HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE)) {
                    throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
                }
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW)) {
                    CalcitePlanner.this.checkExpressionsForGroupingSet(grpByAstExprs, qb.getParseInfo().getDistinctFuncExprsForClause(detsClauseName), aggregationTrees, this.relToHiveRR.get(srcRel));
                    if (qbp.getDestGroupingSets().size() > CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY)) {
                        String errorMsg = "The number of rows per input row due to grouping sets is " + qbp.getDestGroupingSets().size();
                        throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
                    }
                }
            }
            if (hasGrpByAstExprs || hasAggregationTrees) {
                Object field;
                ArrayList<ExprNodeDesc> gbExprNDescLst = new ArrayList<ExprNodeDesc>();
                ArrayList<String> outputColumnNames = new ArrayList<String>();
                RowResolver groupByInputRowResolver = this.relToHiveRR.get(srcRel);
                RowResolver groupByOutputRowResolver = new RowResolver();
                groupByOutputRowResolver.setIsExprResolver(true);
                if (hasGrpByAstExprs) {
                    for (int i = 0; i < grpByAstExprs.size(); ++i) {
                        ASTNode grpbyExpr = grpByAstExprs.get(i);
                        Map<ASTNode, ExprNodeDesc> astToExprNDescMap = TypeCheckProcFactory.genExprNode(grpbyExpr, new TypeCheckCtx(groupByInputRowResolver));
                        ExprNodeDesc grpbyExprNDesc = astToExprNDescMap.get(grpbyExpr);
                        if (grpbyExprNDesc == null) {
                            throw new CalciteSemanticException("Invalid Column Reference: " + grpbyExpr.dump(), CalciteSemanticException.UnsupportedFeature.Invalid_column_reference);
                        }
                        this.addToGBExpr(groupByOutputRowResolver, groupByInputRowResolver, grpbyExpr, grpbyExprNDesc, gbExprNDescLst, outputColumnNames);
                    }
                }
                int groupingColsSize = gbExprNDescLst.size();
                List<Integer> groupingSets = null;
                if (cubeRollupGrpSetPresent) {
                    if (qbp.getDestRollups().contains(detsClauseName)) {
                        groupingSets = CalcitePlanner.this.getGroupingSetsForRollup(grpByAstExprs.size());
                    } else if (qbp.getDestCubes().contains(detsClauseName)) {
                        groupingSets = CalcitePlanner.this.getGroupingSetsForCube(grpByAstExprs.size());
                    } else if (qbp.getDestGroupingSets().contains(detsClauseName)) {
                        groupingSets = CalcitePlanner.this.getGroupingSets(grpByAstExprs, qbp, detsClauseName);
                    }
                    int limit = groupingColsSize * 2;
                    while (groupingColsSize < limit) {
                        field = SemanticAnalyzer.getColumnInternalName(groupingColsSize);
                        outputColumnNames.add((String)field);
                        groupByOutputRowResolver.put(null, (String)field, new ColumnInfo((String)field, TypeInfoFactory.booleanTypeInfo, null, false));
                        ++groupingColsSize;
                    }
                }
                ArrayList<AggInfo> aggregations = new ArrayList<AggInfo>();
                if (hasAggregationTrees) {
                    assert (aggregationTrees != null);
                    for (ASTNode value : aggregationTrees.values()) {
                        String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
                        boolean isDistinct = value.getType() == 706;
                        boolean isAllColumns = value.getType() == 707;
                        ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
                        for (int i = 1; i < value.getChildCount(); ++i) {
                            ASTNode paraExpr = (ASTNode)value.getChild(i);
                            ExprNodeDesc paraExprNode = CalcitePlanner.this.genExprNodeDesc(paraExpr, groupByInputRowResolver);
                            aggParameters.add(paraExprNode);
                        }
                        GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                        GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
                        assert (genericUDAFEvaluator != null);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        AggInfo aInfo = new AggInfo(aggParameters, udaf.returnType, aggName, isDistinct);
                        aggregations.add(aInfo);
                        String field2 = SemanticAnalyzer.getColumnInternalName(groupingColsSize + aggregations.size() - 1);
                        outputColumnNames.add(field2);
                        groupByOutputRowResolver.putExpression(value, new ColumnInfo(field2, aInfo.m_returnType, "", false));
                    }
                }
                if (groupingSets != null && !groupingSets.isEmpty()) {
                    field = SemanticAnalyzer.getColumnInternalName(groupingColsSize + aggregations.size());
                    outputColumnNames.add((String)field);
                    groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo((String)field, TypeInfoFactory.intTypeInfo, null, true));
                }
                gbRel = this.genGBRelNode(gbExprNDescLst, aggregations, groupingSets, srcRel);
                this.relToHiveColNameCalcitePosMap.put(gbRel, this.buildHiveToCalciteColumnMap(groupByOutputRowResolver, gbRel));
                this.relToHiveRR.put(gbRel, groupByOutputRowResolver);
            }
            return gbRel;
        }

        private Pair<RelNode, RelNode> genOBLogicalPlan(QB qb, RelNode srcRel, boolean outermostOB) throws SemanticException {
            String dest;
            HiveSort sortRel = null;
            RelNode originalOBChild = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            ASTNode obAST = qbp.getOrderByForClause(dest = qbp.getClauseNames().iterator().next());
            if (obAST != null) {
                Integer limit = qb.getParseInfo().getDestLimit(dest);
                if (CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVEMAPREDMODE).equalsIgnoreCase("strict") && limit == null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(obAST, ErrorMsg.NO_LIMIT_WITH_ORDERBY.getMsg()));
                }
                ArrayList<RexNode> newVCLst = new ArrayList<RexNode>();
                ArrayList<RelFieldCollation> fieldCollations = Lists.newArrayList();
                int fieldIndex = 0;
                List obASTExprLst = obAST.getChildren();
                ArrayList<Pair> vcASTTypePairs = new ArrayList<Pair>();
                RowResolver inputRR = this.relToHiveRR.get(srcRel);
                RowResolver outputRR = new RowResolver();
                RexNodeConverter converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), this.relToHiveColNameCalcitePosMap.get(srcRel), 0, false);
                int srcRelRecordSz = srcRel.getRowType().getFieldCount();
                for (int i = 0; i < obASTExprLst.size(); ++i) {
                    ASTNode obASTExpr = (ASTNode)obASTExprLst.get(i);
                    Map<ASTNode, ExprNodeDesc> astToExprNDescMap = TypeCheckProcFactory.genExprNode(obASTExpr, new TypeCheckCtx(inputRR));
                    ExprNodeDesc obExprNDesc = astToExprNDescMap.get(obASTExpr.getChild(0));
                    if (obExprNDesc == null) {
                        throw new SemanticException("Invalid order by expression: " + obASTExpr.toString());
                    }
                    RexNode rnd = converter.convert(obExprNDesc);
                    if (rnd instanceof RexInputRef) {
                        fieldIndex = ((RexInputRef)rnd).getIndex();
                    } else {
                        fieldIndex = srcRelRecordSz + newVCLst.size();
                        newVCLst.add(rnd);
                        vcASTTypePairs.add(new Pair((Object)((ASTNode)obASTExpr.getChild(0)), (Object)obExprNDesc.getTypeInfo()));
                    }
                    RelFieldCollation.Direction order = RelFieldCollation.Direction.DESCENDING;
                    if (obASTExpr.getType() == 899) {
                        order = RelFieldCollation.Direction.ASCENDING;
                    }
                    fieldCollations.add(new RelFieldCollation(fieldIndex, order));
                }
                RelNode obInputRel = srcRel;
                if (!newVCLst.isEmpty()) {
                    List<RexNode> originalInputRefs = Lists.transform(srcRel.getRowType().getFieldList(), new Function<RelDataTypeField, RexNode>(){

                        @Override
                        public RexNode apply(RelDataTypeField input) {
                            return new RexInputRef(input.getIndex(), input.getType());
                        }
                    });
                    RowResolver obSyntheticProjectRR = new RowResolver();
                    if (!RowResolver.add(obSyntheticProjectRR, inputRR)) {
                        throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                    }
                    int vcolPos = inputRR.getRowSchema().getSignature().size();
                    for (Pair astTypePair : vcASTTypePairs) {
                        obSyntheticProjectRR.putExpression((ASTNode)astTypePair.getKey(), new ColumnInfo(SemanticAnalyzer.getColumnInternalName(vcolPos), (TypeInfo)astTypePair.getValue(), null, false));
                        ++vcolPos;
                    }
                    obInputRel = this.genSelectRelNode((List<RexNode>)CompositeList.of(originalInputRefs, newVCLst), obSyntheticProjectRR, srcRel);
                    if (outermostOB) {
                        if (!RowResolver.add(outputRR, inputRR)) {
                            throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                        }
                    } else {
                        if (!RowResolver.add(outputRR, obSyntheticProjectRR)) {
                            throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                        }
                        originalOBChild = srcRel;
                    }
                } else if (!RowResolver.add(outputRR, inputRR)) {
                    throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                RelTraitSet traitSet = this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION);
                RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollationImpl.of(fieldCollations));
                sortRel = new HiveSort(this.cluster, traitSet, obInputRel, canonizedCollation, null, null);
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveToCalciteColumnMap(outputRR, sortRel);
                this.relToHiveRR.put(sortRel, outputRR);
                this.relToHiveColNameCalcitePosMap.put(sortRel, hiveColNameCalcitePosMap);
            }
            return new Pair(sortRel, originalOBChild);
        }

        private RelNode genLimitLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            HiveSort sortRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            Integer limit = qbp.getDestToLimit().get(qbp.getClauseNames().iterator().next());
            if (limit != null) {
                RexLiteral fetch = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(limit.intValue()));
                RelTraitSet traitSet = this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION);
                RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollations.EMPTY);
                sortRel = new HiveSort(this.cluster, traitSet, srcRel, canonizedCollation, null, (RexNode)fetch);
                RowResolver outputRR = new RowResolver();
                if (!RowResolver.add(outputRR, this.relToHiveRR.get(srcRel))) {
                    throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveToCalciteColumnMap(outputRR, sortRel);
                this.relToHiveRR.put(sortRel, outputRR);
                this.relToHiveColNameCalcitePosMap.put(sortRel, hiveColNameCalcitePosMap);
            }
            return sortRel;
        }

        private List<RexNode> getPartitionKeys(PTFInvocationSpec.PartitionSpec ps, RexNodeConverter converter, RowResolver inputRR) throws SemanticException {
            ArrayList<RexNode> pKeys = new ArrayList<RexNode>();
            if (ps != null) {
                ArrayList<PTFInvocationSpec.PartitionExpression> pExprs = ps.getExpressions();
                for (PTFInvocationSpec.PartitionExpression pExpr : pExprs) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc(pExpr.getExpression(), inputRR, tcCtx);
                    pKeys.add(converter.convert(exp));
                }
            }
            return pKeys;
        }

        private List<RexFieldCollation> getOrderKeys(PTFInvocationSpec.OrderSpec os, RexNodeConverter converter, RowResolver inputRR) throws SemanticException {
            ArrayList<RexFieldCollation> oKeys = new ArrayList<RexFieldCollation>();
            if (os != null) {
                ArrayList<PTFInvocationSpec.OrderExpression> oExprs = os.getExpressions();
                for (PTFInvocationSpec.OrderExpression oExpr : oExprs) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc(oExpr.getExpression(), inputRR, tcCtx);
                    RexNode ordExp = converter.convert(exp);
                    HashSet<SqlKind> flags = new HashSet<SqlKind>();
                    if (oExpr.getOrder() == PTFInvocationSpec.Order.DESC) {
                        flags.add(SqlKind.DESCENDING);
                    }
                    oKeys.add(new RexFieldCollation(ordExp, flags));
                }
            }
            return oKeys;
        }

        private RexWindowBound getBound(WindowingSpec.BoundarySpec bs, RexNodeConverter converter) {
            RexWindowBound rwb = null;
            if (bs != null) {
                SqlParserPos pos = new SqlParserPos(1, 1);
                SqlNumericLiteral amt = bs.getAmt() == 0 ? null : SqlLiteral.createExactNumeric((String)String.valueOf(bs.getAmt()), (SqlParserPos)new SqlParserPos(2, 2));
                RexNode amtLiteral = null;
                SqlCall sc = null;
                if (amt != null) {
                    amtLiteral = this.cluster.getRexBuilder().makeLiteral((Object)new Integer(bs.getAmt()), this.cluster.getTypeFactory().createSqlType(SqlTypeName.INTEGER), true);
                }
                switch (bs.getDirection()) {
                    case PRECEDING: {
                        if (amt == null) {
                            rwb = RexWindowBound.create((SqlNode)SqlWindow.createUnboundedPreceding((SqlParserPos)pos), null);
                            break;
                        }
                        sc = (SqlCall)SqlWindow.createPreceding((SqlNode)amt, (SqlParserPos)pos);
                        rwb = RexWindowBound.create((SqlNode)sc, (RexNode)this.cluster.getRexBuilder().makeCall(sc.getOperator(), new RexNode[]{amtLiteral}));
                        break;
                    }
                    case CURRENT: {
                        rwb = RexWindowBound.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)new SqlParserPos(1, 1)), null);
                        break;
                    }
                    case FOLLOWING: {
                        if (amt == null) {
                            rwb = RexWindowBound.create((SqlNode)SqlWindow.createUnboundedFollowing((SqlParserPos)new SqlParserPos(1, 1)), null);
                            break;
                        }
                        sc = (SqlCall)SqlWindow.createFollowing((SqlNode)amt, (SqlParserPos)pos);
                        rwb = RexWindowBound.create((SqlNode)sc, (RexNode)this.cluster.getRexBuilder().makeCall(sc.getOperator(), new RexNode[]{amtLiteral}));
                    }
                }
            }
            return rwb;
        }

        private int getWindowSpecIndx(ASTNode wndAST) {
            int wi = wndAST.getChildCount() - 1;
            if (wi <= 0 || wndAST.getChild(wi).getType() != 931) {
                wi = -1;
            }
            return wi;
        }

        private Pair<RexNode, TypeInfo> genWindowingProj(QB qb, WindowingSpec.WindowExpressionSpec wExpSpec, RelNode srcRel) throws SemanticException {
            ImmutableList.Builder calciteAggFnArgsTypeBldr;
            ImmutableList.Builder calciteAggFnArgsBldr;
            RexNodeConverter converter;
            RelDataType calciteAggFnRetType;
            AggInfo hiveAggInfo;
            RexNode w = null;
            TypeInfo wHiveRetType = null;
            if (wExpSpec instanceof WindowingSpec.WindowFunctionSpec) {
                WindowingSpec.WindowFunctionSpec wFnSpec = (WindowingSpec.WindowFunctionSpec)wExpSpec;
                ASTNode windowProjAst = wFnSpec.getExpression();
                int wndSpecASTIndx = this.getWindowSpecIndx(windowProjAst);
                hiveAggInfo = this.getHiveAggInfo(windowProjAst, wndSpecASTIndx - 1, this.relToHiveRR.get(srcRel));
                wHiveRetType = hiveAggInfo.m_returnType;
                calciteAggFnRetType = TypeConverter.convert(hiveAggInfo.m_returnType, this.cluster.getTypeFactory());
                ImmutableMap<String, Integer> posMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
                converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), posMap, 0, false);
                calciteAggFnArgsBldr = ImmutableList.builder();
                calciteAggFnArgsTypeBldr = ImmutableList.builder();
                for (int i = 0; i < hiveAggInfo.m_aggParams.size(); ++i) {
                    calciteAggFnArgsBldr.add(converter.convert((ExprNodeDesc)hiveAggInfo.m_aggParams.get(i)));
                    calciteAggFnArgsTypeBldr.add(TypeConverter.convert(((ExprNodeDesc)hiveAggInfo.m_aggParams.get(i)).getTypeInfo(), this.cluster.getTypeFactory()));
                }
            } else {
                throw new RuntimeException("Unsupported window Spec");
            }
            ImmutableCollection calciteAggFnArgs = calciteAggFnArgsBldr.build();
            ImmutableCollection calciteAggFnArgsType = calciteAggFnArgsTypeBldr.build();
            SqlAggFunction calciteAggFn = SqlFunctionConverter.getCalciteAggFn(hiveAggInfo.m_udfName, (ImmutableList<RelDataType>)calciteAggFnArgsType, calciteAggFnRetType);
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            WindowingSpec.WindowSpec wndSpec = ((WindowingSpec.WindowFunctionSpec)wExpSpec).getWindowSpec();
            List<RexNode> partitionKeys = this.getPartitionKeys(wndSpec.getPartition(), converter, inputRR);
            List<RexFieldCollation> orderKeys = this.getOrderKeys(wndSpec.getOrder(), converter, inputRR);
            RexWindowBound upperBound = this.getBound(wndSpec.windowFrame.start, converter);
            RexWindowBound lowerBound = this.getBound(wndSpec.windowFrame.end, converter);
            boolean isRows = wndSpec.windowFrame.start instanceof WindowingSpec.RangeBoundarySpec || wndSpec.windowFrame.end instanceof WindowingSpec.RangeBoundarySpec;
            w = this.cluster.getRexBuilder().makeOver(calciteAggFnRetType, calciteAggFn, (List)((Object)calciteAggFnArgs), partitionKeys, ImmutableList.copyOf(orderKeys), lowerBound, upperBound, isRows, true, false);
            return new Pair((Object)w, (Object)wHiveRetType);
        }

        private RelNode genSelectForWindowing(QB qb, RelNode srcRel, HashSet<ColumnInfo> newColumns) throws SemanticException {
            WindowingSpec wSpec;
            this.getQBParseInfo(qb);
            WindowingSpec windowingSpec = wSpec = !qb.getAllWindowingSpecs().isEmpty() ? qb.getAllWindowingSpecs().values().iterator().next() : null;
            if (wSpec == null) {
                return null;
            }
            wSpec.validateAndMakeEffective();
            ArrayList<WindowingSpec.WindowExpressionSpec> windowExpressions = wSpec.getWindowExpressions();
            if (windowExpressions == null || windowExpressions.isEmpty()) {
                return null;
            }
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            ArrayList<RexNode> projsForWindowSelOp = new ArrayList<RexNode>(HiveCalciteUtil.getProjsFromBelowAsInputRef(srcRel));
            RowResolver out_rwsch = new RowResolver();
            if (!RowResolver.add(out_rwsch, inputRR)) {
                CalcitePlanner.this.LOG.warn((Object)"Duplicates detected when adding columns to RR: see previous message");
            }
            for (WindowingSpec.WindowExpressionSpec wExprSpec : windowExpressions) {
                if (out_rwsch.getExpression(wExprSpec.getExpression()) != null) continue;
                Pair<RexNode, TypeInfo> wtp = this.genWindowingProj(qb, wExprSpec, srcRel);
                projsForWindowSelOp.add((RexNode)wtp.getKey());
                ColumnInfo oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(projsForWindowSelOp.size()), (TypeInfo)wtp.getValue(), null, false);
                out_rwsch.putExpression(wExprSpec.getExpression(), oColInfo);
                newColumns.add(oColInfo);
            }
            return this.genSelectRelNode(projsForWindowSelOp, out_rwsch, srcRel, windowExpressions);
        }

        private RelNode genSelectRelNode(List<RexNode> calciteColLst, RowResolver out_rwsch, RelNode srcRel) throws CalciteSemanticException {
            return this.genSelectRelNode(calciteColLst, out_rwsch, srcRel, null);
        }

        private RelNode genSelectRelNode(List<RexNode> calciteColLst, RowResolver out_rwsch, RelNode srcRel, List<WindowingSpec.WindowExpressionSpec> windowExpressions) throws CalciteSemanticException {
            HashSet<String> colNamesSet = new HashSet<String>();
            ArrayList<ColumnInfo> cInfoLst = out_rwsch.getRowSchema().getSignature();
            ArrayList<String> columnNames = new ArrayList<String>();
            HashMap<String, String> windowToAlias = null;
            if (windowExpressions != null) {
                windowToAlias = new HashMap<String, String>();
                for (WindowingSpec.WindowExpressionSpec wes : windowExpressions) {
                    windowToAlias.put(wes.getExpression().toStringTree().toLowerCase(), wes.getAlias());
                }
            }
            for (int i = 0; i < calciteColLst.size(); ++i) {
                ColumnInfo cInfo = (ColumnInfo)cInfoLst.get(i);
                String[] qualifiedColNames = out_rwsch.reverseLookup(cInfo.getInternalName());
                String tmpColAlias = qualifiedColNames[1];
                if (tmpColAlias.contains(".") || tmpColAlias.contains(":")) {
                    tmpColAlias = cInfo.getInternalName();
                }
                if (tmpColAlias.startsWith("_c")) {
                    tmpColAlias = "_o_" + tmpColAlias;
                } else if (windowToAlias != null && windowToAlias.containsKey(tmpColAlias)) {
                    tmpColAlias = (String)windowToAlias.get(tmpColAlias);
                }
                int suffix = 1;
                while (colNamesSet.contains(tmpColAlias)) {
                    tmpColAlias = qualifiedColNames[1] + suffix;
                    ++suffix;
                }
                colNamesSet.add(tmpColAlias);
                columnNames.add(tmpColAlias);
            }
            HiveProject selRel = HiveProject.create(srcRel, calciteColLst, columnNames);
            this.relToHiveColNameCalcitePosMap.put(selRel, this.buildHiveToCalciteColumnMap(out_rwsch, selRel));
            this.relToHiveRR.put(selRel, out_rwsch);
            return selRel;
        }

        private RelNode genSelectLogicalPlan(QB qb, RelNode srcRel, RelNode starSrcRel) throws SemanticException {
            String funcName;
            FunctionInfo fi;
            boolean isInTransform;
            boolean hintPresent;
            RowResolver inputRR;
            HashSet<ColumnInfo> excludedColumns = new HashSet<ColumnInfo>();
            RelNode selForWindow = this.genSelectForWindowing(qb, srcRel, excludedColumns);
            srcRel = selForWindow == null ? srcRel : selForWindow;
            ArrayList<ExprNodeDesc> col_list = new ArrayList<ExprNodeDesc>();
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String selClauseName = qbp.getClauseNames().iterator().next();
            ASTNode selExprList = qbp.getSelForClause(selClauseName);
            RowResolver out_rwsch = new RowResolver();
            Integer pos = 0;
            RowResolver starRR = inputRR = this.relToHiveRR.get(srcRel);
            if (starSrcRel != null) {
                starRR = this.relToHiveRR.get(starSrcRel);
            }
            boolean selectStar = false;
            int posn = 0;
            boolean bl = hintPresent = selExprList.getChild(0).getType() == 720;
            if (hintPresent) {
                String hint = CalcitePlanner.this.ctx.getTokenRewriteStream().toString(selExprList.getChild(0).getTokenStartIndex(), selExprList.getChild(0).getTokenStopIndex());
                String msg = String.format("Hint specified for %s. Currently we don't support hints in CBO, turn off cbo to use hints.", hint);
                CalcitePlanner.this.LOG.debug((Object)msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Hint);
            }
            boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 908;
            if (isInTransform) {
                String msg = String.format("SELECT TRANSFORM is currently not supported in CBO, turn off cbo to use TRANSFORM.", new Object[0]);
                CalcitePlanner.this.LOG.debug((Object)msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Select_transform);
            }
            ASTNode expr = (ASTNode)selExprList.getChild(posn).getChild(0);
            int exprType = expr.getType();
            if ((exprType == 705 || exprType == 707) && (fi = FunctionRegistry.getFunctionInfo(funcName = TypeCheckProcFactory.DefaultExprProcessor.getFunctionText(expr, true))) != null && fi.getGenericUDTF() != null) {
                String msg = String.format("UDTF " + funcName + " is currently not supported in CBO," + " turn off cbo to use UDTF " + funcName, new Object[0]);
                CalcitePlanner.this.LOG.debug((Object)msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.UDTF);
            }
            ASTNode exprList = selExprList;
            int startPosn = posn;
            List<String> tabAliasesForAllProjs = this.getTabAliases(starRR);
            for (int i = startPosn; i < exprList.getChildCount(); ++i) {
                ExprNodeColumnDesc colExp;
                String[] altMapping;
                boolean hasAsClause;
                ASTNode child = (ASTNode)exprList.getChild(i);
                boolean bl3 = hasAsClause = !isInTransform && child.getChildCount() == 2;
                if (child.getChildCount() > 2) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(2), ErrorMsg.INVALID_AS.getMsg()));
                }
                expr = (ASTNode)child.getChild(0);
                String[] colRef = SemanticAnalyzer.getColAlias(child, CalcitePlanner.this.getAutogenColAliasPrfxLbl(), inputRR, CalcitePlanner.this.autogenColAliasPrfxIncludeFuncName(), i);
                String tabAlias = colRef[0];
                String colAlias = colRef[1];
                if (expr.getType() == 606) {
                    pos = CalcitePlanner.this.genColListRegex(".*", expr.getChildCount() == 0 ? null : SemanticAnalyzer.getUnescapedName((ASTNode)expr.getChild(0)).toLowerCase(), expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, tabAliasesForAllProjs, true);
                    selectStar = true;
                    continue;
                }
                if (expr.getType() == 894 && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), CalcitePlanner.this.conf)) {
                    pos = CalcitePlanner.this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, tabAliasesForAllProjs, true);
                    continue;
                }
                if (expr.getType() == 17 && expr.getChild(0).getType() == 894 && inputRR.hasTableAlias(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), CalcitePlanner.this.conf)) {
                    pos = CalcitePlanner.this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, tabAliasesForAllProjs, true);
                    continue;
                }
                if (expr.toStringTree().contains("TOK_FUNCTIONDI") && !(srcRel instanceof HiveAggregate)) {
                    throw new CalciteSemanticException("Distinct without an aggreggation.", CalciteSemanticException.UnsupportedFeature.Distinct_without_an_aggreggation);
                }
                TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                tcCtx.setAllowStatefulFunctions(true);
                ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc(expr, inputRR, tcCtx);
                String recommended = CalcitePlanner.this.recommendName(exp, colAlias);
                if (recommended != null && out_rwsch.get(null, recommended) == null) {
                    colAlias = recommended;
                }
                col_list.add(exp);
                ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), exp.getWritableObjectInspector(), tabAlias, false);
                colInfo.setSkewedCol(exp instanceof ExprNodeColumnDesc ? ((ExprNodeColumnDesc)exp).isSkewedCol() : false);
                if (!out_rwsch.putWithCheck(tabAlias, colAlias, null, colInfo)) {
                    throw new CalciteSemanticException("Cannot add column to RR: " + tabAlias + "." + colAlias + " => " + colInfo + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                if (exp instanceof ExprNodeColumnDesc && (altMapping = inputRR.getAlternateMappings((colExp = (ExprNodeColumnDesc)exp).getColumn())) != null) {
                    out_rwsch.put(altMapping[0], altMapping[1], colInfo);
                }
                pos = pos + 1;
            }
            selectStar = selectStar && exprList.getChildCount() == posn + 1;
            ArrayList<RexNode> calciteColLst = new ArrayList<RexNode>();
            RexNodeConverter rexNodeConv = new RexNodeConverter(this.cluster, srcRel.getRowType(), this.buildHiveColNameToInputPosMap(col_list, inputRR), 0, false);
            for (ExprNodeDesc colExpr : col_list) {
                calciteColLst.add(rexNodeConv.convert(colExpr));
            }
            RelNode selRel = this.genSelectRelNode(calciteColLst, out_rwsch, srcRel);
            return selRel;
        }

        private RelNode genLogicalPlan(QBExpr qbexpr) throws SemanticException {
            if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
                return this.genLogicalPlan(qbexpr.getQB(), false);
            }
            if (qbexpr.getOpcode() == QBExpr.Opcode.UNION) {
                RelNode qbexpr1Ops = this.genLogicalPlan(qbexpr.getQBExpr1());
                RelNode qbexpr2Ops = this.genLogicalPlan(qbexpr.getQBExpr2());
                return this.genUnionLogicalPlan(qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
            }
            return null;
        }

        private RelNode genLogicalPlan(QB qb, boolean outerMostQB) throws SemanticException {
            RelNode srcRel = null;
            RelNode filterRel = null;
            RelNode gbRel = null;
            RelNode gbHavingRel = null;
            RelNode selectRel = null;
            RelNode obRel = null;
            RelNode limitRel = null;
            HashMap<String, RelNode> aliasToRel = new HashMap<String, RelNode>();
            String reason = CalcitePlanner.canHandleQbForCbo(CalcitePlanner.this.queryProperties, CalcitePlanner.this.conf, false, CalcitePlanner.this.LOG.isDebugEnabled(), qb);
            if (reason != null) {
                String msg = "CBO can not handle Sub Query";
                if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                    CalcitePlanner.this.LOG.debug((Object)(msg + " because it: " + reason));
                }
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Subquery);
            }
            for (String subqAlias : qb.getSubqAliases()) {
                QBExpr qbexpr = qb.getSubqForAlias(subqAlias);
                aliasToRel.put(subqAlias, this.genLogicalPlan(qbexpr));
            }
            for (String tableAlias : qb.getTabAliases()) {
                RelNode op = this.genTableLogicalPlan(tableAlias, qb);
                aliasToRel.put(tableAlias, op);
            }
            if (aliasToRel.isEmpty()) {
                throw new CalciteSemanticException("Unsupported", CalciteSemanticException.UnsupportedFeature.Others);
            }
            srcRel = qb.getParseInfo().getJoinExpr() != null ? this.genJoinLogicalPlan(qb.getParseInfo().getJoinExpr(), aliasToRel) : (RelNode)aliasToRel.values().iterator().next();
            filterRel = this.genFilterLogicalPlan(qb, srcRel, aliasToRel, false);
            RelNode starSrcRel = srcRel = filterRel == null ? srcRel : filterRel;
            gbRel = this.genGBLogicalPlan(qb, srcRel);
            srcRel = gbRel == null ? srcRel : gbRel;
            gbHavingRel = this.genGBHavingLogicalPlan(qb, srcRel, aliasToRel);
            srcRel = gbHavingRel == null ? srcRel : gbHavingRel;
            selectRel = this.genSelectLogicalPlan(qb, srcRel, starSrcRel);
            srcRel = selectRel == null ? srcRel : selectRel;
            Pair<RelNode, RelNode> obTopProjPair = this.genOBLogicalPlan(qb, srcRel, outerMostQB);
            obRel = (RelNode)obTopProjPair.getKey();
            RelNode topConstrainingProjArgsRel = (RelNode)obTopProjPair.getValue();
            srcRel = obRel == null ? srcRel : obRel;
            limitRel = this.genLimitLogicalPlan(qb, srcRel);
            RelNode relNode = srcRel = limitRel == null ? srcRel : limitRel;
            if (topConstrainingProjArgsRel != null) {
                List<RexNode> originalInputRefs = Lists.transform(topConstrainingProjArgsRel.getRowType().getFieldList(), new Function<RelDataTypeField, RexNode>(){

                    @Override
                    public RexNode apply(RelDataTypeField input) {
                        return new RexInputRef(input.getIndex(), input.getType());
                    }
                });
                RowResolver topConstrainingProjRR = new RowResolver();
                if (!RowResolver.add(topConstrainingProjRR, this.relToHiveRR.get(topConstrainingProjArgsRel))) {
                    CalcitePlanner.this.LOG.warn((Object)"Duplicates detected when adding columns to RR: see previous message");
                }
                srcRel = this.genSelectRelNode(originalInputRefs, topConstrainingProjRR, srcRel);
            }
            if (qb.getParseInfo().getAlias() != null) {
                RowResolver rr = this.relToHiveRR.get(srcRel);
                RowResolver newRR = new RowResolver();
                String alias = qb.getParseInfo().getAlias();
                for (ColumnInfo colInfo : rr.getColumnInfos()) {
                    String name = colInfo.getInternalName();
                    String[] tmp = rr.reverseLookup(name);
                    if ("".equals(tmp[0]) || tmp[1] == null) {
                        tmp[1] = colInfo.getInternalName();
                    }
                    ColumnInfo newCi = new ColumnInfo(colInfo);
                    newCi.setTabAlias(alias);
                    newRR.put(alias, tmp[1], newCi);
                }
                this.relToHiveRR.put(srcRel, newRR);
                this.relToHiveColNameCalcitePosMap.put(srcRel, this.buildHiveToCalciteColumnMap(newRR, srcRel));
            }
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug((Object)("Created Plan for Query Block " + qb.getId()));
            }
            CalcitePlanner.this.setQB(qb);
            return srcRel;
        }

        private RelNode genGBHavingLogicalPlan(QB qb, RelNode srcRel, Map<String, RelNode> aliasToRel) throws SemanticException {
            RelNode gbFilter = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            ASTNode havingClause = qbp.getHavingForClause(qbp.getClauseNames().iterator().next());
            if (havingClause != null) {
                if (!(srcRel instanceof HiveAggregate)) {
                    throw new CalciteSemanticException("Having clause without any group-by.", CalciteSemanticException.UnsupportedFeature.Having_clause_without_any_groupby);
                }
                this.validateNoHavingReferenceToAlias(qb, (ASTNode)havingClause.getChild(0));
                gbFilter = this.genFilterRelNode(qb, (ASTNode)havingClause.getChild(0), srcRel, aliasToRel, true);
            }
            return gbFilter;
        }

        private void validateNoHavingReferenceToAlias(QB qb, ASTNode havingExpr) throws CalciteSemanticException {
            QBParseInfo qbPI = qb.getParseInfo();
            Map<ASTNode, String> exprToAlias = qbPI.getAllExprToColumnAlias();
            Set<String> aggExprs = qbPI.getDestToAggregationExprs().values().iterator().next().keySet();
            for (Map.Entry<ASTNode, String> selExpr : exprToAlias.entrySet()) {
                ASTNode selAST = selExpr.getKey();
                if (!aggExprs.contains(selAST.toStringTree().toLowerCase())) continue;
                final String aliasToCheck = selExpr.getValue();
                final HashSet aliasReferences = new HashSet();
                TreeVisitorAction action = new TreeVisitorAction(){

                    public Object pre(Object t) {
                        Object c;
                        if (ParseDriver.adaptor.getType(t) == 894 && (c = ParseDriver.adaptor.getChild(t, 0)) != null && ParseDriver.adaptor.getType(c) == 26 && ParseDriver.adaptor.getText(c).equals(aliasToCheck)) {
                            aliasReferences.add(t);
                        }
                        return t;
                    }

                    public Object post(Object t) {
                        return t;
                    }
                };
                new TreeVisitor(ParseDriver.adaptor).visit((Object)havingExpr, action);
                if (aliasReferences.size() <= 0) continue;
                String havingClause = CalcitePlanner.this.ctx.getTokenRewriteStream().toString(havingExpr.getTokenStartIndex(), havingExpr.getTokenStopIndex());
                String msg = String.format("Encountered Select alias '%s' in having clause '%s' This non standard behavior is not supported with cbo on. Turn off cbo for these queries.", aliasToCheck, havingClause);
                CalcitePlanner.this.LOG.debug((Object)msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Select_alias_in_having_clause);
            }
        }

        private ImmutableMap<String, Integer> buildHiveToCalciteColumnMap(RowResolver rr, RelNode rNode) {
            ImmutableMap.Builder<String, Integer> b = new ImmutableMap.Builder<String, Integer>();
            for (ColumnInfo ci : rr.getRowSchema().getSignature()) {
                b.put(ci.getInternalName(), rr.getPosition(ci.getInternalName()));
            }
            return b.build();
        }

        private ImmutableMap<String, Integer> buildHiveColNameToInputPosMap(List<ExprNodeDesc> col_list, RowResolver inputRR) {
            HashMap<Integer, ExprNodeDesc> hashCodeTocolumnDescMap = new HashMap<Integer, ExprNodeDesc>();
            ExprNodeDescUtils.getExprNodeColumnDesc(col_list, hashCodeTocolumnDescMap);
            ImmutableMap.Builder<String, Integer> hiveColNameToInputPosMapBuilder = new ImmutableMap.Builder<String, Integer>();
            for (ExprNodeDesc exprDesc : hashCodeTocolumnDescMap.values()) {
                String exprNodecolName = ((ExprNodeColumnDesc)exprDesc).getColumn();
                hiveColNameToInputPosMapBuilder.put(exprNodecolName, inputRR.getPosition(exprNodecolName));
            }
            return hiveColNameToInputPosMapBuilder.build();
        }

        private QBParseInfo getQBParseInfo(QB qb) throws CalciteSemanticException {
            QBParseInfo qbp = qb.getParseInfo();
            if (qbp.getClauseNames().size() > 1) {
                String msg = String.format("Multi Insert is currently not supported in CBO, turn off cbo to use Multi Insert.", new Object[0]);
                CalcitePlanner.this.LOG.debug((Object)msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Multi_insert);
            }
            return qbp;
        }

        private List<String> getTabAliases(RowResolver inputRR) {
            ArrayList<String> tabAliases = new ArrayList<String>();
            for (ColumnInfo ci : inputRR.getColumnInfos()) {
                tabAliases.add(ci.getTabAlias());
            }
            return tabAliases;
        }

        private class AggInfo {
            private final List<ExprNodeDesc> m_aggParams;
            private final TypeInfo m_returnType;
            private final String m_udfName;
            private final boolean m_distinct;

            private AggInfo(List<ExprNodeDesc> aggParams, TypeInfo returnType, String udfName, boolean isDistinct) {
                this.m_aggParams = aggParams;
                this.m_returnType = returnType;
                this.m_udfName = udfName;
                this.m_distinct = isDistinct;
            }
        }
    }

    private static class ExceptionHelper {
        private static final Field CAUSE_FIELD = ExceptionHelper.getField(Throwable.class, "cause");
        private static final Field TARGET_FIELD = ExceptionHelper.getField(InvocationTargetException.class, "target");
        private static final Field MESSAGE_FIELD = ExceptionHelper.getField(Throwable.class, "detailMessage");

        private ExceptionHelper() {
        }

        private static Field getField(Class<?> clazz, String name) {
            try {
                Field f = clazz.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (Throwable t) {
                return null;
            }
        }

        public static boolean resetCause(Throwable target, Throwable newCause) {
            try {
                Field field;
                if (MESSAGE_FIELD == null) {
                    return false;
                }
                Field field2 = field = target instanceof InvocationTargetException ? TARGET_FIELD : CAUSE_FIELD;
                if (field == null) {
                    return false;
                }
                Throwable oldCause = target.getCause();
                String oldMsg = target.getMessage();
                field.set(target, newCause);
                if (oldMsg != null && oldMsg.equals(oldCause.toString())) {
                    MESSAGE_FIELD.set(target, newCause == null ? null : newCause.toString());
                }
            }
            catch (Throwable se) {
                return false;
            }
            return true;
        }
    }

    static class ASTSearcher {
        private final LinkedList<ASTNode> searchQueue = new LinkedList();

        ASTSearcher() {
        }

        public ASTNode simpleBreadthFirstSearch(ASTNode ast, int ... tokens) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            for (int i = 0; i < tokens.length; ++i) {
                boolean found = false;
                int token = tokens[i];
                while (!this.searchQueue.isEmpty() && !found) {
                    ASTNode next = this.searchQueue.poll();
                    boolean bl = found = next.getType() == token;
                    if (found) {
                        if (i == tokens.length - 1) {
                            return next;
                        }
                        this.searchQueue.clear();
                    }
                    for (int j = 0; j < next.getChildCount(); ++j) {
                        this.searchQueue.add((ASTNode)next.getChild(j));
                    }
                }
                if (found) continue;
                return null;
            }
            return null;
        }
    }

    static class PreCboCtx
    extends SemanticAnalyzer.PlannerContext {
        private ASTNode nodeOfInterest;
        private Type type = Type.NONE;

        PreCboCtx() {
        }

        private void set(Type type, ASTNode ast) {
            if (this.type != Type.NONE) {
                BaseSemanticAnalyzer.STATIC_LOG.warn((Object)("Setting " + (Object)((Object)type) + " when already " + (Object)((Object)this.type) + "; node " + ast.dump() + " vs old node " + this.nodeOfInterest.dump()));
                this.type = Type.UNEXPECTED;
                return;
            }
            this.type = type;
            this.nodeOfInterest = ast;
        }

        @Override
        void setCTASToken(ASTNode child) {
            this.set(Type.CTAS, child);
        }

        @Override
        void setInsertToken(ASTNode ast, boolean isTmpFileDest) {
            if (!isTmpFileDest) {
                this.set(Type.INSERT, ast);
            }
        }

        static enum Type {
            NONE,
            INSERT,
            CTAS,
            UNEXPECTED;

        }
    }
}

