CREATE TABLE my_tt_agg_small (
    symbol character(16),
    event_ts bigint,
    trade_price numeric,
    trade_volume bigint
) DISTRIBUTED BY (symbol);


CREATE TABLE my_tq_agg_small (
    ets bigint,
    sym character varying(16),
    bid_price numeric,
    ask_price numeric,
    end_ts bigint
) DISTRIBUTED BY (ets);

COPY my_tt_agg_small (symbol, event_ts, trade_price, trade_volume) FROM stdin;
SFD             	20101126141540067	165350	200
SFD             	20101126114903007	162950	900
SSO             	20101126114618004	415700	200
SFD             	20101126135708973	165325	100
SSO             	20101126123243370	414100	200
SSO             	20101126103004068	418900	100
SSO             	20101126143516183	413000	400
SSO             	20101126101605922	417300	100
SSO             	20101126141714316	413900	100
SSO             	20101126105438196	420200	300
SSO             	20101126130551217	415200	1884
SSO             	20101126115347005	416094	200
SFD             	20101126142751018	165525	200
SFD             	20101126104718850	162300	100
SFD             	20101126124225712	163400	100
SFD             	20101126140901866	165400	200
SFD             	20101126132748128	163400	200
SSO             	20101126113409949	417100	100
SSO             	20101126122851098	414500	200
SSO             	20101126130853141	413400	100
SSO             	20101126142501553	413900	100
SSO             	20101126110703554	419000	2000
SSO             	20101126111754263	418900	100
SSO             	20101126131159446	414300	200
SSO             	20101126105503130	420200	600
SFD             	20101126103528703	161500	100
SSO             	20101126130611791	415200	200
SSO             	20101126134523280	415200	100
SSO             	20101126114458196	415801	100
SFD             	20101126111634685	161800	200
SSO             	20101126143028816	413800	100
SFD             	20101126114903027	162900	100
SSO             	20101126102534669	419300	100
SSO             	20101126104934902	420296	100
SFD             	20101126132128793	164200	100
SSO             	20101126110209616	419400	100
SSO             	20101126114622409	415700	100
SSO             	20101126102910429	418900	200
SSO             	20101126130710744	414800	200
SSO             	20101126134050571	415200	100
SSO             	20101126143537087	412600	100
SSO             	20101126130216492	415000	100
SSO             	20101126112330010	418600	100
SSO             	20101126132056731	413000	100
SSO             	20101126101909312	418600	200
SSO             	20101126142747861	413500	100
SSO             	20101126140756477	414400	200
SFD             	20101126141930459	165400	100
SSO             	20101126130722909	414000	100
SFD             	20101126132000905	163900	200
SSO             	20101126143910661	413700	100
SSO             	20101126105105773	420400	200
SFD             	20101126135544046	165300	100
SSO             	20101126140334172	414800	200
SFD             	20101126141143414	165500	500
SSO             	20101126132255964	413400	200
SSO             	20101126102739958	419000	100
SSO             	20101126110149068	419400	100
SFD             	20101126101854502	162200	200
SSO             	20101126140802108	414600	100
SFD             	20101126112501534	162000	500
SSO             	20101126105517786	419900	100
SFD             	20101126142750870	165500	100
SSO             	20101126105826745	419700	100
SSO             	20101126130714449	414500	158
SSO             	20101126130810468	413700	100
SSO             	20101126141140108	414700	100
SFD             	20101126141143418	165500	100
SSO             	20101126132848219	413700	200
SSO             	20101126110440168	419200	123
SSO             	20101126143511788	413000	200
SFD             	20101126135445966	164900	100
SSO             	20101126114950925	415000	200
SSO             	20101126122332088	415300	200
SSO             	20101126140738594	414400	200
SSO             	20101126123418884	414300	600
SFD             	20101126132643539	163700	100
SSO             	20101126130807367	413800	300
SSO             	20101126132030805	413000	300
SSO             	20101126115539875	416200	100
SSO             	20101126133447080	414600	100
SFD             	20101126111417395	161800	1600
SSO             	20101126131038125	414000	100
SSO             	20101126140744197	414400	100
SSO             	20101126113637525	417100	100
SSO             	20101126105754039	419800	100
SSO             	20101126114603380	415900	200
SSO             	20101126114137215	416800	200
SSO             	20101126134027584	415400	100
SSO             	20101126134848481	415000	100
SFD             	20101126135749249	165700	100
SSO             	20101126103544685	419480	1100
SSO             	20101126143609990	413000	100
SSO             	20101126111647886	419000	200
SSO             	20101126122759847	414600	200
SSO             	20101126135616060	415600	100
SSO             	20101126112427413	418100	100
SSO             	20101126115012757	415200	700
SFD             	20101126112716237	162100	100
SSO             	20101126130715131	414200	200
SFD             	20101126130031060	164000	100
SFD             	20101126114522652	163100	100
SSO             	20101126135333236	415000	100
SSO             	20101126143537003	412600	200
SSO             	20101126123321946	414100	300
SSO             	20101126120604250	416400	100
SSO             	20101126113846420	417200	100
SSO             	20101126142451184	413900	100
SSO             	20101126115503201	416300	100
SFD             	20101126125825175	164200	100
SSO             	20101126143245800	413500	100
SSO             	20101126121621949	416400	100
SSO             	20101126114342119	416100	100
SSO             	20101126120618531	416400	246
SSO             	20101126130707222	414700	400
SFD             	20101126103441803	161500	300
SSO             	20101126134036304	415400	146
SSO             	20101126140047856	415500	200
SFD             	20101126103005559	161700	100
SSO             	20101126140616208	415000	100
SSO             	20101126113636765	417300	500
SSO             	20101126113453468	417100	200
SSO             	20101126101605890	417300	200
SSO             	20101126105329812	420000	171
SSO             	20101126120749846	416300	800
SSO             	20101126110853997	419300	200
SSO             	20101126130704392	414800	270
SSO             	20101126115850387	415900	200
SSO             	20101126124939495	414800	200
SSO             	20101126142309251	414600	335
SSO             	20101126114551287	415900	100
SSO             	20101126123802699	414500	500
SSO             	20101126110004924	419900	100
SSO             	20101126113359671	417100	141
SSO             	20101126141929749	414300	100
SSO             	20101126134054343	415200	800
SSO             	20101126131848923	413800	100
SSO             	20101126130224192	415300	200
SSO             	20101126105517786	419900	100
SSO             	20101126104758870	420100	100
SSO             	20101126131619976	414000	123
SSO             	20101126113006036	418300	866
SSO             	20101126111358582	419200	1800
SSO             	20101126122754091	414700	100
SSO             	20101126135333236	415000	100
SSO             	20101126142838242	413500	200
SSO             	20101126113403721	417100	1000
SSO             	20101126113959989	416600	200
SSO             	20101126113011394	418400	300
SSO             	20101126105424710	420300	100
SSO             	20101126123428434	414500	100
SSO             	20101126105325042	420100	100
SSO             	20101126114816778	415000	100
SSO             	20101126110617990	418700	100
SSO             	20101126141925219	414400	100
SSO             	20101126102023826	418500	100
SSO             	20101126103924857	419900	100
SSO             	20101126105849151	419625	100
SSO             	20101126131348047	413900	100
SSO             	20101126113637241	417300	1000
SFD             	20101126111745854	161900	100
SSO             	20101126143838743	413700	100
SSO             	20101126113453458	417100	200
SSO             	20101126142424814	414000	100
SFD             	20101126121722920	162500	100
SSO             	20101126105358112	420300	1000
SSO             	20101126112944097	418000	200
SSO             	20101126134100279	415000	190
SSO             	20101126101709857	418100	165
SSO             	20101126104013964	419763	100
SSO             	20101126113041749	418300	100
SSO             	20101126114618008	415700	106
SSO             	20101126122840398	414400	100
SSO             	20101126132520125	413600	300
SSO             	20101126103758899	419700	600
SSO             	20101126122520605	415175	1000
SFD             	20101126113959990	162900	100
SSO             	20101126141956083	414400	100
SSO             	20101126115245995	415798	1000
SSO             	20101126140053811	415400	100
SSO             	20101126140818182	414399	100
SFD             	20101126101752361	161900	100
SSO             	20101126132056079	413000	200
SSO             	20101126140617828	415000	100
SFD             	20101126104602149	162300	200
SFD             	20101126115409329	162900	100
SSO             	20101126130010638	415500	300
SSO             	20101126114258924	416400	500
SSO             	20101126131209969	414200	100
SSO             	20101126105443658	420100	100
SFD             	20101126103327476	161500	100
SSO             	20101126101443309	417000	100
SFD             	20101126124639145	163400	100
SSO             	20101126130431657	415600	200
SSO             	20101126130431657	415600	400
SSO             	20101126134114387	414900	100
SSO             	20101126115518789	416200	200
SSO             	20101126105625089	419800	100
SFD             	20101126131917942	164000	100
SSO             	20101126105430987	420300	200
SSO             	20101126102438583	419400	100
SSO             	20101126113912443	416900	100
SSO             	20101126132645595	413501	200
SSO             	20101126114456865	415900	100
SSO             	20101126113636889	417100	200
SSO             	20101126114516074	415501	100
SSO             	20101126113538994	417197	200
SSO             	20101126142545339	414100	100
SSO             	20101126140033101	415501	1000
SFD             	20101126111723537	161700	300
SSO             	20101126103140617	418600	200
SSO             	20101126113453530	417200	200
SSO             	20101126104859164	420200	100
SSO             	20101126123628022	414800	100
SSO             	20101126104046425	419500	200
SSO             	20101126130605677	415100	200
SSO             	20101126131917795	413100	200
SSO             	20101126130213540	414700	100
SSO             	20101126113636841	417200	200
SFD             	20101126135756855	165750	100
SSO             	20101126115010525	415100	100
SSO             	20101126132938938	413800	100
SSO             	20101126141554586	414200	100
SSO             	20101126130840845	413700	200
SSO             	20101126114846399	414900	200
SSO             	20101126103107093	418500	100
SSO             	20101126132938474	413800	200
SSO             	20101126121710164	415900	100
SFD             	20101126114903009	162900	200
SSO             	20101126131235625	413900	100
SFD             	20101126134958750	164550	100
SSO             	20101126103537432	419400	100
SSO             	20101126132312872	413400	500
SFD             	20101126114239283	163163	200
SSO             	20101126143537747	412600	200
SSO             	20101126103026298	418800	100
SSO             	20101126115001012	414900	100
SSO             	20101126121621949	416400	300
SSO             	20101126143505542	413000	100
SSO             	20101126130802076	414000	330
SSO             	20101126115747456	415800	500
SSO             	20101126123430908	414500	200
SSO             	20101126143620175	413300	2000
SSO             	20101126105759234	419900	200
SFD             	20101126120930243	163050	100
SSO             	20101126130857288	413400	200
SFD             	20101126140546276	165250	100
SSO             	20101126120953550	416300	900
SSO             	20101126101210755	417500	300
SSO             	20101126103750590	419400	200
SSO             	20101126123605349	414800	100
SSO             	20101126121636735	416300	200
SSO             	20101126101710043	417900	100
SSO             	20101126123102566	414500	200
SSO             	20101126115022903	415300	100
SSO             	20101126115451813	416300	100
SSO             	20101126141925625	414300	100
SFD             	20101126101624106	161900	100
SSO             	20101126140738588	414400	135
SSO             	20101126114803631	415100	100
SSO             	20101126105454327	420200	100
SSO             	20101126121421400	416500	1500
SFD             	20101126120946382	163000	100
SFD             	20101126122600695	162500	100
SFD             	20101126103422112	161400	100
SSO             	20101126140738592	414400	100
SSO             	20101126102502342	419500	100
SSO             	20101126123201437	414200	100
SFD             	20101126131925440	163900	100
SSO             	20101126112955530	418000	100
SSO             	20101126103624657	419400	100
SSO             	20101126105431177	420400	100
SSO             	20101126130216654	415000	200
SSO             	20101126105735960	419800	100
SFD             	20101126113550137	163100	100
SSO             	20101126101851068	418600	600
SSO             	20101126123751700	414675	100
SSO             	20101126122847120	414500	300
SSO             	20101126143326653	413200	100
SSO             	20101126104655754	420192	200
SFD             	20101126135450393	164900	100
SFD             	20101126111758343	161500	200
SSO             	20101126111715845	418900	300
SSO             	20101126132129086	413100	100
SSO             	20101126124348260	414600	200
SFD             	20101126135435803	164600	100
SSO             	20101126130922633	413700	100
SSO             	20101126114908292	415000	1000
SFD             	20101126124846035	163500	100
SSO             	20101126112548492	417400	100
SFD             	20101126141327966	165500	100
SSO             	20101126105742841	419800	100
SFD             	20101126102200948	162100	100
SSO             	20101126113410973	417100	100
SFD             	20101126140059177	165300	200
SSO             	20101126115449867	416300	200
SSO             	20101126142559496	413762	3610
SSO             	20101126132557735	413500	145
SSO             	20101126104818561	420000	100
SSO             	20101126115850223	415900	300
SSO             	20101126105358115	420300	1000
SSO             	20101126113500384	417200	270
SSO             	20101126102558362	419200	100
SSO             	20101126101831833	418500	200
SFD             	20101126104714736	162200	400
SSO             	20101126121724725	415600	1000
SSO             	20101126102124988	418400	200
SFD             	20101126122903952	162600	100
SSO             	20101126130834670	413700	300
SSO             	20101126114251974	416500	200
SFD             	20101126112717807	162100	100
SFD             	20101126112431061	162100	100
SSO             	20101126114251774	416800	100
SFD             	20101126101625944	161900	600
SFD             	20101126103303956	161500	100
SSO             	20101126143628658	413400	100
SSO             	20101126105914477	419700	200
SSO             	20101126113359895	417125	100
SSO             	20101126130704392	414800	700
SFD             	20101126113150816	162400	200
SFD             	20101126105235896	162237	1000
SSO             	20101126132938512	413800	200
SSO             	20101126114816770	415000	100
SSO             	20101126130944630	414000	200
SFD             	20101126101937938	162400	100
SSO             	20101126131742428	413500	200
SSO             	20101126123310836	414100	100
SSO             	20101126130710750	414800	200
SSO             	20101126141454960	414400	100
SSO             	20101126121658563	416100	359
SSO             	20101126113636841	417200	200
SSO             	20101126114419501	416233	600
SFD             	20101126135717744	165400	100
SSO             	20101126103917895	419791	200
SSO             	20101126104347822	419400	463
SSO             	20101126103937248	419800	100
SSO             	20101126140744205	414400	1000
SSO             	20101126142357600	414100	200
SSO             	20101126122647208	414600	418
SSO             	20101126102200911	418600	200
SSO             	20101126115436273	416000	100
SSO             	20101126123200963	414200	300
SSO             	20101126102631986	419190	1300
SSO             	20101126104617052	419800	100
SSO             	20101126115450869	416400	200
SSO             	20101126103539365	419500	300
SFD             	20101126132132690	164200	100
SSO             	20101126121421263	416700	130
SSO             	20101126125618749	415200	4000
SSO             	20101126121653497	416300	200
SSO             	20101126114504490	415500	100
SFD             	20101126135727068	165500	100
SSO             	20101126141213101	414200	100
SSO             	20101126140057949	415200	100
SSO             	20101126130808096	413800	100
SFD             	20101126101319209	161500	100
SSO             	20101126131820010	413500	145
SFD             	20101126101301707	161400	100
SSO             	20101126135333234	415000	200
SSO             	20101126105517786	419900	100
SSO             	20101126133003223	413800	200
SFD             	20101126101926385	162400	100
SSO             	20101126103538701	419400	200
SSO             	20101126113157575	417300	100
SSO             	20101126141557486	413900	300
SFD             	20101126143008195	165300	100
SSO             	20101126113113207	417900	200
SSO             	20101126103059317	418500	200
SSO             	20101126114457007	415900	300
SSO             	20101126103117340	418500	200
SFD             	20101126134246308	164500	100
SSO             	20101126104250518	419400	100
SSO             	20101126105438200	420200	100
SSO             	20101126113259706	417500	100
SSO             	20101126123039599	414501	200
SFD             	20101126121613015	162700	1985
SSO             	20101126101403752	417600	100
SFD             	20101126141908195	165325	100
SSO             	20101126120305353	416600	200
SSO             	20101126103758873	419600	200
SSO             	20101126103652893	419300	300
SSO             	20101126123605355	414800	200
SSO             	20101126130431639	415600	200
SSO             	20101126134710335	415100	100
SSO             	20101126130710748	414800	700
SFD             	20101126131448313	163500	100
SFD             	20101126140713723	165200	100
SFD             	20101126143632686	165600	100
SSO             	20101126122550204	414900	100
SSO             	20101126113206560	417200	100
SFD             	20101126121002145	162900	100
SSO             	20101126114405423	416200	100
SSO             	20101126114656448	415300	200
SSO             	20101126104603642	419700	100
SSO             	20101126120305345	416601	200
SSO             	20101126101506479	417000	100
SSO             	20101126132042749	413000	100
SSO             	20101126105133053	420200	100
SSO             	20101126101552263	417100	100
SSO             	20101126102048888	418700	530
SSO             	20101126114741057	415000	200
SSO             	20101126112944097	418000	100
SSO             	20101126130806733	413700	200
SSO             	20101126115451195	416293	1000
SSO             	20101126140244013	414900	100
SSO             	20101126130835528	413600	200
SSO             	20101126114950929	415000	100
SSO             	20101126130216514	415100	200
SSO             	20101126131923122	413400	200
SSO             	20101126115026566	415200	100
SSO             	20101126113349693	417400	300
SSO             	20101126113804966	417400	200
SSO             	20101126123248949	414100	200
SFD             	20101126143702995	165500	200
SSO             	20101126141653600	413800	200
SSO             	20101126113405657	417100	238
SFD             	20101126135724178	165500	100
SFD             	20101126141237272	165500	100
SSO             	20101126105736136	419800	100
SSO             	20101126104026261	419600	300
\.



COPY my_tq_agg_small (ets, sym, bid_price, ask_price, end_ts) FROM stdin;
20101126101359577	SFD	177900	178000	20101126101359578
20101126101154807	SFD	178100	178200	20101126101154808
20101126101259868	SFD	177900	178000	20101126101259868
20101126101228812	SFD	178100	178200	20101126101228817
20101126101435260	SFD	178000	178100	20101126101435261
20101126101236779	SFD	178100	178200	20101126101236788
20101126101426112	SFD	178000	178100	20101126101426428
20101126101705936	SFD	178000	178100	20101126101705937
20101126101635495	SFD	178000	178100	20101126101635903
20101126101957322	SFD	177900	178000	20101126101957411
20101126101431491	SFD	178000	178100	20101126101431492
20101126101202012	SFD	178200	178300	20101126101202012
20101126101500530	SFD	177900	178000	20101126101500531
20101126101259323	SFD	178000	178200	20101126101259325
20101126101426429	SFD	178000	178100	20101126101426737
20101126101202054	SFD	178200	178300	20101126101202055
20101126102019602	SFD	178000	178100	20101126102019603
20101126101259331	SFD	177900	178100	20101126101259332
20101126101236790	SFD	178100	178300	20101126101236795
20101126101426760	SFD	178000	178100	20101126101426761
20101126101359923	SFD	178000	178100	20101126101359924
20101126101202813	SFD	178100	178200	20101126101204340
20101126101215145	SFD	178100	178300	20101126101215165
20101126101538699	SFD	177900	178000	20101126101539675
20101126101755863	SFD	177900	178000	20101126101755919
20101126101914926	SFD	178100	178200	20101126101914928
20101126101905317	SFD	178100	178200	20101126101905320
20101126101638422	SFD	178000	178100	20101126101638423
20101126101448351	SFD	175700	178000	20101126101448351
20101126102325055	SFD	178100	178200	20101126102332204
20101126101426737	SFD	178000	178100	20101126101426738
20101126101755921	SFD	177900	178000	20101126101758413
20101126102213275	SFD	178200	178300	20101126102213307
20101126101545973	SFD	177900	178000	20101126101546090
20101126101448464	SFD	175700	180500	20101126101448472
20101126101949080	SFD	178100	178200	20101126101949081
20101126101552149	SFD	177800	177900	20101126101552150
20101126101601001	SFD	177800	177900	20101126101601004
20101126101546095	SFD	177800	178000	20101126101546095
20101126101948331	SFD	178100	178200	20101126101948333
20101126101832395	SFD	177900	178000	20101126101832401
20101126101635135	SFD	177900	180600	20101126101635135
20101126101742772	SFD	177800	178000	20101126101742937
20101126101549947	SFD	177800	177900	20101126101549948
20101126101959699	SFD	177900	178000	20101126101959699
20101126102312165	SFD	178200	178400	20101126102312188
20101126103909779	SFD	178100	178200	20101126103910300
20101126101500555	SFD	178000	178100	20101126101500556
20101126103851414	SFD	178300	178400	20101126103851418
20101126102213320	SFD	178200	178300	20101126102213352
20101126102019622	SFD	178000	178100	20101126102019623
20101126102056754	SFD	178000	178100	20101126102056756
20101126102408356	SFD	178100	178200	20101126102410126
20101126102419097	SFD	178100	178200	20101126102443207
20101126101504439	SFD	177900	178000	20101126101511443
20101126104453016	SFD	177900	178000	20101126104453026
20101126101709150	SFD	178000	178100	20101126101719149
20101126101850878	SFD	178100	178200	20101126101850883
20101126101841692	SFD	178000	178200	20101126101841694
20101126103223066	SFD	178200	178300	20101126103225605
20101126101753590	SFD	177900	178000	20101126101753591
20101126101635934	SFD	178000	178100	20101126101635934
20101126101426761	SFD	178000	178100	20101126101428688
20101126104109128	SFD	177900	178000	20101126104109128
20101126101946170	SFD	178100	178200	20101126101946171
20101126101949084	SFD	178000	178100	20101126101949084
20101126101841696	SFD	178000	178200	20101126101841697
20101126102022683	SFD	178000	178100	20101126102022684
20101126102021473	SFD	178000	178100	20101126102021474
20101126102757279	SFD	178100	178200	20101126102805438
20101126101637834	SFD	178000	178100	20101126101638257
20101126102101375	SFD	178100	180500	20101126102101957
20101126102316017	SFD	178100	178200	20101126102316019
20101126102259333	SFD	178100	178300	20101126102259333
20101126102214054	SFD	178200	178300	20101126102221477
20101126101916462	SFD	178100	178200	20101126101917275
20101126101837622	SFD	177900	178000	20101126101837623
20101126101647128	SFD	178000	178100	20101126101652412
20101126102056749	SFD	178000	178100	20101126102056754
20101126102222199	SFD	178200	178400	20101126102222585
20101126102022680	SFD	177900	178100	20101126102022681
20101126102632227	SFD	178100	178200	20101126102632228
20101126101635148	SFD	178000	178100	20101126101635154
20101126101841697	SFD	178000	178200	20101126101841881
20101126102144355	SFD	178100	178200	20101126102144397
20101126102302233	SFD	178100	178200	20101126102302235
20101126103906342	SFD	178200	178300	20101126103906342
20101126101908643	SFD	178000	178200	20101126101908647
20101126102213319	SFD	178200	178300	20101126102213320
20101126101836826	SFD	177800	178000	20101126101836826
20101126102310460	SFD	178100	178200	20101126102311747
20101126102313707	SFD	178100	178200	20101126102315820
20101126101948328	SFD	178100	178200	20101126101948329
20101126102158266	SFD	178200	178400	20101126102158267
20101126102056821	SFD	178100	178200	20101126102056821
20101126103848576	SFD	178300	178400	20101126103848592
20101126101854058	SFD	178100	178200	20101126101854661
20101126102312161	SFD	178200	178300	20101126102312163
20101126102323020	SFD	178100	178300	20101126102323021
20101126103652592	SFD	178300	178400	20101126103653911
20101126102141566	SFD	178100	178200	20101126102143182
20101126101949082	SFD	178000	178200	20101126101949082
20101126102019700	SFD	178000	178100	20101126102019709
20101126104320852	SFD	177900	178000	20101126104322882
20101126102649297	SFD	178100	178200	20101126102649299
20101126101955425	SFD	177800	178000	20101126101955426
20101126102149421	SFD	178100	178200	20101126102149461
20101126103906345	SFD	178200	178300	20101126103906347
20101126102151294	SFD	178200	178300	20101126102151305
20101126105026983	SFD	178200	178300	20101126105026983
20101126104152601	SFD	177900	178000	20101126104153483
20101126102144774	SFD	178200	178300	20101126102144814
20101126102019624	SFD	178000	178100	20101126102019697
20101126103928019	SFD	178100	178200	20101126103928019
20101126103953755	SFD	178100	178200	20101126103953778
20101126102019601	SFD	178000	180500	20101126102019601
20101126103022673	SFD	178200	178300	20101126103023335
20101126102144398	SFD	178100	178200	20101126102144402
20101126103517588	SFD	178300	178400	20101126103517589
20101126101948329	SFD	178100	178200	20101126101948330
20101126102340171	SFD	178100	178200	20101126102340263
20101126102149420	SFD	178100	178200	20101126102149421
20101126103906326	SFD	178300	178400	20101126103906326
20101126102407580	SFD	178100	178200	20101126102407582
20101126102818591	SFD	178100	178200	20101126102818593
20101126104841506	SFD	178100	178200	20101126104843034
20101126103456800	SFD	178300	178400	20101126103456802
20101126102259433	SFD	178100	178200	20101126102300313
20101126104101041	SFD	178000	178100	20101126104101041
20101126103908451	SFD	178100	178200	20101126103908453
20101126104458019	SFD	177900	178000	20101126104458021
20101126102926234	SFD	178100	178200	20101126102926235
20101126103906352	SFD	178200	178300	20101126103906355
20101126103747593	SFD	178300	178400	20101126103756234
20101126102021886	SFD	177900	178000	20101126102021886
20101126103855975	SFD	178300	178400	20101126103856578
20101126103016222	SFD	178100	178300	20101126103016540
20101126105027626	SFD	178300	178400	20101126105027943
20101126105215369	SFD	178400	178500	20101126105215469
20101126103908435	SFD	176000	178300	20101126103908436
20101126102618402	SFD	178100	178200	20101126102622492
20101126104919037	SFD	178200	178300	20101126104920056
20101126104743128	SFD	177900	178000	20101126104743221
20101126103157426	SFD	178200	178300	20101126103157427
20101126103621025	SFD	178300	178400	20101126103621027
20101126103246117	SFD	178200	178400	20101126103246118
20101126103432608	SFD	178300	178400	20101126103432608
20101126102019603	SFD	174800	178100	20101126102019603
20101126103800414	SFD	178300	178400	20101126103800414
20101126102056820	SFD	178100	178200	20101126102056821
20101126104103455	SFD	178000	179400	20101126104103455
20101126102233015	SFD	178200	178300	20101126102246655
20101126104810369	SFD	177900	178000	20101126104810384
20101126102904908	SFD	178100	178200	20101126102905010
20101126104740370	SFD	177900	178000	20101126104740372
20101126104756824	SFD	177800	178000	20101126104758028
20101126103345692	SFD	178300	178400	20101126103345693
20101126104238210	SFD	177900	178000	20101126104238331
20101126103632593	SFD	178300	178400	20101126103637592
20101126104104052	SFD	178000	178100	20101126104104143
20101126104304660	SFD	177900	178000	20101126104304673
20101126104559030	SFD	177900	178000	20101126104559032
20101126102113499	SFD	174800	178200	20101126102118693
20101126104801217	SFD	177900	178000	20101126104801218
20101126102540241	SFD	178100	178200	20101126102541299
20101126104823748	SFD	177900	178100	20101126104823748
20101126103024536	SFD	178200	178300	20101126103024537
20101126105730213	SFD	178400	178500	20101126105730831
20101126102324700	SFD	175700	178400	20101126102324702
20101126103906333	SFD	178200	178300	20101126103906333
20101126105115477	SFD	178300	178500	20101126105115477
20101126105213553	SFD	178400	178500	20101126105215369
20101126104717012	SFD	177900	178000	20101126104722707
20101126104723304	SFD	177900	178000	20101126104725011
20101126104250905	SFD	177900	178000	20101126104252602
20101126104729462	SFD	177900	178000	20101126104729466
20101126105402638	SFD	178300	178500	20101126105402639
20101126104941117	SFD	178200	178300	20101126104941152
20101126103456834	SFD	178300	178400	20101126103457211
20101126102807097	SFD	178100	178200	20101126102807098
20101126103603039	SFD	178300	178400	20101126103607590
20101126104530542	SFD	177900	178000	20101126104537612
20101126104314707	SFD	177900	178000	20101126104315249
20101126104101108	SFD	178000	178100	20101126104101109
20101126103914901	SFD	178100	178200	20101126103914901
20101126103540436	SFD	178300	178400	20101126103541377
20101126110208158	SFD	178400	178500	20101126110209446
20101126104822050	SFD	177900	178000	20101126104823734
20101126105115842	SFD	178300	178400	20101126105116016
20101126103325423	SFD	178300	178400	20101126103325429
20101126105113178	SFD	178400	178500	20101126105113178
20101126104748289	SFD	177900	178000	20101126104748292
20101126103953779	SFD	178100	178200	20101126103953948
20101126103325431	SFD	178300	178400	20101126103326153
20101126105027004	SFD	178200	178400	20101126105027018
20101126105026995	SFD	178200	178400	20101126105026995
20101126104103547	SFD	177900	178100	20101126104104052
20101126103959337	SFD	178100	178200	20101126104001968
20101126105315389	SFD	178400	178500	20101126105315391
20101126105222530	SFD	178300	178500	20101126105222558
20101126104828385	SFD	178100	178200	20101126104828386
20101126103953949	SFD	178100	178200	20101126103953998
20101126104807627	SFD	177900	178000	20101126104808029
20101126105237260	SFD	178300	178500	20101126105238086
20101126105118025	SFD	178300	178400	20101126105119022
20101126105008160	SFD	178300	178400	20101126105008171
20101126104103298	SFD	178000	178100	20101126104103298
20101126104829023	SFD	178100	178200	20101126104829024
20101126104828970	SFD	178100	178200	20101126104829023
20101126104616086	SFD	177900	178000	20101126104616088
20101126105326972	SFD	178400	178500	20101126105326972
20101126105707953	SFD	178400	178600	20101126105707955
20101126103132177	SFD	178200	178300	20101126103138511
20101126104940369	SFD	178200	178300	20101126104940372
20101126104109131	SFD	177900	178000	20101126104109133
20101126105714631	SFD	178400	178500	20101126105714631
20101126104314707	SFD	177900	178000	20101126104314707
20101126103801069	SFD	178300	178400	20101126103801071
20101126105031417	SFD	178300	178400	20101126105032648
20101126103801069	SFD	178300	178400	20101126103801069
20101126104804136	SFD	177900	178000	20101126104807626
20101126111027058	SFD	178700	178800	20101126111027059
20101126103312815	SFD	178200	178300	20101126103323505
20101126103042635	SFD	178200	178300	20101126103042637
20101126105027173	SFD	178200	178300	20101126105027173
20101126104110881	SFD	177900	178000	20101126104113785
20101126104631784	SFD	177900	178000	20101126104633983
20101126104248215	SFD	177900	178000	20101126104248219
20101126104743221	SFD	177900	178000	20101126104744021
20101126104904515	SFD	178100	178300	20101126104906134
20101126103815083	SFD	178300	178400	20101126103828959
20101126105814618	SFD	178500	178600	20101126105814618
20101126105259519	SFD	178300	178500	20101126105259527
20101126104101040	SFD	178000	178200	20101126104101041
20101126104802258	SFD	177900	178000	20101126104804007
20101126104729466	SFD	177900	178000	20101126104729468
20101126104906138	SFD	178200	178300	20101126104906138
20101126103344231	SFD	178300	178500	20101126103344232
20101126105930419	SFD	178300	178400	20101126105930423
20101126105930003	SFD	178300	178500	20101126105930004
20101126110258899	SFD	178400	178600	20101126110258900
20101126105835672	SFD	178400	178600	20101126105835673
20101126105401622	SFD	178300	178500	20101126105401777
20101126105335672	SFD	178400	178500	20101126105342640
20101126104101041	SFD	178000	178200	20101126104101041
20101126105653036	SFD	178400	178600	20101126105653040
20101126110856685	SFD	178600	178700	20101126110856687
20101126105517727	SFD	178400	178500	20101126105520673
20101126105502527	SFD	178400	178500	20101126105502872
20101126105556712	SFD	178400	178500	20101126105600234
20101126104828154	SFD	178100	178200	20101126104828173
20101126105900741	SFD	178200	178500	20101126105900742
20101126104109127	SFD	175500	178100	20101126104109127
20101126104101042	SFD	178000	178100	20101126104101043
20101126105734971	SFD	178400	178500	20101126105736165
20101126105008937	SFD	178200	178400	20101126105009035
20101126105114174	SFD	178400	178500	20101126105114327
20101126105129842	SFD	178300	178500	20101126105129843
20101126110804788	SFD	178500	178600	20101126110805047
20101126105714657	SFD	178400	178500	20101126105714817
20101126104003713	SFD	178100	178200	20101126104012602
20101126104330096	SFD	177900	178000	20101126104330097
20101126105627905	SFD	178400	178500	20101126105627976
20101126105926055	SFD	178200	178400	20101126105926055
20101126105730108	SFD	178400	178500	20101126105730111
20101126105642565	SFD	178400	178500	20101126105642566
20101126103906328	SFD	178300	178400	20101126103906328
20101126111149010	SFD	178400	178600	20101126111149015
20101126103848593	SFD	178300	178400	20101126103851414
20101126110824150	SFD	178500	178700	20101126110828529
20101126105938043	SFD	178400	178500	20101126105938043
20101126105535275	SFD	178400	178500	20101126105535922
20101126105113178	SFD	178400	178500	20101126105113824
20101126104933016	SFD	178200	178300	20101126104933017
20101126110435748	SFD	178500	178600	20101126110435749
20101126110130278	SFD	178400	178500	20101126110130544
20101126105938039	SFD	178300	178500	20101126105938041
20101126111542694	SFD	178700	178900	20101126111542695
20101126105836033	SFD	178400	178600	20101126105836035
20101126105508437	SFD	178400	178500	20101126105508538
20101126110507104	SFD	178600	178700	20101126110508808
20101126105129930	SFD	178100	178800	20101126105129933
20101126110313852	SFD	178500	178600	20101126110313870
20101126105401946	SFD	178400	178500	20101126105402044
20101126104748288	SFD	177900	178000	20101126104748289
20101126110438464	SFD	178500	178700	20101126110438468
20101126110438597	SFD	178500	178600	20101126110438605
20101126110333268	SFD	178500	178600	20101126110341212
20101126110010369	SFD	178400	178500	20101126110010369
20101126105625765	SFD	178400	178500	20101126105625766
20101126105133142	SFD	178400	178500	20101126105134288
20101126110438936	SFD	178500	178600	20101126110439107
20101126110258895	SFD	178500	178600	20101126110258896
20101126104906141	SFD	178200	178300	20101126104906141
20101126104620639	SFD	177900	178000	20101126104631784
20101126105113028	SFD	178400	178500	20101126105113033
20101126104906295	SFD	178200	178300	20101126104906889
20101126110839987	SFD	178700	178800	20101126110839988
20101126111141851	SFD	178500	178600	20101126111141859
20101126105026975	SFD	178300	178400	20101126105026977
20101126105948683	SFD	178400	178500	20101126105950077
20101126110840017	SFD	178600	178700	20101126110840017
20101126111044018	SFD	178700	178800	20101126111044018
20101126105555496	SFD	178400	178500	20101126105556391
20101126105627977	SFD	178400	178500	20101126105628037
20101126105926057	SFD	178200	178300	20101126105926057
20101126110919022	SFD	178700	178800	20101126110919027
20101126110551933	SFD	178500	178600	20101126110551934
20101126104823743	SFD	177900	178000	20101126104823745
20101126111620678	SFD	178700	178800	20101126111632448
20101126110446628	SFD	178600	178700	20101126110446629
20101126104442609	SFD	177900	178000	20101126104447612
20101126110443946	SFD	178600	178700	20101126110443947
20101126110811479	SFD	178500	178600	20101126110813230
20101126105814398	SFD	178400	178600	20101126105814398
20101126104823772	SFD	177900	178000	20101126104823772
20101126105653041	SFD	178500	178600	20101126105653134
20101126105926210	SFD	178300	178400	20101126105926210
20101126111130254	SFD	178500	178600	20101126111130255
20101126111416768	SFD	178500	178600	20101126111418022
20101126110837981	SFD	178700	178800	20101126110837982
20101126112219995	SFD	178600	178700	20101126112247695
20101126105936009	SFD	178300	178500	20101126105936061
20101126110612340	SFD	178500	178600	20101126110612340
20101126110551934	SFD	178500	178600	20101126110553773
20101126104922033	SFD	178200	178300	20101126104923028
20101126111004129	SFD	178700	178800	20101126111004181
20101126111458159	SFD	178700	178800	20101126111458159
20101126105702226	SFD	178500	178700	20101126105702302
20101126110839991	SFD	178700	178800	20101126110840002
20101126105315391	SFD	178400	178500	20101126105315392
20101126111833156	SFD	178700	178800	20101126111840150
20101126110852591	SFD	178600	178700	20101126110852592
20101126110549319	SFD	178500	178700	20101126110549370
20101126111203517	SFD	178400	178500	20101126111203520
20101126111910131	SFD	178800	179000	20101126111910132
20101126110001922	SFD	178400	178500	20101126110002211
20101126105942413	SFD	178400	178500	20101126105948683
20101126111948621	SFD	178700	178900	20101126111948710
20101126110917216	SFD	178700	178800	20101126110917218
20101126104617617	SFD	177900	178000	20101126104620327
20101126110549253	SFD	178500	178700	20101126110549253
20101126111128053	SFD	178600	178700	20101126111128139
20101126111548412	SFD	178700	178800	20101126111548412
20101126113101442	SFD	178700	178800	20101126113101778
20101126111937691	SFD	178900	179000	20101126111937692
20101126111044018	SFD	178700	178800	20101126111044316
20101126111501644	SFD	178600	178800	20101126111502472
20101126111430371	SFD	178600	178700	20101126111430380
20101126111458669	SFD	178700	178800	20101126111458669
20101126112450744	SFD	178600	178800	20101126112450754
20101126111948620	SFD	178700	178800	20101126111948620
20101126105109024	SFD	178300	178400	20101126105110294
20101126111156102	SFD	178500	178600	20101126111156351
20101126111910397	SFD	178800	178900	20101126111910398
20101126110600791	SFD	178500	178600	20101126110601433
20101126112545783	SFD	178700	178800	20101126112546536
20101126111137343	SFD	178400	178500	20101126111138812
20101126111458672	SFD	178700	178800	20101126111458672
20101126110549238	SFD	178600	178700	20101126110549239
20101126110505672	SFD	178600	178700	20101126110505673
20101126112004005	SFD	178600	178700	20101126112004531
20101126110310728	SFD	178500	178600	20101126110313126
20101126110549309	SFD	178500	178600	20101126110549310
20101126111149033	SFD	178400	178500	20101126111150079
20101126110917210	SFD	178700	178800	20101126110917212
20101126105731168	SFD	178400	180900	20101126105732641
20101126111056641	SFD	178700	178800	20101126111103698
20101126111141859	SFD	178500	178600	20101126111141860
20101126113002726	SFD	178600	178700	20101126113012778
20101126111524368	SFD	178700	178800	20101126111524369
20101126105707957	SFD	178400	178600	20101126105714629
20101126111606266	SFD	178700	178800	20101126111606268
20101126105326971	SFD	178300	178500	20101126105326972
20101126105501607	SFD	178400	178500	20101126105502527
20101126111124242	SFD	178600	178700	20101126111124243
20101126111502472	SFD	178700	178800	20101126111502473
20101126111709595	SFD	178700	178800	20101126111715833
20101126111458549	SFD	178600	178700	20101126111458665
20101126111124256	SFD	178600	178800	20101126111124274
20101126111430018	SFD	178500	178700	20101126111430047
20101126105220803	SFD	178300	178400	20101126105222374
20101126110916661	SFD	178700	178800	20101126110916662
20101126112252751	SFD	178700	178900	20101126112252872
20101126111741443	SFD	178700	178800	20101126111744763
20101126111130255	SFD	178500	178600	20101126111130256
20101126110410730	SFD	178500	178600	20101126110410731
20101126111352044	SFD	178400	178500	20101126111352045
20101126110840866	SFD	178600	178700	20101126110840867
20101126110559904	SFD	178500	178600	20101126110559905
20101126111937658	SFD	178900	179000	20101126111937662
20101126111957273	SFD	178600	178800	20101126111957617
20101126111430048	SFD	178600	178700	20101126111430048
20101126112358526	SFD	178700	178800	20101126112358526
20101126111947255	SFD	178700	178900	20101126111947256
20101126110601439	SFD	178400	178600	20101126110601440
20101126110549252	SFD	178500	178700	20101126110549253
20101126111450674	SFD	178600	178700	20101126111451847
20101126113108287	SFD	178700	178800	20101126113108541
20101126112038139	SFD	178600	178700	20101126112042698
20101126111709229	SFD	178600	178800	20101126111709230
20101126111910338	SFD	178900	179000	20101126111910339
20101126105033082	SFD	178300	178400	20101126105033172
20101126111416736	SFD	178400	178600	20101126111416736
20101126105402638	SFD	178300	178500	20101126105402638
20101126112248558	SFD	178600	178700	20101126112248559
20101126111130258	SFD	178500	178600	20101126111130261
20101126112656243	SFD	178700	178800	20101126112656593
20101126105415672	SFD	178400	178500	20101126105418028
20101126105836539	SFD	178300	178400	20101126105836599
20101126111735138	SFD	178700	178800	20101126111735293
20101126110843623	SFD	178600	178700	20101126110843623
20101126111521039	SFD	178600	178900	20101126111521039
20101126110836944	SFD	178600	178800	20101126110837297
20101126110151094	SFD	178400	178600	20101126110155013
20101126111947698	SFD	178700	178900	20101126111948611
20101126113750048	SFD	178200	178300	20101126113750740
20101126111458163	SFD	178600	178700	20101126111458163
20101126111130071	SFD	178500	178600	20101126111130077
20101126113019076	SFD	178700	178800	20101126113019077
20101126112446849	SFD	178700	178800	20101126112447165
20101126111957255	SFD	178700	178800	20101126111957256
20101126110843622	SFD	178600	178700	20101126110843622
20101126111524061	SFD	178700	178800	20101126111524062
20101126105736938	SFD	178400	178500	20101126105737632
20101126111453033	SFD	178600	178700	20101126111453033
20101126110612339	SFD	178400	178600	20101126110612339
20101126110919047	SFD	178700	178800	20101126110919320
20101126110438493	SFD	178600	178700	20101126110438500
20101126111430370	SFD	178600	178700	20101126111430371
20101126105814767	SFD	178500	178600	20101126105814777
20101126111458669	SFD	178700	178800	20101126111458670
20101126112441562	SFD	178700	178800	20101126112441875
20101126110508808	SFD	178600	178700	20101126110508809
20101126111156360	SFD	178400	178600	20101126111156361
20101126111149004	SFD	178400	178600	20101126111149005
20101126111124231	SFD	178700	178800	20101126111124231
20101126111957271	SFD	178600	178700	20101126111957272
20101126111709594	SFD	178700	178800	20101126111709595
20101126110830441	SFD	178600	178700	20101126110830450
20101126114118603	SFD	178200	178300	20101126114118603
20101126110252758	SFD	178400	178500	20101126110255855
20101126105926054	SFD	178200	178400	20101126105926055
20101126112754326	SFD	178600	178700	20101126112754328
20101126112723684	SFD	178600	178700	20101126112724304
20101126112417030	SFD	178700	178800	20101126112418060
20101126111458184	SFD	178600	178700	20101126111458192
20101126111548433	SFD	178700	178800	20101126111548508
20101126112342401	SFD	178600	178700	20101126112350446
20101126112400446	SFD	178700	178800	20101126112402713
20101126111143239	SFD	178400	178600	20101126111149002
20101126111430244	SFD	178600	178700	20101126111430247
20101126110129944	SFD	178400	178500	20101126110130278
20101126112502155	SFD	178700	178800	20101126112502710
20101126112154895	SFD	178600	178700	20101126112156204
20101126113237745	SFD	178600	178700	20101126113237936
20101126112557790	SFD	178700	178800	20101126112558096
20101126111520680	SFD	178700	178800	20101126111521026
20101126113713024	SFD	178300	178400	20101126113713024
20101126113606375	SFD	178400	178500	20101126113608423
20101126111700224	SFD	178700	178900	20101126111700225
20101126112448998	SFD	178600	178800	20101126112449286
20101126105950660	SFD	178400	178500	20101126105950950
20101126113433581	SFD	178400	178500	20101126113433583
20101126112716573	SFD	178600	178700	20101126112718231
20101126112653378	SFD	178700	178800	20101126112654448
20101126111633464	SFD	178700	178800	20101126111633466
20101126111937667	SFD	178900	179000	20101126111937669
20101126111910371	SFD	178900	179000	20101126111910371
20101126113704881	SFD	178400	178500	20101126113705059
20101126113711396	SFD	178400	178500	20101126113712927
20101126111736101	SFD	178700	178800	20101126111736115
20101126110840167	SFD	178600	178700	20101126110840168
20101126112136521	SFD	178600	178700	20101126112136558
20101126111909920	SFD	178700	178900	20101126111909920
20101126113238029	SFD	178500	178700	20101126113238030
20101126111910181	SFD	178900	179000	20101126111910191
20101126111910154	SFD	178900	179000	20101126111910162
20101126111130256	SFD	178500	178600	20101126111130258
20101126112658791	SFD	178700	178900	20101126112658791
20101126111910397	SFD	178800	178900	20101126111910397
20101126111542688	SFD	178700	178800	20101126111542689
20101126112714882	SFD	178700	178800	20101126112714882
20101126110830324	SFD	178500	178700	20101126110830433
20101126111654903	SFD	178700	178800	20101126111654905
20101126113952715	SFD	178300	178400	20101126113952724
20101126110258891	SFD	178400	178600	20101126110258895
20101126120325343	SFD	178600	178700	20101126120325468
20101126111156091	SFD	178400	178500	20101126111156093
20101126113243422	SFD	178400	178500	20101126113243422
20101126110940140	SFD	178700	178800	20101126110940281
20101126113146163	SFD	178600	178700	20101126113146163
20101126111933122	SFD	178900	179000	20101126111933123
20101126113326772	SFD	178400	178500	20101126113326774
20101126111927490	SFD	178900	179000	20101126111927491
20101126111937695	SFD	178800	178900	20101126111937695
20101126112027015	SFD	178600	179000	20101126112027701
20101126111632463	SFD	178700	178800	20101126111632464
20101126113237732	SFD	178600	178700	20101126113237732
20101126112400369	SFD	178700	178800	20101126112400370
20101126111910371	SFD	178900	179000	20101126111910371
20101126111926993	SFD	178900	179000	20101126111926994
20101126112723050	SFD	178600	178700	20101126112723377
20101126113109681	SFD	178700	178800	20101126113109681
20101126111937676	SFD	178900	179000	20101126111937678
20101126114959905	SFD	178600	178800	20101126115000877
20101126112754986	SFD	178600	178700	20101126112755635
20101126113238033	SFD	178300	178700	20101126113238033
20101126112638503	SFD	178700	178800	20101126112640595
20101126113952755	SFD	178200	178400	20101126113952756
20101126112658750	SFD	178700	178800	20101126112658754
20101126112353016	SFD	178600	178700	20101126112353027
20101126113520772	SFD	178400	178500	20101126113522006
20101126114605682	SFD	178300	178400	20101126114605682
20101126110440673	SFD	178500	178700	20101126110443867
20101126113822358	SFD	178200	178300	20101126113822746
20101126110313960	SFD	178500	178600	20101126110314206
20101126113109717	SFD	178600	178800	20101126113109719
20101126114653830	SFD	178300	178400	20101126114653836
20101126114021115	SFD	178200	178300	20101126114021146
20101126111521396	SFD	178800	178900	20101126111522472
20101126114706821	SFD	178400	178500	20101126114711418
20101126112301744	SFD	178600	178800	20101126112301744
20101126112447165	SFD	178600	178800	20101126112447186
20101126111718828	SFD	178700	178800	20101126111718829
20101126114705304	SFD	178400	178500	20101126114706820
20101126111154410	SFD	178400	178500	20101126111154410
20101126114118606	SFD	178200	178400	20101126114118834
20101126111018558	SFD	178700	178800	20101126111018559
20101126113605237	SFD	178400	178500	20101126113605273
20101126113238030	SFD	178500	178600	20101126113238030
20101126113608423	SFD	178400	178500	20101126113608680
20101126110917147	SFD	178700	178800	20101126110917210
20101126112938372	SFD	178600	178700	20101126112938373
20101126113237405	SFD	178600	178700	20101126113237406
20101126115250661	SFD	178800	178900	20101126115250664
20101126114123221	SFD	178300	178400	20101126114123223
20101126114147760	SFD	178300	178400	20101126114149150
20101126115810465	SFD	178800	178900	20101126115810466
20101126113646209	SFD	178400	178500	20101126113646435
20101126110836943	SFD	178700	178800	20101126110836943
20101126114825024	SFD	178400	178500	20101126114825026
20101126111150079	SFD	178400	178600	20101126111150080
20101126114021184	SFD	178200	178300	20101126114021299
20101126113715672	SFD	178300	178900	20101126113716037
20101126112714742	SFD	178800	178900	20101126112714754
20101126114355409	SFD	178200	178300	20101126114355409
20101126120148731	SFD	178700	178800	20101126120148732
20101126113722855	SFD	178200	178400	20101126113722946
20101126115722873	SFD	178800	178900	20101126115722876
20101126113146160	SFD	178600	178700	20101126113146160
20101126112351593	SFD	178600	178700	20101126112351594
20101126111948611	SFD	178700	178800	20101126111948620
20101126114825371	SFD	178400	178500	20101126114825371
20101126111912682	SFD	178800	178900	20101126111913885
20101126115114022	SFD	178700	178900	20101126115114023
20101126112654714	SFD	178700	178800	20101126112655756
20101126113952755	SFD	178200	178300	20101126113952755
20101126114513195	SFD	178300	178400	20101126114515369
20101126114834242	SFD	178400	178500	20101126114834243
20101126111957270	SFD	178600	178700	20101126111957270
20101126113034203	SFD	178700	178800	20101126113034204
20101126112420498	SFD	178600	178800	20101126112420498
20101126113328724	SFD	178400	178500	20101126113328725
20101126114019129	SFD	178200	178600	20101126114019480
20101126113019096	SFD	178700	178800	20101126113019096
20101126112653023	SFD	178700	178800	20101126112653023
20101126114328043	SFD	178200	178400	20101126114328043
20101126113324486	SFD	178300	178500	20101126113326025
20101126112630814	SFD	178700	178800	20101126112632712
20101126113530822	SFD	178400	178500	20101126113531004
20101126112730247	SFD	178600	178700	20101126112730537
20101126112656593	SFD	178700	178800	20101126112656859
20101126114042360	SFD	178200	178300	20101126114042369
20101126112659551	SFD	178800	178900	20101126112700124
20101126114327270	SFD	178300	178400	20101126114327271
20101126112715647	SFD	178600	178700	20101126112715714
20101126120148497	SFD	178800	178900	20101126120148497
20101126112827727	SFD	178600	178700	20101126112839005
20101126113509682	SFD	178400	178500	20101126113509694
20101126113127285	SFD	178600	178700	20101126113127587
20101126120109696	SFD	178800	178900	20101126120115637
20101126111524209	SFD	178700	178800	20101126111524368
20101126112715716	SFD	178600	178700	20101126112715720
20101126110916727	SFD	178700	178800	20101126110916796
20101126113952065	SFD	178300	178400	20101126113952066
20101126112026744	SFD	178600	178800	20101126112026745
20101126122442148	SFD	178900	179000	20101126122442150
20101126113111126	SFD	178600	178700	20101126113113172
20101126121210135	SFD	178900	179000	20101126121217226
20101126112754269	SFD	178600	178700	20101126112754292
20101126115250348	SFD	178800	179000	20101126115250349
20101126112351901	SFD	178600	178700	20101126112351902
20101126120145621	SFD	178800	178900	20101126120145622
20101126112157029	SFD	178600	178700	20101126112157700
20101126115130213	SFD	178700	178800	20101126115130935
20101126112658794	SFD	178800	178900	20101126112658795
20101126115059130	SFD	178700	178800	20101126115059887
20101126113247304	SFD	178400	178500	20101126113247306
20101126114117253	SFD	178200	178300	20101126114117749
20101126114529085	SFD	178300	178500	20101126114529087
20101126114605694	SFD	178400	178500	20101126114605695
20101126112749976	SFD	178600	178700	20101126112750405
20101126113840899	SFD	178200	178300	20101126113840999
20101126114028401	SFD	178200	178300	20101126114035074
20101126113724033	SFD	178200	178300	20101126113724034
20101126115805160	SFD	178800	179000	20101126115805161
20101126120615758	SFD	178900	179100	20101126120615759
20101126112353030	SFD	178600	178700	20101126112353036
20101126115607018	SFD	178800	178900	20101126115610672
20101126112038134	SFD	178600	178700	20101126112038135
20101126120325468	SFD	178600	178700	20101126120325469
20101126121617822	SFD	178900	179000	20101126121617823
20101126120428472	SFD	178600	178700	20101126120428523
20101126113041314	SFD	178700	178800	20101126113041315
20101126113624139	SFD	178400	178500	20101126113624140
20101126113127588	SFD	178600	178700	20101126113131253
20101126114320369	SFD	178200	178400	20101126114320369
20101126121745939	SFD	178900	179000	20101126121745940
20101126122123328	SFD	178900	179000	20101126122123330
20101126112653023	SFD	178700	178800	20101126112653023
20101126120147814	SFD	178800	178900	20101126120148214
20101126120148726	SFD	178700	178800	20101126120148726
20101126114118847	SFD	178200	178400	20101126114118859
20101126114633984	SFD	178400	178500	20101126114633987
20101126113328726	SFD	178400	178500	20101126113328727
20101126112714820	SFD	178600	178800	20101126112714833
20101126115004148	SFD	178600	178700	20101126115004866
20101126114605675	SFD	178400	178500	20101126114605675
20101126120512803	SFD	178800	178900	20101126120512804
20101126114503588	SFD	178200	178300	20101126114503778
20101126113903036	SFD	178200	178300	20101126113912745
20101126115901473	SFD	178900	179000	20101126115942947
20101126111947256	SFD	178700	178900	20101126111947698
20101126113921031	SFD	178200	178300	20101126113928024
20101126113349293	SFD	178400	178500	20101126113349294
20101126113101147	SFD	178700	178800	20101126113101442
20101126114641991	SFD	178300	178400	20101126114641993
20101126114147751	SFD	178300	178400	20101126114147760
20101126121826389	SFD	178900	179000	20101126121827618
20101126122349100	SFD	178900	179000	20101126122352834
20101126124217839	SFD	178700	178800	20101126124217927
20101126115716373	SFD	178800	179000	20101126115719386
20101126120105604	SFD	178800	178900	20101126120105606
20101126120612036	SFD	178900	179000	20101126120612036
20101126120509751	SFD	178800	178900	20101126120510095
20101126120318028	SFD	178600	178700	20101126120318029
20101126122751918	SFD	178900	179000	20101126122752850
20101126114153417	SFD	178300	178400	20101126114154229
20101126120950655	SFD	178900	179000	20101126120957000
20101126112720482	SFD	178600	178700	20101126112720507
20101126120248556	SFD	178600	178700	20101126120248694
20101126120612036	SFD	178900	179000	20101126120612039
20101126114316906	SFD	178300	178400	20101126114317014
20101126113109676	SFD	178700	178800	20101126113109676
20101126114201328	SFD	178300	178400	20101126114201328
20101126113912745	SFD	178200	178300	20101126113913252
20101126113857767	SFD	178200	178300	20101126113857768
20101126112759198	SFD	178600	178700	20101126112759464
20101126120105576	SFD	178800	179000	20101126120105576
20101126113724034	SFD	178200	178300	20101126113724034
20101126120508811	SFD	178800	178900	20101126120509149
20101126115723653	SFD	178800	178900	20101126115726368
20101126122953015	SFD	178900	179000	20101126122953019
20101126114825029	SFD	178400	178500	20101126114825029
20101126113902745	SFD	178200	178300	20101126113903036
20101126115331973	SFD	178800	178900	20101126115333415
20101126120148288	SFD	178800	178900	20101126120148300
20101126114125384	SFD	177900	178400	20101126114125390
20101126120300625	SFD	178600	178700	20101126120300626
20101126120944175	SFD	178900	179000	20101126120944176
20101126113147994	SFD	178600	178700	20101126113147996
20101126113317989	SFD	178400	178500	20101126113317989
20101126122953015	SFD	178900	179000	20101126122953015
20101126112658176	SFD	178700	178800	20101126112658749
20101126121205466	SFD	178900	179000	20101126121210129
20101126113619949	SFD	178400	178500	20101126113620511
20101126113238033	SFD	178500	178600	20101126113238033
20101126114959143	SFD	178500	178700	20101126114959144
20101126123020873	SFD	178900	179000	20101126123027856
20101126120055962	SFD	178900	179000	20101126120056315
20101126115346109	SFD	178800	178900	20101126115346574
20101126114328044	SFD	178200	178400	20101126114328044
20101126114209133	SFD	178300	178400	20101126114209133
20101126112707718	SFD	178800	178900	20101126112709149
20101126120433893	SFD	178700	178800	20101126120434092
20101126120118044	SFD	178800	178900	20101126120118045
20101126120613105	SFD	178900	179100	20101126120613106
20101126123731782	SFD	178900	179000	20101126123742878
20101126123456204	SFD	178900	179000	20101126123502871
20101126115810622	SFD	178900	179000	20101126115810625
20101126121217226	SFD	178900	179000	20101126121222267
20101126114955183	SFD	178500	178700	20101126114955201
20101126114643667	SFD	178300	178400	20101126114643670
20101126115428103	SFD	178800	178900	20101126115433226
20101126122859587	SFD	178900	179000	20101126122859591
20101126120612044	SFD	178900	179000	20101126120612098
20101126124630204	SFD	178300	178400	20101126124634351
20101126120931836	SFD	178900	179000	20101126120931841
20101126124353588	SFD	178400	178500	20101126124354080
20101126120428626	SFD	178700	178800	20101126120428714
20101126120932255	SFD	178900	179000	20101126120937855
20101126114825234	SFD	178500	178600	20101126114825235
20101126120248269	SFD	178700	178800	20101126120248317
20101126122735764	SFD	178900	179000	20101126122735765
20101126120314152	SFD	178600	178700	20101126120314157
20101126114830520	SFD	178400	178600	20101126114831915
20101126121752112	SFD	178900	179000	20101126121759464
20101126114851256	SFD	178500	178600	20101126114851264
20101126120253152	SFD	178600	178700	20101126120253155
20101126120428523	SFD	178700	178800	20101126120428524
20101126121032415	SFD	178900	179000	20101126121032417
20101126115036129	SFD	178600	178800	20101126115036130
20101126120121203	SFD	178800	178900	20101126120122837
20101126115719386	SFD	178800	179000	20101126115719388
20101126120931757	SFD	178900	179000	20101126120931757
20101126120148732	SFD	178700	178800	20101126120148732
20101126120957000	SFD	178900	179000	20101126120957003
20101126121439976	SFD	178900	179000	20101126121440885
20101126120510196	SFD	178800	178900	20101126120510448
20101126124157767	SFD	178800	178900	20101126124157770
20101126114201328	SFD	178300	178400	20101126114201614
20101126122217831	SFD	178900	179000	20101126122225295
20101126121449137	SFD	178900	179000	20101126121449141
20101126114959149	SFD	178600	178700	20101126114959149
20101126120544780	SFD	178800	178900	20101126120544888
20101126120325077	SFD	178600	178700	20101126120325078
20101126124228176	SFD	178600	178700	20101126124228176
20101126114653908	SFD	178400	178500	20101126114653908
20101126120601013	SFD	178800	178900	20101126120601036
20101126114711418	SFD	178400	178500	20101126114713830
20101126115716038	SFD	178800	179000	20101126115716332
20101126115222770	SFD	178700	178800	20101126115222771
20101126120325078	SFD	178600	178700	20101126120325102
20101126120751537	SFD	178900	179000	20101126120753616
20101126120612344	SFD	178900	179000	20101126120612348
20101126120727860	SFD	178900	179000	20101126120729199
20101126113735727	SFD	178200	178300	20101126113736816
20101126114638073	SFD	178300	178400	20101126114638127
20101126124212733	SFD	178800	178900	20101126124213166
20101126122329075	SFD	178900	179000	20101126122329172
20101126124500281	SFD	178300	178400	20101126124500298
20101126120944185	SFD	178900	179100	20101126120944185
20101126115810904	SFD	178900	179000	20101126115810905
20101126120609701	SFD	178800	178900	20101126120609703
20101126124040935	SFD	178900	179000	20101126124040939
20101126120427644	SFD	178600	178700	20101126120427646
20101126115716028	SFD	178800	178900	20101126115716038
20101126114118834	SFD	178200	178300	20101126114118839
20101126122740389	SFD	178900	179000	20101126122742847
20101126124215935	SFD	178700	178800	20101126124215961
20101126114118839	SFD	178200	178300	20101126114118846
20101126124757290	SFD	178200	178300	20101126124757291
20101126121354563	SFD	178900	179000	20101126121357952
20101126120304130	SFD	178600	178700	20101126120307520
20101126123339412	SFD	178900	179000	20101126123339421
20101126123419656	SFD	178900	179000	20101126123427709
20101126121925400	SFD	178900	179000	20101126121933952
20101126114745722	SFD	178400	178500	20101126114748121
20101126124151078	SFD	178800	178900	20101126124151090
20101126124151067	SFD	178800	178900	20101126124151067
20101126120318037	SFD	178600	178700	20101126120318714
20101126124821295	SFD	178100	178300	20101126124821295
20101126122425829	SFD	178900	179000	20101126122425831
20101126124416309	SFD	178300	178400	20101126124417033
20101126114209316	SFD	178300	178400	20101126114211863
20101126115622873	SFD	178800	178900	20101126115622873
20101126124216566	SFD	178700	178800	20101126124217239
20101126122316123	SFD	178900	179000	20101126122316126
20101126124358443	SFD	178300	178400	20101126124358444
20101126123401039	SFD	178900	179000	20101126123401272
20101126114653913	SFD	178400	178500	20101126114653919
20101126120206103	SFD	178700	178800	20101126120208776
20101126115345051	SFD	178800	178900	20101126115345369
20101126121359909	SFD	178900	179000	20101126121401398
20101126121521375	SFD	179000	179100	20101126121521813
20101126120325469	SFD	178600	178700	20101126120331501
20101126123433014	SFD	178900	179000	20101126123433014
20101126124251932	SFD	178500	178600	20101126124252949
20101126123827878	SFD	178900	179000	20101126123834986
20101126120517857	SFD	178800	178900	20101126120517858
20101126122425815	SFD	178900	179000	20101126122425816
20101126120519241	SFD	178800	178900	20101126120519245
20101126122747435	SFD	178900	179000	20101126122747844
20101126120428714	SFD	178700	178800	20101126120428715
20101126120507895	SFD	178700	178800	20101126120508176
20101126124022715	SFD	178900	179000	20101126124022729
20101126122752850	SFD	178900	179000	20101126122755258
20101126114327275	SFD	178300	178400	20101126114327369
20101126120804117	SFD	178900	179000	20101126120804191
20101126115808817	SFD	178800	178900	20101126115808819
20101126124213629	SFD	178700	178900	20101126124213663
20101126124213680	SFD	178700	178800	20101126124213689
20101126120307520	SFD	178600	178700	20101126120307522
20101126120037839	SFD	178900	179000	20101126120042839
20101126124231792	SFD	178600	178700	20101126124231792
20101126124843839	SFD	178000	178100	20101126124843839
20101126123418205	SFD	178900	179000	20101126123418206
20101126121338085	SFD	178900	179000	20101126121346221
20101126125247292	SFD	177900	178000	20101126125247293
20101126120122838	SFD	178800	178900	20101126120125679
20101126122912852	SFD	178900	179000	20101126122933496
20101126122239335	SFD	178900	179000	20101126122239832
20101126124757289	SFD	178200	178300	20101126124757289
20101126123945991	SFD	178900	179000	20101126123945995
20101126122817134	SFD	178900	179000	20101126122818603
20101126120145620	SFD	178800	178900	20101126120145621
20101126124224459	SFD	178700	178800	20101126124224460
20101126122329178	SFD	178900	179000	20101126122329182
20101126115810625	SFD	178900	179000	20101126115810677
20101126121521016	SFD	178900	179000	20101126121521017
20101126120428524	SFD	178700	178800	20101126120428524
20101126121521022	SFD	179000	179100	20101126121521022
20101126122859591	SFD	178900	179000	20101126122859598
20101126120325166	SFD	178600	178700	20101126120325343
20101126124358441	SFD	178300	178400	20101126124358441
20101126122708461	SFD	178900	179000	20101126122708917
20101126122955155	SFD	178800	179000	20101126122955568
20101126124102891	SFD	178900	179000	20101126124102891
20101126122900006	SFD	178900	179000	20101126122901988
20101126124243973	SFD	178500	178600	20101126124243973
20101126122537841	SFD	178900	179000	20101126122539628
20101126115810517	SFD	178800	178900	20101126115810536
20101126125025934	SFD	178000	178100	20101126125026877
20101126124453877	SFD	178300	178400	20101126124455925
20101126122757982	SFD	178900	179000	20101126122758408
20101126114605703	SFD	178400	178500	20101126114605705
20101126122758408	SFD	178900	179000	20101126122758413
20101126124510088	SFD	178300	178400	20101126124510331
20101126124136939	SFD	178900	179000	20101126124141124
20101126124400707	SFD	178300	178400	20101126124400843
20101126124151074	SFD	178800	178900	20101126124151075
20101126120318032	SFD	178600	178700	20101126120318037
20101126124326033	SFD	178500	178600	20101126124328640
20101126114825039	SFD	178400	178600	20101126114825039
20101126125112260	SFD	177900	178000	20101126125112704
20101126120919031	SFD	179000	179100	20101126120919033
20101126124335633	SFD	178500	178600	20101126124335637
20101126123405924	SFD	178900	179000	20101126123414018
20101126122245280	SFD	178900	179000	20101126122245285
20101126122206093	SFD	178900	179000	20101126122206893
20101126121311130	SFD	178900	179000	20101126121319137
20101126124141928	SFD	178900	179000	20101126124141928
20101126124511844	SFD	178300	178400	20101126124513417
20101126122953457	SFD	178900	179000	20101126122954764
20101126124102925	SFD	178900	179000	20101126124102926
20101126122239315	SFD	178900	179000	20101126122239323
20101126122217828	SFD	178900	179000	20101126122217831
20101126124224460	SFD	178700	178800	20101126124227884
20101126124150979	SFD	178900	179000	20101126124150979
20101126120919027	SFD	179000	179100	20101126120919028
20101126121642349	SFD	178900	179000	20101126121643946
20101126124222203	SFD	178700	178800	20101126124222205
20101126124243978	SFD	178500	178600	20101126124243978
20101126124213694	SFD	178700	178800	20101126124213695
20101126124844520	SFD	178000	178100	20101126124847708
20101126120949263	SFD	178900	179000	20101126120950654
20101126124243355	SFD	178600	178700	20101126124243356
20101126124243973	SFD	178500	178600	20101126124243973
20101126124724158	SFD	178300	178400	20101126124724160
20101126120944261	SFD	178900	179000	20101126120944261
20101126125630023	SFD	178200	178400	20101126125630038
20101126120437834	SFD	178700	178800	20101126120444127
20101126125353378	SFD	178000	178100	20101126125353378
20101126124227884	SFD	178700	178800	20101126124227884
20101126124546998	SFD	178200	178400	20101126124546998
20101126124546726	SFD	178300	178400	20101126124546731
20101126120513953	SFD	178800	178900	20101126120514763
20101126125109784	SFD	178000	178100	20101126125110045
20101126120631361	SFD	178900	179000	20101126120631363
20101126125412429	SFD	178000	178200	20101126125412431
20101126121521865	SFD	178900	179000	20101126121521885
20101126124848903	SFD	178000	178100	20101126124849015
20101126124243293	SFD	178600	178700	20101126124243293
20101126123453204	SFD	178900	179000	20101126123454634
20101126122657842	SFD	178900	179000	20101126122657847
20101126124310626	SFD	178500	178600	20101126124310626
20101126124724160	SFD	178300	178400	20101126124724160
20101126124826304	SFD	178100	178200	20101126124839209
20101126124757495	SFD	178200	178300	20101126124757639
20101126124150719	SFD	178900	179000	20101126124150978
20101126125353017	SFD	177900	178100	20101126125353018
20101126122843991	SFD	178900	179000	20101126122844485
20101126124546958	SFD	178200	178400	20101126124546960
20101126122842870	SFD	178900	179000	20101126122843991
20101126124106890	SFD	178900	179000	20101126124119105
20101126122137609	SFD	178900	179000	20101126122137610
20101126124213695	SFD	178700	178800	20101126124213697
20101126120437139	SFD	178700	178800	20101126120437832
20101126122911709	SFD	178900	179000	20101126122911747
20101126120148734	SFD	178700	178800	20101126120148735
20101126124500218	SFD	178300	178400	20101126124500218
20101126121222267	SFD	178900	179000	20101126121222274
20101126125221977	SFD	177900	178000	20101126125223121
20101126120612193	SFD	178900	179000	20101126120612210
20101126124243634	SFD	178500	178700	20101126124243969
20101126124455925	SFD	178300	178400	20101126124500136
20101126123340575	SFD	178900	179000	20101126123340575
20101126124839225	SFD	178000	178100	20101126124839252
20101126120753809	SFD	178900	179000	20101126120753811
20101126124128857	SFD	178900	179000	20101126124136934
20101126124607646	SFD	178300	178400	20101126124607647
20101126122202983	SFD	178900	179000	20101126122206093
20101126124228039	SFD	178600	178700	20101126124228040
20101126124500219	SFD	178300	178400	20101126124500220
20101126125944721	SFD	178200	178400	20101126125944734
20101126124924421	SFD	178000	178100	20101126124924421
20101126124839210	SFD	0	178200	20101126124839210
20101126124246159	SFD	178500	178600	20101126124246161
20101126120508795	SFD	178800	178900	20101126120508796
20101126124358207	SFD	178400	178500	20101126124358207
20101126125553077	SFD	178100	178200	20101126125553077
20101126124400843	SFD	178300	178400	20101126124402052
20101126124551458	SFD	178200	178400	20101126124551459
20101126124150980	SFD	178900	179000	20101126124150982
20101126121744883	SFD	178900	179000	20101126121744885
20101126125315141	SFD	177900	178000	20101126125316478
20101126125640676	SFD	178200	178300	20101126125640705
20101126124821224	SFD	178200	178300	20101126124821224
20101126120612210	SFD	178900	179000	20101126120612245
20101126125638224	SFD	178200	178400	20101126125638294
20101126124500490	SFD	178300	178400	20101126124500684
20101126124352368	SFD	178400	178500	20101126124352368
20101126125516066	SFD	178100	178200	20101126125523500
20101126124141928	SFD	178900	179000	20101126124141928
20101126125014305	SFD	178000	178100	20101126125015455
20101126124148117	SFD	178900	179000	20101126124148191
20101126122813152	SFD	178900	179000	20101126122817134
20101126124213311	SFD	178800	178900	20101126124213340
20101126125749257	SFD	178300	178500	20101126125750328
20101126124500228	SFD	178300	178400	20101126124500229
20101126124749332	SFD	178300	178400	20101126124749375
20101126120919025	SFD	178900	179100	20101126120919026
20101126122127827	SFD	178900	179000	20101126122129435
20101126122202230	SFD	178900	179000	20101126122202983
20101126124358009	SFD	178400	178500	20101126124358012
20101126101155337	SSO	431500	431600	20101126101155337
20101126125234996	SFD	177900	178000	20101126125235164
20101126124228175	SFD	178600	178700	20101126124228176
20101126122407799	SFD	178900	179000	20101126122421082
20101126124924421	SFD	178000	178100	20101126124924422
20101126124821302	SFD	178100	178300	20101126124821302
20101126124227900	SFD	178700	178800	20101126124227901
20101126125001888	SFD	178000	178100	20101126125003452
20101126125850371	SFD	178300	178400	20101126125850372
20101126124358439	SFD	178300	178400	20101126124358439
20101126124905380	SFD	178000	178100	20101126124905431
20101126124929362	SFD	178000	178100	20101126124929646
20101126124823076	SFD	178100	178200	20101126124823792
20101126125636488	SFD	178200	178400	20101126125636497
20101126124150988	SFD	178800	179000	20101126124150988
20101126125159235	SFD	177900	178000	20101126125159235
20101126125257777	SFD	177900	178000	20101126125257778
20101126125337179	SFD	177900	178000	20101126125345117
20101126125058532	SFD	178000	178100	20101126125104356
20101126125211179	SFD	177900	178000	20101126125214228
20101126125408112	SFD	178000	178100	20101126125408203
20101126124821223	SFD	178200	178300	20101126124821223
20101126124228054	SFD	178600	178700	20101126124228055
20101126124358441	SFD	178300	178400	20101126124358442
20101126125414125	SFD	178100	178200	20101126125417086
20101126124228045	SFD	178600	178700	20101126124228045
20101126124320721	SFD	178500	178600	20101126124320721
20101126125951281	SFD	178400	178500	20101126125952106
20101126101156288	SSO	431500	431700	20101126101156290
20101126125950688	SFD	178400	178500	20101126125950690
20101126124257200	SFD	178500	178600	20101126124257202
20101126125412406	SFD	178000	178200	20101126125412406
20101126125353016	SFD	177900	178000	20101126125353016
20101126125159235	SFD	177900	178000	20101126125159708
20101126125944035	SFD	178300	178400	20101126125944172
20101126125610671	SFD	178100	178300	20101126125610672
20101126124607633	SFD	178300	178400	20101126124607634
20101126124222895	SFD	178700	178800	20101126124223153
20101126125110874	SFD	177900	178000	20101126125110874
20101126122123330	SFD	178900	179000	20101126122124654
20101126125111203	SFD	177900	178000	20101126125111211
20101126124358208	SFD	178400	178500	20101126124358209
20101126125316478	SFD	177900	178000	20101126125317289
20101126101156327	SSO	431600	431700	20101126101156337
20101126124352366	SFD	178400	178500	20101126124352366
20101126122903138	SFD	178900	179000	20101126122903139
20101126125542326	SFD	178100	178200	20101126125542966
20101126124231790	SFD	178600	178700	20101126124231792
20101126125502877	SFD	178100	178300	20101126125502958
20101126124546998	SFD	178200	178400	20101126124547097
20101126124839213	SFD	178000	178100	20101126124839213
20101126125020324	SFD	178000	178100	20101126125025454
20101126101159346	SSO	431600	431700	20101126101159352
20101126125412422	SFD	178000	178200	20101126125412422
20101126125915042	SFD	178300	178400	20101126125915043
20101126124551462	SFD	178200	178300	20101126124551463
20101126125930635	SFD	178300	178400	20101126125930716
20101126125113260	SFD	177900	178000	20101126125114158
20101126124757286	SFD	178200	178300	20101126124757286
20101126125305868	SFD	177900	178000	20101126125306203
20101126130146126	SFD	177500	182000	20101126130146130
20101126125554455	SFD	178100	178200	20101126125554520
20101126124905352	SFD	178000	178100	20101126124905366
20101126124151072	SFD	178800	178900	20101126124151073
20101126125803326	SFD	178300	178400	20101126125803326
20101126124607634	SFD	178300	178400	20101126124607634
20101126125610672	SFD	178200	178300	20101126125610672
20101126101156337	SSO	431600	431700	20101126101156338
20101126125639975	SFD	178200	178400	20101126125639995
20101126125640709	SFD	178300	178400	20101126125640709
20101126125504630	SFD	178100	178200	20101126125504632
20101126133210906	SFD	177000	182000	20101126133212917
20101126124608241	SFD	178300	178400	20101126124612681
20101126130900339	SFD	161900	178700	20101126130900736
20101126125826038	SFD	178300	178400	20101126125826042
20101126125950686	SFD	178300	178500	20101126125950688
20101126124501203	SFD	178300	178400	20101126124501205
20101126101156018	SSO	431500	431600	20101126101156238
20101126101157631	SSO	431600	431700	20101126101157631
20101126125650369	SFD	178300	178400	20101126125652042
20101126124708890	SFD	178300	178400	20101126124709935
20101126124243978	SFD	178500	178600	20101126124243979
20101126125422805	SFD	178100	178200	20101126125422806
20101126124243974	SFD	178500	178600	20101126124243974
20101126124839209	SFD	178100	178200	20101126124839210
20101126101238096	SSO	431300	431400	20101126101238096
20101126125945616	SFD	178300	178400	20101126125945616
20101126125854030	SFD	178300	178400	20101126125855060
20101126125229644	SFD	177900	178000	20101126125230360
20101126130732018	SFD	177300	178700	20101126130900339
20101126125030342	SFD	178000	178100	20101126125038904
20101126124102933	SFD	178900	179000	20101126124102935
20101126125750368	SFD	178300	178400	20101126125750372
20101126101205237	SSO	431600	431700	20101126101205237
20101126124607633	SFD	178300	178400	20101126124607633
20101126125914891	SFD	178300	178400	20101126125915042
20101126101157638	SSO	431600	431700	20101126101157638
20101126125159233	SFD	177900	178000	20101126125159235
20101126124920321	SFD	178000	178100	20101126124920735
20101126125230360	SFD	177900	178000	20101126125230360
20101126130903663	SFD	177200	182000	20101126130914680
20101126101157630	SSO	431600	431700	20101126101157631
20101126125959032	SFD	178200	178400	20101126125959081
20101126125614928	SFD	178200	178300	20101126125614929
20101126125104356	SFD	178000	178100	20101126125106202
20101126125358442	SFD	178000	178100	20101126125358442
20101126143803521	SFD	157500	178500	20101126143806194
20101126101204897	SSO	431600	431700	20101126101204899
20101126101202178	SSO	431600	431700	20101126101202185
20101126101153681	SSO	431500	431600	20101126101153682
20101126101201346	SSO	431600	431700	20101126101201346
20101126125353378	SFD	178000	178100	20101126125353379
20101126130136779	SFD	170100	182000	20101126130146126
20101126101156956	SSO	431600	431700	20101126101156994
20101126125412431	SFD	178000	178200	20101126125412432
20101126125947098	SFD	178400	178500	20101126125947125
20101126124243969	SFD	178500	178600	20101126124243969
20101126101156952	SSO	431600	431700	20101126101156955
20101126125948605	SFD	178200	178500	20101126125948606
20101126125248814	SFD	177900	178000	20101126125248856
20101126101156290	SSO	431500	431700	20101126101156291
20101126125947908	SFD	178300	178500	20101126125947908
20101126125412455	SFD	178100	178200	20101126125412456
20101126125242222	SFD	177900	178000	20101126125242223
20101126124821501	SFD	178100	178200	20101126124821544
20101126101203614	SSO	431600	431700	20101126101203614
20101126101220084	SSO	431400	431500	20101126101220308
20101126125230653	SFD	177900	178000	20101126125231738
20101126124531911	SFD	178300	178400	20101126124532536
20101126101156283	SSO	431500	431700	20101126101156284
20101126101212748	SSO	431400	431500	20101126101212748
20101126124521108	SFD	178300	178400	20101126124524822
20101126101159515	SSO	431600	431700	20101126101159517
20101126125505619	SFD	178100	178200	20101126125512719
20101126125934631	SFD	178300	178500	20101126125935633
20101126101220696	SSO	431400	431500	20101126101220696
20101126101311179	SSO	431000	431100	20101126101311180
20101126125110883	SFD	177900	178000	20101126125110883
20101126125232678	SFD	177900	178000	20101126125234987
20101126101259584	SSO	431100	431200	20101126101259584
20101126101236882	SSO	431300	431400	20101126101236901
20101126101224493	SSO	431400	431500	20101126101224624
20101126124606934	SFD	178200	178300	20101126124606935
20101126101206609	SSO	431600	431700	20101126101206611
20101126101237069	SSO	431400	431500	20101126101237381
20101126124553313	SFD	178200	178300	20101126124554638
20101126101209316	SSO	431500	431700	20101126101209316
20101126101210918	SSO	431400	431500	20101126101210918
20101126101205337	SSO	431600	431700	20101126101205338
20101126101156291	SSO	431500	431700	20101126101156293
20101126130425618	SFD	177400	182000	20101126130427712
20101126125232562	SFD	177900	178000	20101126125232678
20101126101200758	SSO	431600	431700	20101126101200758
20101126101209452	SSO	431500	431600	20101126101209452
20101126125351008	SFD	177900	178000	20101126125351158
20101126101209452	SSO	431500	431600	20101126101209452
20101126124608145	SFD	178300	178400	20101126124608146
20101126101210133	SSO	431400	431500	20101126101210134
20101126101206586	SSO	431600	431700	20101126101206588
20101126125652044	SFD	178300	178400	20101126125652062
20101126101208323	SSO	431600	431700	20101126101208403
20101126125838671	SFD	178300	178400	20101126125838673
20101126101157077	SSO	431600	431700	20101126101157077
20101126101206673	SSO	431600	431700	20101126101206688
20101126101209318	SSO	431500	431600	20101126101209318
20101126101236967	SSO	431300	431400	20101126101236971
20101126101237009	SSO	431400	431500	20101126101237009
20101126124757285	SFD	178200	178300	20101126124757285
20101126101236798	SSO	431300	431500	20101126101236798
20101126101201440	SSO	431600	431700	20101126101201441
20101126101233192	SSO	431400	431500	20101126101233210
20101126101252070	SSO	431200	431300	20101126101252070
20101126125944790	SFD	178200	178400	20101126125944790
20101126101204550	SSO	431600	431700	20101126101204550
20101126101232625	SSO	431400	431500	20101126101232625
20101126101252107	SSO	431100	431200	20101126101252107
20101126125623633	SFD	178200	178400	20101126125624224
20101126125947191	SFD	178400	178500	20101126125947239
20101126101211033	SSO	431400	431500	20101126101211287
20101126101236779	SSO	431400	431500	20101126101236786
20101126101334151	SSO	431000	431100	20101126101334152
20101126101205509	SSO	431600	431700	20101126101205570
20101126101239466	SSO	431300	431400	20101126101239508
20101126101159247	SSO	431600	431700	20101126101159251
20101126101336262	SSO	431100	431200	20101126101336264
20101126124920277	SFD	178000	178100	20101126124920278
20101126101156290	SSO	431500	431700	20101126101156290
20101126101236803	SSO	431300	431400	20101126101236804
20101126101159515	SSO	431600	431700	20101126101159515
20101126101210918	SSO	431400	431500	20101126101210947
20101126101209318	SSO	431500	431600	20101126101209318
20101126101215020	SSO	431400	431500	20101126101215021
20101126101159619	SSO	431600	431800	20101126101159620
20101126101212588	SSO	431400	431500	20101126101212588
20101126142617885	SFD	161700	178600	20101126142620865
20101126125948138	SFD	178300	178500	20101126125948581
20101126101215021	SSO	431400	431500	20101126101215021
20101126125641476	SFD	178300	178400	20101126125644596
20101126101212220	SSO	431400	431500	20101126101212338
20101126101239264	SSO	431300	431400	20101126101239265
20101126131506832	SFD	176900	178600	20101126132324323
20101126101205197	SSO	431600	431700	20101126101205197
20101126125610759	SFD	178200	178300	20101126125610760
20101126101153430	SSO	431500	431600	20101126101153433
20101126101157631	SSO	431600	431700	20101126101157631
20101126101208763	SSO	431600	431700	20101126101208822
20101126101307684	SSO	431000	431100	20101126101307734
20101126101204971	SSO	431600	431700	20101126101204971
20101126101243120	SSO	431300	431400	20101126101243138
20101126143130357	SFD	157500	182000	20101126143134051
20101126101205096	SSO	431600	431700	20101126101205098
20101126101241632	SSO	431300	431400	20101126101241643
20101126101241145	SSO	431400	431500	20101126101241148
20101126101310303	SSO	431000	431100	20101126101310442
20101126101205014	SSO	431600	431700	20101126101205014
20101126101212749	SSO	431400	431500	20101126101212749
20101126101159619	SSO	431600	431800	20101126101159619
20101126101240738	SSO	431400	431500	20101126101240738
20101126101153160	SSO	431500	431600	20101126101153177
20101126125945631	SFD	178400	178500	20101126125945633
20101126101205654	SSO	431600	431700	20101126101205660
20101126125827565	SFD	178300	178400	20101126125831395
20101126101222424	SSO	431400	431500	20101126101222424
20101126101252109	SSO	431100	431200	20101126101252109
20101126131505228	SFD	176900	182000	20101126131506832
20101126101240333	SSO	431300	431400	20101126101240334
20101126131157414	SFD	161700	178600	20101126131157750
20101126125941069	SFD	178300	178400	20101126125942292
20101126125944172	SFD	178300	178400	20101126125944194
20101126101356691	SSO	431100	431200	20101126101356706
20101126101244393	SSO	431300	431400	20101126101244397
20101126101154787	SSO	431500	431600	20101126101154787
20101126125305371	SFD	177900	178000	20101126125305371
20101126101239278	SSO	431300	431400	20101126101239278
20101126101208178	SSO	431600	431700	20101126101208281
20101126101204630	SSO	431600	431700	20101126101204896
20101126101155897	SSO	431500	431600	20101126101155897
20101126101156291	SSO	431500	431700	20101126101156291
20101126135349067	SFD	161700	182000	20101126135350982
20101126101213247	SSO	431400	431500	20101126101213325
20101126101206443	SSO	431600	431700	20101126101206443
20101126101236959	SSO	431300	431400	20101126101236960
20101126101217633	SSO	431400	431500	20101126101217694
20101126101209321	SSO	431500	431600	20101126101209321
20101126130124586	SFD	177300	9999999900	20101126130124619
20101126101209454	SSO	431500	431600	20101126101209454
20101126101223424	SSO	431400	431500	20101126101223425
20101126101239276	SSO	431300	431400	20101126101239277
20101126101243141	SSO	431300	431400	20101126101243192
20101126101224077	SSO	431400	431500	20101126101224141
20101126101159555	SSO	431600	431700	20101126101159557
20101126101243117	SSO	431300	431400	20101126101243120
20101126101156738	SSO	431600	431700	20101126101156739
20101126101210470	SSO	431400	431500	20101126101210492
20101126101210764	SSO	431400	431500	20101126101210918
20101126101238845	SSO	431400	431500	20101126101238846
20101126101356435	SSO	431100	431200	20101126101356435
20101126101236845	SSO	431300	431400	20101126101236869
20101126101257213	SSO	431000	431200	20101126101257441
20101126101240361	SSO	431300	431400	20101126101240361
20101126101157079	SSO	431600	431700	20101126101157082
20101126101336265	SSO	431000	431200	20101126101336265
20101126101202953	SSO	431600	431700	20101126101202959
20101126101233667	SSO	431400	431500	20101126101234026
20101126101250266	SSO	431200	431300	20101126101250758
20101126101224047	SSO	431400	431500	20101126101224077
20101126101208722	SSO	431600	431700	20101126101208756
20101126101253201	SSO	431100	431200	20101126101253201
20101126101156298	SSO	431600	431700	20101126101156298
20101126101242409	SSO	431300	431400	20101126101242410
20101126101229539	SSO	431400	431500	20101126101229539
20101126101239258	SSO	431300	431400	20101126101239258
20101126101239285	SSO	431300	431400	20101126101239285
20101126101215020	SSO	431400	431500	20101126101215020
20101126101239257	SSO	431300	431400	20101126101239258
20101126101213207	SSO	431400	431500	20101126101213208
20101126101208300	SSO	431600	431700	20101126101208301
20101126101302045	SSO	431000	431100	20101126101302045
20101126125610672	SFD	178200	178300	20101126125610672
20101126101249340	SSO	431200	431300	20101126101249499
20101126125924246	SFD	178300	178400	20101126125924247
20101126101156669	SSO	431600	431700	20101126101156669
20101126101315311	SSO	431000	431100	20101126101315922
20101126101358265	SSO	431100	431200	20101126101358265
20101126101302046	SSO	431000	431100	20101126101302046
20101126101347491	SSO	431000	431100	20101126101347521
20101126101239267	SSO	431300	431400	20101126101239267
20101126101307462	SSO	431000	431100	20101126101307463
20101126101236774	SSO	431400	431500	20101126101236774
20101126101314469	SSO	431000	431100	20101126101314469
20101126101226206	SSO	431400	431500	20101126101226645
20101126125812234	SFD	178300	178400	20101126125812628
20101126101209453	SSO	431500	431600	20101126101209454
20101126101320286	SSO	431100	431200	20101126101320291
20101126101209489	SSO	431500	431600	20101126101209490
20101126101331949	SSO	431100	431200	20101126101333116
20101126101244379	SSO	431300	431400	20101126101244393
20101126101304394	SSO	431000	431100	20101126101304465
20101126101205570	SSO	431600	431700	20101126101205573
20101126101302047	SSO	431000	431100	20101126101302047
20101126101328344	SSO	431000	431200	20101126101328344
20101126101213213	SSO	431400	431500	20101126101213225
20101126101229576	SSO	431400	431500	20101126101229624
20101126101215022	SSO	431400	431500	20101126101215026
20101126101357700	SSO	431100	431200	20101126101357915
20101126101153177	SSO	431500	431600	20101126101153177
20101126101243084	SSO	431300	431400	20101126101243084
20101126101239290	SSO	431300	431400	20101126101239290
20101126101236798	SSO	431400	431500	20101126101236798
20101126101313766	SSO	431000	431100	20101126101313766
20101126101354297	SSO	431000	431100	20101126101354299
20101126101229627	SSO	431400	431500	20101126101230622
20101126101220066	SSO	431400	431500	20101126101220077
20101126101311871	SSO	431000	431100	20101126101311873
20101126101248526	SSO	431200	431300	20101126101248528
20101126101239258	SSO	431300	431400	20101126101239258
20101126101320339	SSO	431100	431200	20101126101320366
20101126101240238	SSO	431300	431400	20101126101240238
20101126101156306	SSO	431600	431700	20101126101156306
20101126101236568	SSO	431400	431500	20101126101236697
20101126101313767	SSO	431000	431100	20101126101313816
20101126101239260	SSO	431300	431400	20101126101239264
20101126101243086	SSO	431300	431400	20101126101243087
20101126101241292	SSO	431300	431400	20101126101241292
20101126101302046	SSO	431000	431100	20101126101302046
20101126101336386	SSO	431000	431100	20101126101336387
20101126101201095	SSO	431600	431700	20101126101201103
20101126101248017	SSO	431200	431300	20101126101248271
20101126101234356	SSO	431400	431500	20101126101234436
20101126101347782	SSO	431000	431100	20101126101347783
20101126101406405	SSO	431200	431300	20101126101406406
20101126101239425	SSO	431300	431400	20101126101239465
20101126101209828	SSO	431400	431500	20101126101209828
20101126101236811	SSO	431300	431400	20101126101236833
20101126125941034	SFD	178300	178400	20101126125941062
20101126101238845	SSO	431400	431500	20101126101238845
20101126101239243	SSO	431300	431500	20101126101239243
20101126101252072	SSO	431200	431300	20101126101252073
20101126101238846	SSO	431400	431500	20101126101238847
20101126101307906	SSO	431000	431100	20101126101308115
20101126101238846	SSO	431400	431500	20101126101238846
20101126101356526	SSO	431100	431200	20101126101356527
20101126101406407	SSO	431200	431300	20101126101406407
20101126101342917	SSO	431000	431100	20101126101342988
20101126101248012	SSO	431200	431400	20101126101248012
20101126101315188	SSO	431000	431100	20101126101315311
20101126101319428	SSO	431000	431100	20101126101319562
20101126101328345	SSO	431000	431100	20101126101328345
20101126101239745	SSO	431300	431400	20101126101239745
20101126101321824	SSO	431100	431200	20101126101321825
20101126101336573	SSO	431000	431100	20101126101336574
20101126101209412	SSO	431500	431600	20101126101209412
20101126101329224	SSO	431000	431100	20101126101329224
20101126101311660	SSO	431000	431100	20101126101311660
20101126101333639	SSO	431100	431200	20101126101333689
20101126101356573	SSO	431100	431200	20101126101356573
20101126101339142	SSO	431000	431100	20101126101339142
20101126101419941	SSO	431200	431300	20101126101419942
20101126101241291	SSO	431300	431500	20101126101241291
20101126101336259	SSO	431000	431200	20101126101336259
20101126101252108	SSO	431100	431200	20101126101252108
20101126101329658	SSO	431000	431100	20101126101329659
20101126101203021	SSO	431600	431700	20101126101203021
20101126101348644	SSO	431000	431100	20101126101348644
20101126101232925	SSO	431400	431500	20101126101233023
20101126101356488	SSO	431100	431200	20101126101356488
20101126101409475	SSO	431200	431300	20101126101409504
20101126101257204	SSO	431000	431200	20101126101257213
20101126101354847	SSO	431000	431100	20101126101355027
20101126101242304	SSO	431300	431400	20101126101242305
20101126101328348	SSO	431000	431100	20101126101328349
20101126101420427	SSO	431200	431300	20101126101420435
20101126101333846	SSO	431000	431100	20101126101333846
20101126101323747	SSO	431100	431200	20101126101323747
20101126101209495	SSO	431400	431500	20101126101209495
20101126101435141	SSO	431200	431300	20101126101435228
20101126101311762	SSO	431000	431100	20101126101311792
20101126101257524	SSO	431000	431200	20101126101257524
20101126101351084	SSO	431000	431100	20101126101351401
20101126101356573	SSO	431100	431200	20101126101356573
20101126101329212	SSO	431000	431100	20101126101329224
20101126101248017	SSO	431200	431300	20101126101248017
20101126101240338	SSO	431300	431400	20101126101240342
20101126101406954	SSO	431200	431300	20101126101406954
20101126101252395	SSO	431100	431200	20101126101252395
20101126101420001	SSO	431200	431300	20101126101420013
20101126101401057	SSO	431200	431300	20101126101401078
20101126101302356	SSO	431000	431100	20101126101302410
20101126101419938	SSO	431200	431300	20101126101419938
20101126101333847	SSO	431000	431100	20101126101333847
20101126101240350	SSO	431300	431400	20101126101240361
20101126101406491	SSO	431200	431300	20101126101406492
20101126101334677	SSO	431000	431100	20101126101334694
20101126101315078	SSO	431000	431100	20101126101315106
20101126101328555	SSO	431000	431100	20101126101328555
20101126101319643	SSO	431000	431100	20101126101319754
20101126101239265	SSO	431300	431400	20101126101239266
20101126101333845	SSO	431000	431200	20101126101333845
20101126101240408	SSO	431400	431500	20101126101240470
20101126101433097	SSO	431300	431400	20101126101433097
20101126101340160	SSO	431000	431100	20101126101340162
20101126101402256	SSO	431200	431300	20101126101402427
20101126101304345	SSO	431000	431100	20101126101304346
20101126101452123	SSO	431400	431500	20101126101452164
20101126101329786	SSO	431000	431100	20101126101329788
20101126101336574	SSO	431000	431100	20101126101336601
20101126101342989	SSO	431000	431100	20101126101342991
20101126101311738	SSO	431000	431100	20101126101311762
20101126101311197	SSO	431000	431100	20101126101311261
20101126101243264	SSO	431300	431400	20101126101243264
20101126101259579	SSO	431100	431200	20101126101259580
20101126101252121	SSO	431100	431200	20101126101252121
20101126101240342	SSO	431300	431500	20101126101240349
20101126101407258	SSO	431200	431300	20101126101407636
20101126101252126	SSO	431100	431200	20101126101252127
20101126101333903	SSO	431000	431100	20101126101333903
20101126101338866	SSO	431000	431100	20101126101338869
20101126101240316	SSO	431300	431400	20101126101240316
20101126101340419	SSO	431000	431100	20101126101340419
20101126101328347	SSO	431000	431100	20101126101328347
20101126101357692	SSO	431100	431200	20101126101357694
20101126101454916	SSO	431400	431700	20101126101454976
20101126101311735	SSO	431000	431100	20101126101311735
20101126101453554	SSO	431400	431500	20101126101453555
20101126101304240	SSO	431000	431100	20101126101304240
20101126101348644	SSO	431000	431100	20101126101348668
20101126101248012	SSO	431200	431300	20101126101248013
20101126101425330	SSO	431200	431300	20101126101425332
20101126101426054	SSO	431200	431300	20101126101426055
20101126101432797	SSO	431300	431400	20101126101432797
20101126101356662	SSO	431100	431200	20101126101356663
20101126101336291	SSO	431100	431200	20101126101336291
20101126101346801	SSO	431000	431100	20101126101346801
20101126101252101	SSO	431100	431300	20101126101252102
20101126101359816	SSO	431200	431300	20101126101359974
20101126101406402	SSO	431200	431300	20101126101406402
20101126101412270	SSO	431200	431300	20101126101412270
20101126101243087	SSO	431300	431400	20101126101243110
20101126101331832	SSO	0	0	20101126101331832
20101126101341162	SSO	431000	431100	20101126101341259
20101126101359457	SSO	431100	431200	20101126101359458
20101126101336301	SSO	431100	431200	20101126101336308
20101126101356554	SSO	431100	431200	20101126101356559
20101126101420186	SSO	431200	431300	20101126101420288
20101126101325262	SSO	431100	431200	20101126101325262
20101126101407772	SSO	431200	431300	20101126101407772
20101126101438019	SSO	431200	431300	20101126101438023
20101126101445419	SSO	431400	431500	20101126101445430
20101126101330127	SSO	431000	431100	20101126101330128
20101126101348644	SSO	431000	431100	20101126101348644
20101126101313816	SSO	431000	431100	20101126101313816
20101126101418192	SSO	431200	431300	20101126101418194
20101126101344141	SSO	431000	431100	20101126101344173
20101126101252070	SSO	431200	431300	20101126101252071
20101126101316183	SSO	431000	431100	20101126101316240
20101126101448370	SSO	431500	431600	20101126101448372
20101126101249044	SSO	431200	431300	20101126101249044
20101126101401590	SSO	431200	431300	20101126101402023
20101126101314464	SSO	431000	431100	20101126101314467
20101126101434725	SSO	431200	431300	20101126101434725
20101126101302046	SSO	431000	431100	20101126101302046
20101126101422658	SSO	431200	431300	20101126101422658
20101126101432782	SSO	431300	431400	20101126101432784
20101126101356466	SSO	431100	431200	20101126101356467
20101126101415967	SSO	431200	431300	20101126101415967
20101126101427065	SSO	431200	431300	20101126101427535
20101126101333846	SSO	431000	431100	20101126101333846
20101126101416508	SSO	431100	431200	20101126101416508
20101126101416467	SSO	431100	431200	20101126101416476
20101126101407776	SSO	431200	431300	20101126101407786
20101126101409046	SSO	431200	431300	20101126101409047
20101126101318822	SSO	431000	431100	20101126101318822
20101126101307461	SSO	431000	431100	20101126101307461
20101126101429189	SSO	431200	431300	20101126101429206
20101126101452321	SSO	431400	431500	20101126101452323
20101126101409067	SSO	431200	431300	20101126101409130
20101126101336272	SSO	431100	431200	20101126101336279
20101126101329705	SSO	431000	431100	20101126101329716
20101126101333689	SSO	431100	431200	20101126101333845
20101126101406493	SSO	431200	431300	20101126101406494
20101126101325264	SSO	431100	431200	20101126101325266
20101126101510414	SSO	431300	431400	20101126101510415
20101126101420408	SSO	431200	431300	20101126101420408
20101126101406406	SSO	431200	431300	20101126101406406
20101126101335087	SSO	431000	431100	20101126101335087
20101126101448469	SSO	431500	431600	20101126101448476
20101126101449510	SSO	431500	431600	20101126101449556
20101126101404135	SSO	431200	431300	20101126101404893
20101126101428708	SSO	431200	431300	20101126101428708
20101126101406406	SSO	431200	431300	20101126101406406
20101126101319793	SSO	431000	431100	20101126101319852
20101126101416988	SSO	431100	431200	20101126101417011
20101126101439826	SSO	431200	431300	20101126101439826
20101126101409472	SSO	431200	431300	20101126101409475
20101126101343047	SSO	431000	431100	20101126101343057
20101126101400884	SSO	431200	431300	20101126101400885
20101126101359459	SSO	431100	431200	20101126101359474
20101126101453233	SSO	431400	431500	20101126101453233
20101126101433144	SSO	431300	431400	20101126101433163
20101126101452065	SSO	431400	431600	20101126101452065
20101126101431397	SSO	431200	431300	20101126101431401
20101126101338221	SSO	431000	431100	20101126101338226
20101126101410272	SSO	431200	431300	20101126101410273
20101126101406958	SSO	431200	431300	20101126101406959
20101126101420410	SSO	431200	431300	20101126101420411
20101126101409504	SSO	431200	431300	20101126101409530
20101126101444488	SSO	431300	431400	20101126101444488
20101126101413400	SSO	431200	431300	20101126101413405
20101126101407670	SSO	431200	431300	20101126101407670
20101126101458550	SSO	431500	431700	20101126101458553
20101126101500915	SSO	431500	431600	20101126101500915
20101126101358183	SSO	431100	431200	20101126101358194
20101126101336664	SSO	431000	431100	20101126101336669
20101126101430725	SSO	431200	431300	20101126101430739
20101126101333846	SSO	431000	431100	20101126101333846
20101126101444778	SSO	431300	431400	20101126101444779
20101126101359585	SSO	431200	431300	20101126101359585
20101126101500878	SSO	431500	431600	20101126101500878
20101126101441330	SSO	431200	431300	20101126101441330
20101126101451257	SSO	431500	431600	20101126101451308
20101126101447018	SSO	431400	431500	20101126101447018
20101126101502274	SSO	431400	431500	20101126101502301
20101126101444518	SSO	431300	431400	20101126101444522
20101126101451372	SSO	431500	431600	20101126101451374
20101126101501980	SSO	431400	431500	20101126101502161
20101126101412548	SSO	431200	431300	20101126101412548
20101126101448086	SSO	431400	431500	20101126101448287
20101126101417465	SSO	431200	431300	20101126101417487
20101126101405510	SSO	431200	431300	20101126101405593
20101126101434723	SSO	431200	431400	20101126101434723
20101126101432772	SSO	431300	431400	20101126101432772
20101126101422620	SSO	431200	431300	20101126101422621
20101126101336292	SSO	431100	431200	20101126101336293
20101126101506420	SSO	431300	431400	20101126101506421
20101126101407646	SSO	431200	431300	20101126101407670
20101126101441349	SSO	431200	431300	20101126101441360
20101126101458633	SSO	431600	431700	20101126101458635
20101126101457749	SSO	431500	431600	20101126101457750
20101126101453435	SSO	431400	431500	20101126101453435
20101126101424364	SSO	431200	431300	20101126101424530
20101126101336644	SSO	431000	431100	20101126101336645
20101126101441730	SSO	431200	431300	20101126101442116
20101126101459250	SSO	431600	431700	20101126101459308
20101126101416460	SSO	431100	431300	20101126101416461
20101126101401156	SSO	431200	431300	20101126101401157
20101126101415407	SSO	431200	431300	20101126101415457
20101126101444781	SSO	431300	431400	20101126101444781
20101126101508821	SSO	431300	431400	20101126101508824
20101126101436437	SSO	431200	431300	20101126101436437
20101126101416462	SSO	431100	431200	20101126101416462
20101126101420030	SSO	431200	431300	20101126101420030
20101126101359147	SSO	431100	431200	20101126101359149
20101126101444944	SSO	431300	431400	20101126101444952
20101126101501244	SSO	431400	431500	20101126101501257
20101126101412272	SSO	431200	431300	20101126101412272
20101126101417389	SSO	431100	431300	20101126101417389
20101126101304365	SSO	431000	431100	20101126101304365
20101126101356530	SSO	431100	431200	20101126101356532
20101126101412286	SSO	431200	431300	20101126101412286
20101126101400984	SSO	431200	431300	20101126101401010
20101126101315077	SSO	431000	431100	20101126101315078
20101126101420409	SSO	431200	431300	20101126101420409
20101126101340421	SSO	431000	431100	20101126101340421
20101126101500975	SSO	431400	431500	20101126101500975
20101126101445066	SSO	431300	431400	20101126101445066
20101126101511739	SSO	431300	431500	20101126101511748
20101126101412268	SSO	431200	431300	20101126101412268
20101126101412548	SSO	431200	431300	20101126101412548
20101126101416461	SSO	431100	431200	20101126101416461
20101126101500916	SSO	431500	431600	20101126101500916
20101126101415087	SSO	431200	431300	20101126101415104
20101126101430101	SSO	431200	431300	20101126101430177
20101126101424530	SSO	431200	431300	20101126101424592
20101126101434259	SSO	431300	431400	20101126101434259
20101126101340162	SSO	431000	431100	20101126101340163
20101126101453233	SSO	431400	431500	20101126101453233
20101126101426693	SSO	431200	431300	20101126101426694
20101126101458835	SSO	431600	431700	20101126101458838
20101126101452208	SSO	431400	431500	20101126101452208
20101126101419939	SSO	431200	431300	20101126101419940
20101126101506395	SSO	431300	431400	20101126101506398
20101126101514064	SSO	431400	431500	20101126101514065
20101126101356640	SSO	431100	431200	20101126101356640
20101126101428830	SSO	431200	431300	20101126101428915
20101126101415463	SSO	431200	431300	20101126101415625
20101126101433197	SSO	431300	431400	20101126101433200
20101126101420288	SSO	431200	431300	20101126101420289
20101126101431402	SSO	431200	431300	20101126101431402
20101126101407911	SSO	431200	431300	20101126101407915
20101126101433352	SSO	431300	431400	20101126101433361
20101126101415382	SSO	431200	431300	20101126101415385
20101126101500985	SSO	431400	431500	20101126101500986
20101126101445173	SSO	431400	431500	20101126101445175
20101126101406406	SSO	431200	431300	20101126101406406
20101126101348558	SSO	431000	431100	20101126101348621
20101126101452410	SSO	431400	431500	20101126101452641
20101126101406482	SSO	431200	431300	20101126101406482
20101126101510701	SSO	431300	431400	20101126101510703
20101126101457659	SSO	431500	431600	20101126101457668
20101126101508271	SSO	431300	431400	20101126101508729
20101126101452060	SSO	431500	431600	20101126101452063
20101126101452083	SSO	431400	431500	20101126101452083
20101126101404084	SSO	431200	431300	20101126101404130
20101126101502238	SSO	431400	431500	20101126101502239
20101126101412549	SSO	431200	431300	20101126101412549
20101126101448758	SSO	431500	431600	20101126101449070
20101126101328692	SSO	431000	431100	20101126101328729
20101126101430177	SSO	431200	431300	20101126101430361
20101126101536186	SSO	431400	431500	20101126101536190
20101126101426055	SSO	431200	431300	20101126101426055
20101126101500915	SSO	431500	431600	20101126101500915
20101126101554091	SSO	431200	431300	20101126101554091
20101126101406184	SSO	431200	431300	20101126101406264
20101126101500975	SSO	431400	431500	20101126101500976
20101126101421129	SSO	431200	431300	20101126101421131
20101126101452203	SSO	431400	431500	20101126101452203
20101126101432782	SSO	431300	431400	20101126101432782
20101126101444561	SSO	431300	431400	20101126101444561
20101126101500984	SSO	431400	431500	20101126101500985
20101126101358076	SSO	431100	431200	20101126101358078
20101126101449118	SSO	431500	431600	20101126101449119
20101126101506689	SSO	431300	431400	20101126101506689
20101126101509011	SSO	431300	431400	20101126101509133
20101126101419469	SSO	431200	431300	20101126101419470
20101126101503166	SSO	431400	431500	20101126101503166
20101126101502687	SSO	431400	431500	20101126101502687
20101126101425333	SSO	431200	431300	20101126101425334
20101126101447565	SSO	431400	431500	20101126101447639
20101126101454915	SSO	431400	431500	20101126101454915
20101126101436347	SSO	431200	431300	20101126101436348
20101126101432772	SSO	431300	431400	20101126101432772
20101126101416462	SSO	431100	431200	20101126101416463
20101126101514235	SSO	431400	431500	20101126101514256
20101126101507645	SSO	431300	431400	20101126101507773
20101126101428082	SSO	431200	431300	20101126101428084
20101126101447760	SSO	431400	431500	20101126101447760
20101126101444488	SSO	431300	431400	20101126101444488
20101126101518065	SSO	431300	431500	20101126101518489
20101126101456001	SSO	431500	431600	20101126101456031
20101126101444686	SSO	431300	431400	20101126101444688
20101126101447070	SSO	431400	431500	20101126101447085
20101126101452290	SSO	431400	431500	20101126101452291
20101126101452082	SSO	431400	431500	20101126101452082
20101126101510932	SSO	431400	431500	20101126101510933
20101126101417390	SSO	431100	431300	20101126101417406
20101126101504123	SSO	431400	431500	20101126101504148
20101126101422087	SSO	431200	431300	20101126101422527
20101126101537189	SSO	431300	431500	20101126101537189
20101126101530218	SSO	431300	431400	20101126101530218
20101126101444489	SSO	431300	431400	20101126101444489
20101126101504150	SSO	431400	431500	20101126101504193
20101126101412267	SSO	431200	431300	20101126101412267
20101126101503843	SSO	431400	431500	20101126101503844
20101126101444489	SSO	431300	431400	20101126101444489
20101126101458776	SSO	431600	431700	20101126101458787
20101126101356870	SSO	431100	431200	20101126101356870
20101126101434260	SSO	431300	431400	20101126101434262
20101126101510711	SSO	431400	431500	20101126101510711
20101126101435284	SSO	431200	431300	20101126101435285
20101126101400890	SSO	431200	431300	20101126101400892
20101126101502237	SSO	431400	431500	20101126101502238
20101126101509863	SSO	431400	431500	20101126101509864
20101126101503170	SSO	431400	431500	20101126101503255
20101126101506468	SSO	431300	431400	20101126101506468
20101126101517669	SSO	431400	431500	20101126101517670
20101126101522180	SSO	431400	431500	20101126101522184
20101126101452164	SSO	431400	431500	20101126101452164
20101126101501734	SSO	431400	431500	20101126101501735
20101126101526435	SSO	431400	431500	20101126101526435
20101126101523362	SSO	431400	431500	20101126101523387
20101126101458563	SSO	431600	431700	20101126101458566
20101126101445172	SSO	431400	431500	20101126101445172
20101126101432774	SSO	431300	431400	20101126101432775
20101126101452287	SSO	431400	431500	20101126101452288
20101126101500877	SSO	431500	431700	20101126101500877
20101126101510371	SSO	431300	431400	20101126101510379
20101126101425036	SSO	431200	431300	20101126101425036
20101126101445053	SSO	431300	431400	20101126101445066
20101126101506425	SSO	431300	431400	20101126101506425
20101126101457646	SSO	431500	431600	20101126101457646
20101126101434726	SSO	431200	431400	20101126101434728
20101126101520955	SSO	431400	431500	20101126101520956
20101126101508208	SSO	431300	431400	20101126101508241
20101126101510709	SSO	431300	431400	20101126101510709
20101126101503895	SSO	431400	431500	20101126101503898
20101126101500989	SSO	431400	431500	20101126101500989
20101126101510286	SSO	431300	431400	20101126101510286
20101126101514072	SSO	431400	431500	20101126101514074
20101126101502325	SSO	431400	431500	20101126101502325
20101126101453556	SSO	431400	431500	20101126101453570
20101126101508744	SSO	431300	431400	20101126101508744
20101126101526063	SSO	431300	431500	20101126101526063
20101126101503839	SSO	431400	431500	20101126101503839
20101126101447850	SSO	431400	431500	20101126101447940
20101126101448407	SSO	431500	431600	20101126101448413
20101126101543811	SSO	431400	431500	20101126101543812
20101126101514533	SSO	431400	431500	20101126101514533
20101126101514112	SSO	431400	431500	20101126101514115
20101126101451034	SSO	431500	431600	20101126101451034
20101126101526077	SSO	431300	431400	20101126101526079
20101126101502686	SSO	431400	431500	20101126101502686
20101126101506446	SSO	431300	431400	20101126101506447
20101126101537192	SSO	431300	431400	20101126101537192
20101126101456707	SSO	431500	431600	20101126101456832
20101126101514930	SSO	431400	431500	20101126101514932
20101126101445067	SSO	431300	431400	20101126101445067
20101126101437802	SSO	431200	431300	20101126101437816
20101126101527553	SSO	431400	431500	20101126101527662
20101126101454754	SSO	431400	431600	20101126101454915
20101126101517565	SSO	431400	431500	20101126101517579
20101126101501628	SSO	431400	431500	20101126101501732
20101126101453227	SSO	431400	431500	20101126101453228
20101126101514798	SSO	431400	431500	20101126101514821
20101126101517634	SSO	431400	431500	20101126101517634
20101126101510296	SSO	431300	431400	20101126101510348
20101126101526063	SSO	431300	431500	20101126101526064
20101126101541188	SSO	431400	431500	20101126101541188
20101126101538809	SSO	431300	431400	20101126101538824
20101126101525584	SSO	431400	431500	20101126101525585
20101126101530177	SSO	431400	431500	20101126101530178
20101126101512047	SSO	431300	431400	20101126101512048
20101126101545963	SSO	431300	431500	20101126101545963
20101126101515135	SSO	431400	431500	20101126101515190
20101126101538914	SSO	431300	431400	20101126101538931
20101126101546005	SSO	431300	431400	20101126101546007
20101126101534471	SSO	431300	431400	20101126101534473
20101126101457750	SSO	431500	431600	20101126101457909
20101126101509827	SSO	431400	431500	20101126101509827
20101126101526435	SSO	431400	431500	20101126101526435
20101126101529827	SSO	431400	431500	20101126101529843
20101126101418310	SSO	431200	431300	20101126101418783
20101126101527209	SSO	431400	431500	20101126101527210
20101126101444347	SSO	431200	431300	20101126101444438
20101126101500878	SSO	431500	431600	20101126101500878
20101126101510286	SSO	431300	431400	20101126101510287
20101126101506470	SSO	431300	431400	20101126101506471
20101126101510200	SSO	431300	431400	20101126101510220
20101126101614291	SSO	431300	431500	20101126101614291
20101126101516930	SSO	431400	431500	20101126101516934
20101126101546377	SSO	431300	431400	20101126101546377
20101126101516942	SSO	431400	431500	20101126101516947
20101126101556812	SSO	431200	431300	20101126101556812
20101126101506855	SSO	431300	431400	20101126101506855
20101126101526081	SSO	431300	431400	20101126101526081
20101126101438023	SSO	431200	431300	20101126101438174
20101126101503840	SSO	431400	431500	20101126101503840
20101126101452082	SSO	431400	431500	20101126101452082
20101126101453221	SSO	431400	431500	20101126101453221
20101126101514790	SSO	431400	431500	20101126101514793
20101126101527281	SSO	431400	431500	20101126101527281
20101126101514065	SSO	431300	431500	20101126101514065
20101126101502328	SSO	431400	431500	20101126101502330
20101126101503841	SSO	431400	431500	20101126101503842
20101126101536870	SSO	431400	431500	20101126101536872
20101126101526070	SSO	431300	431400	20101126101526071
20101126101514074	SSO	431400	431500	20101126101514078
20101126101526441	SSO	431400	431500	20101126101526614
20101126101616410	SSO	431200	431300	20101126101616410
20101126101529768	SSO	431400	431500	20101126101529784
20101126101537189	SSO	431300	431500	20101126101537189
20101126101554090	SSO	431200	431300	20101126101554090
20101126101502314	SSO	431400	431500	20101126101502323
20101126101557281	SSO	431200	431300	20101126101557281
20101126101508745	SSO	431300	431400	20101126101508745
20101126101611600	SSO	431200	431300	20101126101611621
20101126101507402	SSO	431300	431400	20101126101507403
20101126101530216	SSO	431300	431500	20101126101530216
20101126101507464	SSO	431300	431400	20101126101507471
20101126101501494	SSO	431400	431500	20101126101501540
20101126101536651	SSO	431400	431500	20101126101536651
20101126101526614	SSO	431400	431500	20101126101526657
20101126101530199	SSO	431400	431500	20101126101530200
20101126101543196	SSO	431400	431500	20101126101543416
20101126101511642	SSO	431400	431500	20101126101511642
20101126101601428	SSO	431200	431300	20101126101601434
20101126101556812	SSO	431200	431300	20101126101556812
20101126101613626	SSO	431300	431400	20101126101613627
20101126101510759	SSO	431300	431500	20101126101510766
20101126101509862	SSO	431400	431500	20101126101509863
20101126101504149	SSO	431400	431500	20101126101504150
20101126101451038	SSO	431500	431600	20101126101451039
20101126101508884	SSO	431300	431400	20101126101508884
20101126101506401	SSO	431300	431400	20101126101506402
20101126101611350	SSO	431200	431300	20101126101611379
20101126101509921	SSO	431400	431500	20101126101509923
20101126101501543	SSO	431400	431500	20101126101501543
20101126101558793	SSO	431100	431200	20101126101559029
20101126101554091	SSO	431200	431300	20101126101554091
20101126101537190	SSO	431300	431400	20101126101537190
20101126101508982	SSO	431300	431400	20101126101508982
20101126101630813	SSO	431200	431300	20101126101630813
20101126101606896	SSO	431200	431300	20101126101606896
20101126101554534	SSO	431200	431300	20101126101554584
20101126101557442	SSO	431100	431200	20101126101557446
20101126101510633	SSO	431300	431400	20101126101510642
20101126101521123	SSO	431400	431500	20101126101521123
20101126101509822	SSO	431400	431500	20101126101509822
20101126101502189	SSO	431400	431500	20101126101502206
20101126101506379	SSO	431300	431400	20101126101506380
20101126101557284	SSO	431100	431300	20101126101557285
20101126101509824	SSO	431400	431500	20101126101509825
20101126101534768	SSO	431300	431400	20101126101534774
20101126101509822	SSO	431400	431500	20101126101509822
20101126101504199	SSO	431300	431400	20101126101504201
20101126101551872	SSO	431200	431400	20101126101552322
20101126101514060	SSO	431300	431400	20101126101514062
20101126101500988	SSO	431400	431500	20101126101500988
20101126101614948	SSO	431300	431400	20101126101614949
20101126101506441	SSO	431300	431400	20101126101506441
20101126101451037	SSO	431500	431600	20101126101451037
20101126101614925	SSO	431300	431400	20101126101614929
20101126101515638	SSO	431400	431500	20101126101515638
20101126101632064	SSO	431300	431400	20101126101632065
20101126101517590	SSO	431400	431500	20101126101517592
20101126101600834	SSO	431100	431200	20101126101600969
20101126101633705	SSO	431300	431400	20101126101633705
20101126101436348	SSO	431200	431300	20101126101436383
20101126101613665	SSO	431300	431400	20101126101613665
20101126101511904	SSO	431300	431500	20101126101512046
20101126101508825	SSO	431300	431400	20101126101508826
20101126101436437	SSO	431200	431300	20101126101436537
20101126101506689	SSO	431300	431400	20101126101506689
20101126101633630	SSO	431300	431400	20101126101633630
20101126101654848	SSO	431300	431400	20101126101654848
20101126101539027	SSO	431300	431400	20101126101539033
20101126101613679	SSO	431300	431400	20101126101613679
20101126101500877	SSO	431500	431700	20101126101500877
20101126101656215	SSO	431200	431300	20101126101656215
20101126101540017	SSO	431400	431500	20101126101540019
20101126101546353	SSO	431300	431400	20101126101546353
20101126101604426	SSO	431200	431300	20101126101604535
20101126101613757	SSO	431400	431500	20101126101613761
20101126101530246	SSO	431300	431400	20101126101530262
20101126101637066	SSO	431300	431400	20101126101637067
20101126101540702	SSO	431400	431500	20101126101540702
20101126101627107	SSO	431200	431300	20101126101627107
20101126101517803	SSO	431400	431500	20101126101518063
20101126101554091	SSO	431200	431300	20101126101554091
20101126101613559	SSO	431200	431400	20101126101613559
20101126101713486	SSO	431300	431400	20101126101713507
20101126101522604	SSO	431400	431500	20101126101522633
20101126101613627	SSO	431300	431400	20101126101613628
20101126101538706	SSO	431300	431400	20101126101538779
20101126101539755	SSO	431400	431500	20101126101539766
20101126101512416	SSO	431300	431400	20101126101512418
20101126101602142	SSO	431200	431300	20101126101602143
20101126101556608	SSO	431200	431300	20101126101556667
20101126101616410	SSO	431200	431300	20101126101616410
20101126101645125	SSO	431300	431400	20101126101645130
20101126101613643	SSO	431300	431400	20101126101613643
20101126101505281	SSO	431300	431400	20101126101505297
20101126101517288	SSO	431400	431500	20101126101517554
20101126101439826	SSO	431200	431300	20101126101439826
20101126101645664	SSO	431300	431400	20101126101645673
20101126101605942	SSO	431200	431300	20101126101605942
20101126101546377	SSO	431300	431400	20101126101546377
20101126101452068	SSO	431400	431600	20101126101452069
20101126101514066	SSO	431400	431500	20101126101514066
20101126101444691	SSO	431300	431400	20101126101444775
20101126101641465	SSO	431300	431400	20101126101641465
20101126101530736	SSO	431300	431400	20101126101530741
20101126101526125	SSO	431300	431400	20101126101526125
20101126101510710	SSO	431400	431500	20101126101510710
20101126101616410	SSO	431200	431300	20101126101616410
20101126101522793	SSO	431400	431500	20101126101522829
20101126101642104	SSO	431300	431400	20101126101642105
20101126101509824	SSO	431300	431500	20101126101509824
20101126101616293	SSO	431300	431400	20101126101616294
20101126101554056	SSO	431200	431400	20101126101554089
20101126101613641	SSO	431300	431400	20101126101613641
20101126101506447	SSO	431300	431400	20101126101506461
20101126101541408	SSO	431400	431500	20101126101541410
20101126101449510	SSO	431500	431600	20101126101449510
20101126101632103	SSO	431300	431400	20101126101632103
20101126101526062	SSO	431300	431500	20101126101526063
20101126101530215	SSO	431300	431500	20101126101530216
20101126101637650	SSO	431200	431300	20101126101637653
20101126101628147	SSO	431200	431300	20101126101628394
20101126101535461	SSO	431400	431500	20101126101535461
20101126101614143	SSO	431400	431500	20101126101614143
20101126101557287	SSO	431100	431300	20101126101557287
20101126101530217	SSO	431300	431400	20101126101530218
20101126101631771	SSO	431200	431300	20101126101631772
20101126101618498	SSO	431200	431300	20101126101618498
20101126101559598	SSO	431100	431200	20101126101559600
20101126101557330	SSO	431100	431200	20101126101557333
20101126101523616	SSO	431400	431500	20101126101523641
20101126101617484	SSO	431200	431300	20101126101617484
20101126101530178	SSO	431400	431500	20101126101530179
20101126101526065	SSO	431300	431400	20101126101526066
20101126101557391	SSO	431100	431200	20101126101557434
20101126101514781	SSO	431400	431500	20101126101514786
20101126101554090	SSO	431200	431300	20101126101554090
20101126101543795	SSO	431400	431500	20101126101543811
20101126101557750	SSO	431100	431200	20101126101557781
20101126101626352	SSO	431200	431300	20101126101626353
20101126101616411	SSO	431200	431300	20101126101616411
20101126101705077	SSO	431300	431400	20101126101705079
20101126101511131	SSO	431400	431500	20101126101511133
20101126101632087	SSO	431300	431400	20101126101632087
20101126101600579	SSO	431100	431200	20101126101600583
20101126101557099	SSO	431200	431300	20101126101557100
20101126101557353	SSO	431100	431200	20101126101557353
20101126101526888	SSO	431400	431500	20101126101526888
20101126101611100	SSO	431200	431300	20101126101611124
20101126101536872	SSO	431400	431500	20101126101537188
20101126101530218	SSO	431300	431400	20101126101530218
20101126101632059	SSO	431200	431400	20101126101632059
20101126101605942	SSO	431200	431300	20101126101605942
20101126101508767	SSO	431300	431400	20101126101508772
20101126101528425	SSO	431400	431500	20101126101528441
20101126101505113	SSO	431300	431400	20101126101505114
20101126101613702	SSO	431400	431500	20101126101613703
20101126101554312	SSO	431200	431300	20101126101554312
20101126101613678	SSO	431300	431400	20101126101613679
20101126101633689	SSO	431300	431400	20101126101633692
20101126101609871	SSO	431200	431300	20101126101609872
20101126101618494	SSO	431200	431300	20101126101618494
20101126101616419	SSO	431200	431300	20101126101616427
20101126101614143	SSO	431400	431500	20101126101614149
20101126101536624	SSO	431400	431500	20101126101536624
20101126101640829	SSO	431300	431400	20101126101640830
20101126101540724	SSO	431400	431500	20101126101540745
20101126101633789	SSO	431300	431400	20101126101633789
20101126101654939	SSO	431300	431400	20101126101654944
20101126101618805	SSO	431200	431300	20101126101618805
20101126101601428	SSO	431200	431300	20101126101601428
20101126101640897	SSO	431300	431400	20101126101640897
20101126101546940	SSO	431300	431400	20101126101547035
20101126101537189	SSO	431400	431500	20101126101537189
20101126101550566	SSO	431200	431400	20101126101550567
20101126101554091	SSO	431200	431300	20101126101554091
20101126101557287	SSO	431100	431300	20101126101557288
20101126101641947	SSO	431300	431400	20101126101641948
20101126101627624	SSO	431200	431300	20101126101627697
20101126101546004	SSO	431300	431400	20101126101546005
20101126101613616	SSO	431300	431400	20101126101613619
20101126101636030	SSO	431300	431400	20101126101636040
20101126101522054	SSO	431400	431500	20101126101522055
20101126101556832	SSO	431200	431300	20101126101556832
20101126101627719	SSO	431200	431300	20101126101627884
20101126101617843	SSO	431200	431300	20101126101617857
20101126101618963	SSO	431200	431300	20101126101618965
20101126101633631	SSO	431300	431400	20101126101633632
20101126101527313	SSO	431400	431500	20101126101527327
20101126101635111	SSO	431300	431400	20101126101635671
20101126101602139	SSO	431200	431300	20101126101602139
20101126101633655	SSO	431300	431400	20101126101633656
20101126101659467	SSO	431200	431300	20101126101659467
20101126101601001	SSO	431100	431200	20101126101601002
20101126101633640	SSO	431300	431400	20101126101633640
20101126101510781	SSO	431400	431500	20101126101510784
20101126101525913	SSO	431400	431500	20101126101525913
20101126101631876	SSO	431200	431300	20101126101631876
20101126101635067	SSO	431300	431400	20101126101635069
20101126101648009	SSO	431200	431300	20101126101648026
20101126101633650	SSO	431300	431400	20101126101633650
20101126101721503	SSO	431400	431500	20101126101721503
20101126101528421	SSO	431400	431500	20101126101528423
20101126101642202	SSO	431300	431400	20101126101642203
20101126101626755	SSO	431200	431300	20101126101626756
20101126101510701	SSO	431300	431400	20101126101510701
20101126101539658	SSO	431300	431400	20101126101539674
20101126101617787	SSO	431200	431300	20101126101617787
20101126101613732	SSO	431400	431500	20101126101613732
20101126101510283	SSO	431300	431400	20101126101510283
20101126101637634	SSO	431300	431400	20101126101637636
20101126101713136	SSO	431300	431400	20101126101713182
20101126101740768	SSO	431200	431400	20101126101740768
20101126101621068	SSO	431200	431300	20101126101621068
20101126101527054	SSO	431400	431500	20101126101527075
20101126101624096	SSO	431200	431300	20101126101624096
20101126101527829	SSO	431400	431500	20101126101527829
20101126101514062	SSO	431300	431500	20101126101514062
20101126101527299	SSO	431400	431500	20101126101527300
20101126101619947	SSO	431200	431300	20101126101619947
20101126101643416	SSO	431300	431400	20101126101644043
20101126101627097	SSO	431200	431300	20101126101627098
20101126101621009	SSO	431200	431300	20101126101621009
20101126101701870	SSO	431300	431400	20101126101701871
20101126101641906	SSO	431300	431400	20101126101641906
20101126101610408	SSO	431200	431300	20101126101610475
20101126101620143	SSO	431200	431300	20101126101620553
20101126101647824	SSO	431200	431400	20101126101647826
20101126101624085	SSO	431200	431300	20101126101624086
20101126101633789	SSO	431300	431400	20101126101633789
20101126101624095	SSO	431200	431300	20101126101624095
20101126101637637	SSO	431200	431400	20101126101637637
20101126101507642	SSO	431300	431400	20101126101507645
20101126101754045	SSO	431100	431200	20101126101754045
20101126101545966	SSO	431300	431400	20101126101545966
20101126101654848	SSO	431300	431400	20101126101654848
20101126101637638	SSO	431200	431300	20101126101637639
20101126101642202	SSO	431300	431400	20101126101642202
20101126101614913	SSO	431300	431400	20101126101614913
20101126101645160	SSO	431300	431400	20101126101645163
20101126101627092	SSO	431200	431300	20101126101627095
20101126101641465	SSO	431300	431400	20101126101641465
20101126101642113	SSO	431300	431400	20101126101642113
20101126101743331	SSO	431100	431200	20101126101743331
20101126101632104	SSO	431300	431400	20101126101632121
20101126101557286	SSO	431100	431300	20101126101557286
20101126101642113	SSO	431300	431400	20101126101642121
20101126101656213	SSO	431200	431300	20101126101656213
20101126101627092	SSO	431200	431300	20101126101627092
20101126101633798	SSO	431300	431400	20101126101633802
20101126101613732	SSO	431400	431500	20101126101613732
20101126101642104	SSO	431300	431400	20101126101642104
20101126101659348	SSO	431200	431300	20101126101659357
20101126101642391	SSO	431300	431400	20101126101643394
20101126101630510	SSO	431200	431300	20101126101630511
20101126101605943	SSO	431200	431300	20101126101605943
20101126101546400	SSO	431300	431400	20101126101546445
20101126101719007	SSO	431300	431400	20101126101719008
20101126101645876	SSO	431300	431400	20101126101645882
20101126101656317	SSO	431200	431300	20101126101656391
20101126101627088	SSO	431200	431300	20101126101627089
20101126101600975	SSO	431100	431200	20101126101600976
20101126101616413	SSO	431200	431300	20101126101616418
20101126101637639	SSO	431200	431300	20101126101637639
20101126101657867	SSO	431200	431300	20101126101657868
20101126101705964	SSO	431300	431500	20101126101706192
20101126101645163	SSO	431300	431400	20101126101645173
20101126101657868	SSO	431200	431300	20101126101657868
20101126101659870	SSO	431300	431400	20101126101659873
20101126101637155	SSO	431300	431400	20101126101637272
20101126101656214	SSO	431200	431300	20101126101656214
20101126101631770	SSO	431200	431300	20101126101631771
20101126101611598	SSO	431200	431300	20101126101611600
20101126101627457	SSO	431200	431300	20101126101627624
20101126101705074	SSO	431300	431400	20101126101705075
20101126101613623	SSO	431300	431400	20101126101613625
20101126101520932	SSO	431400	431500	20101126101520932
20101126101722493	SSO	431300	431400	20101126101722571
20101126101643394	SSO	431300	431400	20101126101643395
20101126101631876	SSO	431200	431300	20101126101631877
20101126101624085	SSO	431200	431300	20101126101624085
20101126101659709	SSO	431300	431400	20101126101659711
20101126101614304	SSO	431300	431400	20101126101614314
20101126101620584	SSO	431200	431300	20101126101620623
20101126101700831	SSO	431300	431400	20101126101700832
20101126101637639	SSO	431200	431300	20101126101637645
20101126101640824	SSO	431300	431400	20101126101640824
20101126101613679	SSO	431300	431500	20101126101613680
20101126101740598	SSO	431300	431400	20101126101740598
20101126101705059	SSO	431300	431400	20101126101705060
20101126101742600	SSO	431100	431300	20101126101742600
20101126101614956	SSO	431300	431400	20101126101614962
20101126101727413	SSO	431400	431500	20101126101727697
20101126101644415	SSO	431300	431400	20101126101644638
20101126101706680	SSO	431400	431500	20101126101706680
20101126101627081	SSO	431200	431300	20101126101627081
20101126101639788	SSO	431200	431300	20101126101639788
20101126101730435	SSO	431400	431500	20101126101730435
20101126101606745	SSO	431200	431300	20101126101606745
20101126101637637	SSO	431200	431400	20101126101637637
20101126101701211	SSO	431300	431400	20101126101701268
20101126101706681	SSO	431400	431500	20101126101706682
20101126101710296	SSO	431400	431500	20101126101710550
20101126101645118	SSO	431300	431400	20101126101645119
20101126101614925	SSO	431300	431400	20101126101614925
20101126101656215	SSO	431200	431300	20101126101656215
20101126101645882	SSO	431300	431400	20101126101646049
20101126101635964	SSO	431300	431500	20101126101636009
20101126101648873	SSO	431200	431300	20101126101648873
20101126101642311	SSO	431300	431400	20101126101642389
20101126101702349	SSO	431300	431400	20101126101702350
20101126101659855	SSO	431300	431400	20101126101659856
20101126101659662	SSO	431300	431400	20101126101659662
20101126101712546	SSO	431300	431400	20101126101712547
20101126101645163	SSO	431300	431400	20101126101645163
20101126101712871	SSO	431300	431400	20101126101712872
20101126101657875	SSO	431200	431300	20101126101657875
20101126101704294	SSO	431300	431400	20101126101704306
20101126101647833	SSO	431200	431300	20101126101647833
20101126101657872	SSO	431200	431300	20101126101657873
20101126101647833	SSO	431200	431300	20101126101647833
20101126101654848	SSO	431300	431400	20101126101654849
20101126101646191	SSO	431300	431400	20101126101646333
20101126101632079	SSO	431300	431400	20101126101632080
20101126101648046	SSO	431200	431300	20101126101648046
20101126101640966	SSO	431300	431400	20101126101640967
20101126101642207	SSO	431300	431400	20101126101642216
20101126101613695	SSO	431400	431500	20101126101613695
20101126101642111	SSO	431300	431400	20101126101642111
20101126101659705	SSO	431300	431400	20101126101659708
20101126101530174	SSO	431400	431500	20101126101530174
20101126101607223	SSO	431200	431300	20101126101607248
20101126101722446	SSO	431300	431400	20101126101722446
20101126101655142	SSO	431300	431400	20101126101655142
20101126101717733	SSO	431200	431400	20101126101717924
\.



CREATE INDEX my_tq_agg_small_ets_end_ts_ix ON my_tq_agg_small USING btree (ets, end_ts);


analyze my_tq_agg_small;
analyze my_tt_agg_small;
set optimizer_enable_indexjoin=on;
set optimizer_nestloop_factor = 1.0;
-- force_explain
EXPLAIN 
SELECT (tt.event_ts / 100000) / 5 * 5 as fivemin, COUNT(*)
FROM my_tt_agg_small tt, my_tq_agg_small tq
WHERE tq.sym = tt.symbol AND
      tt.event_ts >= tq.ets AND
      tt.event_ts <  tq.end_ts
GROUP BY 1
ORDER BY 1 asc ;
  
SELECT (tt.event_ts / 100000) / 5 * 5 as fivemin, COUNT(*)
FROM my_tt_agg_small tt, my_tq_agg_small tq
WHERE tq.sym = tt.symbol AND
      tt.event_ts >= tq.ets AND
      tt.event_ts <  tq.end_ts
GROUP BY 1
ORDER BY 1 asc ;
  
set enable_hashjoin=off;
set enable_seqscan=off;
set enable_mergejoin=off;
set enable_nestloop=on;
set enable_indexscan=on;

-- force_explain
set optimizer_segments = 2;
set optimizer_nestloop_factor = 1.0;
EXPLAIN 
SELECT (tt.event_ts / 100000) / 5 * 5 as fivemin, COUNT(*)
FROM my_tt_agg_small tt, my_tq_agg_small tq
WHERE tq.sym = tt.symbol AND
      tt.event_ts >= tq.ets AND
      tt.event_ts <  tq.end_ts
GROUP BY 1
ORDER BY 1 asc ;

reset optimizer_segments;
reset optimizer_nestloop_factor;
SELECT (tt.event_ts / 100000) / 5 * 5 as fivemin, COUNT(*)
FROM my_tt_agg_small tt, my_tq_agg_small tq
WHERE tq.sym = tt.symbol AND
      tt.event_ts >= tq.ets AND
      tt.event_ts <  tq.end_ts
GROUP BY 1
ORDER BY 1 asc ;
  
