--
-- Generated by tidycat
--

   CREATE TABLE gp_interfaces

   (
   interfaceid  smallint,
   address      name,
   status       smallint 
   );

   CREATE TABLE gp_db_interfaces

   (
   dbid           smallint,
   interfaceid    smallint,
   priority       smallint
   );

   CREATE TABLE gp_configuration

   (
   content         smallint,
   definedprimary  boolean,
   dbid            smallint,
   isprimary       boolean,
   valid           boolean,
   hostname        name,
   port            integer,
   datadir         text
   );

   CREATE TABLE gp_configuration_history

   (
   time    timestamp with time zone,
   dbid    smallint,
   "desc"    text
   );

   CREATE TABLE gp_fastsequence

   (
   objid   oid,
   objmod  bigint,
   last_sequence bigint
   );

   CREATE TABLE gp_global_sequence

   (
   sequence_num bigint
   );

   CREATE TABLE gp_id

   (
   gpname       name     ,
   numsegments  smallint ,
   dbid         smallint ,
   content      smallint 
   );

   CREATE TABLE gp_master_mirroring

   (
   summary_state  text,
   detail_state   text,
   log_time       timestamp with time zone,
   error_message  text
   );

   CREATE TABLE gp_persistent_tablespace_node

   (
   filespace_oid                                 oid      ,
   tablespace_oid                                oid      ,
   persistent_state                              smallint ,
   create_mirror_data_loss_tracking_session_num  bigint   ,
   mirror_existence_state                        smallint ,
   reserved                                      integer  ,
   parent_xid                                    integer  ,
   persistent_serial_num                         bigint   ,
   previous_free_tid                             tid      
   );

   CREATE TABLE gp_relation_node

   (
   relfilenode_oid                               oid     ,
   segment_file_num                              integer ,
   create_mirror_data_loss_tracking_session_num  bigint  ,
   persistent_tid                                tid     ,
   persistent_serial_num                         bigint  
   );

   CREATE TABLE gp_persistent_database_node

   (
   tablespace_oid                                oid      ,
   database_oid                                  oid      ,
   persistent_state                              smallint ,
   create_mirror_data_loss_tracking_session_num  bigint   ,
   mirror_existence_state                        smallint ,
   reserved                                      integer  ,
   parent_xid                                    integer  ,
   persistent_serial_num                         bigint   ,
   previous_free_tid                             tid      
   );

   CREATE TABLE gp_persistent_relation_node

   (
   tablespace_oid                                     oid       ,
   database_oid                                       oid       ,
   relfilenode_oid                                    oid       ,
   segment_file_num                                   integer   ,
   relation_storage_manager                           smallint  ,
   persistent_state                                   smallint  ,
   create_mirror_data_loss_tracking_session_num       bigint    ,
   mirror_existence_state                             smallint  ,
   mirror_data_synchronization_state                  smallint  ,
   mirror_bufpool_marked_for_scan_incremental_resync  boolean   ,
   mirror_bufpool_resync_changed_page_count           bigint    ,
   mirror_bufpool_resync_ckpt_loc                     gpxlogloc ,
   mirror_bufpool_resync_ckpt_block_num               integer   ,
   mirror_append_only_loss_eof                        bigint    ,
   mirror_append_only_new_eof                         bigint    ,
   reserved                                           integer   ,
   parent_xid                                         integer   ,
   persistent_serial_num                              bigint    ,
   previous_free_tid                                  tid       
   );

   CREATE TABLE gp_persistent_filespace_node

   (
   filespace_oid                                 oid      ,
   db_id_1                                       smallint ,
   location_1                                    text     ,
   db_id_2                                       smallint ,
   location_2                                    text     ,
   persistent_state                              smallint ,
   create_mirror_data_loss_tracking_session_num  bigint   ,
   mirror_existence_state                        smallint ,
   reserved                                      integer  ,
   parent_xid                                    integer  ,
   persistent_serial_num                         bigint   ,
   previous_free_tid                             tid      
   );

   CREATE TABLE gp_distribution_policy

   (
   localoid  oid,
   attrnums  smallint[]
   );

   CREATE TABLE gp_san_configuration

   (
   mountid             smallint ,
   active_host         "char"   ,
   san_type            "char"   ,
   primary_host        text     ,
   primary_mountpoint  text     ,
   primary_device      text     ,
   mirror_host         text     ,
   mirror_mountpoint   text     ,
   mirror_device       text     
   );

   CREATE TABLE gp_fault_strategy

   (
   fault_strategy "char"
   );

   CREATE TABLE gp_segment_configuration

   (
   dbid              smallint   , -- up to 32767 segment databases
   content           smallint   , -- up to 32767 contents -- only 16384 usable with mirroring (see dbid)

   role              "char"     ,
   preferred_role    "char"     ,
   mode              "char"     ,
   status            "char"     ,
   port              integer    ,

   hostname          text       ,
   address           text       ,

   replication_port  integer    ,
   san_mounts        int2vector   -- one or more mount-points used by this segment.
   );

   CREATE TABLE gp_version_at_initdb

   (
   schemaversion   smallint     ,
   productversion  text
   );

   CREATE TABLE pg_aggregate

   (
   aggfnoid        regproc, 
   aggtransfn      regproc, 
   agginvtransfn   regproc, -- MPP windowing
   aggprelimfn     regproc, -- MPP 2-phase agg
   agginvprelimfn  regproc, -- MPP windowing
   aggfinalfn      regproc, 
   aggsortop       oid, 
   aggtranstype    oid, 
   agginitval      text -- VARIABLE LENGTH FIELD
   );

   CREATE TABLE pg_am

   (
   amname           name, 
   amstrategies     smallint, 
   amsupport        smallint, 
   amorderstrategy  smallint, 
   amcanunique      boolean, 
   amcanmulticol    boolean, 
   amoptionalkey    boolean, 
   amindexnulls     boolean, 
   amstorage        boolean, 
   amclusterable    boolean, 
   amcanshrink      boolean, 
   aminsert         regproc, 
   ambeginscan      regproc, 
   amgettuple       regproc, 
   amgetmulti       regproc, 
   amrescan         regproc, 
   amendscan        regproc, 
   ammarkpos        regproc, 
   amrestrpos       regproc, 
   ambuild          regproc, 
   ambulkdelete     regproc, 
   amvacuumcleanup  regproc, 
   amcostestimate   regproc, 
   amoptions        regproc
    );

   CREATE TABLE pg_amop

   (
   amopclaid     oid, 
   amopsubtype   oid, 
   amopstrategy  smallint, 
   amopreqcheck  boolean, 
   amopopr       oid
   );

   CREATE TABLE pg_amproc

   (
   amopclaid      oid, 
   amprocsubtype  oid, 
   amprocnum      smallint, 
   amproc         regproc
   );

   CREATE TABLE pg_appendonly

   (
   relid            oid, 
   blocksize        integer, 
   safefswritesize  integer, 
   compresslevel    smallint, 
   majorversion     smallint, 
   minorversion     smallint, 
   checksum         boolean, 
   compresstype     text, 
   columnstore      boolean, 
   segrelid         oid, 
   segidxid         oid, 
   blkdirrelid      oid, 
   blkdiridxid      oid, 
   version          integer
   );

   CREATE TABLE pg_appendonly_alter_column

   (
   relid             oid, 
   changenum         integer, 
   segfilenums       integer[], 
   highwaterrownums  bytea
   );

   CREATE TABLE pg_attrdef

   (
   adrelid  oid, 
   adnum    smallint, 
   adbin    text, 
   adsrc    text
   );

   CREATE TABLE pg_attribute

   (
   attrelid       oid, 
   attname        name, 
   atttypid       oid, 
   attstattarget  integer, 
   attlen         smallint, 
   attnum         smallint, 
   attndims       integer, 
   attcacheoff    integer, 
   atttypmod      integer, 
   attbyval       boolean, 
   attstorage     "char", 
   attalign       "char", 
   attnotnull     boolean, 
   atthasdef      boolean, 
   attisdropped   boolean, 
   attislocal     boolean, 
   attinhcount    integer
   );

   CREATE TABLE pg_auth_members

   (
   roleid        oid, 
   member        oid, 
   grantor       oid, 
   admin_option  boolean
   );

   CREATE TABLE pg_authid

   (
   rolname name, -- name of role  
   rolsuper boolean, -- read this field via superuser() only! 
   rolinherit boolean, -- inherit privileges from other roles? 
   rolcreaterole boolean, -- allowed to create more roles? 
   rolcreatedb boolean, -- allowed to create databases? 
   rolcatupdate boolean, -- allowed to alter catalogs manually? 
   rolcanlogin boolean, -- allowed to log in as session user? 
   rolconnlimit integer, -- max connections allowed (-1=no limit) 

   -- remaining fields may be null. use heap_getattr to read them! 
   rolpassword text, -- password, if any 
   rolvaliduntil timestamp with time zone, -- password expiration time, if any
   rolconfig text[], -- GUC settings to apply at login 
   rolresqueue oid, -- ID of resource queue for this role 
   
   -- GP added fields
   rolcreaterextgpfd boolean, -- allowed to create readable gpfdist tbl? 
   rolcreaterexthttp boolean, -- allowed to create readable http tbl? 
   rolcreatewextgpfd boolean -- allowed to create writable gpfdist tbl? 
   );

   CREATE TABLE pg_autovacuum

   (
   vacrelid          oid, 
   enabled           boolean, 
   vac_base_thresh   integer, 
   vac_scale_factor  real, 
   anl_base_thresh   integer, 
   anl_scale_factor  real, 
   vac_cost_delay    integer, 
   vac_cost_limit    integer, 
   freeze_min_age    integer, 
   freeze_max_age    integer
   );

   CREATE TABLE pg_cast

   (
   castsource   oid, 
   casttarget   oid, 
   castfunc     oid, 
   castcontext  "char"
   );

   CREATE TABLE pg_class

   (
   relname         name      ,
   relnamespace    oid       ,
   reltype         oid       ,
   relowner        oid       ,
   relam           oid       ,
   relfilenode     oid       ,
   reltablespace   oid       ,
   relpages        integer   ,
   reltuples       real      ,
   reltoastrelid   oid       ,
   reltoastidxid   oid       ,
   relaosegrelid   oid       ,
   relaosegidxid   oid       ,
   relhasindex     boolean   ,
   relisshared     boolean   ,
   relkind         "char"    ,
   relstorage      "char"    ,
   relnatts        smallint  ,
   relchecks       smallint  ,
   reltriggers     smallint  ,
   relukeys        smallint  ,
   relfkeys        smallint  ,
   relrefs         smallint  ,
   relhasoids      boolean   ,
   relhaspkey      boolean   ,
   relhasrules     boolean   ,
   relhassubclass  boolean   ,
   relfrozenxid    xid       ,
   relacl          aclitem[] ,
   reloptions      text[]    
   );

   CREATE TABLE pg_constraint

   (
   conname        name, 
   connamespace   oid, 
   contype        "char", 
   condeferrable  boolean, 
   condeferred    boolean, 
   conrelid       oid, 
   contypid       oid, 
   confrelid      oid, 
   confupdtype    "char", 
   confdeltype    "char", 
   confmatchtype  "char", 
   conkey         smallint[], 
   confkey        smallint[], 
   conbin         text, 
   consrc         text
   );

   CREATE TABLE pg_conversion

   (
   conname         name, 
   connamespace    oid, 
   conowner        oid, 
   conforencoding  integer, 
   contoencoding   integer, 
   conproc         regproc, 
   condefault      boolean
   );

   CREATE TABLE pg_database

   (
   datname        name, 
   datdba         oid, 
   encoding       integer, 
   datistemplate  boolean, 
   datallowconn   boolean, 
   datconnlimit   integer, 
   datlastsysoid  oid, 
   datfrozenxid   xid, 
   dattablespace  oid, 
   datconfig      text[], 
   datacl         aclitem[]
   );

   CREATE TABLE pg_depend

   (
   classid      oid, 
   objid        oid, 
   objsubid     integer, 
   refclassid   oid, 
   refobjid     oid, 
   refobjsubid  integer, 
   deptype      "char"
   );

   CREATE TABLE pg_description

   (
   objoid       oid, 
   classoid     oid, 
   objsubid     integer, 
   description  text
   );

   CREATE TABLE pg_exttable

   (
   reloid           oid, -- refers to this relation's oid in pg_class 
   location         text[], -- array of URI strings
   fmttype          "char", -- 't' (text) or 'c' (csv)
   fmtopts          text, -- the data format options
   command          text, -- the command string to EXECUTE
   rejectlimit      integer, -- error count reject limit per segment
   rejectlimittype  "char", -- 'r' (rows) or 'p' (percent)
   fmterrtbl        oid, -- the data format error table oid in pg_class
   encoding         integer, -- character encoding of this external table
   writable         boolean -- 't' if writable, 'f' if readable
   );

   CREATE TABLE pg_filespace

   (
   fsname name, -- filespace name
   fsowner oid -- owner of filespace
   );

   CREATE TABLE pg_filespace_entry

   (
   fsefsoid     oid, -- foreign key to pg_filespace 
   fsedbid      smallint, -- segment dbid this refers to 
   fselocation  text -- location of filespace directory
   );

   CREATE TABLE pg_foreign_data_wrapper

   (
   fdwname       name, -- foreign-data wrapper name
   fdwowner      oid, -- FDW owner
   fdwvalidator  oid, -- optional validation function

   -- VARIABLE LENGTH FIELDS start here.

   fdwacl        aclitem[], -- access permissions
   fdwoptions    text[] -- FDW options
   );

   CREATE TABLE pg_foreign_server

   (
   srvname       name, -- foreign server name
   srvowner      oid, -- server owner
   srvfdw      oid, -- server FDW

   -- VARIABLE LENGTH FIELDS start here.  These fields may be NULL, too.

   srvtype     text,
   srvversion  text,
   srvacl        aclitem[], -- access permissions
   srvoptions    text[] -- FDW-specific options
   );

   CREATE TABLE pg_foreign_table

   (
   reloid      oid, -- refers to this relation's oid in pg_class
   server      oid, -- table's foreign server
   -- VARIABLE LENGTH FIELDS start here.  These fields may be NULL, too.

   tbloptions    text[] -- foreign table-specific options
   );

   CREATE TABLE pg_index

   (
   indexrelid      oid        ,
   indrelid        oid        ,
   indnatts        smallint   ,
   indisunique     boolean    ,
   indisprimary    boolean    ,
   indisclustered  boolean    ,
   indisvalid      boolean    ,
   indkey          int2vector ,
   indclass        oidvector  ,
   indexprs        text       ,
   indpred         text       
   );

   CREATE TABLE pg_inherits

   (
   inhrelid   oid     ,
   inhparent  oid     ,
   inhseqno   integer 
   );

   CREATE TABLE pg_language

   ( 
   lanname        name, 
   lanispl        boolean, 
   lanpltrusted   boolean, 
   lanplcallfoid  oid, 
   lanvalidator   oid, 
   lanacl         aclitem[]
   );

   CREATE TABLE pg_largeobject

   (
   loid    oid     , -- Identifier of large object 
   pageno  integer , -- Page number (starting from 0)
   data    bytea     -- Data for page (may be zero-length)
   );

   CREATE TABLE pg_listener

   (
   relname       name    ,
   listenerpid   integer ,
   notification  integer 
   );

   CREATE TABLE pg_namespace

   (
   nspname   name      ,
   nspowner  oid       ,
   nspacl    aclitem[]  -- VARIABLE LENGTH FIELD
   );

   CREATE TABLE pg_opclass

   (
   opcamid       oid     ,
   opcname       name    ,
   opcnamespace  oid     ,
   opcowner      oid     ,
   opcintype     oid     ,
   opcdefault    boolean ,
   opckeytype    oid     
   );

   CREATE TABLE pg_operator

   (
   oprname       name    ,
   oprnamespace  oid     ,
   oprowner      oid     ,
   oprkind       "char"  ,
   oprcanhash    boolean ,
   oprleft       oid     ,
   oprright      oid     ,
   oprresult     oid     ,
   oprcom        oid     ,
   oprnegate     oid     ,
   oprlsortop    oid     ,
   oprrsortop    oid     ,
   oprltcmpop    oid     ,
   oprgtcmpop    oid     ,
   oprcode       regproc ,
   oprrest       regproc ,
   oprjoin       regproc 
   );

   CREATE TABLE pg_partition

   (
   parrelid       oid,
   parkind        "char",
   parlevel       smallint,
   paristemplate  boolean,
   parnatts       smallint,
   paratts        int2vector,
   parclass       oidvector
   );

   CREATE TABLE pg_partition_rule

   ( 
   paroid             oid,
   parchildrelid      oid,
   parparentrule      oid,
   parname            name,
   parisdefault       boolean,
   parruleord         smallint,
   parrangestartincl  boolean,
   parrangeendincl    boolean,
   parrangestart      text,
   parrangeend        text,
   parrangeevery      text,
   parlistvalues      text,
   parreloptions      text[],
   partemplatespace   oid
   );

   CREATE TABLE pg_pltemplate

   (
   tmplname       name, 
   tmpltrusted    boolean, 
   tmplhandler    text, 
   tmplvalidator  text, 
   tmpllibrary    text, 
   tmplacl        aclitem[]
   );

   CREATE TABLE pg_proc

   (
   proname         name, 
   pronamespace    oid, 
   proowner        oid, 
   prolang         oid, 
   proisagg        boolean, 
   prosecdef       boolean, 
   proisstrict     boolean, 
   proretset       boolean, 
   provolatile     "char", 
   pronargs        smallint, 
   prorettype      oid, 
   proiswin        boolean, 
   proargtypes     oidvector, 
   proallargtypes  oid[], 
   proargmodes     "char"[], 
   proargnames     text[], 
   prosrc          text, 
   probin          bytea, 
   proacl          aclitem[]
   );

   CREATE TABLE pg_resqueue

   (
   rsqname name, -- name of resource queue
   rsqcountlimit real, -- max active count limit
   rsqcostlimit real, -- max cost limit
   rsqovercommit boolean, -- allow overcommit on suitable  limits
   rsqignorecostlimit real -- ignore queries with cost less than
   );

   CREATE TABLE pg_resqueuecapability

   (
   resqueueid oid,		-- OID of the queue with this capability 
   restypid smallint,	-- resource type id (key to pg_resourcetype) 
   ressetting text		-- resource setting (opaque type) 
   );

   CREATE TABLE pg_resourcetype

   (
   resname name, -- name of resource type 
   restypid smallint, -- resource type id 
   resrequired boolean, -- if required, user must specify during CREATE
   reshasdefault boolean, -- create a default entry for optional type
   reshasdisable boolean, -- whether the type can be removed or shut off
   resdefaultsetting text,	-- default resource setting 
   resdisabledsetting text	-- value that turns it off 
   );

   CREATE TABLE pg_rewrite

   (
   rulename    name, 
   ev_class    oid, 
   ev_attr     smallint, 
   ev_type     "char", 
   is_instead  boolean, 
   ev_qual     text, 
   ev_action   text
   );

   CREATE TABLE pg_shdepend

   (
   dbid        oid, 
   classid     oid, 
   objid       oid, 
   refclassid  oid, 
   refobjid    oid, 
   deptype     "char"
   );

   CREATE TABLE pg_shdescription

   (
   objoid       oid, 
   classoid     oid, 
   description  text
   );

   CREATE TABLE pg_stat_last_shoperation

   (
   classid        oid, 
   objid          oid, 
   staactionname  name, 
   stasysid       oid, 
   stausename     name, 
   stasubtype     text, 
   statime        timestamp with time zone
   );

   CREATE TABLE pg_statistic

   (
   starelid     oid, 
   staattnum    smallint, 
   stanullfrac  real, 
   stawidth     integer, 
   stadistinct  real, 
   stakind1     smallint, 
   stakind2     smallint, 
   stakind3     smallint, 
   stakind4     smallint, 
   staop1       oid, 
   staop2       oid, 
   staop3       oid, 
   staop4       oid, 
   stanumbers1  real[], 
   stanumbers2  real[], 
   stanumbers3  real[], 
   stanumbers4  real[], 
   stavalues1   text, 
   stavalues2   text, 
   stavalues3   text, 
   stavalues4   text
   );

   CREATE TABLE pg_stat_last_operation

   (
   classid        oid, 
   objid          oid, 
   staactionname  name, 
   stasysid       oid, 
   stausename     name, 
   stasubtype     text, 
   statime        timestamp with time zone
   );

   CREATE TABLE pg_tablespace

   (
   spcname          name, 
   spcowner         oid, 
   spclocation      text, 
   spcacl           aclitem[], 
   spcprilocations  text[], 
   spcmirlocations  text[], 
   spcfsoid         oid
   );

   CREATE TABLE pg_trigger

   (
   tgrelid         oid, 
   tgname          name, 
   tgfoid          oid, 
   tgtype          smallint, 
   tgenabled       boolean, 
   tgisconstraint  boolean, 
   tgconstrname    name, 
   tgconstrrelid   oid, 
   tgdeferrable    boolean, 
   tginitdeferred  boolean, 
   tgnargs         smallint, 
   tgattr          int2vector, 
   tgargs          bytea
   );

   CREATE TABLE pg_type

   (
   typname        name     ,
   typnamespace   oid      ,
   typowner       oid      ,
   typlen         smallint ,
   typbyval       boolean  ,
   typtype        "char"   ,
   typisdefined   boolean  ,
   typdelim       "char"   ,
   typrelid       oid      ,
   typelem        oid      ,
   typinput       regproc  ,
   typoutput      regproc  ,
   typreceive     regproc  ,
   typsend        regproc  ,
   typanalyze     regproc  ,
   typalign       "char"   ,
   typstorage     "char"   ,
   typnotnull     boolean  ,
   typbasetype    oid      ,
   typtypmod      integer  ,
   typndims       integer  ,
   typdefaultbin  text     ,
   typdefault     text     
   );

   CREATE TABLE pg_user_mapping

   (
   umuser     oid, 
   umserver   oid, 
   umoptions  text[]
   );

   CREATE TABLE pg_window

   (
   winfnoid         regproc,  -- pg_proc OID of the window function itself
   winrequireorder  boolean, -- does wf require order by?
   winallowframe    boolean, -- does wf allow framing?
   winpeercount     boolean, -- does wf definition need peer row count?
   wincount         boolean, -- does wf definition need partition row count?
   winfunc          regproc, -- immediate function (0 if none)
   winprefunc       regproc, -- preliminary function (0 if none)
   winpretype       oid, -- type of preliminary function result
   winfinfunc       regproc, -- final function (0 if none)
   winkind          "char" 
   );
