-- Functions defined in the 4.0 Catalog:
--
-- Does not include:
--    * Window functions
--    * Aggregate dummy functions (see aggregates.sql)
--    * SQL Language functions    (see functions_sql.sql)
--    * Shell type functions      (see type_functions.sql)
--    * Cast functions            (see cast_functions.sql)
--    * Conversion functions      (see conversions.sql)
--    * Operator Comparision functions (see operator_comparison_functions.sql)
--    * Operator Selectivity functions (see operator_selectivity_functions.sql)
--    * Access Method functions   (see access_method_functions.sql)
--
-- Derived via the following SQL run within a 4.0 catalog
--
/*
\o /tmp/functions
SELECT 
    'CREATE FUNCTION upg_catalog.'
    || case when proname in ('convert') then '"' || proname || '"' else quote_ident(proname) end
    || '('
    || coalesce(
        array_to_string( 
            case when proargmodes is null 
                 then array(
                     select coalesce(proargnames[i] || ' ','') 
                           || 'upg_catalog.' || quote_ident(typname)
                     from pg_type t, generate_series(1, pronargs) i
                     where t.oid = proargtypes[i-1]
                     order by i)
                 else array(
                     select   case when proargmodes[i] = 'i' then 'IN '
                                   when proargmodes[i] = 'o' then 'OUT '
                                   when proargmodes[i] = 'b' then 'INOUT '
                                   else 'BROKEN(proargmode)' end
                           || coalesce(proargnames[i] || ' ','') 
                           || 'upg_catalog.' || quote_ident(typname)
                     from pg_type t, generate_series(1, array_upper(proargmodes, 1)) i
                     where t.oid = proallargtypes[i]
                     order by i) 
                 end, ', '), '')
    || ') RETURNS '
    || case when proretset then 'SETOF ' else '' end 
    || case when lanname = 'sql' or proargmodes is not null then 'pg_catalog.' else 'upg_catalog.' end
    || quote_ident(r.typname) || ' '
    || 'LANGUAGE ' || quote_ident(lanname) || ' '
    || case when provolatile = 'i' then 'IMMUTABLE '
            when provolatile = 'v' then 'VOLATILE '
            when provolatile = 's' then 'STABLE ' 
            else '' end
    || case when proisstrict then 'STRICT ' else '' end
    || case when prosecdef then 'SECURITY DEFINER ' else '' end
    || 'AS ' 
    || case when lanname = 'c' 
            then '''' || textin(byteaout(probin)) || ''', ''' || prosrc || '''' 
            when lanname = 'internal'
            then '''' || prosrc || ''''
            else 'BROKEN (unsupported language)' end
    || ';'
FROM pg_proc p
JOIN pg_type r on (p.prorettype = r.oid)
JOIN pg_language l on (p.prolang = l.oid)
JOIN pg_namespace n on (p.pronamespace = n.oid)
WHERE n.nspname = 'pg_catalog'
  and proisagg = 'f'
  and proiswin = 'f'
  and p.oid not in (select unnest(array[typinput, typoutput, typreceive, typsend, typanalyze]) from pg_type)
  and p.oid not in (select castfunc from pg_cast)
  and p.oid not in (select conproc from pg_conversion)
  and p.oid not in (select unnest(array[oprrest, oprjoin]) from pg_operator)
  and p.oid not in (select oprcode from pg_operator where oprname in ('<', '<=', '=', '>', '>='))
  and p.oid not in (select oprcode from pg_operator where oid in (select amopopr from pg_amop))
  and p.oid not in (select amproc from pg_amproc)
  and p.oid not in (select unnest(array['pg_catalog.shell_in'::regproc, 'pg_catalog.shell_out'::regproc]))
  and p.oid not in (select unnest(array[lanplcallfoid, lanvalidator]) 
                    from pg_language where lanname not in ('internal', 'c', 'sql', 'plpgsql'))
  and l.lanname != 'sql'
order by 1;
*/
 CREATE FUNCTION upg_catalog."RI_FKey_cascade_del"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_cascade_del';
 CREATE FUNCTION upg_catalog."RI_FKey_cascade_upd"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_cascade_upd';
 CREATE FUNCTION upg_catalog."RI_FKey_check_ins"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_check_ins';
 CREATE FUNCTION upg_catalog."RI_FKey_check_upd"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_check_upd';
 CREATE FUNCTION upg_catalog."RI_FKey_noaction_del"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_noaction_del';
 CREATE FUNCTION upg_catalog."RI_FKey_noaction_upd"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_noaction_upd';
 CREATE FUNCTION upg_catalog."RI_FKey_restrict_del"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_restrict_del';
 CREATE FUNCTION upg_catalog."RI_FKey_restrict_upd"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_restrict_upd';
 CREATE FUNCTION upg_catalog."RI_FKey_setdefault_del"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_setdefault_del';
 CREATE FUNCTION upg_catalog."RI_FKey_setdefault_upd"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_setdefault_upd';
 CREATE FUNCTION upg_catalog."RI_FKey_setnull_del"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_setnull_del';
 CREATE FUNCTION upg_catalog."RI_FKey_setnull_upd"() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'RI_FKey_setnull_upd';
 CREATE FUNCTION upg_catalog."convert"(upg_catalog.text, upg_catalog.name) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_convert';
 CREATE FUNCTION upg_catalog."convert"(upg_catalog.text, upg_catalog.name, upg_catalog.name) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_convert2';
 CREATE FUNCTION upg_catalog."current_schema"() RETURNS upg_catalog.name LANGUAGE internal STABLE STRICT AS 'current_schema';
 CREATE FUNCTION upg_catalog."current_user"() RETURNS upg_catalog.name LANGUAGE internal STABLE STRICT AS 'current_user';
 CREATE FUNCTION upg_catalog."host"(upg_catalog.inet) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'network_host';
 CREATE FUNCTION upg_catalog."like"(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'bytealike';
 CREATE FUNCTION upg_catalog."like"(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'namelike';
 CREATE FUNCTION upg_catalog."like"(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textlike';
 CREATE FUNCTION upg_catalog."log"(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_log';
 CREATE FUNCTION upg_catalog."log"(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dlog10';
 CREATE FUNCTION upg_catalog."overlaps"(upg_catalog."time", upg_catalog."time", upg_catalog."time", upg_catalog."time") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'overlaps_time';
 CREATE FUNCTION upg_catalog."overlaps"(upg_catalog."timestamp", upg_catalog."timestamp", upg_catalog."timestamp", upg_catalog."timestamp") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'overlaps_timestamp';
 CREATE FUNCTION upg_catalog."overlaps"(upg_catalog.timestamptz, upg_catalog.timestamptz, upg_catalog.timestamptz, upg_catalog.timestamptz) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'overlaps_timestamp';
 CREATE FUNCTION upg_catalog."overlaps"(upg_catalog.timetz, upg_catalog.timetz, upg_catalog.timetz, upg_catalog.timetz) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'overlaps_timetz';
 CREATE FUNCTION upg_catalog."position"(upg_catalog."bit", upg_catalog."bit") RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'bitposition';
 CREATE FUNCTION upg_catalog."position"(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'byteapos';
 CREATE FUNCTION upg_catalog."position"(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'textpos';
 CREATE FUNCTION upg_catalog."session_user"() RETURNS upg_catalog.name LANGUAGE internal STABLE STRICT AS 'session_user';
 CREATE FUNCTION upg_catalog."substring"(upg_catalog."bit", upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog."bit" LANGUAGE internal IMMUTABLE STRICT AS 'bitsubstr';
 CREATE FUNCTION upg_catalog."substring"(upg_catalog.bytea, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'bytea_substr_no_len';
 CREATE FUNCTION upg_catalog."substring"(upg_catalog.bytea, upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'bytea_substr';
 CREATE FUNCTION upg_catalog."substring"(upg_catalog.text, upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'text_substr_no_len';
 CREATE FUNCTION upg_catalog."substring"(upg_catalog.text, upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'text_substr';
 CREATE FUNCTION upg_catalog."substring"(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'textregexsubstr';
 CREATE FUNCTION upg_catalog."timestamp"(upg_catalog.date, upg_catalog."time") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'datetime_timestamp';
 CREATE FUNCTION upg_catalog.abbrev(upg_catalog.cidr) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'cidr_abbrev';
 CREATE FUNCTION upg_catalog.abbrev(upg_catalog.inet) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'inet_abbrev';
 CREATE FUNCTION upg_catalog.abs(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_abs';
 CREATE FUNCTION upg_catalog.abs(upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4abs';
 CREATE FUNCTION upg_catalog.abs(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8abs';
 CREATE FUNCTION upg_catalog.abs(upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2abs';
 CREATE FUNCTION upg_catalog.abs(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4abs';
 CREATE FUNCTION upg_catalog.abs(upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8abs';
 CREATE FUNCTION upg_catalog.abstimene(upg_catalog.abstime, upg_catalog.abstime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'abstimene';
 CREATE FUNCTION upg_catalog.aclcontains(upg_catalog._aclitem, upg_catalog.aclitem) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'aclcontains';
 CREATE FUNCTION upg_catalog.aclinsert(upg_catalog._aclitem, upg_catalog.aclitem) RETURNS upg_catalog._aclitem LANGUAGE internal IMMUTABLE STRICT AS 'aclinsert';
 CREATE FUNCTION upg_catalog.aclremove(upg_catalog._aclitem, upg_catalog.aclitem) RETURNS upg_catalog._aclitem LANGUAGE internal IMMUTABLE STRICT AS 'aclremove';
 CREATE FUNCTION upg_catalog.acos(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dacos';
 CREATE FUNCTION upg_catalog.age(upg_catalog."timestamp", upg_catalog."timestamp") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_age';
 CREATE FUNCTION upg_catalog.age(upg_catalog.timestamptz, upg_catalog.timestamptz) RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'timestamptz_age';
 CREATE FUNCTION upg_catalog.age(upg_catalog.xid) RETURNS upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'xid_age';
 CREATE FUNCTION upg_catalog.area(upg_catalog.box) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'box_area';
 CREATE FUNCTION upg_catalog.area(upg_catalog.circle) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'circle_area';
 CREATE FUNCTION upg_catalog.area(upg_catalog.path) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'path_area';
 CREATE FUNCTION upg_catalog.array_add(upg_catalog._int4, upg_catalog._int4) RETURNS upg_catalog._int4 LANGUAGE internal IMMUTABLE STRICT AS 'array_int4_add';
 CREATE FUNCTION upg_catalog.array_append(upg_catalog.anyarray, upg_catalog.anyelement) RETURNS upg_catalog.anyarray LANGUAGE internal IMMUTABLE AS 'array_push';
 CREATE FUNCTION upg_catalog.array_cat(upg_catalog.anyarray, upg_catalog.anyarray) RETURNS upg_catalog.anyarray LANGUAGE internal IMMUTABLE AS 'array_cat';
 CREATE FUNCTION upg_catalog.array_coerce(upg_catalog.anyarray) RETURNS upg_catalog.anyarray LANGUAGE internal STABLE STRICT AS 'array_type_coerce';
 CREATE FUNCTION upg_catalog.array_dims(upg_catalog.anyarray) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'array_dims';
 CREATE FUNCTION upg_catalog.array_larger(upg_catalog.anyarray, upg_catalog.anyarray) RETURNS upg_catalog.anyarray LANGUAGE internal IMMUTABLE STRICT AS 'array_larger';
 CREATE FUNCTION upg_catalog.array_length_coerce(upg_catalog.anyarray, upg_catalog.int4, upg_catalog.bool) RETURNS upg_catalog.anyarray LANGUAGE internal STABLE STRICT AS 'array_length_coerce';
 CREATE FUNCTION upg_catalog.array_lower(upg_catalog.anyarray, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'array_lower';
 CREATE FUNCTION upg_catalog.array_ne(upg_catalog.anyarray, upg_catalog.anyarray) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'array_ne';
 CREATE FUNCTION upg_catalog.array_prepend(upg_catalog.anyelement, upg_catalog.anyarray) RETURNS upg_catalog.anyarray LANGUAGE internal IMMUTABLE AS 'array_push';
 CREATE FUNCTION upg_catalog.array_smaller(upg_catalog.anyarray, upg_catalog.anyarray) RETURNS upg_catalog.anyarray LANGUAGE internal IMMUTABLE STRICT AS 'array_smaller';
 CREATE FUNCTION upg_catalog.array_to_string(upg_catalog.anyarray, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'array_to_text';
 CREATE FUNCTION upg_catalog.array_type_length_coerce(upg_catalog.anyarray, upg_catalog.int4, upg_catalog.bool) RETURNS upg_catalog.anyarray LANGUAGE internal STABLE STRICT AS 'array_type_length_coerce';
 CREATE FUNCTION upg_catalog.array_upper(upg_catalog.anyarray, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'array_upper';
 CREATE FUNCTION upg_catalog.ascii(upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'ascii';
 CREATE FUNCTION upg_catalog.asin(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dasin';
 CREATE FUNCTION upg_catalog.atan(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'datan';
 CREATE FUNCTION upg_catalog.atan2(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'datan2';
 CREATE FUNCTION upg_catalog.bitand(upg_catalog."bit", upg_catalog."bit") RETURNS upg_catalog."bit" LANGUAGE internal IMMUTABLE STRICT AS 'bitand';
 CREATE FUNCTION upg_catalog.bitcat(upg_catalog."bit", upg_catalog."bit") RETURNS upg_catalog."bit" LANGUAGE internal IMMUTABLE STRICT AS 'bitcat';
 CREATE FUNCTION upg_catalog.bitne(upg_catalog."bit", upg_catalog."bit") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'bitne';
 CREATE FUNCTION upg_catalog.bitnot(upg_catalog."bit") RETURNS upg_catalog."bit" LANGUAGE internal IMMUTABLE STRICT AS 'bitnot';
 CREATE FUNCTION upg_catalog.bitor(upg_catalog."bit", upg_catalog."bit") RETURNS upg_catalog."bit" LANGUAGE internal IMMUTABLE STRICT AS 'bitor';
 CREATE FUNCTION upg_catalog.bitshiftleft(upg_catalog."bit", upg_catalog.int4) RETURNS upg_catalog."bit" LANGUAGE internal IMMUTABLE STRICT AS 'bitshiftleft';
 CREATE FUNCTION upg_catalog.bitshiftright(upg_catalog."bit", upg_catalog.int4) RETURNS upg_catalog."bit" LANGUAGE internal IMMUTABLE STRICT AS 'bitshiftright';
 CREATE FUNCTION upg_catalog.bitxor(upg_catalog."bit", upg_catalog."bit") RETURNS upg_catalog."bit" LANGUAGE internal IMMUTABLE STRICT AS 'bitxor';
 CREATE FUNCTION upg_catalog.bmbeginscan(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'bmbeginscan';
 CREATE FUNCTION upg_catalog.bmbuild(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'bmbuild';
 CREATE FUNCTION upg_catalog.bmbulkdelete(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'bmbulkdelete';
 CREATE FUNCTION upg_catalog.bmcostestimate(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'bmcostestimate';
 CREATE FUNCTION upg_catalog.bmendscan(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'bmendscan';
 CREATE FUNCTION upg_catalog.bmgetmulti(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'bmgetmulti';
 CREATE FUNCTION upg_catalog.bmgettuple(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'bmgettuple';
 CREATE FUNCTION upg_catalog.bminsert(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'bminsert';
 CREATE FUNCTION upg_catalog.bmmarkpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'bmmarkpos';
 CREATE FUNCTION upg_catalog.bmoptions(upg_catalog._text, upg_catalog.bool) RETURNS upg_catalog.bytea LANGUAGE internal STABLE STRICT AS 'bmoptions';
 CREATE FUNCTION upg_catalog.bmrescan(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'bmrescan';
 CREATE FUNCTION upg_catalog.bmrestrpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'bmrestrpos';
 CREATE FUNCTION upg_catalog.bmvacuumcleanup(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'bmvacuumcleanup';
 CREATE FUNCTION upg_catalog.booland_statefunc(upg_catalog.bool, upg_catalog.bool) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'booland_statefunc';
 CREATE FUNCTION upg_catalog.boolne(upg_catalog.bool, upg_catalog.bool) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'boolne';
 CREATE FUNCTION upg_catalog.boolor_statefunc(upg_catalog.bool, upg_catalog.bool) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'boolor_statefunc';
 CREATE FUNCTION upg_catalog.box(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.box LANGUAGE internal IMMUTABLE STRICT AS 'points_box';
 CREATE FUNCTION upg_catalog.box_above_eq(upg_catalog.box, upg_catalog.box) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'box_above_eq';
 CREATE FUNCTION upg_catalog.box_add(upg_catalog.box, upg_catalog.point) RETURNS upg_catalog.box LANGUAGE internal IMMUTABLE STRICT AS 'box_add';
 CREATE FUNCTION upg_catalog.box_below_eq(upg_catalog.box, upg_catalog.box) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'box_below_eq';
 CREATE FUNCTION upg_catalog.box_center(upg_catalog.box) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'box_center';
 CREATE FUNCTION upg_catalog.box_distance(upg_catalog.box, upg_catalog.box) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'box_distance';
 CREATE FUNCTION upg_catalog.box_div(upg_catalog.box, upg_catalog.point) RETURNS upg_catalog.box LANGUAGE internal IMMUTABLE STRICT AS 'box_div';
 CREATE FUNCTION upg_catalog.box_intersect(upg_catalog.box, upg_catalog.box) RETURNS upg_catalog.box LANGUAGE internal IMMUTABLE STRICT AS 'box_intersect';
 CREATE FUNCTION upg_catalog.box_mul(upg_catalog.box, upg_catalog.point) RETURNS upg_catalog.box LANGUAGE internal IMMUTABLE STRICT AS 'box_mul';
 CREATE FUNCTION upg_catalog.box_sub(upg_catalog.box, upg_catalog.point) RETURNS upg_catalog.box LANGUAGE internal IMMUTABLE STRICT AS 'box_sub';
 CREATE FUNCTION upg_catalog.bpchar_larger(upg_catalog.bpchar, upg_catalog.bpchar) RETURNS upg_catalog.bpchar LANGUAGE internal IMMUTABLE STRICT AS 'bpchar_larger';
 CREATE FUNCTION upg_catalog.bpchar_pattern_ne(upg_catalog.bpchar, upg_catalog.bpchar) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textne';
 CREATE FUNCTION upg_catalog.bpchar_smaller(upg_catalog.bpchar, upg_catalog.bpchar) RETURNS upg_catalog.bpchar LANGUAGE internal IMMUTABLE STRICT AS 'bpchar_smaller';
 CREATE FUNCTION upg_catalog.bpchariclike(upg_catalog.bpchar, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texticlike';
 CREATE FUNCTION upg_catalog.bpcharicnlike(upg_catalog.bpchar, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texticnlike';
 CREATE FUNCTION upg_catalog.bpcharicregexeq(upg_catalog.bpchar, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texticregexeq';
 CREATE FUNCTION upg_catalog.bpcharicregexne(upg_catalog.bpchar, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texticregexne';
 CREATE FUNCTION upg_catalog.bpcharlike(upg_catalog.bpchar, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textlike';
 CREATE FUNCTION upg_catalog.bpcharne(upg_catalog.bpchar, upg_catalog.bpchar) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'bpcharne';
 CREATE FUNCTION upg_catalog.bpcharnlike(upg_catalog.bpchar, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textnlike';
 CREATE FUNCTION upg_catalog.bpcharregexeq(upg_catalog.bpchar, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textregexeq';
 CREATE FUNCTION upg_catalog.bpcharregexne(upg_catalog.bpchar, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textregexne';
 CREATE FUNCTION upg_catalog.broadcast(upg_catalog.inet) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'network_broadcast';
 CREATE FUNCTION upg_catalog.btbeginscan(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'btbeginscan';
 CREATE FUNCTION upg_catalog.btbuild(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'btbuild';
 CREATE FUNCTION upg_catalog.btbulkdelete(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'btbulkdelete';
 CREATE FUNCTION upg_catalog.btcostestimate(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'btcostestimate';
 CREATE FUNCTION upg_catalog.btendscan(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'btendscan';
 CREATE FUNCTION upg_catalog.btgetmulti(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'btgetmulti';
 CREATE FUNCTION upg_catalog.btgettuple(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'btgettuple';
 CREATE FUNCTION upg_catalog.btinsert(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'btinsert';
 CREATE FUNCTION upg_catalog.btmarkpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'btmarkpos';
 CREATE FUNCTION upg_catalog.btoptions(upg_catalog._text, upg_catalog.bool) RETURNS upg_catalog.bytea LANGUAGE internal STABLE STRICT AS 'btoptions';
 CREATE FUNCTION upg_catalog.btrescan(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'btrescan';
 CREATE FUNCTION upg_catalog.btrestrpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'btrestrpos';
 CREATE FUNCTION upg_catalog.btrim(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'byteatrim';
 CREATE FUNCTION upg_catalog.btrim(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'btrim1';
 CREATE FUNCTION upg_catalog.btrim(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'btrim';
 CREATE FUNCTION upg_catalog.btvacuumcleanup(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'btvacuumcleanup';
 CREATE FUNCTION upg_catalog.byteacat(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'byteacat';
 CREATE FUNCTION upg_catalog.bytealike(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'bytealike';
 CREATE FUNCTION upg_catalog.byteane(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'byteane';
 CREATE FUNCTION upg_catalog.byteanlike(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'byteanlike';
 CREATE FUNCTION upg_catalog.cash_div_flt4(upg_catalog.money, upg_catalog.float4) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_div_flt4';
 CREATE FUNCTION upg_catalog.cash_div_flt8(upg_catalog.money, upg_catalog.float8) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_div_flt8';
 CREATE FUNCTION upg_catalog.cash_div_int2(upg_catalog.money, upg_catalog.int2) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_div_int2';
 CREATE FUNCTION upg_catalog.cash_div_int4(upg_catalog.money, upg_catalog.int4) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_div_int4';
 CREATE FUNCTION upg_catalog.cash_mi(upg_catalog.money, upg_catalog.money) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_mi';
 CREATE FUNCTION upg_catalog.cash_mul_flt4(upg_catalog.money, upg_catalog.float4) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_mul_flt4';
 CREATE FUNCTION upg_catalog.cash_mul_flt8(upg_catalog.money, upg_catalog.float8) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_mul_flt8';
 CREATE FUNCTION upg_catalog.cash_mul_int2(upg_catalog.money, upg_catalog.int2) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_mul_int2';
 CREATE FUNCTION upg_catalog.cash_mul_int4(upg_catalog.money, upg_catalog.int4) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_mul_int4';
 CREATE FUNCTION upg_catalog.cash_ne(upg_catalog.money, upg_catalog.money) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'cash_ne';
 CREATE FUNCTION upg_catalog.cash_pl(upg_catalog.money, upg_catalog.money) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cash_pl';
 CREATE FUNCTION upg_catalog.cash_words(upg_catalog.money) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'cash_words';
 CREATE FUNCTION upg_catalog.cashlarger(upg_catalog.money, upg_catalog.money) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cashlarger';
 CREATE FUNCTION upg_catalog.cashsmaller(upg_catalog.money, upg_catalog.money) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'cashsmaller';
 CREATE FUNCTION upg_catalog.cbrt(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dcbrt';
 CREATE FUNCTION upg_catalog.ceil(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_ceil';
 CREATE FUNCTION upg_catalog.ceil(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dceil';
 CREATE FUNCTION upg_catalog.ceiling(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_ceil';
 CREATE FUNCTION upg_catalog.ceiling(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dceil';
 CREATE FUNCTION upg_catalog.center(upg_catalog.box) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'box_center';
 CREATE FUNCTION upg_catalog.center(upg_catalog.circle) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'circle_center';
 CREATE FUNCTION upg_catalog.char_length(upg_catalog.bpchar) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'bpcharlen';
 CREATE FUNCTION upg_catalog.char_length(upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'textlen';
 CREATE FUNCTION upg_catalog.character_length(upg_catalog.bpchar) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'bpcharlen';
 CREATE FUNCTION upg_catalog.character_length(upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'textlen';
 CREATE FUNCTION upg_catalog.charne(upg_catalog."char", upg_catalog."char") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'charne';
 CREATE FUNCTION upg_catalog.chr(upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'chr';
 CREATE FUNCTION upg_catalog.circle(upg_catalog.point, upg_catalog.float8) RETURNS upg_catalog.circle LANGUAGE internal IMMUTABLE STRICT AS 'cr_circle';
 CREATE FUNCTION upg_catalog.circle_add_pt(upg_catalog.circle, upg_catalog.point) RETURNS upg_catalog.circle LANGUAGE internal IMMUTABLE STRICT AS 'circle_add_pt';
 CREATE FUNCTION upg_catalog.circle_center(upg_catalog.circle) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'circle_center';
 CREATE FUNCTION upg_catalog.circle_contain_pt(upg_catalog.circle, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'circle_contain_pt';
 CREATE FUNCTION upg_catalog.circle_distance(upg_catalog.circle, upg_catalog.circle) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'circle_distance';
 CREATE FUNCTION upg_catalog.circle_div_pt(upg_catalog.circle, upg_catalog.point) RETURNS upg_catalog.circle LANGUAGE internal IMMUTABLE STRICT AS 'circle_div_pt';
 CREATE FUNCTION upg_catalog.circle_mul_pt(upg_catalog.circle, upg_catalog.point) RETURNS upg_catalog.circle LANGUAGE internal IMMUTABLE STRICT AS 'circle_mul_pt';
 CREATE FUNCTION upg_catalog.circle_ne(upg_catalog.circle, upg_catalog.circle) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'circle_ne';
 CREATE FUNCTION upg_catalog.circle_sub_pt(upg_catalog.circle, upg_catalog.point) RETURNS upg_catalog.circle LANGUAGE internal IMMUTABLE STRICT AS 'circle_sub_pt';
 CREATE FUNCTION upg_catalog.clock_timestamp() RETURNS upg_catalog.timestamptz LANGUAGE internal VOLATILE STRICT AS 'clock_timestamp';
 CREATE FUNCTION upg_catalog.close_lb(upg_catalog.line, upg_catalog.box) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'close_lb';
 CREATE FUNCTION upg_catalog.close_ls(upg_catalog.line, upg_catalog.lseg) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'close_ls';
 CREATE FUNCTION upg_catalog.close_lseg(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'close_lseg';
 CREATE FUNCTION upg_catalog.close_pb(upg_catalog.point, upg_catalog.box) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'close_pb';
 CREATE FUNCTION upg_catalog.close_pl(upg_catalog.point, upg_catalog.line) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'close_pl';
 CREATE FUNCTION upg_catalog.close_ps(upg_catalog.point, upg_catalog.lseg) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'close_ps';
 CREATE FUNCTION upg_catalog.close_sb(upg_catalog.lseg, upg_catalog.box) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'close_sb';
 CREATE FUNCTION upg_catalog.close_sl(upg_catalog.lseg, upg_catalog.line) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'close_sl';
 CREATE FUNCTION upg_catalog.convert_using(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_convert_using';
 CREATE FUNCTION upg_catalog.cos(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dcos';
 CREATE FUNCTION upg_catalog.cot(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dcot';
 CREATE FUNCTION upg_catalog.cume_dist_final(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'cume_dist_final';
 CREATE FUNCTION upg_catalog.cume_dist_prelim(upg_catalog.internal) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'cume_dist_prelim';
 CREATE FUNCTION upg_catalog.current_database() RETURNS upg_catalog.name LANGUAGE internal IMMUTABLE STRICT AS 'current_database';
 CREATE FUNCTION upg_catalog.current_query() RETURNS upg_catalog.text LANGUAGE internal VOLATILE AS 'current_query';
 CREATE FUNCTION upg_catalog.current_schemas(upg_catalog.bool) RETURNS upg_catalog._name LANGUAGE internal STABLE STRICT AS 'current_schemas';
 CREATE FUNCTION upg_catalog.current_setting(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'show_config_by_name';
 CREATE FUNCTION upg_catalog.currtid(upg_catalog.oid, upg_catalog.tid) RETURNS upg_catalog.tid LANGUAGE internal VOLATILE STRICT AS 'currtid_byreloid';
 CREATE FUNCTION upg_catalog.currtid2(upg_catalog.text, upg_catalog.tid) RETURNS upg_catalog.tid LANGUAGE internal VOLATILE STRICT AS 'currtid_byrelname';
 CREATE FUNCTION upg_catalog.currval(upg_catalog.regclass) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'currval_oid';
 CREATE FUNCTION upg_catalog.date_larger(upg_catalog.date, upg_catalog.date) RETURNS upg_catalog.date LANGUAGE internal IMMUTABLE STRICT AS 'date_larger';
 CREATE FUNCTION upg_catalog.date_mi(upg_catalog.date, upg_catalog.date) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'date_mi';
 CREATE FUNCTION upg_catalog.date_mi_interval(upg_catalog.date, upg_catalog."interval") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'date_mi_interval';
 CREATE FUNCTION upg_catalog.date_mii(upg_catalog.date, upg_catalog.int4) RETURNS upg_catalog.date LANGUAGE internal IMMUTABLE STRICT AS 'date_mii';
 CREATE FUNCTION upg_catalog.date_ne(upg_catalog.date, upg_catalog.date) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'date_ne';
 CREATE FUNCTION upg_catalog.date_ne_timestamp(upg_catalog.date, upg_catalog."timestamp") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'date_ne_timestamp';
 CREATE FUNCTION upg_catalog.date_ne_timestamptz(upg_catalog.date, upg_catalog.timestamptz) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'date_ne_timestamptz';
 CREATE FUNCTION upg_catalog.date_part(upg_catalog.text, upg_catalog."interval") RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'interval_part';
 CREATE FUNCTION upg_catalog.date_part(upg_catalog.text, upg_catalog."time") RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'time_part';
 CREATE FUNCTION upg_catalog.date_part(upg_catalog.text, upg_catalog."timestamp") RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_part';
 CREATE FUNCTION upg_catalog.date_part(upg_catalog.text, upg_catalog.timestamptz) RETURNS upg_catalog.float8 LANGUAGE internal STABLE STRICT AS 'timestamptz_part';
 CREATE FUNCTION upg_catalog.date_part(upg_catalog.text, upg_catalog.timetz) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'timetz_part';
 CREATE FUNCTION upg_catalog.date_pl_interval(upg_catalog.date, upg_catalog."interval") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'date_pl_interval';
 CREATE FUNCTION upg_catalog.date_pli(upg_catalog.date, upg_catalog.int4) RETURNS upg_catalog.date LANGUAGE internal IMMUTABLE STRICT AS 'date_pli';
 CREATE FUNCTION upg_catalog.date_smaller(upg_catalog.date, upg_catalog.date) RETURNS upg_catalog.date LANGUAGE internal IMMUTABLE STRICT AS 'date_smaller';
 CREATE FUNCTION upg_catalog.date_trunc(upg_catalog.text, upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_trunc';
 CREATE FUNCTION upg_catalog.date_trunc(upg_catalog.text, upg_catalog."timestamp") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_trunc';
 CREATE FUNCTION upg_catalog.date_trunc(upg_catalog.text, upg_catalog.timestamptz) RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'timestamptz_trunc';
 CREATE FUNCTION upg_catalog.datetime_pl(upg_catalog.date, upg_catalog."time") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'datetime_timestamp';
 CREATE FUNCTION upg_catalog.datetimetz_pl(upg_catalog.date, upg_catalog.timetz) RETURNS upg_catalog.timestamptz LANGUAGE internal IMMUTABLE STRICT AS 'datetimetz_timestamptz';
 CREATE FUNCTION upg_catalog.dcbrt(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dcbrt';
 CREATE FUNCTION upg_catalog.decode(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'binary_decode';
 CREATE FUNCTION upg_catalog.degrees(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'degrees';
 CREATE FUNCTION upg_catalog.dense_rank_immed(upg_catalog.internal) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'dense_rank_immed';
 CREATE FUNCTION upg_catalog.dexp(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dexp';
 CREATE FUNCTION upg_catalog.diagonal(upg_catalog.box) RETURNS upg_catalog.lseg LANGUAGE internal IMMUTABLE STRICT AS 'box_diagonal';
 CREATE FUNCTION upg_catalog.diameter(upg_catalog.circle) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'circle_diameter';
 CREATE FUNCTION upg_catalog.dist_cpoly(upg_catalog.circle, upg_catalog.polygon) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_cpoly';
 CREATE FUNCTION upg_catalog.dist_lb(upg_catalog.line, upg_catalog.box) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_lb';
 CREATE FUNCTION upg_catalog.dist_pb(upg_catalog.point, upg_catalog.box) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_pb';
 CREATE FUNCTION upg_catalog.dist_pc(upg_catalog.point, upg_catalog.circle) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_pc';
 CREATE FUNCTION upg_catalog.dist_pl(upg_catalog.point, upg_catalog.line) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_pl';
 CREATE FUNCTION upg_catalog.dist_ppath(upg_catalog.point, upg_catalog.path) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_ppath';
 CREATE FUNCTION upg_catalog.dist_ps(upg_catalog.point, upg_catalog.lseg) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_ps';
 CREATE FUNCTION upg_catalog.dist_sb(upg_catalog.lseg, upg_catalog.box) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_sb';
 CREATE FUNCTION upg_catalog.dist_sl(upg_catalog.lseg, upg_catalog.line) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dist_sl';
 CREATE FUNCTION upg_catalog.dlog1(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dlog1';
 CREATE FUNCTION upg_catalog.dlog10(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dlog10';
 CREATE FUNCTION upg_catalog.dpow(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dpow';
 CREATE FUNCTION upg_catalog.dround(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dround';
 CREATE FUNCTION upg_catalog.dsqrt(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dsqrt';
 CREATE FUNCTION upg_catalog.dtrunc(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dtrunc';
 CREATE FUNCTION upg_catalog.encode(upg_catalog.bytea, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'binary_encode';
 CREATE FUNCTION upg_catalog.exp(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_exp';
 CREATE FUNCTION upg_catalog.exp(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dexp';
 CREATE FUNCTION upg_catalog.factorial(upg_catalog.int8) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_fac';
 CREATE FUNCTION upg_catalog.family(upg_catalog.inet) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'network_family';
 CREATE FUNCTION upg_catalog.flatfile_update_trigger() RETURNS upg_catalog.trigger LANGUAGE internal VOLATILE STRICT AS 'flatfile_update_trigger';
 CREATE FUNCTION upg_catalog.float48div(upg_catalog.float4, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float48div';
 CREATE FUNCTION upg_catalog.float48mi(upg_catalog.float4, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float48mi';
 CREATE FUNCTION upg_catalog.float48mul(upg_catalog.float4, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float48mul';
 CREATE FUNCTION upg_catalog.float48ne(upg_catalog.float4, upg_catalog.float8) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'float48ne';
 CREATE FUNCTION upg_catalog.float48pl(upg_catalog.float4, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float48pl';
 CREATE FUNCTION upg_catalog.float4_accum(upg_catalog._float8, upg_catalog.float4) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float4_accum';
 CREATE FUNCTION upg_catalog.float4_avg_accum(upg_catalog.bytea, upg_catalog.float4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'float4_avg_accum';
 CREATE FUNCTION upg_catalog.float4_avg_decum(upg_catalog.bytea, upg_catalog.float4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'float4_avg_decum';
 CREATE FUNCTION upg_catalog.float4_decum(upg_catalog._float8, upg_catalog.float4) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float4_decum';
 CREATE FUNCTION upg_catalog.float4abs(upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4abs';
 CREATE FUNCTION upg_catalog.float4div(upg_catalog.float4, upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4div';
 CREATE FUNCTION upg_catalog.float4larger(upg_catalog.float4, upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4larger';
 CREATE FUNCTION upg_catalog.float4mi(upg_catalog.float4, upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4mi';
 CREATE FUNCTION upg_catalog.float4mul(upg_catalog.float4, upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4mul';
 CREATE FUNCTION upg_catalog.float4ne(upg_catalog.float4, upg_catalog.float4) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'float4ne';
 CREATE FUNCTION upg_catalog.float4pl(upg_catalog.float4, upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4pl';
 CREATE FUNCTION upg_catalog.float4smaller(upg_catalog.float4, upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4smaller';
 CREATE FUNCTION upg_catalog.float4um(upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4um';
 CREATE FUNCTION upg_catalog.float4up(upg_catalog.float4) RETURNS upg_catalog.float4 LANGUAGE internal IMMUTABLE STRICT AS 'float4up';
 CREATE FUNCTION upg_catalog.float84div(upg_catalog.float8, upg_catalog.float4) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float84div';
 CREATE FUNCTION upg_catalog.float84mi(upg_catalog.float8, upg_catalog.float4) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float84mi';
 CREATE FUNCTION upg_catalog.float84mul(upg_catalog.float8, upg_catalog.float4) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float84mul';
 CREATE FUNCTION upg_catalog.float84ne(upg_catalog.float8, upg_catalog.float4) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'float84ne';
 CREATE FUNCTION upg_catalog.float84pl(upg_catalog.float8, upg_catalog.float4) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float84pl';
 CREATE FUNCTION upg_catalog.float8_accum(upg_catalog._float8, upg_catalog.float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_accum';
 CREATE FUNCTION upg_catalog.float8_amalg(upg_catalog._float8, upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_amalg';
 CREATE FUNCTION upg_catalog.float8_avg(upg_catalog.bytea) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_avg';
 CREATE FUNCTION upg_catalog.float8_avg_accum(upg_catalog.bytea, upg_catalog.float8) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'float8_avg_accum';
 CREATE FUNCTION upg_catalog.float8_avg_amalg(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'float8_avg_amalg';
 CREATE FUNCTION upg_catalog.float8_avg_decum(upg_catalog.bytea, upg_catalog.float8) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'float8_avg_decum';
 CREATE FUNCTION upg_catalog.float8_avg_demalg(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'float8_avg_demalg';
 CREATE FUNCTION upg_catalog.float8_corr(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_corr';
 CREATE FUNCTION upg_catalog.float8_covar_pop(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_covar_pop';
 CREATE FUNCTION upg_catalog.float8_covar_samp(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_covar_samp';
 CREATE FUNCTION upg_catalog.float8_decum(upg_catalog._float8, upg_catalog.float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_decum';
 CREATE FUNCTION upg_catalog.float8_demalg(upg_catalog._float8, upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_demalg';
 CREATE FUNCTION upg_catalog.float8_matrix_accum(upg_catalog._float8, upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_add';
 CREATE FUNCTION upg_catalog.float8_mregr_accum(upg_catalog._float8, upg_catalog.float8, upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_mregr_accum';
 CREATE FUNCTION upg_catalog.float8_mregr_coef(upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_mregr_coef';
 CREATE FUNCTION upg_catalog.float8_mregr_combine(upg_catalog._float8, upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_mregr_combine';
 CREATE FUNCTION upg_catalog.float8_mregr_r2(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_mregr_r2';
 CREATE FUNCTION upg_catalog.float8_pivot_accum(upg_catalog._float8, upg_catalog._text, upg_catalog.text, upg_catalog.float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE AS 'float8_pivot_accum';
 CREATE FUNCTION upg_catalog.float8_regr_accum(upg_catalog._float8, upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_accum';
 CREATE FUNCTION upg_catalog.float8_regr_amalg(upg_catalog._float8, upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_amalg';
 CREATE FUNCTION upg_catalog.float8_regr_avgx(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_avgx';
 CREATE FUNCTION upg_catalog.float8_regr_avgy(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_avgy';
 CREATE FUNCTION upg_catalog.float8_regr_intercept(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_intercept';
 CREATE FUNCTION upg_catalog.float8_regr_r2(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_r2';
 CREATE FUNCTION upg_catalog.float8_regr_slope(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_slope';
 CREATE FUNCTION upg_catalog.float8_regr_sxx(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_sxx';
 CREATE FUNCTION upg_catalog.float8_regr_sxy(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_sxy';
 CREATE FUNCTION upg_catalog.float8_regr_syy(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_regr_syy';
 CREATE FUNCTION upg_catalog.float8_stddev_pop(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_stddev_pop';
 CREATE FUNCTION upg_catalog.float8_stddev_samp(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_stddev_samp';
 CREATE FUNCTION upg_catalog.float8_var_pop(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_var_pop';
 CREATE FUNCTION upg_catalog.float8_var_samp(upg_catalog._float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_var_samp';
 CREATE FUNCTION upg_catalog.float8abs(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8abs';
 CREATE FUNCTION upg_catalog.float8div(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8div';
 CREATE FUNCTION upg_catalog.float8larger(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8larger';
 CREATE FUNCTION upg_catalog.float8mi(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8mi';
 CREATE FUNCTION upg_catalog.float8mul(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8mul';
 CREATE FUNCTION upg_catalog.float8ne(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'float8ne';
 CREATE FUNCTION upg_catalog.float8pl(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8pl';
 CREATE FUNCTION upg_catalog.float8smaller(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8smaller';
 CREATE FUNCTION upg_catalog.float8um(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8um';
 CREATE FUNCTION upg_catalog.float8up(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8up';
 CREATE FUNCTION upg_catalog.floor(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_floor';
 CREATE FUNCTION upg_catalog.floor(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dfloor';
 CREATE FUNCTION upg_catalog.flt4_mul_cash(upg_catalog.float4, upg_catalog.money) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'flt4_mul_cash';
 CREATE FUNCTION upg_catalog.flt8_mul_cash(upg_catalog.float8, upg_catalog.money) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'flt8_mul_cash';
 CREATE FUNCTION upg_catalog.fmgr_c_validator(upg_catalog.oid) RETURNS upg_catalog.void LANGUAGE internal STABLE STRICT AS 'fmgr_c_validator';
 CREATE FUNCTION upg_catalog.fmgr_internal_validator(upg_catalog.oid) RETURNS upg_catalog.void LANGUAGE internal STABLE STRICT AS 'fmgr_internal_validator';
 CREATE FUNCTION upg_catalog.fmgr_sql_validator(upg_catalog.oid) RETURNS upg_catalog.void LANGUAGE internal STABLE STRICT AS 'fmgr_sql_validator';
 CREATE FUNCTION upg_catalog.format_type(upg_catalog.oid, upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal STABLE AS 'format_type';
 CREATE FUNCTION upg_catalog.generate_series(upg_catalog.int4, upg_catalog.int4) RETURNS SETOF upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'generate_series_int4';
 CREATE FUNCTION upg_catalog.generate_series(upg_catalog.int4, upg_catalog.int4, upg_catalog.int4) RETURNS SETOF upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'generate_series_step_int4';
 CREATE FUNCTION upg_catalog.generate_series(upg_catalog.int8, upg_catalog.int8) RETURNS SETOF upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'generate_series_int8';
 CREATE FUNCTION upg_catalog.generate_series(upg_catalog.int8, upg_catalog.int8, upg_catalog.int8) RETURNS SETOF upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'generate_series_step_int8';
 CREATE FUNCTION upg_catalog.get_ao_compression_ratio(upg_catalog.oid) RETURNS upg_catalog.float8 LANGUAGE internal VOLATILE AS 'get_ao_compression_ratio_oid';
 CREATE FUNCTION upg_catalog.get_ao_compression_ratio(upg_catalog.text) RETURNS upg_catalog.float8 LANGUAGE internal VOLATILE AS 'get_ao_compression_ratio_name';
 CREATE FUNCTION upg_catalog.get_ao_distribution(IN relname upg_catalog.text, OUT segmentid upg_catalog.int4, OUT tupcount upg_catalog.float8) RETURNS SETOF pg_catalog.record LANGUAGE internal VOLATILE AS 'get_ao_distribution_name';
 CREATE FUNCTION upg_catalog.get_ao_distribution(IN reloid upg_catalog.oid, OUT segmentid upg_catalog.int4, OUT tupcount upg_catalog.float8) RETURNS SETOF pg_catalog.record LANGUAGE internal VOLATILE AS 'get_ao_distribution_oid';
 CREATE FUNCTION upg_catalog.get_bit(upg_catalog.bytea, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'byteaGetBit';
 CREATE FUNCTION upg_catalog.get_byte(upg_catalog.bytea, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'byteaGetByte';
 CREATE FUNCTION upg_catalog.getdatabaseencoding() RETURNS upg_catalog.name LANGUAGE internal STABLE STRICT AS 'getdatabaseencoding';
 CREATE FUNCTION upg_catalog.getpgusername() RETURNS upg_catalog.name LANGUAGE internal STABLE STRICT AS 'current_user';
 CREATE FUNCTION upg_catalog.ginbeginscan(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'ginbeginscan';
 CREATE FUNCTION upg_catalog.ginbuild(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'ginbuild';
 CREATE FUNCTION upg_catalog.ginbulkdelete(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'ginbulkdelete';
 CREATE FUNCTION upg_catalog.gincostestimate(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'gincostestimate';
 CREATE FUNCTION upg_catalog.ginendscan(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'ginendscan';
 CREATE FUNCTION upg_catalog.gingetmulti(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'gingetmulti';
 CREATE FUNCTION upg_catalog.gingettuple(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'gingettuple';
 CREATE FUNCTION upg_catalog.gininsert(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'gininsert';
 CREATE FUNCTION upg_catalog.ginmarkpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'ginmarkpos';
 CREATE FUNCTION upg_catalog.ginoptions(upg_catalog._text, upg_catalog.bool) RETURNS upg_catalog.bytea LANGUAGE internal STABLE STRICT AS 'ginoptions';
 CREATE FUNCTION upg_catalog.ginrescan(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'ginrescan';
 CREATE FUNCTION upg_catalog.ginrestrpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'ginrestrpos';
 CREATE FUNCTION upg_catalog.ginvacuumcleanup(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'ginvacuumcleanup';
 CREATE FUNCTION upg_catalog.gistbeginscan(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'gistbeginscan';
 CREATE FUNCTION upg_catalog.gistbuild(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'gistbuild';
 CREATE FUNCTION upg_catalog.gistbulkdelete(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'gistbulkdelete';
 CREATE FUNCTION upg_catalog.gistcostestimate(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'gistcostestimate';
 CREATE FUNCTION upg_catalog.gistendscan(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'gistendscan';
 CREATE FUNCTION upg_catalog.gistgetmulti(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'gistgetmulti';
 CREATE FUNCTION upg_catalog.gistgettuple(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'gistgettuple';
 CREATE FUNCTION upg_catalog.gistinsert(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'gistinsert';
 CREATE FUNCTION upg_catalog.gistmarkpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'gistmarkpos';
 CREATE FUNCTION upg_catalog.gistoptions(upg_catalog._text, upg_catalog.bool) RETURNS upg_catalog.bytea LANGUAGE internal STABLE STRICT AS 'gistoptions';
 CREATE FUNCTION upg_catalog.gistrescan(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'gistrescan';
 CREATE FUNCTION upg_catalog.gistrestrpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'gistrestrpos';
 CREATE FUNCTION upg_catalog.gistvacuumcleanup(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'gistvacuumcleanup';
 CREATE FUNCTION upg_catalog.gp_activate_standby() RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_activate_standby';
 CREATE FUNCTION upg_catalog.gp_add_global_sequence_entry(upg_catalog.tid, upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_add_global_sequence_entry';
 CREATE FUNCTION upg_catalog.gp_add_master_standby(upg_catalog.text, upg_catalog.text, upg_catalog._text) RETURNS upg_catalog.int2 LANGUAGE internal VOLATILE AS 'gp_add_master_standby';
 CREATE FUNCTION upg_catalog.gp_add_persistent_database_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.oid, upg_catalog.int2, upg_catalog.int8, upg_catalog.int2, upg_catalog.int4, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_add_persistent_database_node_entry';
 CREATE FUNCTION upg_catalog.gp_add_persistent_filespace_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.int2, upg_catalog.text, upg_catalog.int2, upg_catalog.text, upg_catalog.int2, upg_catalog.int8, upg_catalog.int2, upg_catalog.int4, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_add_persistent_filespace_node_entry';
 CREATE FUNCTION upg_catalog.gp_add_persistent_relation_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.oid, upg_catalog.oid, upg_catalog.int4, upg_catalog.int2, upg_catalog.int2, upg_catalog.int8, upg_catalog.int2, upg_catalog.int2, upg_catalog.bool, upg_catalog.int8, upg_catalog.gpxlogloc, upg_catalog.int4, upg_catalog.int8, upg_catalog.int8, upg_catalog.int4, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_add_persistent_relation_node_entry';
 CREATE FUNCTION upg_catalog.gp_add_persistent_tablespace_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.oid, upg_catalog.int2, upg_catalog.int8, upg_catalog.int2, upg_catalog.int4, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_add_persistent_tablespace_node_entry';
 CREATE FUNCTION upg_catalog.gp_add_relation_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid, upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_add_relation_node_entry';
 CREATE FUNCTION upg_catalog.gp_add_segment(upg_catalog.text, upg_catalog.text, upg_catalog.int4, upg_catalog._text) RETURNS upg_catalog.int2 LANGUAGE internal VOLATILE AS 'gp_add_segment';
 CREATE FUNCTION upg_catalog.gp_add_segment_mirror(upg_catalog.int2, upg_catalog.text, upg_catalog.text, upg_catalog.int4, upg_catalog.int4, upg_catalog._text) RETURNS upg_catalog.int2 LANGUAGE internal VOLATILE AS 'gp_add_segment_mirror';
 CREATE FUNCTION upg_catalog.gp_add_segment_persistent_entries(upg_catalog.int2, upg_catalog.int2, upg_catalog._text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'gp_add_segment_persistent_entries';
 CREATE FUNCTION upg_catalog.gp_adjust_priority(upg_catalog.int4, upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'gp_adjust_priority_int';
 CREATE FUNCTION upg_catalog.gp_adjust_priority(upg_catalog.int4, upg_catalog.int4, upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'gp_adjust_priority_value';
 CREATE FUNCTION upg_catalog.gp_backup_launch(upg_catalog.text, upg_catalog.text, upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal VOLATILE AS 'gp_backup_launch__';
 CREATE FUNCTION upg_catalog.gp_changetracking_log(IN filetype upg_catalog.int4, OUT segment_id upg_catalog.int2, OUT dbid upg_catalog.int2, OUT space upg_catalog.oid, OUT db upg_catalog.oid, OUT rel upg_catalog.oid, OUT xlogloc upg_catalog.gpxlogloc, OUT blocknum upg_catalog.int4, OUT persistent_tid upg_catalog.tid, OUT persistent_sn upg_catalog.int8) RETURNS SETOF pg_catalog.record LANGUAGE internal VOLATILE AS 'gp_changetracking_log';
 CREATE FUNCTION upg_catalog.gp_delete_global_sequence_entry(upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_delete_global_sequence_entry';
 CREATE FUNCTION upg_catalog.gp_delete_persistent_database_node_entry(upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_delete_persistent_database_node_entry';
 CREATE FUNCTION upg_catalog.gp_delete_persistent_filespace_node_entry(upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_delete_persistent_filespace_node_entry';
 CREATE FUNCTION upg_catalog.gp_delete_persistent_relation_node_entry(upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_delete_persistent_relation_node_entry';
 CREATE FUNCTION upg_catalog.gp_delete_persistent_tablespace_node_entry(upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_delete_persistent_tablespace_node_entry';
 CREATE FUNCTION upg_catalog.gp_delete_relation_node_entry(upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_delete_relation_node_entry';
 CREATE FUNCTION upg_catalog.gp_deprecated() RETURNS upg_catalog.void LANGUAGE internal IMMUTABLE AS 'gp_deprecated';
 CREATE FUNCTION upg_catalog.gp_distributed_log() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE AS 'gp_distributed_log';
 CREATE FUNCTION upg_catalog.gp_distributed_xacts() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE AS 'gp_distributed_xacts__';
 CREATE FUNCTION upg_catalog.gp_distributed_xid() RETURNS upg_catalog.xid LANGUAGE internal VOLATILE STRICT AS 'gp_distributed_xid';
 CREATE FUNCTION upg_catalog.gp_elog(upg_catalog.text) RETURNS upg_catalog.void LANGUAGE internal IMMUTABLE STRICT AS 'gp_elog';
 CREATE FUNCTION upg_catalog.gp_elog(upg_catalog.text, upg_catalog.bool) RETURNS upg_catalog.void LANGUAGE internal IMMUTABLE STRICT AS 'gp_elog';
 CREATE FUNCTION upg_catalog.gp_execution_dbid() RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE AS 'gp_execution_dbid';
 CREATE FUNCTION upg_catalog.gp_execution_segment() RETURNS SETOF upg_catalog.int4 LANGUAGE internal VOLATILE AS 'mpp_execution_segment';
 CREATE FUNCTION upg_catalog.gp_fault_inject(upg_catalog.int4, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'gp_fault_inject';
 CREATE FUNCTION upg_catalog.gp_list_backend_priorities() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE AS 'gp_list_backend_priorities';
 CREATE FUNCTION upg_catalog.gp_max_distributed_xid() RETURNS upg_catalog.xid LANGUAGE internal VOLATILE STRICT AS 'gp_max_distributed_xid';
 CREATE FUNCTION upg_catalog.gp_persistent_build_db(upg_catalog.bool) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE AS 'gp_persistent_build_db';
 CREATE FUNCTION upg_catalog.gp_persistent_relation_node_check() RETURNS SETOF upg_catalog.gp_persistent_relation_node LANGUAGE internal VOLATILE AS 'gp_persistent_relation_node_check';
 CREATE FUNCTION upg_catalog.gp_pgdatabase() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE AS 'gp_pgdatabase__';
 CREATE FUNCTION upg_catalog.gp_prep_new_segment(upg_catalog._text) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_prep_new_segment';
 CREATE FUNCTION upg_catalog.gp_read_backup_file(upg_catalog.text, upg_catalog.text, upg_catalog.regproc) RETURNS upg_catalog.text LANGUAGE internal VOLATILE AS 'gp_read_backup_file__';
 CREATE FUNCTION upg_catalog.gp_remove_master_standby() RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_remove_master_standby';
 CREATE FUNCTION upg_catalog.gp_remove_segment(upg_catalog.int2) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_remove_segment';
 CREATE FUNCTION upg_catalog.gp_remove_segment_mirror(upg_catalog.int2) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_remove_segment_mirror';
 CREATE FUNCTION upg_catalog.gp_remove_segment_persistent_entries(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'gp_remove_segment_persistent_entries';
 CREATE FUNCTION upg_catalog.gp_restore_launch(upg_catalog.text, upg_catalog.text, upg_catalog.text, upg_catalog.text, upg_catalog.text, upg_catalog.text, upg_catalog.int4, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal VOLATILE AS 'gp_restore_launch__';
 CREATE FUNCTION upg_catalog.gp_statistics_estimate_reltuples_relpages_oid(upg_catalog.oid) RETURNS upg_catalog._float4 LANGUAGE internal VOLATILE STRICT AS 'gp_statistics_estimate_reltuples_relpages_oid';
 CREATE FUNCTION upg_catalog.gp_transaction_log() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE AS 'gp_transaction_log';
 CREATE FUNCTION upg_catalog.gp_update_ao_master_stats(upg_catalog.oid) RETURNS upg_catalog.float8 LANGUAGE internal VOLATILE AS 'gp_update_ao_master_stats_oid';
 CREATE FUNCTION upg_catalog.gp_update_ao_master_stats(upg_catalog.text) RETURNS upg_catalog.float8 LANGUAGE internal VOLATILE AS 'gp_update_ao_master_stats_name';
 CREATE FUNCTION upg_catalog.gp_update_global_sequence_entry(upg_catalog.tid, upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_update_global_sequence_entry';
 CREATE FUNCTION upg_catalog.gp_update_persistent_database_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.oid, upg_catalog.int2, upg_catalog.int8, upg_catalog.int2, upg_catalog.int4, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_update_persistent_database_node_entry';
 CREATE FUNCTION upg_catalog.gp_update_persistent_filespace_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.int2, upg_catalog.text, upg_catalog.int2, upg_catalog.text, upg_catalog.int2, upg_catalog.int8, upg_catalog.int2, upg_catalog.int4, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_update_persistent_filespace_node_entry';
 CREATE FUNCTION upg_catalog.gp_update_persistent_relation_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.oid, upg_catalog.oid, upg_catalog.int4, upg_catalog.int2, upg_catalog.int2, upg_catalog.int8, upg_catalog.int2, upg_catalog.int2, upg_catalog.bool, upg_catalog.int8, upg_catalog.gpxlogloc, upg_catalog.int4, upg_catalog.int8, upg_catalog.int8, upg_catalog.int4, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_update_persistent_relation_node_entry';
 CREATE FUNCTION upg_catalog.gp_update_persistent_tablespace_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.oid, upg_catalog.int2, upg_catalog.int8, upg_catalog.int2, upg_catalog.int4, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_update_persistent_tablespace_node_entry';
 CREATE FUNCTION upg_catalog.gp_update_relation_node_entry(upg_catalog.tid, upg_catalog.oid, upg_catalog.int4, upg_catalog.int8, upg_catalog.tid, upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'gp_update_relation_node_entry';
 CREATE FUNCTION upg_catalog.gp_write_backup_file(upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal VOLATILE AS 'gp_write_backup_file__';
 CREATE FUNCTION upg_catalog.gpdb_fdw_validator(upg_catalog._text, upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'gpdb_fdw_validator';
 CREATE FUNCTION upg_catalog.gpxlogloclarger(upg_catalog.gpxlogloc, upg_catalog.gpxlogloc) RETURNS upg_catalog.gpxlogloc LANGUAGE internal IMMUTABLE STRICT AS 'gpxlogloclarger';
 CREATE FUNCTION upg_catalog.gpxloglocne(upg_catalog.gpxlogloc, upg_catalog.gpxlogloc) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'gpxloglocne';
 CREATE FUNCTION upg_catalog.gpxloglocsmaller(upg_catalog.gpxlogloc, upg_catalog.gpxlogloc) RETURNS upg_catalog.gpxlogloc LANGUAGE internal IMMUTABLE STRICT AS 'gpxloglocsmaller';
 CREATE FUNCTION upg_catalog.has_database_privilege(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_database_privilege_name_id';
 CREATE FUNCTION upg_catalog.has_database_privilege(upg_catalog.name, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_database_privilege_name_name';
 CREATE FUNCTION upg_catalog.has_database_privilege(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_database_privilege_id_id';
 CREATE FUNCTION upg_catalog.has_database_privilege(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_database_privilege_id';
 CREATE FUNCTION upg_catalog.has_database_privilege(upg_catalog.oid, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_database_privilege_id_name';
 CREATE FUNCTION upg_catalog.has_database_privilege(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_database_privilege_name';
 CREATE FUNCTION upg_catalog.has_foreign_data_wrapper_privilege(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_foreign_data_wrapper_privilege_name_id';
 CREATE FUNCTION upg_catalog.has_foreign_data_wrapper_privilege(upg_catalog.name, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_foreign_data_wrapper_privilege_name_name';
 CREATE FUNCTION upg_catalog.has_foreign_data_wrapper_privilege(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_foreign_data_wrapper_privilege_id_id';
 CREATE FUNCTION upg_catalog.has_foreign_data_wrapper_privilege(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_foreign_data_wrapper_privilege_id';
 CREATE FUNCTION upg_catalog.has_foreign_data_wrapper_privilege(upg_catalog.oid, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_foreign_data_wrapper_privilege_id_name';
 CREATE FUNCTION upg_catalog.has_foreign_data_wrapper_privilege(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_foreign_data_wrapper_privilege_name';
 CREATE FUNCTION upg_catalog.has_function_privilege(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_function_privilege_name_id';
 CREATE FUNCTION upg_catalog.has_function_privilege(upg_catalog.name, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_function_privilege_name_name';
 CREATE FUNCTION upg_catalog.has_function_privilege(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_function_privilege_id_id';
 CREATE FUNCTION upg_catalog.has_function_privilege(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_function_privilege_id';
 CREATE FUNCTION upg_catalog.has_function_privilege(upg_catalog.oid, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_function_privilege_id_name';
 CREATE FUNCTION upg_catalog.has_function_privilege(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_function_privilege_name';
 CREATE FUNCTION upg_catalog.has_language_privilege(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_language_privilege_name_id';
 CREATE FUNCTION upg_catalog.has_language_privilege(upg_catalog.name, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_language_privilege_name_name';
 CREATE FUNCTION upg_catalog.has_language_privilege(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_language_privilege_id_id';
 CREATE FUNCTION upg_catalog.has_language_privilege(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_language_privilege_id';
 CREATE FUNCTION upg_catalog.has_language_privilege(upg_catalog.oid, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_language_privilege_id_name';
 CREATE FUNCTION upg_catalog.has_language_privilege(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_language_privilege_name';
 CREATE FUNCTION upg_catalog.has_schema_privilege(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_schema_privilege_name_id';
 CREATE FUNCTION upg_catalog.has_schema_privilege(upg_catalog.name, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_schema_privilege_name_name';
 CREATE FUNCTION upg_catalog.has_schema_privilege(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_schema_privilege_id_id';
 CREATE FUNCTION upg_catalog.has_schema_privilege(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_schema_privilege_id';
 CREATE FUNCTION upg_catalog.has_schema_privilege(upg_catalog.oid, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_schema_privilege_id_name';
 CREATE FUNCTION upg_catalog.has_schema_privilege(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_schema_privilege_name';
 CREATE FUNCTION upg_catalog.has_server_privilege(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_server_privilege_name_id';
 CREATE FUNCTION upg_catalog.has_server_privilege(upg_catalog.name, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_server_privilege_name_name';
 CREATE FUNCTION upg_catalog.has_server_privilege(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_server_privilege_id_id';
 CREATE FUNCTION upg_catalog.has_server_privilege(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_server_privilege_id';
 CREATE FUNCTION upg_catalog.has_server_privilege(upg_catalog.oid, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_server_privilege_id_name';
 CREATE FUNCTION upg_catalog.has_server_privilege(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_server_privilege_name';
 CREATE FUNCTION upg_catalog.has_table_privilege(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_table_privilege_name_id';
 CREATE FUNCTION upg_catalog.has_table_privilege(upg_catalog.name, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_table_privilege_name_name';
 CREATE FUNCTION upg_catalog.has_table_privilege(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_table_privilege_id_id';
 CREATE FUNCTION upg_catalog.has_table_privilege(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_table_privilege_id';
 CREATE FUNCTION upg_catalog.has_table_privilege(upg_catalog.oid, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_table_privilege_id_name';
 CREATE FUNCTION upg_catalog.has_table_privilege(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_table_privilege_name';
 CREATE FUNCTION upg_catalog.has_tablespace_privilege(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_tablespace_privilege_name_id';
 CREATE FUNCTION upg_catalog.has_tablespace_privilege(upg_catalog.name, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_tablespace_privilege_name_name';
 CREATE FUNCTION upg_catalog.has_tablespace_privilege(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_tablespace_privilege_id_id';
 CREATE FUNCTION upg_catalog.has_tablespace_privilege(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_tablespace_privilege_id';
 CREATE FUNCTION upg_catalog.has_tablespace_privilege(upg_catalog.oid, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_tablespace_privilege_id_name';
 CREATE FUNCTION upg_catalog.has_tablespace_privilege(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'has_tablespace_privilege_name';
 CREATE FUNCTION upg_catalog.hashbeginscan(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'hashbeginscan';
 CREATE FUNCTION upg_catalog.hashbuild(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'hashbuild';
 CREATE FUNCTION upg_catalog.hashbulkdelete(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'hashbulkdelete';
 CREATE FUNCTION upg_catalog.hashcostestimate(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'hashcostestimate';
 CREATE FUNCTION upg_catalog.hashendscan(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'hashendscan';
 CREATE FUNCTION upg_catalog.hashgetmulti(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'hashgetmulti';
 CREATE FUNCTION upg_catalog.hashgettuple(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'hashgettuple';
 CREATE FUNCTION upg_catalog.hashinsert(upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'hashinsert';
 CREATE FUNCTION upg_catalog.hashmarkpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'hashmarkpos';
 CREATE FUNCTION upg_catalog.hashoptions(upg_catalog._text, upg_catalog.bool) RETURNS upg_catalog.bytea LANGUAGE internal STABLE STRICT AS 'hashoptions';
 CREATE FUNCTION upg_catalog.hashrescan(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'hashrescan';
 CREATE FUNCTION upg_catalog.hashrestrpos(upg_catalog.internal) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'hashrestrpos';
 CREATE FUNCTION upg_catalog.hashvacuumcleanup(upg_catalog.internal, upg_catalog.internal) RETURNS upg_catalog.internal LANGUAGE internal VOLATILE STRICT AS 'hashvacuumcleanup';
 CREATE FUNCTION upg_catalog.height(upg_catalog.box) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'box_height';
 CREATE FUNCTION upg_catalog.hostmask(upg_catalog.inet) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'network_hostmask';
 CREATE FUNCTION upg_catalog.inet_client_addr() RETURNS upg_catalog.inet LANGUAGE internal STABLE AS 'inet_client_addr';
 CREATE FUNCTION upg_catalog.inet_client_port() RETURNS upg_catalog.int4 LANGUAGE internal STABLE AS 'inet_client_port';
 CREATE FUNCTION upg_catalog.inet_server_addr() RETURNS upg_catalog.inet LANGUAGE internal STABLE AS 'inet_server_addr';
 CREATE FUNCTION upg_catalog.inet_server_port() RETURNS upg_catalog.int4 LANGUAGE internal STABLE AS 'inet_server_port';
 CREATE FUNCTION upg_catalog.inetand(upg_catalog.inet, upg_catalog.inet) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'inetand';
 CREATE FUNCTION upg_catalog.inetmi(upg_catalog.inet, upg_catalog.inet) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'inetmi';
 CREATE FUNCTION upg_catalog.inetmi_int8(upg_catalog.inet, upg_catalog.int8) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'inetmi_int8';
 CREATE FUNCTION upg_catalog.inetnot(upg_catalog.inet) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'inetnot';
 CREATE FUNCTION upg_catalog.inetor(upg_catalog.inet, upg_catalog.inet) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'inetor';
 CREATE FUNCTION upg_catalog.inetpl(upg_catalog.inet, upg_catalog.int8) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'inetpl';
 CREATE FUNCTION upg_catalog.initcap(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'initcap';
 CREATE FUNCTION upg_catalog.int24div(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int24div';
 CREATE FUNCTION upg_catalog.int24mi(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int24mi';
 CREATE FUNCTION upg_catalog.int24mod(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int24mod';
 CREATE FUNCTION upg_catalog.int24mul(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int24mul';
 CREATE FUNCTION upg_catalog.int24ne(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int24ne';
 CREATE FUNCTION upg_catalog.int24pl(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int24pl';
 CREATE FUNCTION upg_catalog.int28ne(upg_catalog.int2, upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int28ne';
 CREATE FUNCTION upg_catalog.int2_accum(upg_catalog._numeric, upg_catalog.int2) RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'int2_accum';
 CREATE FUNCTION upg_catalog.int2_avg_accum(upg_catalog.bytea, upg_catalog.int2) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'int2_avg_accum';
 CREATE FUNCTION upg_catalog.int2_avg_decum(upg_catalog.bytea, upg_catalog.int2) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'int2_avg_decum';
 CREATE FUNCTION upg_catalog.int2_decum(upg_catalog._numeric, upg_catalog.int2) RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'int2_decum';
 CREATE FUNCTION upg_catalog.int2_invsum(upg_catalog.int8, upg_catalog.int2) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE AS 'int2_invsum';
 CREATE FUNCTION upg_catalog.int2_matrix_accum(upg_catalog._int8, upg_catalog._int2) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE AS 'matrix_add';
 CREATE FUNCTION upg_catalog.int2_mul_cash(upg_catalog.int2, upg_catalog.money) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'int2_mul_cash';
 CREATE FUNCTION upg_catalog.int2_sum(upg_catalog.int8, upg_catalog.int2) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE AS 'int2_sum';
 CREATE FUNCTION upg_catalog.int2abs(upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2abs';
 CREATE FUNCTION upg_catalog.int2and(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2and';
 CREATE FUNCTION upg_catalog.int2div(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2div';
 CREATE FUNCTION upg_catalog.int2larger(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2larger';
 CREATE FUNCTION upg_catalog.int2mi(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2mi';
 CREATE FUNCTION upg_catalog.int2mod(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2mod';
 CREATE FUNCTION upg_catalog.int2mul(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2mul';
 CREATE FUNCTION upg_catalog.int2ne(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int2ne';
 CREATE FUNCTION upg_catalog.int2not(upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2not';
 CREATE FUNCTION upg_catalog.int2or(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2or';
 CREATE FUNCTION upg_catalog.int2pl(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2pl';
 CREATE FUNCTION upg_catalog.int2shl(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2shl';
 CREATE FUNCTION upg_catalog.int2shr(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2shr';
 CREATE FUNCTION upg_catalog.int2smaller(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2smaller';
 CREATE FUNCTION upg_catalog.int2um(upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2um';
 CREATE FUNCTION upg_catalog.int2up(upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2up';
 CREATE FUNCTION upg_catalog.int2xor(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2xor';
 CREATE FUNCTION upg_catalog.int42div(upg_catalog.int4, upg_catalog.int2) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int42div';
 CREATE FUNCTION upg_catalog.int42mi(upg_catalog.int4, upg_catalog.int2) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int42mi';
 CREATE FUNCTION upg_catalog.int42mod(upg_catalog.int4, upg_catalog.int2) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int42mod';
 CREATE FUNCTION upg_catalog.int42mul(upg_catalog.int4, upg_catalog.int2) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int42mul';
 CREATE FUNCTION upg_catalog.int42ne(upg_catalog.int4, upg_catalog.int2) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int42ne';
 CREATE FUNCTION upg_catalog.int42pl(upg_catalog.int4, upg_catalog.int2) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int42pl';
 CREATE FUNCTION upg_catalog.int48div(upg_catalog.int4, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int48div';
 CREATE FUNCTION upg_catalog.int48mi(upg_catalog.int4, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int48mi';
 CREATE FUNCTION upg_catalog.int48mul(upg_catalog.int4, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int48mul';
 CREATE FUNCTION upg_catalog.int48ne(upg_catalog.int4, upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int48ne';
 CREATE FUNCTION upg_catalog.int48pl(upg_catalog.int4, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int48pl';
 CREATE FUNCTION upg_catalog.int4_accum(upg_catalog._numeric, upg_catalog.int4) RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'int4_accum';
 CREATE FUNCTION upg_catalog.int4_avg_accum(upg_catalog.bytea, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'int4_avg_accum';
 CREATE FUNCTION upg_catalog.int4_avg_decum(upg_catalog.bytea, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'int4_avg_decum';
 CREATE FUNCTION upg_catalog.int4_decum(upg_catalog._numeric, upg_catalog.int4) RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'int4_decum';
 CREATE FUNCTION upg_catalog.int4_invsum(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE AS 'int4_invsum';
 CREATE FUNCTION upg_catalog.int4_matrix_accum(upg_catalog._int8, upg_catalog._int4) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE AS 'matrix_add';
 CREATE FUNCTION upg_catalog.int4_mul_cash(upg_catalog.int4, upg_catalog.money) RETURNS upg_catalog.money LANGUAGE internal IMMUTABLE STRICT AS 'int4_mul_cash';
 CREATE FUNCTION upg_catalog.int4_pivot_accum(upg_catalog._int4, upg_catalog._text, upg_catalog.text, upg_catalog.int4) RETURNS upg_catalog._int4 LANGUAGE internal IMMUTABLE AS 'int4_pivot_accum';
 CREATE FUNCTION upg_catalog.int4_sum(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE AS 'int4_sum';
 CREATE FUNCTION upg_catalog.int4abs(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4abs';
 CREATE FUNCTION upg_catalog.int4and(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4and';
 CREATE FUNCTION upg_catalog.int4div(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4div';
 CREATE FUNCTION upg_catalog.int4inc(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4inc';
 CREATE FUNCTION upg_catalog.int4larger(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4larger';
 CREATE FUNCTION upg_catalog.int4mi(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4mi';
 CREATE FUNCTION upg_catalog.int4mod(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4mod';
 CREATE FUNCTION upg_catalog.int4mul(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4mul';
 CREATE FUNCTION upg_catalog.int4ne(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int4ne';
 CREATE FUNCTION upg_catalog.int4not(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4not';
 CREATE FUNCTION upg_catalog.int4notin(upg_catalog.int4, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'int4notin';
 CREATE FUNCTION upg_catalog.int4or(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4or';
 CREATE FUNCTION upg_catalog.int4pl(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4pl';
 CREATE FUNCTION upg_catalog.int4shl(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4shl';
 CREATE FUNCTION upg_catalog.int4shr(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4shr';
 CREATE FUNCTION upg_catalog.int4smaller(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4smaller';
 CREATE FUNCTION upg_catalog.int4um(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4um';
 CREATE FUNCTION upg_catalog.int4up(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4up';
 CREATE FUNCTION upg_catalog.int4xor(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4xor';
 CREATE FUNCTION upg_catalog.int82ne(upg_catalog.int8, upg_catalog.int2) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int82ne';
 CREATE FUNCTION upg_catalog.int84div(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int84div';
 CREATE FUNCTION upg_catalog.int84mi(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int84mi';
 CREATE FUNCTION upg_catalog.int84mul(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int84mul';
 CREATE FUNCTION upg_catalog.int84ne(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int84ne';
 CREATE FUNCTION upg_catalog.int84pl(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int84pl';
 CREATE FUNCTION upg_catalog.int8_accum(upg_catalog._numeric, upg_catalog.int8) RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'int8_accum';
 CREATE FUNCTION upg_catalog.int8_avg(upg_catalog.bytea) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'int8_avg';
 CREATE FUNCTION upg_catalog.int8_avg_accum(upg_catalog.bytea, upg_catalog.int8) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'int8_avg_accum';
 CREATE FUNCTION upg_catalog.int8_avg_amalg(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'int8_avg_amalg';
 CREATE FUNCTION upg_catalog.int8_avg_decum(upg_catalog.bytea, upg_catalog.int8) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'int8_avg_decum';
 CREATE FUNCTION upg_catalog.int8_avg_demalg(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'int8_avg_demalg';
 CREATE FUNCTION upg_catalog.int8_decum(upg_catalog._numeric, upg_catalog.int8) RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'int8_decum';
 CREATE FUNCTION upg_catalog.int8_invsum(upg_catalog."numeric", upg_catalog.int8) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE AS 'int8_invsum';
 CREATE FUNCTION upg_catalog.int8_matrix_accum(upg_catalog._int8, upg_catalog._int8) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_add';
 CREATE FUNCTION upg_catalog.int8_pivot_accum(upg_catalog._int8, upg_catalog._text, upg_catalog.text, upg_catalog.int8) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE AS 'int8_pivot_accum';
 CREATE FUNCTION upg_catalog.int8_sum(upg_catalog."numeric", upg_catalog.int8) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE AS 'int8_sum';
 CREATE FUNCTION upg_catalog.int8abs(upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8abs';
 CREATE FUNCTION upg_catalog.int8and(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8and';
 CREATE FUNCTION upg_catalog.int8dec(upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8dec';
 CREATE FUNCTION upg_catalog.int8div(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8div';
 CREATE FUNCTION upg_catalog.int8inc(upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8inc';
 CREATE FUNCTION upg_catalog.int8inc_any(upg_catalog.int8, upg_catalog."any") RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8inc_any';
 CREATE FUNCTION upg_catalog.int8inc_float8_float8(upg_catalog.int8, upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8inc_float8_float8';
 CREATE FUNCTION upg_catalog.int8larger(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8larger';
 CREATE FUNCTION upg_catalog.int8mi(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8mi';
 CREATE FUNCTION upg_catalog.int8mod(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8mod';
 CREATE FUNCTION upg_catalog.int8mul(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8mul';
 CREATE FUNCTION upg_catalog.int8ne(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'int8ne';
 CREATE FUNCTION upg_catalog.int8not(upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8not';
 CREATE FUNCTION upg_catalog.int8or(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8or';
 CREATE FUNCTION upg_catalog.int8pl(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8pl';
 CREATE FUNCTION upg_catalog.int8shl(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8shl';
 CREATE FUNCTION upg_catalog.int8shr(upg_catalog.int8, upg_catalog.int4) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8shr';
 CREATE FUNCTION upg_catalog.int8smaller(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8smaller';
 CREATE FUNCTION upg_catalog.int8um(upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8um';
 CREATE FUNCTION upg_catalog.int8up(upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8up';
 CREATE FUNCTION upg_catalog.int8xor(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8xor';
 CREATE FUNCTION upg_catalog.inter_lb(upg_catalog.line, upg_catalog.box) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'inter_lb';
 CREATE FUNCTION upg_catalog.inter_sb(upg_catalog.lseg, upg_catalog.box) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'inter_sb';
 CREATE FUNCTION upg_catalog.inter_sl(upg_catalog.lseg, upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'inter_sl';
 CREATE FUNCTION upg_catalog.interval_accum(upg_catalog._interval, upg_catalog."interval") RETURNS upg_catalog._interval LANGUAGE internal IMMUTABLE STRICT AS 'interval_accum';
 CREATE FUNCTION upg_catalog.interval_amalg(upg_catalog._interval, upg_catalog._interval) RETURNS upg_catalog._interval LANGUAGE internal IMMUTABLE STRICT AS 'interval_amalg';
 CREATE FUNCTION upg_catalog.interval_avg(upg_catalog._interval) RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_avg';
 CREATE FUNCTION upg_catalog.interval_decum(upg_catalog._interval, upg_catalog."interval") RETURNS upg_catalog._interval LANGUAGE internal IMMUTABLE STRICT AS 'interval_decum';
 CREATE FUNCTION upg_catalog.interval_demalg(upg_catalog._interval, upg_catalog._interval) RETURNS upg_catalog._interval LANGUAGE internal IMMUTABLE STRICT AS 'interval_demalg';
 CREATE FUNCTION upg_catalog.interval_div(upg_catalog."interval", upg_catalog.float8) RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_div';
 CREATE FUNCTION upg_catalog.interval_larger(upg_catalog."interval", upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_larger';
 CREATE FUNCTION upg_catalog.interval_mi(upg_catalog."interval", upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_mi';
 CREATE FUNCTION upg_catalog.interval_mul(upg_catalog."interval", upg_catalog.float8) RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_mul';
 CREATE FUNCTION upg_catalog.interval_ne(upg_catalog."interval", upg_catalog."interval") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'interval_ne';
 CREATE FUNCTION upg_catalog.interval_pl(upg_catalog."interval", upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_pl';
 CREATE FUNCTION upg_catalog.interval_smaller(upg_catalog."interval", upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_smaller';
 CREATE FUNCTION upg_catalog.interval_um(upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_um';
 CREATE FUNCTION upg_catalog.intinterval(upg_catalog.abstime, upg_catalog.tinterval) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'intinterval';
 CREATE FUNCTION upg_catalog.isclosed(upg_catalog.path) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'path_isclosed';
 CREATE FUNCTION upg_catalog.isfalse(upg_catalog.bool) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'isfalse';
 CREATE FUNCTION upg_catalog.isfinite(upg_catalog."interval") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'interval_finite';
 CREATE FUNCTION upg_catalog.isfinite(upg_catalog."timestamp") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_finite';
 CREATE FUNCTION upg_catalog.isfinite(upg_catalog.abstime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'abstime_finite';
 CREATE FUNCTION upg_catalog.isfinite(upg_catalog.timestamptz) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_finite';
 CREATE FUNCTION upg_catalog.ishorizontal(upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_horizontal';
 CREATE FUNCTION upg_catalog.ishorizontal(upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_horizontal';
 CREATE FUNCTION upg_catalog.ishorizontal(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_horiz';
 CREATE FUNCTION upg_catalog.isnotfalse(upg_catalog.bool) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'isnotfalse';
 CREATE FUNCTION upg_catalog.isnottrue(upg_catalog.bool) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'isnottrue';
 CREATE FUNCTION upg_catalog.isopen(upg_catalog.path) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'path_isopen';
 CREATE FUNCTION upg_catalog.isparallel(upg_catalog.line, upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_parallel';
 CREATE FUNCTION upg_catalog.isparallel(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_parallel';
 CREATE FUNCTION upg_catalog.isperp(upg_catalog.line, upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_perp';
 CREATE FUNCTION upg_catalog.isperp(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_perp';
 CREATE FUNCTION upg_catalog.istrue(upg_catalog.bool) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'istrue';
 CREATE FUNCTION upg_catalog.isvertical(upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_vertical';
 CREATE FUNCTION upg_catalog.isvertical(upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_vertical';
 CREATE FUNCTION upg_catalog.isvertical(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_vert';
 CREATE FUNCTION upg_catalog.justify_days(upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_justify_days';
 CREATE FUNCTION upg_catalog.justify_hours(upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_justify_hours';
 CREATE FUNCTION upg_catalog.justify_interval(upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'interval_justify_interval';
 CREATE FUNCTION upg_catalog.lastval() RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'lastval';
 CREATE FUNCTION upg_catalog.length(upg_catalog."bit") RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'bitlength';
 CREATE FUNCTION upg_catalog.length(upg_catalog.bpchar) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'bpcharlen';
 CREATE FUNCTION upg_catalog.length(upg_catalog.bytea) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'byteaoctetlen';
 CREATE FUNCTION upg_catalog.length(upg_catalog.lseg) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'lseg_length';
 CREATE FUNCTION upg_catalog.length(upg_catalog.path) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'path_length';
 CREATE FUNCTION upg_catalog.length(upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'textlen';
 CREATE FUNCTION upg_catalog.like_escape(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'like_escape_bytea';
 CREATE FUNCTION upg_catalog.like_escape(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'like_escape';
 CREATE FUNCTION upg_catalog.line(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.line LANGUAGE internal IMMUTABLE STRICT AS 'line_construct_pp';
 CREATE FUNCTION upg_catalog.line_distance(upg_catalog.line, upg_catalog.line) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'line_distance';
 CREATE FUNCTION upg_catalog.line_horizontal(upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_horizontal';
 CREATE FUNCTION upg_catalog.line_interpt(upg_catalog.line, upg_catalog.line) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'line_interpt';
 CREATE FUNCTION upg_catalog.line_intersect(upg_catalog.line, upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_intersect';
 CREATE FUNCTION upg_catalog.line_parallel(upg_catalog.line, upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_parallel';
 CREATE FUNCTION upg_catalog.line_perp(upg_catalog.line, upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_perp';
 CREATE FUNCTION upg_catalog.line_vertical(upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'line_vertical';
 CREATE FUNCTION upg_catalog.ln(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_ln';
 CREATE FUNCTION upg_catalog.ln(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dlog1';
 CREATE FUNCTION upg_catalog.lo_close(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'lo_close';
 CREATE FUNCTION upg_catalog.lo_creat(upg_catalog.int4) RETURNS upg_catalog.oid LANGUAGE internal VOLATILE STRICT AS 'lo_creat';
 CREATE FUNCTION upg_catalog.lo_create(upg_catalog.oid) RETURNS upg_catalog.oid LANGUAGE internal VOLATILE STRICT AS 'lo_create';
 CREATE FUNCTION upg_catalog.lo_export(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'lo_export';
 CREATE FUNCTION upg_catalog.lo_import(upg_catalog.text) RETURNS upg_catalog.oid LANGUAGE internal VOLATILE STRICT AS 'lo_import';
 CREATE FUNCTION upg_catalog.lo_lseek(upg_catalog.int4, upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'lo_lseek';
 CREATE FUNCTION upg_catalog.lo_open(upg_catalog.oid, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'lo_open';
 CREATE FUNCTION upg_catalog.lo_tell(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'lo_tell';
 CREATE FUNCTION upg_catalog.lo_truncate(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'lo_truncate';
 CREATE FUNCTION upg_catalog.lo_unlink(upg_catalog.oid) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'lo_unlink';
 CREATE FUNCTION upg_catalog.loread(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal VOLATILE STRICT AS 'loread';
 CREATE FUNCTION upg_catalog.lower(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'lower';
 CREATE FUNCTION upg_catalog.lowrite(upg_catalog.int4, upg_catalog.bytea) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'lowrite';
 CREATE FUNCTION upg_catalog.lpad(upg_catalog.text, upg_catalog.int4, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'lpad';
 CREATE FUNCTION upg_catalog.lseg(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.lseg LANGUAGE internal IMMUTABLE STRICT AS 'lseg_construct';
 CREATE FUNCTION upg_catalog.lseg_center(upg_catalog.lseg) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'lseg_center';
 CREATE FUNCTION upg_catalog.lseg_distance(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'lseg_distance';
 CREATE FUNCTION upg_catalog.lseg_horizontal(upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_horizontal';
 CREATE FUNCTION upg_catalog.lseg_interpt(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'lseg_interpt';
 CREATE FUNCTION upg_catalog.lseg_intersect(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_intersect';
 CREATE FUNCTION upg_catalog.lseg_length(upg_catalog.lseg) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'lseg_length';
 CREATE FUNCTION upg_catalog.lseg_ne(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_ne';
 CREATE FUNCTION upg_catalog.lseg_parallel(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_parallel';
 CREATE FUNCTION upg_catalog.lseg_perp(upg_catalog.lseg, upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_perp';
 CREATE FUNCTION upg_catalog.lseg_vertical(upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'lseg_vertical';
 CREATE FUNCTION upg_catalog.ltrim(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'ltrim1';
 CREATE FUNCTION upg_catalog.ltrim(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'ltrim';
 CREATE FUNCTION upg_catalog.macaddr_ne(upg_catalog.macaddr, upg_catalog.macaddr) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'macaddr_ne';
 CREATE FUNCTION upg_catalog.makeaclitem(upg_catalog.oid, upg_catalog.oid, upg_catalog.text, upg_catalog.bool) RETURNS upg_catalog.aclitem LANGUAGE internal IMMUTABLE STRICT AS 'makeaclitem';
 CREATE FUNCTION upg_catalog.masklen(upg_catalog.inet) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'network_masklen';
 CREATE FUNCTION upg_catalog.matrix_add(upg_catalog._float8, upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_add';
 CREATE FUNCTION upg_catalog.matrix_add(upg_catalog._int2, upg_catalog._int2) RETURNS upg_catalog._int2 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_add';
 CREATE FUNCTION upg_catalog.matrix_add(upg_catalog._int4, upg_catalog._int4) RETURNS upg_catalog._int4 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_add';
 CREATE FUNCTION upg_catalog.matrix_add(upg_catalog._int8, upg_catalog._int8) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_add';
 CREATE FUNCTION upg_catalog.matrix_multiply(upg_catalog._float8, upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_multiply';
 CREATE FUNCTION upg_catalog.matrix_multiply(upg_catalog._float8, upg_catalog.float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'float8_matrix_smultiply';
 CREATE FUNCTION upg_catalog.matrix_multiply(upg_catalog._int2, upg_catalog._int2) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_multiply';
 CREATE FUNCTION upg_catalog.matrix_multiply(upg_catalog._int4, upg_catalog._int4) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_multiply';
 CREATE FUNCTION upg_catalog.matrix_multiply(upg_catalog._int8, upg_catalog._int8) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'matrix_multiply';
 CREATE FUNCTION upg_catalog.matrix_multiply(upg_catalog._int8, upg_catalog.int8) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8_matrix_smultiply';
 CREATE FUNCTION upg_catalog.matrix_transpose(upg_catalog.anyarray) RETURNS upg_catalog.anyarray LANGUAGE internal IMMUTABLE STRICT AS 'matrix_transpose';
 CREATE FUNCTION upg_catalog.md5(upg_catalog.bytea) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'md5_bytea';
 CREATE FUNCTION upg_catalog.md5(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'md5_text';
 CREATE FUNCTION upg_catalog.mktinterval(upg_catalog.abstime, upg_catalog.abstime) RETURNS upg_catalog.tinterval LANGUAGE internal IMMUTABLE STRICT AS 'mktinterval';
 CREATE FUNCTION upg_catalog.mod(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_mod';
 CREATE FUNCTION upg_catalog.mod(upg_catalog.int2, upg_catalog.int2) RETURNS upg_catalog.int2 LANGUAGE internal IMMUTABLE STRICT AS 'int2mod';
 CREATE FUNCTION upg_catalog.mod(upg_catalog.int2, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int24mod';
 CREATE FUNCTION upg_catalog.mod(upg_catalog.int4, upg_catalog.int2) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int42mod';
 CREATE FUNCTION upg_catalog.mod(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'int4mod';
 CREATE FUNCTION upg_catalog.mod(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'int8mod';
 CREATE FUNCTION upg_catalog.mul_d_interval(upg_catalog.float8, upg_catalog."interval") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'mul_d_interval';
 CREATE FUNCTION upg_catalog.name_pattern_ne(upg_catalog.name, upg_catalog.name) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'name_pattern_ne';
 CREATE FUNCTION upg_catalog.nameiclike(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'nameiclike';
 CREATE FUNCTION upg_catalog.nameicnlike(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'nameicnlike';
 CREATE FUNCTION upg_catalog.nameicregexeq(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'nameicregexeq';
 CREATE FUNCTION upg_catalog.nameicregexne(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'nameicregexne';
 CREATE FUNCTION upg_catalog.namelike(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'namelike';
 CREATE FUNCTION upg_catalog.namene(upg_catalog.name, upg_catalog.name) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'namene';
 CREATE FUNCTION upg_catalog.namenlike(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'namenlike';
 CREATE FUNCTION upg_catalog.nameregexeq(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'nameregexeq';
 CREATE FUNCTION upg_catalog.nameregexne(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'nameregexne';
 CREATE FUNCTION upg_catalog.nb_classify_accum(upg_catalog.nb_classification, upg_catalog._text, upg_catalog.int8, upg_catalog._int8, upg_catalog._int8) RETURNS upg_catalog.nb_classification LANGUAGE internal IMMUTABLE AS 'nb_classify_accum';
 CREATE FUNCTION upg_catalog.nb_classify_combine(upg_catalog.nb_classification, upg_catalog.nb_classification) RETURNS upg_catalog.nb_classification LANGUAGE internal IMMUTABLE AS 'nb_classify_combine';
 CREATE FUNCTION upg_catalog.nb_classify_final(upg_catalog.nb_classification) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'nb_classify_final';
 CREATE FUNCTION upg_catalog.netmask(upg_catalog.inet) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'network_netmask';
 CREATE FUNCTION upg_catalog.network(upg_catalog.inet) RETURNS upg_catalog.cidr LANGUAGE internal IMMUTABLE STRICT AS 'network_network';
 CREATE FUNCTION upg_catalog.network_ne(upg_catalog.inet, upg_catalog.inet) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'network_ne';
 CREATE FUNCTION upg_catalog.network_sub(upg_catalog.inet, upg_catalog.inet) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'network_sub';
 CREATE FUNCTION upg_catalog.network_subeq(upg_catalog.inet, upg_catalog.inet) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'network_subeq';
 CREATE FUNCTION upg_catalog.network_sup(upg_catalog.inet, upg_catalog.inet) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'network_sup';
 CREATE FUNCTION upg_catalog.network_supeq(upg_catalog.inet, upg_catalog.inet) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'network_supeq';
 CREATE FUNCTION upg_catalog.nextval(upg_catalog.regclass) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'nextval_oid';
 CREATE FUNCTION upg_catalog.nonnullvalue(upg_catalog."any") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'nonnullvalue';
 CREATE FUNCTION upg_catalog.notlike(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'byteanlike';
 CREATE FUNCTION upg_catalog.notlike(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'namenlike';
 CREATE FUNCTION upg_catalog.notlike(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textnlike';
 CREATE FUNCTION upg_catalog.now() RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'now';
 CREATE FUNCTION upg_catalog.npoints(upg_catalog.path) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'path_npoints';
 CREATE FUNCTION upg_catalog.npoints(upg_catalog.polygon) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'poly_npoints';
 CREATE FUNCTION upg_catalog.ntile_final(upg_catalog._int8, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'ntile_final';
 CREATE FUNCTION upg_catalog.ntile_prelim_bigint(upg_catalog.internal, upg_catalog.int8) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'ntile_prelim_bigint';
 CREATE FUNCTION upg_catalog.ntile_prelim_int(upg_catalog.internal, upg_catalog.int4) RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'ntile_prelim_int';
 CREATE FUNCTION upg_catalog.ntile_prelim_numeric(upg_catalog.internal, upg_catalog."numeric") RETURNS upg_catalog._int8 LANGUAGE internal IMMUTABLE STRICT AS 'ntile_prelim_numeric';
 CREATE FUNCTION upg_catalog.nullvalue(upg_catalog."any") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE AS 'nullvalue';
 CREATE FUNCTION upg_catalog.numeric_abs(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_abs';
 CREATE FUNCTION upg_catalog.numeric_accum(upg_catalog._numeric, upg_catalog."numeric") RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'numeric_accum';
 CREATE FUNCTION upg_catalog.numeric_add(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_add';
 CREATE FUNCTION upg_catalog.numeric_amalg(upg_catalog._numeric, upg_catalog._numeric) RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'numeric_amalg';
 CREATE FUNCTION upg_catalog.numeric_avg(upg_catalog.bytea) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_avg';
 CREATE FUNCTION upg_catalog.numeric_avg_accum(upg_catalog.bytea, upg_catalog."numeric") RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'numeric_avg_accum';
 CREATE FUNCTION upg_catalog.numeric_avg_amalg(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'numeric_avg_amalg';
 CREATE FUNCTION upg_catalog.numeric_avg_decum(upg_catalog.bytea, upg_catalog."numeric") RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'numeric_avg_decum';
 CREATE FUNCTION upg_catalog.numeric_avg_demalg(upg_catalog.bytea, upg_catalog.bytea) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'numeric_avg_demalg';
 CREATE FUNCTION upg_catalog.numeric_dec(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_dec';
 CREATE FUNCTION upg_catalog.numeric_decum(upg_catalog._numeric, upg_catalog."numeric") RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'numeric_decum';
 CREATE FUNCTION upg_catalog.numeric_demalg(upg_catalog._numeric, upg_catalog._numeric) RETURNS upg_catalog._numeric LANGUAGE internal IMMUTABLE STRICT AS 'numeric_demalg';
 CREATE FUNCTION upg_catalog.numeric_div(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_div';
 CREATE FUNCTION upg_catalog.numeric_exp(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_exp';
 CREATE FUNCTION upg_catalog.numeric_fac(upg_catalog.int8) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_fac';
 CREATE FUNCTION upg_catalog.numeric_inc(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_inc';
 CREATE FUNCTION upg_catalog.numeric_larger(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_larger';
 CREATE FUNCTION upg_catalog.numeric_ln(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_ln';
 CREATE FUNCTION upg_catalog.numeric_log(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_log';
 CREATE FUNCTION upg_catalog.numeric_mod(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_mod';
 CREATE FUNCTION upg_catalog.numeric_mul(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_mul';
 CREATE FUNCTION upg_catalog.numeric_ne(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'numeric_ne';
 CREATE FUNCTION upg_catalog.numeric_power(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_power';
 CREATE FUNCTION upg_catalog.numeric_smaller(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_smaller';
 CREATE FUNCTION upg_catalog.numeric_sqrt(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_sqrt';
 CREATE FUNCTION upg_catalog.numeric_stddev_pop(upg_catalog._numeric) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_stddev_pop';
 CREATE FUNCTION upg_catalog.numeric_stddev_samp(upg_catalog._numeric) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_stddev_samp';
 CREATE FUNCTION upg_catalog.numeric_sub(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_sub';
 CREATE FUNCTION upg_catalog.numeric_uminus(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_uminus';
 CREATE FUNCTION upg_catalog.numeric_uplus(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_uplus';
 CREATE FUNCTION upg_catalog.numeric_var_pop(upg_catalog._numeric) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_var_pop';
 CREATE FUNCTION upg_catalog.numeric_var_samp(upg_catalog._numeric) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_var_samp';
 CREATE FUNCTION upg_catalog.octet_length(upg_catalog."bit") RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'bitoctetlength';
 CREATE FUNCTION upg_catalog.octet_length(upg_catalog.bpchar) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'bpcharoctetlen';
 CREATE FUNCTION upg_catalog.octet_length(upg_catalog.bytea) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'byteaoctetlen';
 CREATE FUNCTION upg_catalog.octet_length(upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'textoctetlen';
 CREATE FUNCTION upg_catalog.oidlarger(upg_catalog.oid, upg_catalog.oid) RETURNS upg_catalog.oid LANGUAGE internal IMMUTABLE STRICT AS 'oidlarger';
 CREATE FUNCTION upg_catalog.oidne(upg_catalog.oid, upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'oidne';
 CREATE FUNCTION upg_catalog.oidnotin(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'oidnotin';
 CREATE FUNCTION upg_catalog.oidsmaller(upg_catalog.oid, upg_catalog.oid) RETURNS upg_catalog.oid LANGUAGE internal IMMUTABLE STRICT AS 'oidsmaller';
 CREATE FUNCTION upg_catalog.oidvectorne(upg_catalog.oidvector, upg_catalog.oidvector) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'oidvectorne';
 CREATE FUNCTION upg_catalog.oidvectortypes(upg_catalog.oidvector) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'oidvectortypes';
 CREATE FUNCTION upg_catalog.on_pb(upg_catalog.point, upg_catalog.box) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'on_pb';
 CREATE FUNCTION upg_catalog.on_pl(upg_catalog.point, upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'on_pl';
 CREATE FUNCTION upg_catalog.on_ppath(upg_catalog.point, upg_catalog.path) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'on_ppath';
 CREATE FUNCTION upg_catalog.on_ps(upg_catalog.point, upg_catalog.lseg) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'on_ps';
 CREATE FUNCTION upg_catalog.on_sb(upg_catalog.lseg, upg_catalog.box) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'on_sb';
 CREATE FUNCTION upg_catalog.on_sl(upg_catalog.lseg, upg_catalog.line) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'on_sl';
 CREATE FUNCTION upg_catalog.path_add(upg_catalog.path, upg_catalog.path) RETURNS upg_catalog.path LANGUAGE internal IMMUTABLE STRICT AS 'path_add';
 CREATE FUNCTION upg_catalog.path_add_pt(upg_catalog.path, upg_catalog.point) RETURNS upg_catalog.path LANGUAGE internal IMMUTABLE STRICT AS 'path_add_pt';
 CREATE FUNCTION upg_catalog.path_center(upg_catalog.path) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'path_center';
 CREATE FUNCTION upg_catalog.path_distance(upg_catalog.path, upg_catalog.path) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'path_distance';
 CREATE FUNCTION upg_catalog.path_div_pt(upg_catalog.path, upg_catalog.point) RETURNS upg_catalog.path LANGUAGE internal IMMUTABLE STRICT AS 'path_div_pt';
 CREATE FUNCTION upg_catalog.path_inter(upg_catalog.path, upg_catalog.path) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'path_inter';
 CREATE FUNCTION upg_catalog.path_length(upg_catalog.path) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'path_length';
 CREATE FUNCTION upg_catalog.path_mul_pt(upg_catalog.path, upg_catalog.point) RETURNS upg_catalog.path LANGUAGE internal IMMUTABLE STRICT AS 'path_mul_pt';
 CREATE FUNCTION upg_catalog.path_npoints(upg_catalog.path) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'path_npoints';
 CREATE FUNCTION upg_catalog.path_sub_pt(upg_catalog.path, upg_catalog.point) RETURNS upg_catalog.path LANGUAGE internal IMMUTABLE STRICT AS 'path_sub_pt';
 CREATE FUNCTION upg_catalog.pclose(upg_catalog.path) RETURNS upg_catalog.path LANGUAGE internal IMMUTABLE STRICT AS 'path_close';
 CREATE FUNCTION upg_catalog.percent_rank_final(upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'percent_rank_final';
 CREATE FUNCTION upg_catalog.pg_advisory_lock(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_lock_int4';
 CREATE FUNCTION upg_catalog.pg_advisory_lock(upg_catalog.int8) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_lock_int8';
 CREATE FUNCTION upg_catalog.pg_advisory_lock_shared(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_lock_shared_int4';
 CREATE FUNCTION upg_catalog.pg_advisory_lock_shared(upg_catalog.int8) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_lock_shared_int8';
 CREATE FUNCTION upg_catalog.pg_advisory_unlock(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_unlock_int4';
 CREATE FUNCTION upg_catalog.pg_advisory_unlock(upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_unlock_int8';
 CREATE FUNCTION upg_catalog.pg_advisory_unlock_all() RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_unlock_all';
 CREATE FUNCTION upg_catalog.pg_advisory_unlock_shared(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_unlock_shared_int4';
 CREATE FUNCTION upg_catalog.pg_advisory_unlock_shared(upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_advisory_unlock_shared_int8';
 CREATE FUNCTION upg_catalog.pg_backend_pid() RETURNS upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'pg_backend_pid';
 CREATE FUNCTION upg_catalog.pg_cancel_backend(upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_cancel_backend';
 CREATE FUNCTION upg_catalog.pg_char_to_encoding(upg_catalog.name) RETURNS upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'PG_char_to_encoding';
 CREATE FUNCTION upg_catalog.pg_client_encoding() RETURNS upg_catalog.name LANGUAGE internal STABLE STRICT AS 'pg_client_encoding';
 CREATE FUNCTION upg_catalog.pg_column_size(upg_catalog."any") RETURNS upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'pg_column_size';
 CREATE FUNCTION upg_catalog.pg_conversion_is_visible(upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_conversion_is_visible';
 CREATE FUNCTION upg_catalog.pg_current_xlog_insert_location() RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_current_xlog_insert_location';
 CREATE FUNCTION upg_catalog.pg_current_xlog_location() RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_current_xlog_location';
 CREATE FUNCTION upg_catalog.pg_cursor() RETURNS SETOF upg_catalog.record LANGUAGE internal STABLE STRICT AS 'pg_cursor';
 CREATE FUNCTION upg_catalog.pg_database_size(upg_catalog.name) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_database_size_name';
 CREATE FUNCTION upg_catalog.pg_database_size(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_database_size_oid';
 CREATE FUNCTION upg_catalog.pg_encoding_to_char(upg_catalog.int4) RETURNS upg_catalog.name LANGUAGE internal STABLE STRICT AS 'PG_encoding_to_char';
 CREATE FUNCTION upg_catalog.pg_file_length(upg_catalog.text) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_file_length';
 CREATE FUNCTION upg_catalog.pg_file_read(upg_catalog.text, upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_read_file';
 CREATE FUNCTION upg_catalog.pg_file_rename(upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'pg_file_rename';
 CREATE FUNCTION upg_catalog.pg_file_unlink(upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_file_unlink';
 CREATE FUNCTION upg_catalog.pg_file_write(upg_catalog.text, upg_catalog.text, upg_catalog.bool) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_file_write';
 CREATE FUNCTION upg_catalog.pg_function_is_visible(upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_function_is_visible';
 CREATE FUNCTION upg_catalog.pg_get_constraintdef(upg_catalog.oid) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_constraintdef';
 CREATE FUNCTION upg_catalog.pg_get_constraintdef(upg_catalog.oid, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_constraintdef_ext';
 CREATE FUNCTION upg_catalog.pg_get_expr(upg_catalog.text, upg_catalog.oid) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_expr';
 CREATE FUNCTION upg_catalog.pg_get_expr(upg_catalog.text, upg_catalog.oid, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_expr_ext';
 CREATE FUNCTION upg_catalog.pg_get_indexdef(upg_catalog.oid) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_indexdef';
 CREATE FUNCTION upg_catalog.pg_get_indexdef(upg_catalog.oid, upg_catalog.int4, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_indexdef_ext';
 CREATE FUNCTION upg_catalog.pg_get_keywords(OUT word upg_catalog.text, OUT catcode upg_catalog."char", OUT catdesc upg_catalog.text) RETURNS SETOF pg_catalog.record LANGUAGE internal STABLE STRICT AS 'pg_get_keywords';
 CREATE FUNCTION upg_catalog.pg_get_partition_def(upg_catalog.oid) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_partition_def';
 CREATE FUNCTION upg_catalog.pg_get_partition_def(upg_catalog.oid, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_partition_def_ext';
 CREATE FUNCTION upg_catalog.pg_get_partition_def(upg_catalog.oid, upg_catalog.bool, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_partition_def_ext2';
 CREATE FUNCTION upg_catalog.pg_get_partition_rule_def(upg_catalog.oid) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_partition_rule_def';
 CREATE FUNCTION upg_catalog.pg_get_partition_rule_def(upg_catalog.oid, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_partition_rule_def_ext';
 CREATE FUNCTION upg_catalog.pg_get_partition_template_def(upg_catalog.oid, upg_catalog.bool, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_partition_template_def';
 CREATE FUNCTION upg_catalog.pg_get_ruledef(upg_catalog.oid) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_ruledef';
 CREATE FUNCTION upg_catalog.pg_get_ruledef(upg_catalog.oid, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_ruledef_ext';
 CREATE FUNCTION upg_catalog.pg_get_serial_sequence(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_serial_sequence';
 CREATE FUNCTION upg_catalog.pg_get_triggerdef(upg_catalog.oid) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_triggerdef';
 CREATE FUNCTION upg_catalog.pg_get_userbyid(upg_catalog.oid) RETURNS upg_catalog.name LANGUAGE internal STABLE STRICT AS 'pg_get_userbyid';
 CREATE FUNCTION upg_catalog.pg_get_viewdef(upg_catalog.oid) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_viewdef';
 CREATE FUNCTION upg_catalog.pg_get_viewdef(upg_catalog.oid, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_viewdef_ext';
 CREATE FUNCTION upg_catalog.pg_get_viewdef(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_viewdef_name';
 CREATE FUNCTION upg_catalog.pg_get_viewdef(upg_catalog.text, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_get_viewdef_name_ext';
 CREATE FUNCTION upg_catalog.pg_has_role(upg_catalog.name, upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_has_role_name_name';
 CREATE FUNCTION upg_catalog.pg_has_role(upg_catalog.name, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_has_role_name_id';
 CREATE FUNCTION upg_catalog.pg_has_role(upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_has_role_name';
 CREATE FUNCTION upg_catalog.pg_has_role(upg_catalog.oid, upg_catalog.name, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_has_role_id_name';
 CREATE FUNCTION upg_catalog.pg_has_role(upg_catalog.oid, upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_has_role_id_id';
 CREATE FUNCTION upg_catalog.pg_has_role(upg_catalog.oid, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_has_role_id';
 CREATE FUNCTION upg_catalog.pg_highest_oid() RETURNS upg_catalog.oid LANGUAGE internal VOLATILE STRICT AS 'pg_highest_oid';
 CREATE FUNCTION upg_catalog.pg_is_other_temp_schema(upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_is_other_temp_schema';
 CREATE FUNCTION upg_catalog.pg_lock_status() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE STRICT AS 'pg_lock_status';
 CREATE FUNCTION upg_catalog.pg_logdir_ls() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE STRICT AS 'pg_logdir_ls';
 CREATE FUNCTION upg_catalog.pg_logfile_rotate() RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_rotate_logfile';
 CREATE FUNCTION upg_catalog.pg_ls_dir(upg_catalog.text) RETURNS SETOF upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_ls_dir';
 CREATE FUNCTION upg_catalog.pg_my_temp_schema() RETURNS upg_catalog.oid LANGUAGE internal STABLE STRICT AS 'pg_my_temp_schema';
 CREATE FUNCTION upg_catalog.pg_objname_to_oid(upg_catalog.text) RETURNS upg_catalog.oid LANGUAGE internal IMMUTABLE STRICT AS 'pg_objname_to_oid';
 CREATE FUNCTION upg_catalog.pg_opclass_is_visible(upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_opclass_is_visible';
 CREATE FUNCTION upg_catalog.pg_operator_is_visible(upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_operator_is_visible';
 CREATE FUNCTION upg_catalog.pg_options_to_table(IN options_array upg_catalog._text, OUT option_name upg_catalog.text, OUT option_value upg_catalog.text) RETURNS SETOF pg_catalog.record LANGUAGE internal STABLE STRICT AS 'pg_options_to_table';
 CREATE FUNCTION upg_catalog.pg_postmaster_start_time() RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'pgsql_postmaster_start_time';
 CREATE FUNCTION upg_catalog.pg_prepared_statement() RETURNS SETOF upg_catalog.record LANGUAGE internal STABLE STRICT AS 'pg_prepared_statement';
 CREATE FUNCTION upg_catalog.pg_prepared_xact() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE STRICT AS 'pg_prepared_xact';
 CREATE FUNCTION upg_catalog.pg_read_file(upg_catalog.text, upg_catalog.int8, upg_catalog.int8) RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_read_file';
 CREATE FUNCTION upg_catalog.pg_relation_size(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_relation_size_oid';
 CREATE FUNCTION upg_catalog.pg_relation_size(upg_catalog.text) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_relation_size_name';
 CREATE FUNCTION upg_catalog.pg_reload_conf() RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_reload_conf';
 CREATE FUNCTION upg_catalog.pg_renice_session(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'pg_renice_session';
 CREATE FUNCTION upg_catalog.pg_resqueue_status() RETURNS SETOF upg_catalog.record LANGUAGE internal VOLATILE STRICT AS 'pg_resqueue_status';
 CREATE FUNCTION upg_catalog.pg_rotate_logfile() RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_rotate_logfile';
 CREATE FUNCTION upg_catalog.pg_show_all_settings() RETURNS SETOF upg_catalog.record LANGUAGE internal STABLE STRICT AS 'show_all_settings';
 CREATE FUNCTION upg_catalog.pg_size_pretty(upg_catalog.int8) RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_size_pretty';
 CREATE FUNCTION upg_catalog.pg_sleep(upg_catalog.float8) RETURNS upg_catalog.void LANGUAGE internal VOLATILE STRICT AS 'pg_sleep';
 CREATE FUNCTION upg_catalog.pg_start_backup(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_start_backup';
 CREATE FUNCTION upg_catalog.pg_stat_file(IN filename upg_catalog.text, OUT size upg_catalog.int8, OUT access upg_catalog.timestamptz, OUT modification upg_catalog.timestamptz, OUT change upg_catalog.timestamptz, OUT creation upg_catalog.timestamptz, OUT isdir upg_catalog.bool) RETURNS pg_catalog.record LANGUAGE internal VOLATILE STRICT AS 'pg_stat_file';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_activity(upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_activity';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_activity_start(upg_catalog.int4) RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_activity_start';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_client_addr(upg_catalog.int4) RETURNS upg_catalog.inet LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_client_addr';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_client_port(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_client_port';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_dbid(upg_catalog.int4) RETURNS upg_catalog.oid LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_dbid';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_idset() RETURNS SETOF upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_idset';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_pid(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_pid';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_session_id(upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_session_id';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_start(upg_catalog.int4) RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_start';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_userid(upg_catalog.int4) RETURNS upg_catalog.oid LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_userid';
 CREATE FUNCTION upg_catalog.pg_stat_get_backend_waiting(upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_stat_get_backend_waiting';
 CREATE FUNCTION upg_catalog.pg_stat_get_blocks_fetched(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_blocks_fetched';
 CREATE FUNCTION upg_catalog.pg_stat_get_blocks_hit(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_blocks_hit';
 CREATE FUNCTION upg_catalog.pg_stat_get_db_blocks_fetched(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_db_blocks_fetched';
 CREATE FUNCTION upg_catalog.pg_stat_get_db_blocks_hit(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_db_blocks_hit';
 CREATE FUNCTION upg_catalog.pg_stat_get_db_numbackends(upg_catalog.oid) RETURNS upg_catalog.int4 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_db_numbackends';
 CREATE FUNCTION upg_catalog.pg_stat_get_db_xact_commit(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_db_xact_commit';
 CREATE FUNCTION upg_catalog.pg_stat_get_db_xact_rollback(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_db_xact_rollback';
 CREATE FUNCTION upg_catalog.pg_stat_get_last_analyze_time(upg_catalog.oid) RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'pg_stat_get_last_analyze_time';
 CREATE FUNCTION upg_catalog.pg_stat_get_last_autoanalyze_time(upg_catalog.oid) RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'pg_stat_get_last_autoanalyze_time';
 CREATE FUNCTION upg_catalog.pg_stat_get_last_autovacuum_time(upg_catalog.oid) RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'pg_stat_get_last_autovacuum_time';
 CREATE FUNCTION upg_catalog.pg_stat_get_last_vacuum_time(upg_catalog.oid) RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'pg_stat_get_last_vacuum_time';
 CREATE FUNCTION upg_catalog.pg_stat_get_numscans(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_numscans';
 CREATE FUNCTION upg_catalog.pg_stat_get_queue_elapsed_exec(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_queue_elapsed_exec';
 CREATE FUNCTION upg_catalog.pg_stat_get_queue_elapsed_wait(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_queue_elapsed_wait';
 CREATE FUNCTION upg_catalog.pg_stat_get_queue_num_exec(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_queue_num_exec';
 CREATE FUNCTION upg_catalog.pg_stat_get_queue_num_wait(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_queue_num_wait';
 CREATE FUNCTION upg_catalog.pg_stat_get_tuples_deleted(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_tuples_deleted';
 CREATE FUNCTION upg_catalog.pg_stat_get_tuples_fetched(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_tuples_fetched';
 CREATE FUNCTION upg_catalog.pg_stat_get_tuples_inserted(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_tuples_inserted';
 CREATE FUNCTION upg_catalog.pg_stat_get_tuples_returned(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_tuples_returned';
 CREATE FUNCTION upg_catalog.pg_stat_get_tuples_updated(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal STABLE STRICT AS 'pg_stat_get_tuples_updated';
 CREATE FUNCTION upg_catalog.pg_stat_reset() RETURNS upg_catalog.bool LANGUAGE internal VOLATILE AS 'pg_stat_reset';
 CREATE FUNCTION upg_catalog.pg_stop_backup() RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_stop_backup';
 CREATE FUNCTION upg_catalog.pg_switch_xlog() RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'pg_switch_xlog';
 CREATE FUNCTION upg_catalog.pg_table_is_visible(upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_table_is_visible';
 CREATE FUNCTION upg_catalog.pg_tablespace_databases(upg_catalog.oid) RETURNS SETOF upg_catalog.oid LANGUAGE internal STABLE STRICT AS 'pg_tablespace_databases';
 CREATE FUNCTION upg_catalog.pg_tablespace_size(upg_catalog.name) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_tablespace_size_name';
 CREATE FUNCTION upg_catalog.pg_tablespace_size(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_tablespace_size_oid';
 CREATE FUNCTION upg_catalog.pg_terminate_backend(upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_terminate_backend';
 CREATE FUNCTION upg_catalog.pg_timezone_abbrevs(OUT abbrev upg_catalog.text, OUT utc_offset upg_catalog."interval", OUT is_dst upg_catalog.bool) RETURNS SETOF pg_catalog.record LANGUAGE internal STABLE STRICT AS 'pg_timezone_abbrevs';
 CREATE FUNCTION upg_catalog.pg_timezone_names(OUT name upg_catalog.text, OUT abbrev upg_catalog.text, OUT utc_offset upg_catalog."interval", OUT is_dst upg_catalog.bool) RETURNS SETOF pg_catalog.record LANGUAGE internal STABLE STRICT AS 'pg_timezone_names';
 CREATE FUNCTION upg_catalog.pg_total_relation_size(upg_catalog.oid) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_total_relation_size_oid';
 CREATE FUNCTION upg_catalog.pg_total_relation_size(upg_catalog.text) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'pg_total_relation_size_name';
 CREATE FUNCTION upg_catalog.pg_try_advisory_lock(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_try_advisory_lock_int4';
 CREATE FUNCTION upg_catalog.pg_try_advisory_lock(upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_try_advisory_lock_int8';
 CREATE FUNCTION upg_catalog.pg_try_advisory_lock_shared(upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_try_advisory_lock_shared_int4';
 CREATE FUNCTION upg_catalog.pg_try_advisory_lock_shared(upg_catalog.int8) RETURNS upg_catalog.bool LANGUAGE internal VOLATILE STRICT AS 'pg_try_advisory_lock_shared_int8';
 CREATE FUNCTION upg_catalog.pg_type_is_visible(upg_catalog.oid) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'pg_type_is_visible';
 CREATE FUNCTION upg_catalog.pg_typeof(upg_catalog."any") RETURNS upg_catalog.regtype LANGUAGE internal STABLE AS 'pg_typeof';
 CREATE FUNCTION upg_catalog.pg_xlogfile_name(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'pg_xlogfile_name';
 CREATE FUNCTION upg_catalog.pg_xlogfile_name_offset(IN wal_location upg_catalog.text, OUT file_name upg_catalog.text, OUT file_offset upg_catalog.int4) RETURNS pg_catalog.record LANGUAGE internal IMMUTABLE STRICT AS 'pg_xlogfile_name_offset';
 CREATE FUNCTION upg_catalog.pi() RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dpi';
 CREATE FUNCTION upg_catalog.pinv(upg_catalog._float8) RETURNS upg_catalog._float8 LANGUAGE internal IMMUTABLE STRICT AS 'pseudoinverse';
 CREATE FUNCTION upg_catalog.plpgsql_call_handler() RETURNS upg_catalog.language_handler LANGUAGE c VOLATILE AS '$libdir/plpgsql', 'plpgsql_call_handler';
 CREATE FUNCTION upg_catalog.plpgsql_validator(upg_catalog.oid) RETURNS upg_catalog.void LANGUAGE c IMMUTABLE AS '$libdir/plpgsql', 'plpgsql_validator';
 CREATE FUNCTION upg_catalog.point(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'construct_point';
 CREATE FUNCTION upg_catalog.point_above(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_above';
 CREATE FUNCTION upg_catalog.point_add(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'point_add';
 CREATE FUNCTION upg_catalog.point_below(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_below';
 CREATE FUNCTION upg_catalog.point_distance(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'point_distance';
 CREATE FUNCTION upg_catalog.point_div(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'point_div';
 CREATE FUNCTION upg_catalog.point_eq(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_eq';
 CREATE FUNCTION upg_catalog.point_horiz(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_horiz';
 CREATE FUNCTION upg_catalog.point_left(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_left';
 CREATE FUNCTION upg_catalog.point_mul(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'point_mul';
 CREATE FUNCTION upg_catalog.point_ne(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_ne';
 CREATE FUNCTION upg_catalog.point_right(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_right';
 CREATE FUNCTION upg_catalog.point_sub(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'point_sub';
 CREATE FUNCTION upg_catalog.point_vert(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'point_vert';
 CREATE FUNCTION upg_catalog.poly_center(upg_catalog.polygon) RETURNS upg_catalog.point LANGUAGE internal IMMUTABLE STRICT AS 'poly_center';
 CREATE FUNCTION upg_catalog.poly_contain_pt(upg_catalog.polygon, upg_catalog.point) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'poly_contain_pt';
 CREATE FUNCTION upg_catalog.poly_distance(upg_catalog.polygon, upg_catalog.polygon) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'poly_distance';
 CREATE FUNCTION upg_catalog.poly_npoints(upg_catalog.polygon) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'poly_npoints';
 CREATE FUNCTION upg_catalog.polygon(upg_catalog.int4, upg_catalog.circle) RETURNS upg_catalog.polygon LANGUAGE internal IMMUTABLE STRICT AS 'circle_poly';
 CREATE FUNCTION upg_catalog.popen(upg_catalog.path) RETURNS upg_catalog.path LANGUAGE internal IMMUTABLE STRICT AS 'path_open';
 CREATE FUNCTION upg_catalog.pow(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_power';
 CREATE FUNCTION upg_catalog.pow(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dpow';
 CREATE FUNCTION upg_catalog.power(upg_catalog."numeric", upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_power';
 CREATE FUNCTION upg_catalog.power(upg_catalog.float8, upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dpow';
 CREATE FUNCTION upg_catalog.pt_contained_circle(upg_catalog.point, upg_catalog.circle) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'pt_contained_circle';
 CREATE FUNCTION upg_catalog.pt_contained_poly(upg_catalog.point, upg_catalog.polygon) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'pt_contained_poly';
 CREATE FUNCTION upg_catalog.quote_ident(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'quote_ident';
 CREATE FUNCTION upg_catalog.quote_literal(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'quote_literal';
 CREATE FUNCTION upg_catalog.radians(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'radians';
 CREATE FUNCTION upg_catalog.radius(upg_catalog.circle) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'circle_radius';
 CREATE FUNCTION upg_catalog.random() RETURNS upg_catalog.float8 LANGUAGE internal VOLATILE STRICT AS 'drandom';
 CREATE FUNCTION upg_catalog.rank_immed(upg_catalog.internal) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'rank_immed';
 CREATE FUNCTION upg_catalog.regexp_matches(upg_catalog.text, upg_catalog.text) RETURNS SETOF upg_catalog._text LANGUAGE internal IMMUTABLE STRICT AS 'regexp_matches_no_flags';
 CREATE FUNCTION upg_catalog.regexp_matches(upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS SETOF upg_catalog._text LANGUAGE internal IMMUTABLE STRICT AS 'regexp_matches';
 CREATE FUNCTION upg_catalog.regexp_replace(upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'textregexreplace_noopt';
 CREATE FUNCTION upg_catalog.regexp_replace(upg_catalog.text, upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'textregexreplace';
 CREATE FUNCTION upg_catalog.regexp_split_to_array(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog._text LANGUAGE internal IMMUTABLE STRICT AS 'regexp_split_to_array_no_flags';
 CREATE FUNCTION upg_catalog.regexp_split_to_array(upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog._text LANGUAGE internal IMMUTABLE STRICT AS 'regexp_split_to_array';
 CREATE FUNCTION upg_catalog.regexp_split_to_table(upg_catalog.text, upg_catalog.text) RETURNS SETOF upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'regexp_split_to_table_no_flags';
 CREATE FUNCTION upg_catalog.regexp_split_to_table(upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS SETOF upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'regexp_split_to_table';
 CREATE FUNCTION upg_catalog.reltimene(upg_catalog.reltime, upg_catalog.reltime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'reltimene';
 CREATE FUNCTION upg_catalog.repeat(upg_catalog.text, upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'repeat';
 CREATE FUNCTION upg_catalog.replace(upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'replace_text';
 CREATE FUNCTION upg_catalog.round(upg_catalog."numeric", upg_catalog.int4) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_round';
 CREATE FUNCTION upg_catalog.round(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dround';
 CREATE FUNCTION upg_catalog.row_number_immed(upg_catalog.internal) RETURNS upg_catalog.int8 LANGUAGE internal IMMUTABLE STRICT AS 'row_number_immed';
 CREATE FUNCTION upg_catalog.rpad(upg_catalog.text, upg_catalog.int4, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'rpad';
 CREATE FUNCTION upg_catalog.rtrim(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'rtrim1';
 CREATE FUNCTION upg_catalog.rtrim(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'rtrim';
 CREATE FUNCTION upg_catalog.set_bit(upg_catalog.bytea, upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'byteaSetBit';
 CREATE FUNCTION upg_catalog.set_byte(upg_catalog.bytea, upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'byteaSetByte';
 CREATE FUNCTION upg_catalog.set_config(upg_catalog.text, upg_catalog.text, upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal VOLATILE AS 'set_config_by_name';
 CREATE FUNCTION upg_catalog.set_masklen(upg_catalog.cidr, upg_catalog.int4) RETURNS upg_catalog.cidr LANGUAGE internal IMMUTABLE STRICT AS 'cidr_set_masklen';
 CREATE FUNCTION upg_catalog.set_masklen(upg_catalog.inet, upg_catalog.int4) RETURNS upg_catalog.inet LANGUAGE internal IMMUTABLE STRICT AS 'inet_set_masklen';
 CREATE FUNCTION upg_catalog.setseed(upg_catalog.float8) RETURNS upg_catalog.int4 LANGUAGE internal VOLATILE STRICT AS 'setseed';
 CREATE FUNCTION upg_catalog.setval(upg_catalog.regclass, upg_catalog.int8) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'setval_oid';
 CREATE FUNCTION upg_catalog.setval(upg_catalog.regclass, upg_catalog.int8, upg_catalog.bool) RETURNS upg_catalog.int8 LANGUAGE internal VOLATILE STRICT AS 'setval3_oid';
 CREATE FUNCTION upg_catalog.sign(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_sign';
 CREATE FUNCTION upg_catalog.sign(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dsign';
 CREATE FUNCTION upg_catalog.similar_escape(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE AS 'similar_escape';
 CREATE FUNCTION upg_catalog.sin(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dsin';
 CREATE FUNCTION upg_catalog.slope(upg_catalog.point, upg_catalog.point) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'point_slope';
 CREATE FUNCTION upg_catalog.smgreq(upg_catalog.smgr, upg_catalog.smgr) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'smgreq';
 CREATE FUNCTION upg_catalog.smgrne(upg_catalog.smgr, upg_catalog.smgr) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'smgrne';
 CREATE FUNCTION upg_catalog.split_part(upg_catalog.text, upg_catalog.text, upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'split_text';
 CREATE FUNCTION upg_catalog.sqrt(upg_catalog."numeric") RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_sqrt';
 CREATE FUNCTION upg_catalog.sqrt(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dsqrt';
 CREATE FUNCTION upg_catalog.statement_timestamp() RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'statement_timestamp';
 CREATE FUNCTION upg_catalog.string_to_array(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog._text LANGUAGE internal IMMUTABLE STRICT AS 'text_to_array';
 CREATE FUNCTION upg_catalog.strpos(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'textpos';
 CREATE FUNCTION upg_catalog.substr(upg_catalog.bytea, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'bytea_substr_no_len';
 CREATE FUNCTION upg_catalog.substr(upg_catalog.bytea, upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.bytea LANGUAGE internal IMMUTABLE STRICT AS 'bytea_substr';
 CREATE FUNCTION upg_catalog.substr(upg_catalog.text, upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'text_substr_no_len';
 CREATE FUNCTION upg_catalog.substr(upg_catalog.text, upg_catalog.int4, upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'text_substr';
 CREATE FUNCTION upg_catalog.tan(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dtan';
 CREATE FUNCTION upg_catalog.text(upg_catalog.bool) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'booltext';
 CREATE FUNCTION upg_catalog.text_larger(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'text_larger';
 CREATE FUNCTION upg_catalog.text_pattern_eq(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texteq';
 CREATE FUNCTION upg_catalog.text_pattern_ne(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textne';
 CREATE FUNCTION upg_catalog.text_smaller(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'text_smaller';
 CREATE FUNCTION upg_catalog.textcat(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'textcat';
 CREATE FUNCTION upg_catalog.texticlike(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texticlike';
 CREATE FUNCTION upg_catalog.texticnlike(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texticnlike';
 CREATE FUNCTION upg_catalog.texticregexeq(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texticregexeq';
 CREATE FUNCTION upg_catalog.texticregexne(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'texticregexne';
 CREATE FUNCTION upg_catalog.textlen(upg_catalog.text) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'textlen';
 CREATE FUNCTION upg_catalog.textlike(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textlike';
 CREATE FUNCTION upg_catalog.textne(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textne';
 CREATE FUNCTION upg_catalog.textnlike(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textnlike';
 CREATE FUNCTION upg_catalog.textregexeq(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textregexeq';
 CREATE FUNCTION upg_catalog.textregexne(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'textregexne';
 CREATE FUNCTION upg_catalog.tidlarger(upg_catalog.tid, upg_catalog.tid) RETURNS upg_catalog.tid LANGUAGE internal IMMUTABLE STRICT AS 'tidlarger';
 CREATE FUNCTION upg_catalog.tidne(upg_catalog.tid, upg_catalog.tid) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tidne';
 CREATE FUNCTION upg_catalog.tidsmaller(upg_catalog.tid, upg_catalog.tid) RETURNS upg_catalog.tid LANGUAGE internal IMMUTABLE STRICT AS 'tidsmaller';
 CREATE FUNCTION upg_catalog.time_larger(upg_catalog."time", upg_catalog."time") RETURNS upg_catalog."time" LANGUAGE internal IMMUTABLE STRICT AS 'time_larger';
 CREATE FUNCTION upg_catalog.time_mi_interval(upg_catalog."time", upg_catalog."interval") RETURNS upg_catalog."time" LANGUAGE internal IMMUTABLE STRICT AS 'time_mi_interval';
 CREATE FUNCTION upg_catalog.time_mi_time(upg_catalog."time", upg_catalog."time") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'time_mi_time';
 CREATE FUNCTION upg_catalog.time_ne(upg_catalog."time", upg_catalog."time") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'time_ne';
 CREATE FUNCTION upg_catalog.time_pl_interval(upg_catalog."time", upg_catalog."interval") RETURNS upg_catalog."time" LANGUAGE internal IMMUTABLE STRICT AS 'time_pl_interval';
 CREATE FUNCTION upg_catalog.time_smaller(upg_catalog."time", upg_catalog."time") RETURNS upg_catalog."time" LANGUAGE internal IMMUTABLE STRICT AS 'time_smaller';
 CREATE FUNCTION upg_catalog.timemi(upg_catalog.abstime, upg_catalog.reltime) RETURNS upg_catalog.abstime LANGUAGE internal IMMUTABLE STRICT AS 'timemi';
 CREATE FUNCTION upg_catalog.timenow() RETURNS upg_catalog.abstime LANGUAGE internal STABLE STRICT AS 'timenow';
 CREATE FUNCTION upg_catalog.timeofday() RETURNS upg_catalog.text LANGUAGE internal VOLATILE STRICT AS 'timeofday';
 CREATE FUNCTION upg_catalog.timepl(upg_catalog.abstime, upg_catalog.reltime) RETURNS upg_catalog.abstime LANGUAGE internal IMMUTABLE STRICT AS 'timepl';
 CREATE FUNCTION upg_catalog.timestamp_larger(upg_catalog."timestamp", upg_catalog."timestamp") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_larger';
 CREATE FUNCTION upg_catalog.timestamp_mi(upg_catalog."timestamp", upg_catalog."timestamp") RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_mi';
 CREATE FUNCTION upg_catalog.timestamp_mi_interval(upg_catalog."timestamp", upg_catalog."interval") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_mi_interval';
 CREATE FUNCTION upg_catalog.timestamp_ne(upg_catalog."timestamp", upg_catalog."timestamp") RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_ne';
 CREATE FUNCTION upg_catalog.timestamp_ne_date(upg_catalog."timestamp", upg_catalog.date) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_ne_date';
 CREATE FUNCTION upg_catalog.timestamp_ne_timestamptz(upg_catalog."timestamp", upg_catalog.timestamptz) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'timestamp_ne_timestamptz';
 CREATE FUNCTION upg_catalog.timestamp_pl_interval(upg_catalog."timestamp", upg_catalog."interval") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_pl_interval';
 CREATE FUNCTION upg_catalog.timestamp_smaller(upg_catalog."timestamp", upg_catalog."timestamp") RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_smaller';
 CREATE FUNCTION upg_catalog.timestamptz(upg_catalog.date, upg_catalog.timetz) RETURNS upg_catalog.timestamptz LANGUAGE internal IMMUTABLE STRICT AS 'datetimetz_timestamptz';
 CREATE FUNCTION upg_catalog.timestamptz_larger(upg_catalog.timestamptz, upg_catalog.timestamptz) RETURNS upg_catalog.timestamptz LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_larger';
 CREATE FUNCTION upg_catalog.timestamptz_mi(upg_catalog.timestamptz, upg_catalog.timestamptz) RETURNS upg_catalog."interval" LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_mi';
 CREATE FUNCTION upg_catalog.timestamptz_mi_interval(upg_catalog.timestamptz, upg_catalog."interval") RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'timestamptz_mi_interval';
 CREATE FUNCTION upg_catalog.timestamptz_ne(upg_catalog.timestamptz, upg_catalog.timestamptz) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_ne';
 CREATE FUNCTION upg_catalog.timestamptz_ne_date(upg_catalog.timestamptz, upg_catalog.date) RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'timestamptz_ne_date';
 CREATE FUNCTION upg_catalog.timestamptz_ne_timestamp(upg_catalog.timestamptz, upg_catalog."timestamp") RETURNS upg_catalog.bool LANGUAGE internal STABLE STRICT AS 'timestamptz_ne_timestamp';
 CREATE FUNCTION upg_catalog.timestamptz_pl_interval(upg_catalog.timestamptz, upg_catalog."interval") RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'timestamptz_pl_interval';
 CREATE FUNCTION upg_catalog.timestamptz_smaller(upg_catalog.timestamptz, upg_catalog.timestamptz) RETURNS upg_catalog.timestamptz LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_smaller';
 CREATE FUNCTION upg_catalog.timetz_larger(upg_catalog.timetz, upg_catalog.timetz) RETURNS upg_catalog.timetz LANGUAGE internal IMMUTABLE STRICT AS 'timetz_larger';
 CREATE FUNCTION upg_catalog.timetz_mi_interval(upg_catalog.timetz, upg_catalog."interval") RETURNS upg_catalog.timetz LANGUAGE internal IMMUTABLE STRICT AS 'timetz_mi_interval';
 CREATE FUNCTION upg_catalog.timetz_ne(upg_catalog.timetz, upg_catalog.timetz) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'timetz_ne';
 CREATE FUNCTION upg_catalog.timetz_pl_interval(upg_catalog.timetz, upg_catalog."interval") RETURNS upg_catalog.timetz LANGUAGE internal IMMUTABLE STRICT AS 'timetz_pl_interval';
 CREATE FUNCTION upg_catalog.timetz_smaller(upg_catalog.timetz, upg_catalog.timetz) RETURNS upg_catalog.timetz LANGUAGE internal IMMUTABLE STRICT AS 'timetz_smaller';
 CREATE FUNCTION upg_catalog.timezone(upg_catalog."interval", upg_catalog."timestamp") RETURNS upg_catalog.timestamptz LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_izone';
 CREATE FUNCTION upg_catalog.timezone(upg_catalog."interval", upg_catalog.timestamptz) RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'timestamptz_izone';
 CREATE FUNCTION upg_catalog.timezone(upg_catalog."interval", upg_catalog.timetz) RETURNS upg_catalog.timetz LANGUAGE internal IMMUTABLE STRICT AS 'timetz_izone';
 CREATE FUNCTION upg_catalog.timezone(upg_catalog.text, upg_catalog."timestamp") RETURNS upg_catalog.timestamptz LANGUAGE internal IMMUTABLE STRICT AS 'timestamp_zone';
 CREATE FUNCTION upg_catalog.timezone(upg_catalog.text, upg_catalog.timestamptz) RETURNS upg_catalog."timestamp" LANGUAGE internal IMMUTABLE STRICT AS 'timestamptz_zone';
 CREATE FUNCTION upg_catalog.timezone(upg_catalog.text, upg_catalog.timetz) RETURNS upg_catalog.timetz LANGUAGE internal VOLATILE STRICT AS 'timetz_zone';
 CREATE FUNCTION upg_catalog.tinterval(upg_catalog.abstime, upg_catalog.abstime) RETURNS upg_catalog.tinterval LANGUAGE internal IMMUTABLE STRICT AS 'mktinterval';
 CREATE FUNCTION upg_catalog.tintervalct(upg_catalog.tinterval, upg_catalog.tinterval) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervalct';
 CREATE FUNCTION upg_catalog.tintervalend(upg_catalog.tinterval) RETURNS upg_catalog.abstime LANGUAGE internal IMMUTABLE STRICT AS 'tintervalend';
 CREATE FUNCTION upg_catalog.tintervalleneq(upg_catalog.tinterval, upg_catalog.reltime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervalleneq';
 CREATE FUNCTION upg_catalog.tintervallenge(upg_catalog.tinterval, upg_catalog.reltime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervallenge';
 CREATE FUNCTION upg_catalog.tintervallengt(upg_catalog.tinterval, upg_catalog.reltime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervallengt';
 CREATE FUNCTION upg_catalog.tintervallenle(upg_catalog.tinterval, upg_catalog.reltime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervallenle';
 CREATE FUNCTION upg_catalog.tintervallenlt(upg_catalog.tinterval, upg_catalog.reltime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervallenlt';
 CREATE FUNCTION upg_catalog.tintervallenne(upg_catalog.tinterval, upg_catalog.reltime) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervallenne';
 CREATE FUNCTION upg_catalog.tintervalne(upg_catalog.tinterval, upg_catalog.tinterval) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervalne';
 CREATE FUNCTION upg_catalog.tintervalov(upg_catalog.tinterval, upg_catalog.tinterval) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervalov';
 CREATE FUNCTION upg_catalog.tintervalrel(upg_catalog.tinterval) RETURNS upg_catalog.reltime LANGUAGE internal IMMUTABLE STRICT AS 'tintervalrel';
 CREATE FUNCTION upg_catalog.tintervalsame(upg_catalog.tinterval, upg_catalog.tinterval) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'tintervalsame';
 CREATE FUNCTION upg_catalog.tintervalstart(upg_catalog.tinterval) RETURNS upg_catalog.abstime LANGUAGE internal IMMUTABLE STRICT AS 'tintervalstart';
 CREATE FUNCTION upg_catalog.to_ascii(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'to_ascii_default';
 CREATE FUNCTION upg_catalog.to_ascii(upg_catalog.text, upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'to_ascii_enc';
 CREATE FUNCTION upg_catalog.to_ascii(upg_catalog.text, upg_catalog.name) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'to_ascii_encname';
 CREATE FUNCTION upg_catalog.to_char(upg_catalog."interval", upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'interval_to_char';
 CREATE FUNCTION upg_catalog.to_char(upg_catalog."numeric", upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'numeric_to_char';
 CREATE FUNCTION upg_catalog.to_char(upg_catalog."timestamp", upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'timestamp_to_char';
 CREATE FUNCTION upg_catalog.to_char(upg_catalog.float4, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'float4_to_char';
 CREATE FUNCTION upg_catalog.to_char(upg_catalog.float8, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'float8_to_char';
 CREATE FUNCTION upg_catalog.to_char(upg_catalog.int4, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'int4_to_char';
 CREATE FUNCTION upg_catalog.to_char(upg_catalog.int8, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'int8_to_char';
 CREATE FUNCTION upg_catalog.to_char(upg_catalog.timestamptz, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'timestamptz_to_char';
 CREATE FUNCTION upg_catalog.to_date(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.date LANGUAGE internal STABLE STRICT AS 'to_date';
 CREATE FUNCTION upg_catalog.to_hex(upg_catalog.int4) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'to_hex32';
 CREATE FUNCTION upg_catalog.to_hex(upg_catalog.int8) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'to_hex64';
 CREATE FUNCTION upg_catalog.to_number(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog."numeric" LANGUAGE internal STABLE STRICT AS 'numeric_to_number';
 CREATE FUNCTION upg_catalog.to_timestamp(upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'to_timestamp';
 CREATE FUNCTION upg_catalog.transaction_timestamp() RETURNS upg_catalog.timestamptz LANGUAGE internal STABLE STRICT AS 'now';
 CREATE FUNCTION upg_catalog.translate(upg_catalog.text, upg_catalog.text, upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'translate';
 CREATE FUNCTION upg_catalog.trunc(upg_catalog."numeric", upg_catalog.int4) RETURNS upg_catalog."numeric" LANGUAGE internal IMMUTABLE STRICT AS 'numeric_trunc';
 CREATE FUNCTION upg_catalog.trunc(upg_catalog.float8) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'dtrunc';
 CREATE FUNCTION upg_catalog.trunc(upg_catalog.macaddr) RETURNS upg_catalog.macaddr LANGUAGE internal IMMUTABLE STRICT AS 'macaddr_trunc';
 CREATE FUNCTION upg_catalog.unnest(upg_catalog.anyarray) RETURNS SETOF upg_catalog.anyelement LANGUAGE internal IMMUTABLE STRICT AS 'unnest';
 CREATE FUNCTION upg_catalog.upper(upg_catalog.text) RETURNS upg_catalog.text LANGUAGE internal IMMUTABLE STRICT AS 'upper';
 CREATE FUNCTION upg_catalog.varbitne(upg_catalog.varbit, upg_catalog.varbit) RETURNS upg_catalog.bool LANGUAGE internal IMMUTABLE STRICT AS 'bitne';
 CREATE FUNCTION upg_catalog.version() RETURNS upg_catalog.text LANGUAGE internal STABLE STRICT AS 'pgsql_version';
 CREATE FUNCTION upg_catalog.width(upg_catalog.box) RETURNS upg_catalog.float8 LANGUAGE internal IMMUTABLE STRICT AS 'box_width';
 CREATE FUNCTION upg_catalog.width_bucket(upg_catalog."numeric", upg_catalog."numeric", upg_catalog."numeric", upg_catalog.int4) RETURNS upg_catalog.int4 LANGUAGE internal IMMUTABLE STRICT AS 'width_bucket_numeric';
