/*-------------------------------------------------------------------------
 *
 * toasting.h
 *	  This file provides some definitions to support creation of toast tables
 *
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * $PostgreSQL: pgsql/src/include/catalog/toasting.h,v 1.2 2006/10/04 00:30:08 momjian Exp $
 *
 *-------------------------------------------------------------------------
 */
#ifndef TOASTING_H
#define TOASTING_H

/*
 * toasting.c prototypes
 */
extern void AlterTableCreateToastTable(Oid relOid);

extern void AlterTableCreateToastTableWithOid(Oid relOid, Oid newOid,
											  Oid newIndexOid,
											  Oid *comptypeOid,
											  bool is_part_child);

extern bool RelationNeedsToastTable(Relation rel);

extern void BootstrapToastTable(char *relName,
					Oid toastOid, Oid toastIndexOid);

/*
 * This macro is just to keep the C compiler from spitting up on the
 * upcoming commands for genbki.sh.
 */
#define DECLARE_TOAST(name,toastoid,indexoid) extern int no_such_variable


/*
 * What follows are lines processed by genbki.sh to create the statements
 * the bootstrap parser will turn into BootstrapToastTable commands.
 * Each line specifies the system catalog that needs a toast table,
 * the OID to assign to the toast table, and the OID to assign to the
 * toast table's index.  The reason we hard-wire these OIDs is that we
 * need stable OIDs for shared relations, and that includes toast tables
 * of shared relations.
 */

/* normal catalogs */
DECLARE_TOAST(pg_attrdef, 2830, 2831);
DECLARE_TOAST(pg_constraint, 2832, 2833);
DECLARE_TOAST(pg_description, 2834, 2835);
DECLARE_TOAST(pg_proc, 2836, 2837);
DECLARE_TOAST(pg_rewrite, 2838, 2839);
DECLARE_TOAST(pg_statistic, 2840, 2841);

/* shared catalogs */
DECLARE_TOAST(pg_authid, 2842, 2843);
#define PgAuthidToastTable 2842
#define PgAuthidToastIndex 2843
DECLARE_TOAST(pg_database, 2844, 2845);
#define PgDatabaseToastTable 2844
#define PgDatabaseToastIndex 2845
DECLARE_TOAST(pg_shdescription, 2846, 2847);
#define PgShdescriptionToastTable 2846
#define PgShdescriptionToastIndex 2847

/* TIDYCAT_BEGIN_CODEGEN 
*/
/*
   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by ./tidycat.pl version 31
   on Thu Sep  1 16:43:17 2011
 */
/* relation id: 5036 - gp_segment_configuration 20101122 */
DECLARE_TOAST(gp_segment_configuration, 2900, 2901);
#define GpSegmentConfigToastTable	2900
#define GpSegmentConfigToastIndex	2901
/* relation id: 5033 - pg_filespace_entry 20101122 */
DECLARE_TOAST(pg_filespace_entry, 2902, 2903);
#define PgFileSpaceEntryToastTable	2902
#define PgFileSpaceEntryToastIndex	2903
/* relation id: 3231 - pg_attribute_encoding 20110727 */
DECLARE_TOAST(pg_attribute_encoding, 3233, 3234);
#define PgAttributeEncodingToastTable	3233
#define PgAttributeEncodingToastIndex	3234
/* relation id: 3220 - pg_type_encoding 20110727 */
DECLARE_TOAST(pg_type_encoding, 3222, 3223);
#define PgTypeEncodingToastTable	3222
#define PgTypeEncodingToastIndex	3223
/* relation id: 9903 - pg_partition_encoding 20110814 */
DECLARE_TOAST(pg_partition_encoding, 9905, 9906);
#define PgPartitionEncodingToastTable	9905
#define PgPartitionEncodingToastIndex	9906
/* relation id: 6112 - pg_filesystem 20130123 */
DECLARE_TOAST(pg_filesystem, 6114, 6115);
#define PgFileSystemToastTable	6114
#define PgFileSystemToastIndex	6115
/* relation id: 7076 - pg_remote_credentials 20140205 */
DECLARE_TOAST(pg_remote_credentials, 7078, 7079);
#define PgRemoteCredentialsToastTable	7078
#define PgRemoteCredentialsToastIndex	7079

/* relation id: 6026 - pg_resqueue 20150917 */
DECLARE_TOAST(pg_resqueue, 9820, 9821);
#define PgResQueueToastTable	9820
#define PgResQueueToastIndex	9821

/* TIDYCAT_END_CODEGEN */

#endif   /* TOASTING_H */
