/*-------------------------------------------------------------------------
 *
 * pg_type_encoding.h
 *	  some where to stash type ENCODING () clauses
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_TYPE_ENCODING_H
#define PG_TYPE_ENCODING_H

#include "catalog/genbki.h"

/* TIDYCAT_BEGINDEF

   CREATE TABLE pg_type_encoding
   with (relid=3220, reltype_oid=3221, toast_oid=3222, toast_index=3223, toast_reltype=3224, CamelCase=TypeEncoding, oid=false)
   (
   typid     oid, 
   typoptions   text[]
   );

   create unique index on pg_type_encoding(typid) with (indexid=3207, CamelCase=TypeEncodingTypid);

   alter table pg_type_encoding add fk typid on pg_type(oid);

   TIDYCAT_ENDDEF
*/
/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by ./tidycat.pl version 29
   on Thu Aug  4 22:39:49 2011
*/


/*
 TidyCat Comments for pg_type_encoding:
  Table does not have an Oid column.
  Table has static type (see pg_types.h).
  Table has TOASTable columns, and TOAST table has static type.

*/

/* ----------------
 *		pg_type_encoding definition.  cpp turns this into
 *		typedef struct FormData_pg_type_encoding
 * ----------------
 */
#define TypeEncodingRelationId	3220

CATALOG(pg_type_encoding,3220) BKI_WITHOUT_OIDS
{
	Oid		typid;			
	text	typoptions[1];	
} FormData_pg_type_encoding;


/* ----------------
 *		Form_pg_type_encoding corresponds to a pointer to a tuple with
 *		the format of pg_type_encoding relation.
 * ----------------
 */
typedef FormData_pg_type_encoding *Form_pg_type_encoding;


/* ----------------
 *		compiler constants for pg_type_encoding
 * ----------------
 */
#define Natts_pg_type_encoding				2
#define Anum_pg_type_encoding_typid			1
#define Anum_pg_type_encoding_typoptions	2


/* TIDYCAT_END_CODEGEN */

#endif   /* PG_TYPE_ENCODING_H */
