/*-------------------------------------------------------------------------
 *
 * pg_resqueue.h
 *	  definition of the system "resource queue" relation (pg_resqueue).
 *
 *
 * Copyright (c) 2006-2010, Greenplum inc.
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * $PostgreSQL$
 *
 * NOTES
 *	  the genbki.sh script reads this file and generates .bki
 *	  information from the DATA() statements.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_RESQUEUE_H
#define PG_RESQUEUE_H


#include "catalog/genbki.h"

/* TIDYCAT_BEGINDEF

   CREATE TABLE pg_resqueue
   with (camelcase=ResQueue, shared=true, relid=6026, reltype_oid=9830, toast_oid=9820, toast_index=9821, toast_reltype=9822)
   (
   rsqname name, -- name of resource queue
   parentoid oid, -- oid of resource queue
   activestats integer, -- active statement count limit
   memorylimit text, -- memory limit in cluster
   corelimit text, -- core limit in cluster
   resovercommit real, -- resource upper limit in cluster
   allocpolicy text, -- query resource allocation policy
   vsegresourcequota text, -- vsegment resource quota
   nvsegupperlimit integer, -- vsegment size upper limit
   nvseglowerlimit integer, -- vsegment size lower limit
   nvsegupperlimitperseg real, -- vsegment size upper limit per segment
   nvseglowerlimitperseg real, -- vsegment size lower limit per segment
   creationtime timestamp with time zone, -- when the queue is created
   updatetime timestamp with time zone, -- when the queue is updated ( create or alter )
   status text, -- the status of resource queue
   );

   create unique index on pg_resqueue(oid) with (indexid=6027);
   create unique index on pg_resqueue(rsqname) with (indexid=6028);

   TIDYCAT_ENDDEF
*/

/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by ./tidycat.pl version 34
   on Thu Sep 17 15:51:40 2015
*/


/*
 TidyCat Comments for pg_resqueue:
  Table is shared, so catalog.c:IsSharedRelation is updated.
  Table has an Oid column.
  Table has static type (see pg_types.h).
  Table has TOASTable columns, and TOAST table has static type.
  Table has weird hack for timestamp column.
 
*/

/*
 * The CATALOG definition has to refer to the type of "creationtime" et al as
 * "timestamptz" (lower case) so that bootstrap mode recognizes it.  But
 * the C header files define this type as TimestampTz.	Since the field is
 * potentially-null and therefore cannot be accessed directly from C code,
 * there is no particular need for the C struct definition to show the
 * field type as TimestampTz --- instead we just make it Datum.
 */

#define timestamptz Datum

/* ----------------
 *		pg_resqueue definition.  cpp turns this into
 *		typedef struct FormData_pg_resqueue
 * ----------------
 */
#define ResQueueRelationId	6026

CATALOG(pg_resqueue,6026) BKI_SHARED_RELATION
{
	NameData	rsqname;				/* name of resource queue */
	Oid			parentoid;				/* oid of resource queue */
	int4		activestats;			/* active statement count limit */
	text		memorylimit;			/* memory limit in cluster */
	text		corelimit;				/* core limit in cluster */
	float4		resovercommit;			/* resource upper limit in cluster */
	text		allocpolicy;			/* query resource allocation policy */
	text		vsegresourcequota;		/* vsegment resource quota */
	int4		nvsegupperlimit;		/* vsegment size upper limit */
	int4		nvseglowerlimit;		/* vsegment size lower limit */
	float4		nvsegupperlimitperseg;	/* vsegment size upper limit per segment */
	float4		nvseglowerlimitperseg;	/* vsegment size lower limit per segment */
	timestamptz	creationtime;			/* when the queue is created */
	timestamptz	updatetime;				/* when the queue is updated ( create or alter ) */
	text		status;					/* the status of resource queue */
} FormData_pg_resqueue;

#undef timestamptz


/* ----------------
 *		Form_pg_resqueue corresponds to a pointer to a tuple with
 *		the format of pg_resqueue relation.
 * ----------------
 */
typedef FormData_pg_resqueue *Form_pg_resqueue;


/* ----------------
 *		compiler constants for pg_resqueue
 * ----------------
 */
#define Natts_pg_resqueue						15
#define Anum_pg_resqueue_rsqname				1
#define Anum_pg_resqueue_parentoid				2
#define Anum_pg_resqueue_activestats			3
#define Anum_pg_resqueue_memorylimit			4
#define Anum_pg_resqueue_corelimit				5
#define Anum_pg_resqueue_resovercommit			6
#define Anum_pg_resqueue_allocpolicy			7
#define Anum_pg_resqueue_vsegresourcequota		8
#define Anum_pg_resqueue_nvsegupperlimit		9
#define Anum_pg_resqueue_nvseglowerlimit		10
#define Anum_pg_resqueue_nvsegupperlimitperseg	11
#define Anum_pg_resqueue_nvseglowerlimitperseg	12
#define Anum_pg_resqueue_creationtime			13
#define Anum_pg_resqueue_updatetime				14
#define Anum_pg_resqueue_status					15


/* TIDYCAT_END_CODEGEN */


/* Create initial default resource queue */
DATA(insert OID = 9800 ( "pg_root"    0      "-1"    "100%" "100%" 2 "even" _null_      0 0 0 0 _null_ _null_ "branch"));
DATA(insert OID = 6055 ( "pg_default" 9800   "20"    "50%"  "50%"  2 "even" "mem:256mb" 0 0 0 0 _null_ _null_ _null_));

/*
 * The possible resource allocation policies.
 */
enum RESOURCE_QUEUE_ALLOCATION_POLICY_INDEX {
	RSQ_ALLOCATION_POLICY_EVEN = 0,

	RSQ_ALLOCATION_POLICY_COUNT
};

#define DEFAULT_RESQUEUE_ACTIVESTATS					"20"
#define DEFAULT_RESQUEUE_OVERCOMMIT						"2"
#define DEFAULT_RESQUEUE_NVSEG_UPPER_LIMIT				"0"
#define DEFAULT_RESQUEUE_NVSEG_LOWER_LIMIT				"0"
#define DEFAULT_RESQUEUE_NVSEG_UPPER_PERSEG_LIMIT		"0"
#define DEFAULT_RESQUEUE_NVSEG_LOWER_PERSEG_LIMIT		"0"

#define DEFAULT_RESQUEUE_ALLOCPOLICY             		"even"
#define DEFAULT_RESQUEUE_VSEGRESOURCEQUOTA		    	"mem:256mb"

#define DEFAULT_RESQUEUE_ACTIVESTATS_N					20
#define DEFAULT_RESQUEUE_OVERCOMMIT_N					2.0
#define DEFAULT_RESQUEUE_NVSEG_UPPER_LIMIT_N			0
#define DEFAULT_RESQUEUE_NVSEG_LOWER_LIMIT_N			0
#define DEFAULT_RESQUEUE_NVSEG_UPPER_PERSEG_LIMIT_N		0.0
#define DEFAULT_RESQUEUE_NVSEG_LOWER_PERSEG_LIMIT_N		0.0

#define DEFAULT_RESQUEUE_ALLOCPOLICY_N					RSQ_ALLOCATION_POLICY_EVEN
#define DEFAULT_RESQUEUE_VSEGRESOURCEQUOTA_N			256

#define MINIMUM_RESQUEUE_ACTIVESTATS					"1"
#define MINIMUM_RESQUEUE_OVERCOMMIT						"1"
#define MINIMUM_RESQUEUE_NVSEG_UPPER_LIMIT				"0"
#define MINIMUM_RESQUEUE_NVSEG_LOWER_LIMIT				"0"
#define MINIMUM_RESQUEUE_NVSEG_UPPER_PERSEG_LIMIT		"0"
#define MINIMUM_RESQUEUE_NVSEG_LOWER_PERSEG_LIMIT		"0"

#define MINIMUM_RESQUEUE_ACTIVESTATS_N					1
#define MINIMUM_RESQUEUE_OVERCOMMIT_N					1.0
#define MINIMUM_RESQUEUE_NVSEG_UPPER_LIMIT_N			0
#define MINIMUM_RESQUEUE_NVSEG_LOWER_LIMIT_N			0
#define MINIMUM_RESQUEUE_NVSEG_UPPER_PERSEG_LIMIT_N		0.0
#define MINIMUM_RESQUEUE_NVSEG_LOWER_PERSEG_LIMIT_N		0.0

#define PG_RESQUEUE_COL_OID								"oid"
#define PG_RESQUEUE_COL_RSQNAME							"rsqname"
#define PG_RESQUEUE_COL_PARENTOID						"parentoid"
#define PG_RESQUEUE_COL_ACTIVESTATS						"activestats"
#define PG_RESQUEUE_COL_MEMORYLIMIT						"memorylimit"
#define PG_RESQUEUE_COL_CORELIMIT						"corelimit"
#define PG_RESQUEUE_COL_RESOVERCOMMIT					"resovercommit"
#define PG_RESQUEUE_COL_ALLOCPOLICY						"allocpolicy"
#define PG_RESQUEUE_COL_VSEGRESOURCEQUOTA				"vsegresourcequota"
#define PG_RESQUEUE_COL_NVSEGUPPERLIMIT					"nvsegupperlimit"
#define PG_RESQUEUE_COL_NVSEGLOWERLIMIT					"nvsegupperlimit"
#define PG_RESQUEUE_COL_NVSEGUPPERLIMITPERSEG			"nvsegupperlimitperseg"
#define PG_RESQUEUE_COL_NVSEGLOWERLIMITPERSEG			"nvseglowerlimitperseg"
#define PG_RESQUEUE_COL_CREATIONTIME					"creationtime"
#define PG_RESQUEUE_COL_UPDATETIME						"updatetime"
#define PG_RESQUEUE_COL_STATUS							"status"

#define ROOTRESQUEUE_OID    9800
#define DEFAULTRESQUEUE_OID 6055

#define RESOURCE_QUEUE_DEFAULT_QUEUE_NAME				"pg_default"
#define RESOURCE_QUEUE_ROOT_QUEUE_NAME					"pg_root"
#define RESOURCE_QUEUE_SEG_RES_QUOTA_MEM				"mem:"
#define RESOURCE_QUEUE_SEG_RES_QUOTA_CORE   			"core:" /* Reserved. */

#endif   /* PG_RESQUEUE_H */
