/*-------------------------------------------------------------------------
 *
 * pg_proc_callback.h
 *	  
 *   Auxillary extension to pg_proc to enable defining additional callback
 *   functions.  Currently the list of allowable callback functions is small
 *   and consists of:
 *     - DESCRIBE() - to support more complex pseudotype resolution
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_PROC_CALLBACK_H
#define PG_PROC_CALLBACK_H

#include "catalog/genbki.h"

/* TIDYCAT_BEGINDEF

   CREATE TABLE pg_proc_callback
   with (relid=3124, reltype_oid=3125, oid=false, CamelCase=ProcCallback)
   (
   profnoid     regproc,   -- oid of the main function
   procallback  regproc,   -- oid of the callback function
   promethod    "char"     -- role the callback function is performing
   );

   create unique index on pg_proc_callback(profnoid, promethod) with (indexid=3126, CamelCase=ProcCallbackProfnoidPromethod);

   alter table pg_proc_callback add fk profnoid  on pg_proc(oid);
   alter table pg_proc_callback add fk procallback on pg_proc(oid);

   TIDYCAT_ENDDEF
*/
/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by ./tidycat.pl version 31
   on Wed Aug 31 10:04:27 2011
*/


/*
 TidyCat Comments for pg_proc_callback:
  Table does not have an Oid column.
  Table has static type (see pg_types.h).

*/

/* ----------------
 *		pg_proc_callback definition.  cpp turns this into
 *		typedef struct FormData_pg_proc_callback
 * ----------------
 */
#define ProcCallbackRelationId	3124

CATALOG(pg_proc_callback,3124) BKI_WITHOUT_OIDS
{
	regproc	profnoid;		/* oid of the main function */
	regproc	procallback;	/* oid of the callback function */
	char	promethod;		/* role the callback function is performing */
} FormData_pg_proc_callback;


/* ----------------
 *		Form_pg_proc_callback corresponds to a pointer to a tuple with
 *		the format of pg_proc_callback relation.
 * ----------------
 */
typedef FormData_pg_proc_callback *Form_pg_proc_callback;


/* ----------------
 *		compiler constants for pg_proc_callback
 * ----------------
 */
#define Natts_pg_proc_callback				3
#define Anum_pg_proc_callback_profnoid		1
#define Anum_pg_proc_callback_procallback	2
#define Anum_pg_proc_callback_promethod		3


/* TIDYCAT_END_CODEGEN */


/* values for promethod */
#define PROMETHOD_DESCRIBE 'd'

/* Functions in pg_proc_callback.c */
extern void deleteProcCallbacks(Oid profnoid);
extern void addProcCallback(Oid profnoid, Oid procallback, char promethod);
extern Oid lookupProcCallback(Oid profnoid, char promethod);

#endif
