/*-------------------------------------------------------------------------
 *
 * pg_partition_encoding.h
 *	  some where to stash ENCODING() clauses for partition templates
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_PARTITION_ENCODING_H
#define PG_PARTITION_ENCODING_H

#include "catalog/genbki.h"

/* TIDYCAT_BEGINDEF

   CREATE TABLE pg_partition_encoding
   with (relid=9903, reltype_oid=9904, toast_oid=9905, toast_index=9906, toast_reltype=9907, CamelCase=PartitionEncoding, oid=false)
   (
   parencoid     oid, 
   parencattnum	 smallint,
   parencattoptions   text[]
   );

   create unique index on pg_partition_encoding(parencoid, parencattnum) with (indexid=9908, CamelCase=PartitionEncodingParencoidAttnum);
   create index on pg_partition_encoding(parencoid) with (indexid=9909, CamelCase=PartitionEncodingParencoid);

   alter table pg_partition_encoding add fk parencoid on pg_partition(oid);

   TIDYCAT_ENDDEF
*/
/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 33
   on Tue Aug 14 18:24:16 2012
*/


/*
 TidyCat Comments for pg_partition_encoding:
  Table does not have an Oid column.
  Table has static type (see pg_types.h).
  Table has TOASTable columns, and TOAST table has static type.

*/

/* ----------------
 *		pg_partition_encoding definition.  cpp turns this into
 *		typedef struct FormData_pg_partition_encoding
 * ----------------
 */
#define PartitionEncodingRelationId	9903

CATALOG(pg_partition_encoding,9903) BKI_WITHOUT_OIDS
{
	Oid		parencoid;				
	int2	parencattnum;			
	text	parencattoptions[1];	
} FormData_pg_partition_encoding;


/* ----------------
 *		Form_pg_partition_encoding corresponds to a pointer to a tuple with
 *		the format of pg_partition_encoding relation.
 * ----------------
 */
typedef FormData_pg_partition_encoding *Form_pg_partition_encoding;


/* ----------------
 *		compiler constants for pg_partition_encoding
 * ----------------
 */
#define Natts_pg_partition_encoding					3
#define Anum_pg_partition_encoding_parencoid		1
#define Anum_pg_partition_encoding_parencattnum		2
#define Anum_pg_partition_encoding_parencattoptions	3


/* TIDYCAT_END_CODEGEN */

#endif   /* PG_PARTITION_ENCODING_H */
