/*-------------------------------------------------------------------------
 *
 * pg_largeobject.h
 *	  definition of the system "largeobject" relation (pg_largeobject)
 *	  along with the relation's initial contents.
 *
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * $PostgreSQL: pgsql/src/include/catalog/pg_largeobject.h,v 1.20 2006/03/05 15:58:54 momjian Exp $
 *
 * NOTES
 *	  the genbki.sh script reads this file and generates .bki
 *	  information from the DATA() statements.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_LARGEOBJECT_H
#define PG_LARGEOBJECT_H

#include "catalog/genbki.h"

/* TIDYCAT_BEGINDEF

   CREATE TABLE pg_largeobject
   with (camelcase=LargeObject, shared=false, oid=false, relid=2613)
   (
   loid    oid     , -- Identifier of large object 
   pageno  integer , -- Page number (starting from 0)
   data    bytea     -- Data for page (may be zero-length)
   );

   create unique index on pg_largeobject(loid,pageno) with (indexid=2683,indexname=pg_largeobject_loid_pn_index);

   TIDYCAT_ENDDEF
*/

/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 16.
   on Fri Nov  5 15:33:46 2010
*/


/*
 TidyCat Comments for pg_largeobject:
  Table does not have an Oid column.
  Table does not have static type (only legal for pre-3.3 tables). 

*/

/* ----------------
 *		pg_largeobject definition.  cpp turns this into
 *		typedef struct FormData_pg_largeobject
 * ----------------
 */
#define LargeObjectRelationId	2613

CATALOG(pg_largeobject,2613) BKI_WITHOUT_OIDS
{
	Oid		loid;	/* Identifier of large object  */
	int4	pageno;	/* Page number (starting from 0) */
	bytea	data;	/* Data for page (may be zero-length) */
} FormData_pg_largeobject;


/* ----------------
 *		Form_pg_largeobject corresponds to a pointer to a tuple with
 *		the format of pg_largeobject relation.
 * ----------------
 */
typedef FormData_pg_largeobject *Form_pg_largeobject;


/* ----------------
 *		compiler constants for pg_largeobject
 * ----------------
 */
#define Natts_pg_largeobject		3
#define Anum_pg_largeobject_loid	1
#define Anum_pg_largeobject_pageno	2
#define Anum_pg_largeobject_data	3


/* TIDYCAT_END_CODEGEN */

extern void LargeObjectCreate(Oid loid);
extern void LargeObjectDrop(Oid loid);
extern bool LargeObjectExists(Oid loid);

#endif   /* PG_LARGEOBJECT_H */
