/*-------------------------------------------------------------------------
 *
 * pg_language.h
 *	  definition of the system "language" relation (pg_language)
 *	  along with the relation's initial contents.
 *
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * $PostgreSQL: pgsql/src/include/catalog/pg_language.h,v 1.28 2006/03/05 15:58:54 momjian Exp $
 *
 * NOTES
 *	  the genbki.sh script reads this file and generates .bki
 *	  information from the DATA() statements.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_LANGUAGE_H
#define PG_LANGUAGE_H

#include "catalog/genbki.h"

/* TIDYCAT_BEGINDEF

   CREATE TABLE pg_language
   with (relid=2612)
   ( 
   lanname        name, 
   lanispl        boolean, -- Is a procedural language
   lanpltrusted   boolean, -- PL is trusted
   lanplcallfoid  oid,     -- Call handler for PL
   lanvalidator   oid,     -- optional validation function
   lanacl         aclitem[] -- Access privileges
   );

   create unique index on pg_language(lanname) with (indexid=2681, CamelCase=LanguageName, syscacheid=LANGNAME, syscache_nbuckets=4);
   create unique index on pg_language(oid) with (indexid=2682, CamelCase=LanguageOid, syscacheid=LANGOID, syscache_nbuckets=4);

   alter table pg_language add fk lanplcallfoid on pg_proc(oid);
   alter table pg_language add fk lanvalidator on pg_proc(oid);

   TIDYCAT_ENDDEF
*/
/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 27.
   on Tue Jun  7 15:41:32 2011
*/


/*
 TidyCat Comments for pg_language:
  Table has an Oid column.
  Table does not have static type (only legal for pre-3.3 tables). 

*/

/* ----------------
 *		pg_language definition.  cpp turns this into
 *		typedef struct FormData_pg_language
 * ----------------
 */
#define LanguageRelationId	2612

CATALOG(pg_language,2612)
{
 	NameData	lanname;		
	bool		lanispl;		/* Is a procedural language */
	bool		lanpltrusted;	/* PL is trusted */
	Oid			lanplcallfoid;	/* Call handler for PL */
	Oid			lanvalidator;	/* optional validation function */
	aclitem		lanacl[1];		/* Access privileges */
} FormData_pg_language;


/* ----------------
 *		Form_pg_language corresponds to a pointer to a tuple with
 *		the format of pg_language relation.
 * ----------------
 */
typedef FormData_pg_language *Form_pg_language;


/* ----------------
 *		compiler constants for pg_language
 * ----------------
 */
#define Natts_pg_language				6
#define Anum_pg_language_lanname		1
#define Anum_pg_language_lanispl		2
#define Anum_pg_language_lanpltrusted	3
#define Anum_pg_language_lanplcallfoid	4
#define Anum_pg_language_lanvalidator	5
#define Anum_pg_language_lanacl			6


/* TIDYCAT_END_CODEGEN */


/* ----------------
 *		initial contents of pg_language
 * ----------------
 */

DATA(insert OID = 12 ( "internal" f f 0 2246 _null_ ));
DESCR("Built-in functions");
#define INTERNALlanguageId 12
DATA(insert OID = 13 ( "c" f f 0 2247 _null_ ));
DESCR("Dynamically-loaded C functions");
#define ClanguageId 13
DATA(insert OID = 14 ( "sql" f t 0 2248 _null_ ));
DESCR("SQL-language functions");
#define SQLlanguageId 14

#endif   /* PG_LANGUAGE_H */
