/*-------------------------------------------------------------------------
*
* pg_exttable.h
*	  definitions for system wide external relations
*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*
*-------------------------------------------------------------------------
*/

#ifndef PG_EXTTABLE_H
#define PG_EXTTABLE_H

#include "catalog/genbki.h"
#include "nodes/pg_list.h"

/*
 * pg_exttable definition.
 */

/* TIDYCAT_BEGINDEF

   CREATE TABLE pg_exttable
   with (camelcase=ExtTable, oid=false, relid=6040)
   (
   reloid           oid, -- refers to this relation's oid in pg_class 
   location         text[], -- array of URI strings
   fmttype          "char", -- 't' (text) or 'c' (csv)
   fmtopts          text, -- the data format options
   command          text, -- the command string to EXECUTE
   rejectlimit      integer, -- error count reject limit per segment
   rejectlimittype  "char", -- 'r' (rows) or 'p' (percent)
   fmterrtbl        oid, -- the data format error table oid in pg_class
   encoding         integer, -- character encoding of this external table
   writable         boolean -- 't' if writable, 'f' if readable
   );

   create unique index on pg_exttable(reloid) with (indexid=6041);

   alter table pg_exttable add fk reloid on pg_class(oid);
   alter table pg_exttable add fk fmterrtbl on pg_class(oid);

   TIDYCAT_ENDDEF
*/
/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 33
   on Wed Aug 15 14:23:37 2012
*/


/*
 TidyCat Comments for pg_exttable:
  Table does not have an Oid column.
  Table does not have static type (only legal for pre-3.3 tables). 
  Table has TOASTable columns, but NO TOAST table.

*/

/* ----------------
 *		pg_exttable definition.  cpp turns this into
 *		typedef struct FormData_pg_exttable
 * ----------------
 */
#define ExtTableRelationId	6040

CATALOG(pg_exttable,6040) BKI_WITHOUT_OIDS
{
	Oid		reloid;				/* refers to this relation's oid in pg_class  */
	text	location[1];		/* array of URI strings */
	char	fmttype;			/* 't' (text) or 'c' (csv) */
	text	fmtopts;			/* the data format options */
	text	command;			/* the command string to EXECUTE */
	int4	rejectlimit;		/* error count reject limit per segment */
	char	rejectlimittype;	/* 'r' (rows) or 'p' (percent) */
	Oid		fmterrtbl;			/* the data format error table oid in pg_class */
	int4	encoding;			/* character encoding of this external table */
	bool	writable;			/* 't' if writable, 'f' if readable */
} FormData_pg_exttable;


/* ----------------
 *		Form_pg_exttable corresponds to a pointer to a tuple with
 *		the format of pg_exttable relation.
 * ----------------
 */
typedef FormData_pg_exttable *Form_pg_exttable;


/* ----------------
 *		compiler constants for pg_exttable
 * ----------------
 */
#define Natts_pg_exttable					10
#define Anum_pg_exttable_reloid				1
#define Anum_pg_exttable_location			2
#define Anum_pg_exttable_fmttype			3
#define Anum_pg_exttable_fmtopts			4
#define Anum_pg_exttable_command			5
#define Anum_pg_exttable_rejectlimit		6
#define Anum_pg_exttable_rejectlimittype	7
#define Anum_pg_exttable_fmterrtbl			8
#define Anum_pg_exttable_encoding			9
#define Anum_pg_exttable_writable			10


/* TIDYCAT_END_CODEGEN */


/*
 * Descriptor of a single AO relation.
 * For now very similar to the catalog row itself but may change in time.
 */
typedef struct ExtTableEntry
{
	List*	locations;
	char	fmtcode;
	char*	fmtopts;
	char*	command;
	int		rejectlimit;
	char	rejectlimittype;
	Oid		fmterrtbl;
    int		encoding;
    bool	iswritable;
    bool	isweb;		/* extra state, not cataloged */
} ExtTableEntry;

/* No initial contents. */

extern void
InsertExtTableEntry(Oid 	tbloid, 
					bool 	iswritable,
					bool 	isweb,
					bool	issreh,
					char	formattype,
					char	rejectlimittype,
					char*	commandString,
					int		rejectlimit,
					Oid		fmtErrTblOid,
					int		encoding,
					Datum	formatOptStr,
					Datum	locationExec,
					Datum	locationUris);

extern ExtTableEntry*
GetExtTableEntry(Oid relid);

extern void
RemoveExtTableEntry(Oid relid);

#define CustomFormatType 'b'
#define TextFormatType 't'
#define CsvFormatType 'c'

/* PXF formats*/
#define GpdbWritableFormatName "GPDBWritable"
#define TextFormatName "TEXT"

#define fmttype_is_custom(c) (c == CustomFormatType)
#define fmttype_is_text(c)   (c == TextFormatType)
#define fmttype_is_csv(c)    (c == CsvFormatType)

#endif /* PG_EXTTABLE_H */
