/*-------------------------------------------------------------------------
 *
 * pg_autovacuum.h
 *	  definition of the system "autovacuum" relation (pg_autovacuum)
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * $PostgreSQL: pgsql/src/include/catalog/pg_autovacuum.h,v 1.5 2006/11/05 22:42:10 tgl Exp $
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_AUTOVACUUM_H
#define PG_AUTOVACUUM_H

#include "catalog/genbki.h"

/* TIDYCAT_BEGINFAKEDEF

   CREATE TABLE pg_autovacuum
   with (oid=false, relid=1248)
   (
   vacrelid          oid, 
   enabled           boolean, 
   vac_base_thresh   integer, 
   vac_scale_factor  real, 
   anl_base_thresh   integer, 
   anl_scale_factor  real, 
   vac_cost_delay    integer, 
   vac_cost_limit    integer, 
   freeze_min_age    integer, 
   freeze_max_age    integer
   );

   create unique index on pg_autovacuum(vacrelid) with (indexid=1250, CamelCase=AutovacuumRelid);

   TIDYCAT_ENDFAKEDEF
*/


/* ----------------
 *		pg_autovacuum definition.	cpp turns this into
 *		typedef struct FormData_pg_autovacuum
 * ----------------
 */
#define AutovacuumRelationId	1248
CATALOG(pg_autovacuum,1248) BKI_WITHOUT_OIDS
{
	Oid			vacrelid;			/* OID of table */
	bool		enabled;			/* enabled for this table? */
	int4		vac_base_thresh;	/* base threshold value */
	float4		vac_scale_factor;	/* reltuples scaling factor */
	int4		anl_base_thresh;	/* base threshold value */
	float4		anl_scale_factor;	/* reltuples scaling factor */
	int4		vac_cost_delay;		/* vacuum cost-based delay */
	int4		vac_cost_limit;		/* vacuum cost limit */
	int4		freeze_min_age;		/* vacuum min freeze age */
	int4		freeze_max_age;		/* max age before forcing vacuum */
} FormData_pg_autovacuum;

/* ----------------
 *		Form_pg_autovacuum corresponds to a pointer to a tuple with
 *		the format of pg_autovacuum relation.
 * ----------------
 */
typedef FormData_pg_autovacuum *Form_pg_autovacuum;

/* ----------------
 *		compiler constants for pg_autovacuum
 * ----------------
 */
#define Natts_pg_autovacuum							10
#define Anum_pg_autovacuum_vacrelid					1
#define Anum_pg_autovacuum_enabled					2
#define Anum_pg_autovacuum_vac_base_thresh			3
#define Anum_pg_autovacuum_vac_scale_factor			4
#define Anum_pg_autovacuum_anl_base_thresh			5
#define Anum_pg_autovacuum_anl_scale_factor			6
#define Anum_pg_autovacuum_vac_cost_delay			7
#define Anum_pg_autovacuum_vac_cost_limit			8
#define Anum_pg_autovacuum_freeze_min_age			9
#define Anum_pg_autovacuum_freeze_max_age			10

/* There are no preloaded tuples in pg_autovacuum.h */

#endif   /* PG_AUTOVACUUM_H */
