/*-------------------------------------------------------------------------
 *
 * pg_attribute_encoding.h
 *	  some where to stash column level ENCODING () clauses
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_ATTRIBUTE_ENCODING_H
#define PG_ATTRIBUTE_ENCODING_H

#include "catalog/genbki.h"

/* TIDYCAT_BEGINDEF

   CREATE TABLE pg_attribute_encoding
   with (relid=3231, reltype_oid=3232, toast_oid=3233, toast_index=3234, toast_reltype=3235, CamelCase=AttributeEncoding, oid=false)
   (
   attrelid     oid, 
   attnum		smallint, 
   attoptions   text[]
   );

   create index on pg_attribute_encoding(attrelid) with (indexid=3236, CamelCase=AttributeEncodingAttrelid);
   create unique index on pg_attribute_encoding(attrelid, attnum) with (indexid=3237, CamelCase=AttributeEncodingAttrelidAttnum);

   alter table pg_attribute_encoding add fk attrelid on pg_attribute(attrelid);

   TIDYCAT_ENDDEF
*/
/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by ./tidycat.pl version 29
   on Thu Aug  4 22:37:32 2011
*/


/*
 TidyCat Comments for pg_attribute_encoding:
  Table does not have an Oid column.
  Table has static type (see pg_types.h).
  Table has TOASTable columns, and TOAST table has static type.

*/

/* ----------------
 *		pg_attribute_encoding definition.  cpp turns this into
 *		typedef struct FormData_pg_attribute_encoding
 * ----------------
 */
#define AttributeEncodingRelationId	3231

CATALOG(pg_attribute_encoding,3231) BKI_WITHOUT_OIDS
{
	Oid		attrelid;		
	int2	attnum;			
	text	attoptions[1];	
} FormData_pg_attribute_encoding;


/* ----------------
 *		Form_pg_attribute_encoding corresponds to a pointer to a tuple with
 *		the format of pg_attribute_encoding relation.
 * ----------------
 */
typedef FormData_pg_attribute_encoding *Form_pg_attribute_encoding;


/* ----------------
 *		compiler constants for pg_attribute_encoding
 * ----------------
 */
#define Natts_pg_attribute_encoding				3
#define Anum_pg_attribute_encoding_attrelid		1
#define Anum_pg_attribute_encoding_attnum		2
#define Anum_pg_attribute_encoding_attoptions	3


/* TIDYCAT_END_CODEGEN */

extern PGFunction *get_funcs_for_compression(char *compresstype);
extern PGFunction **RelationGetColumnCompressionFuncs(Relation rel);
extern uint32 *RelationGetColumnBlocksize(Relation rel);
extern uint32 RelationGetRelationBlocksize(Relation rel);
extern PGFunction  *RelationGetRelationCompressionFuncs(Relation rel);
extern StdRdOptions **RelationGetAttributeOptions(Relation rel);
extern List **RelationGetUntransformedAttributeOptions(Relation rel);

extern void AddRelationAttributeEncodings(Relation rel, List *attr_encodings);
extern void RemoveAttributeEncodingsByRelid(Oid relid);
extern void cloneAttributeEncoding(Oid oldrelid, Oid newrelid, AttrNumber max_attno);
extern Datum *get_rel_attoptions(Oid relid, AttrNumber max_attno);
extern void AddDefaultRelationAttributeOptions(Relation rel, List *options);

#endif   /* PG_ATTRIBUTE_ENCODING_H */
