/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/*-------------------------------------------------------------------------
 *
 * gp_san_config.h
 *    a san configuration table
 *
 * $Id: $
 * $Change: $
 * $DateTime: $
 * $Author: $
 *-------------------------------------------------------------------------
 */
#ifndef _GP_SAN_CONFIG_H_
#define _GP_SAN_CONFIG_H_


/*
 * Defines for gp_san_config table.
 *
 * Stores info for failover using SAN.
 */
#define GpSanConfigRelationName		"gp_san_configuration"

/* TIDYCAT_BEGINDEF

   CREATE TABLE gp_san_configuration
   with (camelcase=GpSanConfig, shared=true, oid=false, relid=5035, reltype_oid=6444, content=MASTER_ONLY)
   (
   mountid             smallint ,
   active_host         "char"   ,
   san_type            "char"   ,
   primary_host        text     ,
   primary_mountpoint  text     ,
   primary_device      text     ,
   mirror_host         text     ,
   mirror_mountpoint   text     ,
   mirror_device       text     
   );

   create unique index on gp_san_configuration(mountid) with (indexid=6111, indexname=gp_san_config_mountid_index);

   TIDYCAT_ENDDEF
*/
/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 21.
   on Wed Nov 24 14:21:44 2010
*/


/*
 TidyCat Comments for gp_san_configuration:
  Table is shared, so catalog.c:IsSharedRelation is updated.
  Table does not have an Oid column.
  Table has static type (see pg_types.h).
  Table has TOASTable columns, but NO TOAST table.
  Table contents are only maintained on MASTER.

*/

/* ----------------
 *		gp_san_configuration definition.  cpp turns this into
 *		typedef struct FormData_gp_san_configuration
 * ----------------
 */
#define GpSanConfigRelationId	5035

CATALOG(gp_san_configuration,5035) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
	int2	mountid;			
	char	active_host;		
	char	san_type;			
	text	primary_host;		
	text	primary_mountpoint;	
	text	primary_device;		
	text	mirror_host;		
	text	mirror_mountpoint;	
	text	mirror_device;		
} FormData_gp_san_configuration;


/* ----------------
 *		Form_gp_san_configuration corresponds to a pointer to a tuple with
 *		the format of gp_san_configuration relation.
 * ----------------
 */
typedef FormData_gp_san_configuration *Form_gp_san_configuration;


/* ----------------
 *		compiler constants for gp_san_configuration
 * ----------------
 */
#define Natts_gp_san_configuration						9
#define Anum_gp_san_configuration_mountid				1
#define Anum_gp_san_configuration_active_host			2
#define Anum_gp_san_configuration_san_type				3
#define Anum_gp_san_configuration_primary_host			4
#define Anum_gp_san_configuration_primary_mountpoint	5
#define Anum_gp_san_configuration_primary_device		6
#define Anum_gp_san_configuration_mirror_host			7
#define Anum_gp_san_configuration_mirror_mountpoint		8
#define Anum_gp_san_configuration_mirror_device			9


/* TIDYCAT_END_CODEGEN */

#endif /*_GP_SAN_CONFIG_H_*/
