/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/*-------------------------------------------------------------------------
 *
 * gp_configuration.h
 *	  definition of the system configuration
 *
 *
 * NOTES
 *	  the genbki.sh script reads this file and generates .bki
 *	  information from the DATA() statements.
 *
 *-------------------------------------------------------------------------
 */
#ifndef _GP_CONFIGURATION_H_
#define _GP_CONFIGURATION_H_

#include "catalog/genbki.h"
/*
 * Defines for gp_configuration table
 */
#define GpConfigurationRelationName		"gp_configuration"

/* TIDYCAT_BEGINDEF

   CREATE TABLE gp_configuration
   with (shared=true, oid=false, relid=5000, content=MASTER_ONLY)
   (
   content         smallint,
   definedprimary  boolean,
   dbid            smallint,
   isprimary       boolean,
   valid           boolean,
   hostname        name,
   port            integer,
   datadir         text
   );

   create unique index on gp_configuration(content, definedprimary) with (indexid=6101);
   create unique index on gp_configuration(dbid) with (indexid=6102);

   TIDYCAT_ENDDEF
*/

/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 21.
   on Wed Nov 24 14:13:16 2010
*/


/*
 TidyCat Comments for gp_configuration:
  Table is shared, so catalog.c:IsSharedRelation is updated.
  Table does not have an Oid column.
  Table does not have static type (only legal for pre-3.3 tables). 
  Table has TOASTable columns, but NO TOAST table.
  Table contents are only maintained on MASTER.

*/

/* ----------------
 *		gp_configuration definition.  cpp turns this into
 *		typedef struct FormData_gp_configuration
 * ----------------
 */
#define GpConfigurationRelationId	5000

CATALOG(gp_configuration,5000) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
	int2		content;		
	bool		definedprimary;	
	int2		dbid;			
	bool		isprimary;		
	bool		valid;			
	NameData	hostname;		
	int4		port;			
	text		datadir;		
} FormData_gp_configuration;


/* ----------------
 *		Form_gp_configuration corresponds to a pointer to a tuple with
 *		the format of gp_configuration relation.
 * ----------------
 */
typedef FormData_gp_configuration *Form_gp_configuration;


/* ----------------
 *		compiler constants for gp_configuration
 * ----------------
 */
#define Natts_gp_configuration					8
#define Anum_gp_configuration_content			1
#define Anum_gp_configuration_definedprimary	2
#define Anum_gp_configuration_dbid				3
#define Anum_gp_configuration_isprimary			4
#define Anum_gp_configuration_valid				5
#define Anum_gp_configuration_hostname			6
#define Anum_gp_configuration_port				7
#define Anum_gp_configuration_datadir			8


/* TIDYCAT_END_CODEGEN */

/*
 * Defines for gp_configuration_history table
 * 
 * Used by fault-management components to record a "change history" description
 * with timestamp.
 */

#define GpConfigHistoryRelName		"gp_configuration_history"

/* TIDYCAT_BEGINDEF

   CREATE TABLE gp_configuration_history
   with (camelcase=GpConfigHistory, shared=true, oid=false, relid=5006, reltype_oid=6434, content=MASTER_ONLY)
   (
   time               timestamp with time zone,
   registration_order integer,
   hostname           text,
   description        text
   );

   TIDYCAT_ENDDEF
*/

/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 34
   on Fri Feb 26 10:43:15 2016
*/


/*
 TidyCat Comments for gp_configuration_history:
  Table is shared, so catalog.c:IsSharedRelation is updated.
  Table does not have an Oid column.
  Table has static type (see pg_types.h).
  Table has TOASTable columns, but NO TOAST table.
  Table contents are only maintained on MASTER.
  Table has weird hack for timestamp column.
 
*/

/*
 * The CATALOG definition has to refer to the type of "time" as
 * "timestamptz" (lower case) so that bootstrap mode recognizes it.  But
 * the C header files define this type as TimestampTz.	Since the field is
 * potentially-null and therefore cannot be accessed directly from C code,
 * there is no particular need for the C struct definition to show the
 * field type as TimestampTz --- instead we just make it Datum.
 */

#define timestamptz Datum

/* ----------------
 *		gp_configuration_history definition.  cpp turns this into
 *		typedef struct FormData_gp_configuration_history
 * ----------------
 */
#define GpConfigHistoryRelationId	5006

CATALOG(gp_configuration_history,5006) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
	timestamptz	time;				
	int4		registration_order;	
	text		hostname;			
	text		description;
} FormData_gp_configuration_history;

#undef timestamptz


/* ----------------
 *		Form_gp_configuration_history corresponds to a pointer to a tuple with
 *		the format of gp_configuration_history relation.
 * ----------------
 */
typedef FormData_gp_configuration_history *Form_gp_configuration_history;


/* ----------------
 *		compiler constants for gp_configuration_history
 * ----------------
 */
#define Natts_gp_configuration_history						4
#define Anum_gp_configuration_history_time					1
#define Anum_gp_configuration_history_registration_order	2
#define Anum_gp_configuration_history_hostname				3
#define Anum_gp_configuration_history_description			4


/* TIDYCAT_END_CODEGEN */

/*
 * Defines for two new catalog tables:
 *
 *    gp_db_interfaces
 *    gp_interfaces
 */
#define GpDbInterfacesRelationName		"gp_db_interfaces"

/* TIDYCAT_BEGINDEF

   CREATE TABLE gp_db_interfaces
   with (camelcase=GpDbInterfaces, shared=true, oid=false, relid=5029, reltype_oid=6436, content=MASTER_ONLY)
   (
   dbid           smallint,
   interfaceid    smallint,
   priority       smallint
   );

   create index on gp_db_interfaces(dbid) with (indexid=6108);

   TIDYCAT_ENDDEF
*/

/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 21.
   on Wed Nov 24 14:13:16 2010
*/


/*
 TidyCat Comments for gp_db_interfaces:
  Table is shared, so catalog.c:IsSharedRelation is updated.
  Table does not have an Oid column.
  Table has static type (see pg_types.h).
  Table contents are only maintained on MASTER.

*/

/* ----------------
 *		gp_db_interfaces definition.  cpp turns this into
 *		typedef struct FormData_gp_db_interfaces
 * ----------------
 */
#define GpDbInterfacesRelationId	5029

CATALOG(gp_db_interfaces,5029) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
	int2	dbid;			
	int2	interfaceid;	
	int2	priority;		
} FormData_gp_db_interfaces;


/* ----------------
 *		Form_gp_db_interfaces corresponds to a pointer to a tuple with
 *		the format of gp_db_interfaces relation.
 * ----------------
 */
typedef FormData_gp_db_interfaces *Form_gp_db_interfaces;


/* ----------------
 *		compiler constants for gp_db_interfaces
 * ----------------
 */
#define Natts_gp_db_interfaces				3
#define Anum_gp_db_interfaces_dbid			1
#define Anum_gp_db_interfaces_interfaceid	2
#define Anum_gp_db_interfaces_priority		3


/* TIDYCAT_END_CODEGEN */

/*
 * gp_interfaces
 */

#define GpInterfacesRelationName		"gp_interfaces"

/* TIDYCAT_BEGINDEF

   CREATE TABLE gp_interfaces
   with (shared=true, oid=false, relid=5030, reltype_oid=6433, content=MASTER_ONLY)
   (
   interfaceid  smallint,
   address      name,
   status       smallint 
   );

   create unique index on gp_interfaces(interfaceid) with (indexid=6109,indexname=gp_interfaces_interface_index);

   TIDYCAT_ENDDEF
*/

/* TIDYCAT_BEGIN_CODEGEN 

   WARNING: DO NOT MODIFY THE FOLLOWING SECTION: 
   Generated by tidycat.pl version 21.
   on Wed Nov 24 14:13:16 2010
*/


/*
 TidyCat Comments for gp_interfaces:
  Table is shared, so catalog.c:IsSharedRelation is updated.
  Table does not have an Oid column.
  Table has static type (see pg_types.h).
  Table contents are only maintained on MASTER.

*/

/* ----------------
 *		gp_interfaces definition.  cpp turns this into
 *		typedef struct FormData_gp_interfaces
 * ----------------
 */
#define GpInterfacesRelationId	5030

CATALOG(gp_interfaces,5030) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
	int2		interfaceid;	
	NameData	address;		
	int2		status;			
} FormData_gp_interfaces;


/* ----------------
 *		Form_gp_interfaces corresponds to a pointer to a tuple with
 *		the format of gp_interfaces relation.
 * ----------------
 */
typedef FormData_gp_interfaces *Form_gp_interfaces;


/* ----------------
 *		compiler constants for gp_interfaces
 * ----------------
 */
#define Natts_gp_interfaces				3
#define Anum_gp_interfaces_interfaceid	1
#define Anum_gp_interfaces_address		2
#define Anum_gp_interfaces_status		3


/* TIDYCAT_END_CODEGEN */

#endif /*_GP_CONFIGURATION_H_*/
