/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#ifndef parquet_TYPES_H
#define parquet_TYPES_H

//#include <stdint.h>
//#include <string>
//#include <map>
//#include <list>
//#include <set>
//#include <vector>
//#include <exception>
//#include <typeinfo>

#include <thrift/Thrift.h>
#include <thrift/TApplicationException.h>
#include <thrift/protocol/TProtocol.h>
#include <thrift/transport/TTransport.h>



namespace parquet {

struct Type {
  enum type {
    BOOLEAN = 0,
    INT32 = 1,
    INT64 = 2,
    INT96 = 3,
    FLOAT = 4,
    DOUBLE = 5,
    BYTE_ARRAY = 6,
    FIXED_LEN_BYTE_ARRAY = 7
  };
};

extern const std::map<int, const char*> _Type_VALUES_TO_NAMES;

struct ConvertedType {
  enum type {
    UTF8 = 0,
    MAP = 1,
    MAP_KEY_VALUE = 2,
    LIST = 3
  };
};

extern const std::map<int, const char*> _ConvertedType_VALUES_TO_NAMES;

struct FieldRepetitionType {
  enum type {
    REQUIRED = 0,
    OPTIONAL = 1,
    REPEATED = 2
  };
};

extern const std::map<int, const char*> _FieldRepetitionType_VALUES_TO_NAMES;

struct Encoding {
  enum type {
    PLAIN = 0,
    GROUP_VAR_INT = 1,
    PLAIN_DICTIONARY = 2,
    RLE = 3,
    BIT_PACKED = 4
  };
};

extern const std::map<int, const char*> _Encoding_VALUES_TO_NAMES;

struct CompressionCodec {
  enum type {
    UNCOMPRESSED = 0,
    SNAPPY = 1,
    GZIP = 2,
    LZO = 3
  };
};

extern const std::map<int, const char*> _CompressionCodec_VALUES_TO_NAMES;

struct PageType {
  enum type {
    DATA_PAGE = 0,
    INDEX_PAGE = 1,
    DICTIONARY_PAGE = 2
  };
};

extern const std::map<int, const char*> _PageType_VALUES_TO_NAMES;

typedef struct _SchemaElement__isset {
  _SchemaElement__isset() : type(false), type_length(false), repetition_type(false), num_children(false), converted_type(false) {}
  bool type;
  bool type_length;
  bool repetition_type;
  bool num_children;
  bool converted_type;
} _SchemaElement__isset;

class SchemaElement {
 public:

  static const char* ascii_fingerprint; // = "5CBB00B965316400B04640A6847FAA4A";
  static const uint8_t binary_fingerprint[16]; // = {0x5C,0xBB,0x00,0xB9,0x65,0x31,0x64,0x00,0xB0,0x46,0x40,0xA6,0x84,0x7F,0xAA,0x4A};

  SchemaElement() : type((Type::type)0), type_length(0), repetition_type((FieldRepetitionType::type)0), name(), num_children(0), converted_type((ConvertedType::type)0) {
  }

  virtual ~SchemaElement() throw() {}

  Type::type type;
  int32_t type_length;
  FieldRepetitionType::type repetition_type;
  std::string name;
  int32_t num_children;
  ConvertedType::type converted_type;

  _SchemaElement__isset __isset;

  void __set_type(const Type::type val) {
    type = val;
    __isset.type = true;
  }

  void __set_type_length(const int32_t val) {
    type_length = val;
    __isset.type_length = true;
  }

  void __set_repetition_type(const FieldRepetitionType::type val) {
    repetition_type = val;
    __isset.repetition_type = true;
  }

  void __set_name(const std::string& val) {
    name = val;
  }

  void __set_num_children(const int32_t val) {
    num_children = val;
    __isset.num_children = true;
  }

  void __set_converted_type(const ConvertedType::type val) {
    converted_type = val;
    __isset.converted_type = true;
  }

  bool operator == (const SchemaElement & rhs) const
  {
    if (__isset.type != rhs.__isset.type)
      return false;
    else if (__isset.type && !(type == rhs.type))
      return false;
    if (__isset.type_length != rhs.__isset.type_length)
      return false;
    else if (__isset.type_length && !(type_length == rhs.type_length))
      return false;
    if (__isset.repetition_type != rhs.__isset.repetition_type)
      return false;
    else if (__isset.repetition_type && !(repetition_type == rhs.repetition_type))
      return false;
    if (!(name == rhs.name))
      return false;
    if (__isset.num_children != rhs.__isset.num_children)
      return false;
    else if (__isset.num_children && !(num_children == rhs.num_children))
      return false;
    if (__isset.converted_type != rhs.__isset.converted_type)
      return false;
    else if (__isset.converted_type && !(converted_type == rhs.converted_type))
      return false;
    return true;
  }
  bool operator != (const SchemaElement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SchemaElement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(SchemaElement &a, SchemaElement &b);


class DataPageHeader {
 public:

  static const char* ascii_fingerprint; // = "DC1AA6836BD6C88C5EE800E8A474A092";
  static const uint8_t binary_fingerprint[16]; // = {0xDC,0x1A,0xA6,0x83,0x6B,0xD6,0xC8,0x8C,0x5E,0xE8,0x00,0xE8,0xA4,0x74,0xA0,0x92};

  DataPageHeader() : num_values(0), encoding((Encoding::type)0), definition_level_encoding((Encoding::type)0), repetition_level_encoding((Encoding::type)0) {
  }

  virtual ~DataPageHeader() throw() {}

  int32_t num_values;
  Encoding::type encoding;
  Encoding::type definition_level_encoding;
  Encoding::type repetition_level_encoding;

  void __set_num_values(const int32_t val) {
    num_values = val;
  }

  void __set_encoding(const Encoding::type val) {
    encoding = val;
  }

  void __set_definition_level_encoding(const Encoding::type val) {
    definition_level_encoding = val;
  }

  void __set_repetition_level_encoding(const Encoding::type val) {
    repetition_level_encoding = val;
  }

  bool operator == (const DataPageHeader & rhs) const
  {
    if (!(num_values == rhs.num_values))
      return false;
    if (!(encoding == rhs.encoding))
      return false;
    if (!(definition_level_encoding == rhs.definition_level_encoding))
      return false;
    if (!(repetition_level_encoding == rhs.repetition_level_encoding))
      return false;
    return true;
  }
  bool operator != (const DataPageHeader &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const DataPageHeader & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(DataPageHeader &a, DataPageHeader &b);


class IndexPageHeader {
 public:

  static const char* ascii_fingerprint; // = "99914B932BD37A50B983C5E7C90AE93B";
  static const uint8_t binary_fingerprint[16]; // = {0x99,0x91,0x4B,0x93,0x2B,0xD3,0x7A,0x50,0xB9,0x83,0xC5,0xE7,0xC9,0x0A,0xE9,0x3B};

  IndexPageHeader() {
  }

  virtual ~IndexPageHeader() throw() {}


  bool operator == (const IndexPageHeader & /* rhs */) const
  {
    return true;
  }
  bool operator != (const IndexPageHeader &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const IndexPageHeader & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(IndexPageHeader &a, IndexPageHeader &b);


class DictionaryPageHeader {
 public:

  static const char* ascii_fingerprint; // = "20FDD15CF009C5B6C703B6F2C65DFE88";
  static const uint8_t binary_fingerprint[16]; // = {0x20,0xFD,0xD1,0x5C,0xF0,0x09,0xC5,0xB6,0xC7,0x03,0xB6,0xF2,0xC6,0x5D,0xFE,0x88};

  DictionaryPageHeader() : num_values(0), encoding((Encoding::type)0) {
  }

  virtual ~DictionaryPageHeader() throw() {}

  int32_t num_values;
  Encoding::type encoding;

  void __set_num_values(const int32_t val) {
    num_values = val;
  }

  void __set_encoding(const Encoding::type val) {
    encoding = val;
  }

  bool operator == (const DictionaryPageHeader & rhs) const
  {
    if (!(num_values == rhs.num_values))
      return false;
    if (!(encoding == rhs.encoding))
      return false;
    return true;
  }
  bool operator != (const DictionaryPageHeader &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const DictionaryPageHeader & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(DictionaryPageHeader &a, DictionaryPageHeader &b);

typedef struct _PageHeader__isset {
  _PageHeader__isset() : crc(false), data_page_header(false), index_page_header(false), dictionary_page_header(false) {}
  bool crc;
  bool data_page_header;
  bool index_page_header;
  bool dictionary_page_header;
} _PageHeader__isset;

class PageHeader {
 public:

  static const char* ascii_fingerprint; // = "E1BE891B2BAADED36768D57979654E54";
  static const uint8_t binary_fingerprint[16]; // = {0xE1,0xBE,0x89,0x1B,0x2B,0xAA,0xDE,0xD3,0x67,0x68,0xD5,0x79,0x79,0x65,0x4E,0x54};

  PageHeader() : type((PageType::type)0), uncompressed_page_size(0), compressed_page_size(0), crc(0) {
  }

  virtual ~PageHeader() throw() {}

  PageType::type type;
  int32_t uncompressed_page_size;
  int32_t compressed_page_size;
  int32_t crc;
  DataPageHeader data_page_header;
  IndexPageHeader index_page_header;
  DictionaryPageHeader dictionary_page_header;

  _PageHeader__isset __isset;

  void __set_type(const PageType::type val) {
    type = val;
  }

  void __set_uncompressed_page_size(const int32_t val) {
    uncompressed_page_size = val;
  }

  void __set_compressed_page_size(const int32_t val) {
    compressed_page_size = val;
  }

  void __set_crc(const int32_t val) {
    crc = val;
    __isset.crc = true;
  }

  void __set_data_page_header(const DataPageHeader& val) {
    data_page_header = val;
    __isset.data_page_header = true;
  }

  void __set_index_page_header(const IndexPageHeader& val) {
    index_page_header = val;
    __isset.index_page_header = true;
  }

  void __set_dictionary_page_header(const DictionaryPageHeader& val) {
    dictionary_page_header = val;
    __isset.dictionary_page_header = true;
  }

  bool operator == (const PageHeader & rhs) const
  {
    if (!(type == rhs.type))
      return false;
    if (!(uncompressed_page_size == rhs.uncompressed_page_size))
      return false;
    if (!(compressed_page_size == rhs.compressed_page_size))
      return false;
    if (__isset.crc != rhs.__isset.crc)
      return false;
    else if (__isset.crc && !(crc == rhs.crc))
      return false;
    if (__isset.data_page_header != rhs.__isset.data_page_header)
      return false;
    else if (__isset.data_page_header && !(data_page_header == rhs.data_page_header))
      return false;
    if (__isset.index_page_header != rhs.__isset.index_page_header)
      return false;
    else if (__isset.index_page_header && !(index_page_header == rhs.index_page_header))
      return false;
    if (__isset.dictionary_page_header != rhs.__isset.dictionary_page_header)
      return false;
    else if (__isset.dictionary_page_header && !(dictionary_page_header == rhs.dictionary_page_header))
      return false;
    return true;
  }
  bool operator != (const PageHeader &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const PageHeader & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(PageHeader &a, PageHeader &b);

typedef struct _KeyValue__isset {
  _KeyValue__isset() : value(false) {}
  bool value;
} _KeyValue__isset;

class KeyValue {
 public:

  static const char* ascii_fingerprint; // = "5B708A954C550ECA9C1A49D3C5CAFAB9";
  static const uint8_t binary_fingerprint[16]; // = {0x5B,0x70,0x8A,0x95,0x4C,0x55,0x0E,0xCA,0x9C,0x1A,0x49,0xD3,0xC5,0xCA,0xFA,0xB9};

  KeyValue() : key(), value() {
  }

  virtual ~KeyValue() throw() {}

  std::string key;
  std::string value;

  _KeyValue__isset __isset;

  void __set_key(const std::string& val) {
    key = val;
  }

  void __set_value(const std::string& val) {
    value = val;
    __isset.value = true;
  }

  bool operator == (const KeyValue & rhs) const
  {
    if (!(key == rhs.key))
      return false;
    if (__isset.value != rhs.__isset.value)
      return false;
    else if (__isset.value && !(value == rhs.value))
      return false;
    return true;
  }
  bool operator != (const KeyValue &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const KeyValue & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(KeyValue &a, KeyValue &b);

typedef struct _ColumnMetaData__isset {
  _ColumnMetaData__isset() : key_value_metadata(false), index_page_offset(false), dictionary_page_offset(false) {}
  bool key_value_metadata;
  bool index_page_offset;
  bool dictionary_page_offset;
} _ColumnMetaData__isset;

class ColumnMetaData {
 public:

  static const char* ascii_fingerprint; // = "A54C067755C6EAFBFDF0932E09F82EB0";
  static const uint8_t binary_fingerprint[16]; // = {0xA5,0x4C,0x06,0x77,0x55,0xC6,0xEA,0xFB,0xFD,0xF0,0x93,0x2E,0x09,0xF8,0x2E,0xB0};

  ColumnMetaData() : type((Type::type)0), codec((CompressionCodec::type)0), num_values(0), total_uncompressed_size(0), total_compressed_size(0), data_page_offset(0), index_page_offset(0), dictionary_page_offset(0) {
  }

  virtual ~ColumnMetaData() throw() {}

  Type::type type;
  std::vector<Encoding::type>  encodings;
  std::vector<std::string>  path_in_schema;
  CompressionCodec::type codec;
  int64_t num_values;
  int64_t total_uncompressed_size;
  int64_t total_compressed_size;
  std::vector<KeyValue>  key_value_metadata;
  int64_t data_page_offset;
  int64_t index_page_offset;
  int64_t dictionary_page_offset;

  _ColumnMetaData__isset __isset;

  void __set_type(const Type::type val) {
    type = val;
  }

  void __set_encodings(const std::vector<Encoding::type> & val) {
    encodings = val;
  }

  void __set_path_in_schema(const std::vector<std::string> & val) {
    path_in_schema = val;
  }

  void __set_codec(const CompressionCodec::type val) {
    codec = val;
  }

  void __set_num_values(const int64_t val) {
    num_values = val;
  }

  void __set_total_uncompressed_size(const int64_t val) {
    total_uncompressed_size = val;
  }

  void __set_total_compressed_size(const int64_t val) {
    total_compressed_size = val;
  }

  void __set_key_value_metadata(const std::vector<KeyValue> & val) {
    key_value_metadata = val;
    __isset.key_value_metadata = true;
  }

  void __set_data_page_offset(const int64_t val) {
    data_page_offset = val;
  }

  void __set_index_page_offset(const int64_t val) {
    index_page_offset = val;
    __isset.index_page_offset = true;
  }

  void __set_dictionary_page_offset(const int64_t val) {
    dictionary_page_offset = val;
    __isset.dictionary_page_offset = true;
  }

  bool operator == (const ColumnMetaData & rhs) const
  {
    if (!(type == rhs.type))
      return false;
    if (!(encodings == rhs.encodings))
      return false;
    if (!(path_in_schema == rhs.path_in_schema))
      return false;
    if (!(codec == rhs.codec))
      return false;
    if (!(num_values == rhs.num_values))
      return false;
    if (!(total_uncompressed_size == rhs.total_uncompressed_size))
      return false;
    if (!(total_compressed_size == rhs.total_compressed_size))
      return false;
    if (__isset.key_value_metadata != rhs.__isset.key_value_metadata)
      return false;
    else if (__isset.key_value_metadata && !(key_value_metadata == rhs.key_value_metadata))
      return false;
    if (!(data_page_offset == rhs.data_page_offset))
      return false;
    if (__isset.index_page_offset != rhs.__isset.index_page_offset)
      return false;
    else if (__isset.index_page_offset && !(index_page_offset == rhs.index_page_offset))
      return false;
    if (__isset.dictionary_page_offset != rhs.__isset.dictionary_page_offset)
      return false;
    else if (__isset.dictionary_page_offset && !(dictionary_page_offset == rhs.dictionary_page_offset))
      return false;
    return true;
  }
  bool operator != (const ColumnMetaData &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ColumnMetaData & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(ColumnMetaData &a, ColumnMetaData &b);

typedef struct _ColumnChunk__isset {
  _ColumnChunk__isset() : file_path(false), meta_data(false) {}
  bool file_path;
  bool meta_data;
} _ColumnChunk__isset;

class ColumnChunk {
 public:

  static const char* ascii_fingerprint; // = "29169DCD85D0F73C1E4A817035671669";
  static const uint8_t binary_fingerprint[16]; // = {0x29,0x16,0x9D,0xCD,0x85,0xD0,0xF7,0x3C,0x1E,0x4A,0x81,0x70,0x35,0x67,0x16,0x69};

  ColumnChunk() : file_path(), file_offset(0) {
  }

  virtual ~ColumnChunk() throw() {}

  std::string file_path;
  int64_t file_offset;
  ColumnMetaData meta_data;

  _ColumnChunk__isset __isset;

  void __set_file_path(const std::string& val) {
    file_path = val;
    __isset.file_path = true;
  }

  void __set_file_offset(const int64_t val) {
    file_offset = val;
  }

  void __set_meta_data(const ColumnMetaData& val) {
    meta_data = val;
    __isset.meta_data = true;
  }

  bool operator == (const ColumnChunk & rhs) const
  {
    if (__isset.file_path != rhs.__isset.file_path)
      return false;
    else if (__isset.file_path && !(file_path == rhs.file_path))
      return false;
    if (!(file_offset == rhs.file_offset))
      return false;
    if (__isset.meta_data != rhs.__isset.meta_data)
      return false;
    else if (__isset.meta_data && !(meta_data == rhs.meta_data))
      return false;
    return true;
  }
  bool operator != (const ColumnChunk &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ColumnChunk & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(ColumnChunk &a, ColumnChunk &b);


class RowGroup {
 public:

  static const char* ascii_fingerprint; // = "DB64FC4C180CA5E20E79F13A43A96875";
  static const uint8_t binary_fingerprint[16]; // = {0xDB,0x64,0xFC,0x4C,0x18,0x0C,0xA5,0xE2,0x0E,0x79,0xF1,0x3A,0x43,0xA9,0x68,0x75};

  RowGroup() : total_byte_size(0), num_rows(0) {
  }

  virtual ~RowGroup() throw() {}

  std::vector<ColumnChunk>  columns;
  int64_t total_byte_size;
  int64_t num_rows;

  void __set_columns(const std::vector<ColumnChunk> & val) {
    columns = val;
  }

  void __set_total_byte_size(const int64_t val) {
    total_byte_size = val;
  }

  void __set_num_rows(const int64_t val) {
    num_rows = val;
  }

  bool operator == (const RowGroup & rhs) const
  {
    if (!(columns == rhs.columns))
      return false;
    if (!(total_byte_size == rhs.total_byte_size))
      return false;
    if (!(num_rows == rhs.num_rows))
      return false;
    return true;
  }
  bool operator != (const RowGroup &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const RowGroup & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(RowGroup &a, RowGroup &b);

typedef struct _FileMetaData__isset {
  _FileMetaData__isset() : key_value_metadata(false), created_by(false) {}
  bool key_value_metadata;
  bool created_by;
} _FileMetaData__isset;

class FileMetaData {
 public:

  static const char* ascii_fingerprint; // = "E6BD0032D8B4E43BE08802936E279571";
  static const uint8_t binary_fingerprint[16]; // = {0xE6,0xBD,0x00,0x32,0xD8,0xB4,0xE4,0x3B,0xE0,0x88,0x02,0x93,0x6E,0x27,0x95,0x71};

  FileMetaData() : version(0), num_rows(0), created_by() {
  }

  virtual ~FileMetaData() throw() {}

  int32_t version;
  std::vector<SchemaElement>  schema;
  int64_t num_rows;
  std::vector<RowGroup>  row_groups;
  std::vector<KeyValue>  key_value_metadata;
  std::string created_by;

  _FileMetaData__isset __isset;

  void __set_version(const int32_t val) {
    version = val;
  }

  void __set_schema(const std::vector<SchemaElement> & val) {
    schema = val;
  }

  void __set_num_rows(const int64_t val) {
    num_rows = val;
  }

  void __set_row_groups(const std::vector<RowGroup> & val) {
    row_groups = val;
  }

  void __set_key_value_metadata(const std::vector<KeyValue> & val) {
    key_value_metadata = val;
    __isset.key_value_metadata = true;
  }

  void __set_created_by(const std::string& val) {
    created_by = val;
    __isset.created_by = true;
  }

  bool operator == (const FileMetaData & rhs) const
  {
    if (!(version == rhs.version))
      return false;
    if (!(schema == rhs.schema))
      return false;
    if (!(num_rows == rhs.num_rows))
      return false;
    if (!(row_groups == rhs.row_groups))
      return false;
    if (__isset.key_value_metadata != rhs.__isset.key_value_metadata)
      return false;
    else if (__isset.key_value_metadata && !(key_value_metadata == rhs.key_value_metadata))
      return false;
    if (__isset.created_by != rhs.__isset.created_by)
      return false;
    else if (__isset.created_by && !(created_by == rhs.created_by))
      return false;
    return true;
  }
  bool operator != (const FileMetaData &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const FileMetaData & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(FileMetaData &a, FileMetaData &b);

} // namespace

#endif
