/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */

#include <stdint.h>
#include "parquet_types.h"

#include <algorithm>

namespace parquet {

int _kTypeValues[] = {
  Type::BOOLEAN,
  Type::INT32,
  Type::INT64,
  Type::INT96,
  Type::FLOAT,
  Type::DOUBLE,
  Type::BYTE_ARRAY,
  Type::FIXED_LEN_BYTE_ARRAY
};
const char* _kTypeNames[] = {
  "BOOLEAN",
  "INT32",
  "INT64",
  "INT96",
  "FLOAT",
  "DOUBLE",
  "BYTE_ARRAY",
  "FIXED_LEN_BYTE_ARRAY"
};
const std::map<int, const char*> _Type_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(8, _kTypeValues, _kTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kConvertedTypeValues[] = {
  ConvertedType::UTF8,
  ConvertedType::MAP,
  ConvertedType::MAP_KEY_VALUE,
  ConvertedType::LIST
};
const char* _kConvertedTypeNames[] = {
  "UTF8",
  "MAP",
  "MAP_KEY_VALUE",
  "LIST"
};
const std::map<int, const char*> _ConvertedType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(4, _kConvertedTypeValues, _kConvertedTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kFieldRepetitionTypeValues[] = {
  FieldRepetitionType::REQUIRED,
  FieldRepetitionType::OPTIONAL,
  FieldRepetitionType::REPEATED
};
const char* _kFieldRepetitionTypeNames[] = {
  "REQUIRED",
  "OPTIONAL",
  "REPEATED"
};
const std::map<int, const char*> _FieldRepetitionType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kFieldRepetitionTypeValues, _kFieldRepetitionTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kEncodingValues[] = {
  Encoding::PLAIN,
  Encoding::GROUP_VAR_INT,
  Encoding::PLAIN_DICTIONARY,
  Encoding::RLE,
  Encoding::BIT_PACKED
};
const char* _kEncodingNames[] = {
  "PLAIN",
  "GROUP_VAR_INT",
  "PLAIN_DICTIONARY",
  "RLE",
  "BIT_PACKED"
};
const std::map<int, const char*> _Encoding_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kEncodingValues, _kEncodingNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kCompressionCodecValues[] = {
  CompressionCodec::UNCOMPRESSED,
  CompressionCodec::SNAPPY,
  CompressionCodec::GZIP,
  CompressionCodec::LZO
};
const char* _kCompressionCodecNames[] = {
  "UNCOMPRESSED",
  "SNAPPY",
  "GZIP",
  "LZO"
};
const std::map<int, const char*> _CompressionCodec_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(4, _kCompressionCodecValues, _kCompressionCodecNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kPageTypeValues[] = {
  PageType::DATA_PAGE,
  PageType::INDEX_PAGE,
  PageType::DICTIONARY_PAGE
};
const char* _kPageTypeNames[] = {
  "DATA_PAGE",
  "INDEX_PAGE",
  "DICTIONARY_PAGE"
};
const std::map<int, const char*> _PageType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kPageTypeValues, _kPageTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

const char* SchemaElement::ascii_fingerprint = "5CBB00B965316400B04640A6847FAA4A";
const uint8_t SchemaElement::binary_fingerprint[16] = {0x5C,0xBB,0x00,0xB9,0x65,0x31,0x64,0x00,0xB0,0x46,0x40,0xA6,0x84,0x7F,0xAA,0x4A};

uint32_t SchemaElement::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_name = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->type = (Type::type)ecast0;
          this->__isset.type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->type_length);
          this->__isset.type_length = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast1;
          xfer += iprot->readI32(ecast1);
          this->repetition_type = (FieldRepetitionType::type)ecast1;
          this->__isset.repetition_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->name);
          isset_name = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_children);
          this->__isset.num_children = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast2;
          xfer += iprot->readI32(ecast2);
          this->converted_type = (ConvertedType::type)ecast2;
          this->__isset.converted_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_name)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t SchemaElement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("SchemaElement");

  if (this->__isset.type) {
    xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 1);
    xfer += oprot->writeI32((int32_t)this->type);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.type_length) {
    xfer += oprot->writeFieldBegin("type_length", ::apache::thrift::protocol::T_I32, 2);
    xfer += oprot->writeI32(this->type_length);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.repetition_type) {
    xfer += oprot->writeFieldBegin("repetition_type", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32((int32_t)this->repetition_type);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("name", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->name);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.num_children) {
    xfer += oprot->writeFieldBegin("num_children", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32(this->num_children);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.converted_type) {
    xfer += oprot->writeFieldBegin("converted_type", ::apache::thrift::protocol::T_I32, 6);
    xfer += oprot->writeI32((int32_t)this->converted_type);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SchemaElement &a, SchemaElement &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.type_length, b.type_length);
  swap(a.repetition_type, b.repetition_type);
  swap(a.name, b.name);
  swap(a.num_children, b.num_children);
  swap(a.converted_type, b.converted_type);
  swap(a.__isset, b.__isset);
}

const char* DataPageHeader::ascii_fingerprint = "DC1AA6836BD6C88C5EE800E8A474A092";
const uint8_t DataPageHeader::binary_fingerprint[16] = {0xDC,0x1A,0xA6,0x83,0x6B,0xD6,0xC8,0x8C,0x5E,0xE8,0x00,0xE8,0xA4,0x74,0xA0,0x92};

uint32_t DataPageHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_num_values = false;
  bool isset_encoding = false;
  bool isset_definition_level_encoding = false;
  bool isset_repetition_level_encoding = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_values);
          isset_num_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast3;
          xfer += iprot->readI32(ecast3);
          this->encoding = (Encoding::type)ecast3;
          isset_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast4;
          xfer += iprot->readI32(ecast4);
          this->definition_level_encoding = (Encoding::type)ecast4;
          isset_definition_level_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast5;
          xfer += iprot->readI32(ecast5);
          this->repetition_level_encoding = (Encoding::type)ecast5;
          isset_repetition_level_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_num_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_definition_level_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_repetition_level_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DataPageHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("DataPageHeader");

  xfer += oprot->writeFieldBegin("num_values", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->num_values);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("encoding", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->encoding);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("definition_level_encoding", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32((int32_t)this->definition_level_encoding);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("repetition_level_encoding", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32((int32_t)this->repetition_level_encoding);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DataPageHeader &a, DataPageHeader &b) {
  using ::std::swap;
  swap(a.num_values, b.num_values);
  swap(a.encoding, b.encoding);
  swap(a.definition_level_encoding, b.definition_level_encoding);
  swap(a.repetition_level_encoding, b.repetition_level_encoding);
}

const char* IndexPageHeader::ascii_fingerprint = "99914B932BD37A50B983C5E7C90AE93B";
const uint8_t IndexPageHeader::binary_fingerprint[16] = {0x99,0x91,0x4B,0x93,0x2B,0xD3,0x7A,0x50,0xB9,0x83,0xC5,0xE7,0xC9,0x0A,0xE9,0x3B};

uint32_t IndexPageHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t IndexPageHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("IndexPageHeader");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(IndexPageHeader &a, IndexPageHeader &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

const char* DictionaryPageHeader::ascii_fingerprint = "20FDD15CF009C5B6C703B6F2C65DFE88";
const uint8_t DictionaryPageHeader::binary_fingerprint[16] = {0x20,0xFD,0xD1,0x5C,0xF0,0x09,0xC5,0xB6,0xC7,0x03,0xB6,0xF2,0xC6,0x5D,0xFE,0x88};

uint32_t DictionaryPageHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_num_values = false;
  bool isset_encoding = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_values);
          isset_num_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast6;
          xfer += iprot->readI32(ecast6);
          this->encoding = (Encoding::type)ecast6;
          isset_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_num_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DictionaryPageHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("DictionaryPageHeader");

  xfer += oprot->writeFieldBegin("num_values", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->num_values);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("encoding", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->encoding);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DictionaryPageHeader &a, DictionaryPageHeader &b) {
  using ::std::swap;
  swap(a.num_values, b.num_values);
  swap(a.encoding, b.encoding);
}

const char* PageHeader::ascii_fingerprint = "E1BE891B2BAADED36768D57979654E54";
const uint8_t PageHeader::binary_fingerprint[16] = {0xE1,0xBE,0x89,0x1B,0x2B,0xAA,0xDE,0xD3,0x67,0x68,0xD5,0x79,0x79,0x65,0x4E,0x54};

uint32_t PageHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_type = false;
  bool isset_uncompressed_page_size = false;
  bool isset_compressed_page_size = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast7;
          xfer += iprot->readI32(ecast7);
          this->type = (PageType::type)ecast7;
          isset_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->uncompressed_page_size);
          isset_uncompressed_page_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->compressed_page_size);
          isset_compressed_page_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->crc);
          this->__isset.crc = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->data_page_header.read(iprot);
          this->__isset.data_page_header = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->index_page_header.read(iprot);
          this->__isset.index_page_header = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->dictionary_page_header.read(iprot);
          this->__isset.dictionary_page_header = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_type)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_uncompressed_page_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_compressed_page_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t PageHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("PageHeader");

  xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->type);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("uncompressed_page_size", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(this->uncompressed_page_size);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("compressed_page_size", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(this->compressed_page_size);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.crc) {
    xfer += oprot->writeFieldBegin("crc", ::apache::thrift::protocol::T_I32, 4);
    xfer += oprot->writeI32(this->crc);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.data_page_header) {
    xfer += oprot->writeFieldBegin("data_page_header", ::apache::thrift::protocol::T_STRUCT, 5);
    xfer += this->data_page_header.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.index_page_header) {
    xfer += oprot->writeFieldBegin("index_page_header", ::apache::thrift::protocol::T_STRUCT, 6);
    xfer += this->index_page_header.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dictionary_page_header) {
    xfer += oprot->writeFieldBegin("dictionary_page_header", ::apache::thrift::protocol::T_STRUCT, 7);
    xfer += this->dictionary_page_header.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(PageHeader &a, PageHeader &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.uncompressed_page_size, b.uncompressed_page_size);
  swap(a.compressed_page_size, b.compressed_page_size);
  swap(a.crc, b.crc);
  swap(a.data_page_header, b.data_page_header);
  swap(a.index_page_header, b.index_page_header);
  swap(a.dictionary_page_header, b.dictionary_page_header);
  swap(a.__isset, b.__isset);
}

const char* KeyValue::ascii_fingerprint = "5B708A954C550ECA9C1A49D3C5CAFAB9";
const uint8_t KeyValue::binary_fingerprint[16] = {0x5B,0x70,0x8A,0x95,0x4C,0x55,0x0E,0xCA,0x9C,0x1A,0x49,0xD3,0xC5,0xCA,0xFA,0xB9};

uint32_t KeyValue::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_key = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->key);
          isset_key = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->value);
          this->__isset.value = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_key)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t KeyValue::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("KeyValue");

  xfer += oprot->writeFieldBegin("key", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->key);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.value) {
    xfer += oprot->writeFieldBegin("value", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->value);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(KeyValue &a, KeyValue &b) {
  using ::std::swap;
  swap(a.key, b.key);
  swap(a.value, b.value);
  swap(a.__isset, b.__isset);
}

const char* ColumnMetaData::ascii_fingerprint = "A54C067755C6EAFBFDF0932E09F82EB0";
const uint8_t ColumnMetaData::binary_fingerprint[16] = {0xA5,0x4C,0x06,0x77,0x55,0xC6,0xEA,0xFB,0xFD,0xF0,0x93,0x2E,0x09,0xF8,0x2E,0xB0};

uint32_t ColumnMetaData::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_type = false;
  bool isset_encodings = false;
  bool isset_path_in_schema = false;
  bool isset_codec = false;
  bool isset_num_values = false;
  bool isset_total_uncompressed_size = false;
  bool isset_total_compressed_size = false;
  bool isset_data_page_offset = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast8;
          xfer += iprot->readI32(ecast8);
          this->type = (Type::type)ecast8;
          isset_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->encodings.clear();
            uint32_t _size9;
            ::apache::thrift::protocol::TType _etype12;
            xfer += iprot->readListBegin(_etype12, _size9);
            this->encodings.resize(_size9);
            uint32_t _i13;
            for (_i13 = 0; _i13 < _size9; ++_i13)
            {
              int32_t ecast14;
              xfer += iprot->readI32(ecast14);
              this->encodings[_i13] = (Encoding::type)ecast14;
            }
            xfer += iprot->readListEnd();
          }
          isset_encodings = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->path_in_schema.clear();
            uint32_t _size15;
            ::apache::thrift::protocol::TType _etype18;
            xfer += iprot->readListBegin(_etype18, _size15);
            this->path_in_schema.resize(_size15);
            uint32_t _i19;
            for (_i19 = 0; _i19 < _size15; ++_i19)
            {
              xfer += iprot->readString(this->path_in_schema[_i19]);
            }
            xfer += iprot->readListEnd();
          }
          isset_path_in_schema = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast20;
          xfer += iprot->readI32(ecast20);
          this->codec = (CompressionCodec::type)ecast20;
          isset_codec = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->num_values);
          isset_num_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->total_uncompressed_size);
          isset_total_uncompressed_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->total_compressed_size);
          isset_total_compressed_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->key_value_metadata.clear();
            uint32_t _size21;
            ::apache::thrift::protocol::TType _etype24;
            xfer += iprot->readListBegin(_etype24, _size21);
            this->key_value_metadata.resize(_size21);
            uint32_t _i25;
            for (_i25 = 0; _i25 < _size21; ++_i25)
            {
              xfer += this->key_value_metadata[_i25].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.key_value_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->data_page_offset);
          isset_data_page_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->index_page_offset);
          this->__isset.index_page_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->dictionary_page_offset);
          this->__isset.dictionary_page_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_type)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_encodings)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_path_in_schema)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_codec)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_num_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_total_uncompressed_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_total_compressed_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_data_page_offset)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ColumnMetaData::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ColumnMetaData");

  xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->type);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("encodings", ::apache::thrift::protocol::T_LIST, 2);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I32, static_cast<uint32_t>(this->encodings.size()));
    std::vector<Encoding::type> ::const_iterator _iter26;
    for (_iter26 = this->encodings.begin(); _iter26 != this->encodings.end(); ++_iter26)
    {
      xfer += oprot->writeI32((int32_t)(*_iter26));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("path_in_schema", ::apache::thrift::protocol::T_LIST, 3);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->path_in_schema.size()));
    std::vector<std::string> ::const_iterator _iter27;
    for (_iter27 = this->path_in_schema.begin(); _iter27 != this->path_in_schema.end(); ++_iter27)
    {
      xfer += oprot->writeString((*_iter27));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("codec", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32((int32_t)this->codec);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("num_values", ::apache::thrift::protocol::T_I64, 5);
  xfer += oprot->writeI64(this->num_values);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("total_uncompressed_size", ::apache::thrift::protocol::T_I64, 6);
  xfer += oprot->writeI64(this->total_uncompressed_size);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("total_compressed_size", ::apache::thrift::protocol::T_I64, 7);
  xfer += oprot->writeI64(this->total_compressed_size);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.key_value_metadata) {
    xfer += oprot->writeFieldBegin("key_value_metadata", ::apache::thrift::protocol::T_LIST, 8);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->key_value_metadata.size()));
      std::vector<KeyValue> ::const_iterator _iter28;
      for (_iter28 = this->key_value_metadata.begin(); _iter28 != this->key_value_metadata.end(); ++_iter28)
      {
        xfer += (*_iter28).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("data_page_offset", ::apache::thrift::protocol::T_I64, 9);
  xfer += oprot->writeI64(this->data_page_offset);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.index_page_offset) {
    xfer += oprot->writeFieldBegin("index_page_offset", ::apache::thrift::protocol::T_I64, 10);
    xfer += oprot->writeI64(this->index_page_offset);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dictionary_page_offset) {
    xfer += oprot->writeFieldBegin("dictionary_page_offset", ::apache::thrift::protocol::T_I64, 11);
    xfer += oprot->writeI64(this->dictionary_page_offset);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ColumnMetaData &a, ColumnMetaData &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.encodings, b.encodings);
  swap(a.path_in_schema, b.path_in_schema);
  swap(a.codec, b.codec);
  swap(a.num_values, b.num_values);
  swap(a.total_uncompressed_size, b.total_uncompressed_size);
  swap(a.total_compressed_size, b.total_compressed_size);
  swap(a.key_value_metadata, b.key_value_metadata);
  swap(a.data_page_offset, b.data_page_offset);
  swap(a.index_page_offset, b.index_page_offset);
  swap(a.dictionary_page_offset, b.dictionary_page_offset);
  swap(a.__isset, b.__isset);
}

const char* ColumnChunk::ascii_fingerprint = "29169DCD85D0F73C1E4A817035671669";
const uint8_t ColumnChunk::binary_fingerprint[16] = {0x29,0x16,0x9D,0xCD,0x85,0xD0,0xF7,0x3C,0x1E,0x4A,0x81,0x70,0x35,0x67,0x16,0x69};

uint32_t ColumnChunk::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_file_offset = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->file_path);
          this->__isset.file_path = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->file_offset);
          isset_file_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->meta_data.read(iprot);
          this->__isset.meta_data = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_file_offset)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ColumnChunk::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("ColumnChunk");

  if (this->__isset.file_path) {
    xfer += oprot->writeFieldBegin("file_path", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeString(this->file_path);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("file_offset", ::apache::thrift::protocol::T_I64, 2);
  xfer += oprot->writeI64(this->file_offset);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.meta_data) {
    xfer += oprot->writeFieldBegin("meta_data", ::apache::thrift::protocol::T_STRUCT, 3);
    xfer += this->meta_data.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ColumnChunk &a, ColumnChunk &b) {
  using ::std::swap;
  swap(a.file_path, b.file_path);
  swap(a.file_offset, b.file_offset);
  swap(a.meta_data, b.meta_data);
  swap(a.__isset, b.__isset);
}

const char* RowGroup::ascii_fingerprint = "DB64FC4C180CA5E20E79F13A43A96875";
const uint8_t RowGroup::binary_fingerprint[16] = {0xDB,0x64,0xFC,0x4C,0x18,0x0C,0xA5,0xE2,0x0E,0x79,0xF1,0x3A,0x43,0xA9,0x68,0x75};

uint32_t RowGroup::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_columns = false;
  bool isset_total_byte_size = false;
  bool isset_num_rows = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->columns.clear();
            uint32_t _size29;
            ::apache::thrift::protocol::TType _etype32;
            xfer += iprot->readListBegin(_etype32, _size29);
            this->columns.resize(_size29);
            uint32_t _i33;
            for (_i33 = 0; _i33 < _size29; ++_i33)
            {
              xfer += this->columns[_i33].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_columns = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->total_byte_size);
          isset_total_byte_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->num_rows);
          isset_num_rows = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_columns)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_total_byte_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_num_rows)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t RowGroup::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("RowGroup");

  xfer += oprot->writeFieldBegin("columns", ::apache::thrift::protocol::T_LIST, 1);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->columns.size()));
    std::vector<ColumnChunk> ::const_iterator _iter34;
    for (_iter34 = this->columns.begin(); _iter34 != this->columns.end(); ++_iter34)
    {
      xfer += (*_iter34).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("total_byte_size", ::apache::thrift::protocol::T_I64, 2);
  xfer += oprot->writeI64(this->total_byte_size);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("num_rows", ::apache::thrift::protocol::T_I64, 3);
  xfer += oprot->writeI64(this->num_rows);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(RowGroup &a, RowGroup &b) {
  using ::std::swap;
  swap(a.columns, b.columns);
  swap(a.total_byte_size, b.total_byte_size);
  swap(a.num_rows, b.num_rows);
}

const char* FileMetaData::ascii_fingerprint = "E6BD0032D8B4E43BE08802936E279571";
const uint8_t FileMetaData::binary_fingerprint[16] = {0xE6,0xBD,0x00,0x32,0xD8,0xB4,0xE4,0x3B,0xE0,0x88,0x02,0x93,0x6E,0x27,0x95,0x71};

uint32_t FileMetaData::read(::apache::thrift::protocol::TProtocol* iprot) {

  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_version = false;
  bool isset_schema = false;
  bool isset_num_rows = false;
  bool isset_row_groups = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->version);
          isset_version = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->schema.clear();
            uint32_t _size35;
            ::apache::thrift::protocol::TType _etype38;
            xfer += iprot->readListBegin(_etype38, _size35);
            this->schema.resize(_size35);
            uint32_t _i39;
            for (_i39 = 0; _i39 < _size35; ++_i39)
            {
              xfer += this->schema[_i39].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_schema = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->num_rows);
          isset_num_rows = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->row_groups.clear();
            uint32_t _size40;
            ::apache::thrift::protocol::TType _etype43;
            xfer += iprot->readListBegin(_etype43, _size40);
            this->row_groups.resize(_size40);
            uint32_t _i44;
            for (_i44 = 0; _i44 < _size40; ++_i44)
            {
              xfer += this->row_groups[_i44].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_row_groups = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->key_value_metadata.clear();
            uint32_t _size45;
            ::apache::thrift::protocol::TType _etype48;
            xfer += iprot->readListBegin(_etype48, _size45);
            this->key_value_metadata.resize(_size45);
            uint32_t _i49;
            for (_i49 = 0; _i49 < _size45; ++_i49)
            {
              xfer += this->key_value_metadata[_i49].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.key_value_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->created_by);
          this->__isset.created_by = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_version)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_schema)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_num_rows)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_row_groups)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t FileMetaData::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  xfer += oprot->writeStructBegin("FileMetaData");

  xfer += oprot->writeFieldBegin("version", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->version);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("schema", ::apache::thrift::protocol::T_LIST, 2);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->schema.size()));
    std::vector<SchemaElement> ::const_iterator _iter50;
    for (_iter50 = this->schema.begin(); _iter50 != this->schema.end(); ++_iter50)
    {
      xfer += (*_iter50).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("num_rows", ::apache::thrift::protocol::T_I64, 3);
  xfer += oprot->writeI64(this->num_rows);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("row_groups", ::apache::thrift::protocol::T_LIST, 4);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->row_groups.size()));
    std::vector<RowGroup> ::const_iterator _iter51;
    for (_iter51 = this->row_groups.begin(); _iter51 != this->row_groups.end(); ++_iter51)
    {
      xfer += (*_iter51).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  if (this->__isset.key_value_metadata) {
    xfer += oprot->writeFieldBegin("key_value_metadata", ::apache::thrift::protocol::T_LIST, 5);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->key_value_metadata.size()));
      std::vector<KeyValue> ::const_iterator _iter52;
      for (_iter52 = this->key_value_metadata.begin(); _iter52 != this->key_value_metadata.end(); ++_iter52)
      {
        xfer += (*_iter52).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.created_by) {
    xfer += oprot->writeFieldBegin("created_by", ::apache::thrift::protocol::T_STRING, 6);
    xfer += oprot->writeString(this->created_by);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(FileMetaData &a, FileMetaData &b) {
  using ::std::swap;
  swap(a.version, b.version);
  swap(a.schema, b.schema);
  swap(a.num_rows, b.num_rows);
  swap(a.row_groups, b.row_groups);
  swap(a.key_value_metadata, b.key_value_metadata);
  swap(a.created_by, b.created_by);
  swap(a.__isset, b.__isset);
}

} // namespace
