/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef TOKEN_H_
#define TOKEN_H_

#include "YARNSecurity.pb.h"

using std::string;
using namespace hadoop::common;

namespace libyarn {
/*
message TokenProto {
  required bytes identifier = 1;
  required bytes password = 2;
  required string kind = 3;
  required string service = 4;
}
 */
class Token {
public:
	Token();
	Token(const TokenProto &proto);
	virtual ~Token();

	TokenProto& getProto();

	void setIdentifier(string &identifier);
	string getIdentifier();

	void setPassword(string &passwd);
	string getPassword();

	void setKind(string &kind);
	string getKind();

	void setService(string &service);
	string getService();

private:
	TokenProto tokenProto;
};

} /* namespace libyarn */

#endif /* TOKEN_H_ */
