FUNCTION(AUTO_SOURCES RETURN_VALUE PATTERN SOURCE_SUBDIRS)

	IF ("${SOURCE_SUBDIRS}" STREQUAL "RECURSE")
		SET(PATH ".")
		IF (${ARGC} EQUAL 4)
			LIST(GET ARGV 3 PATH)
		ENDIF ()
	ENDIF()

	IF ("${SOURCE_SUBDIRS}" STREQUAL "RECURSE")
		UNSET(${RETURN_VALUE})
		FILE(GLOB SUBDIR_FILES "${PATH}/${PATTERN}")
		LIST(APPEND ${RETURN_VALUE} ${SUBDIR_FILES})

		FILE(GLOB SUBDIRS RELATIVE ${PATH} ${PATH}/*)

		FOREACH(DIR ${SUBDIRS})
			IF (IS_DIRECTORY ${PATH}/${DIR})
				IF (NOT "${DIR}" STREQUAL "CMAKEFILES")
					FILE(GLOB_RECURSE SUBDIR_FILES "${PATH}/${DIR}/${PATTERN}")
					LIST(APPEND ${RETURN_VALUE} ${SUBDIR_FILES})
				ENDIF()
			ENDIF()
		ENDFOREACH()
	ELSE ()
		FILE(GLOB ${RETURN_VALUE} "${PATTERN}")

		FOREACH (PATH ${SOURCE_SUBDIRS})
			FILE(GLOB SUBDIR_FILES "${PATH}/${PATTERN}")
			LIST(APPEND ${RETURN_VALUE} ${SUBDIR_FILES})
		ENDFOREACH(PATH ${SOURCE_SUBDIRS})
	ENDIF ()

	IF (${FILTER_OUT})
		LIST(REMOVE_ITEM ${RETURN_VALUE} ${FILTER_OUT})
	ENDIF()

	SET(${RETURN_VALUE} ${${RETURN_VALUE}} PARENT_SCOPE)
ENDFUNCTION(AUTO_SOURCES)

FUNCTION(CONTAINS_STRING FILE SEARCH RETURN_VALUE)
	FILE(STRINGS ${FILE} FILE_CONTENTS REGEX ".*${SEARCH}.*")
	IF (FILE_CONTENTS)
		SET(${RETURN_VALUE} TRUE PARENT_SCOPE)
	ENDIF()
ENDFUNCTION(CONTAINS_STRING)
