DROP TABLE IF EXISTS test_ao_alltypes;
CREATE TABLE test_ao_alltypes (c0 bool, c1 bit, c2 varbit, c3 bytea, c4 int2, c5 int4, c6 int8, c7 numeric, c8 char(10), c9 varchar(10), c10 text, c11 date, c12 time, c13 timestamp, c14 interval, c15 point, c16 lseg, c17 box, c18 circle, c19 path, c20 polygon, c21 macaddr, c22 inet, c23 cidr, c24 xml) with (appendonly=true, orientation=row, compresstype=none, blocksize=32768, checksum=false, compresslevel=0);
INSERT INTO test_ao_alltypes values ('false', '1', '1111', 'hello world', -128, 2147483647, -32768, null, 'bbccddeeff', '123456789a', 'hello world', '4277-12-31 AD', '04:05:06', null, '-178000000 years', null, '[(0,0),(6,6)]', '((0,1),(2,3))', '<(1,2),3>', null, '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
(null, '1', '1111', 'hello world', 0, 32767, 128, null, null, null, 'z', '4713-01-01 BC', '00:00:00', '2004-10-19 10:23:54', '-178000000 years', POINT(1,2), '[(0,0),(6,6)]', null, '<(1,2),3>', null, null, null, '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
('true', '1', '1111', 'aaaaaaaaaaaaaaaaaaa', -32768, 32767, 9223372036854775807, 6.54, null, '123456789a', 'hello world', '4277-12-31 AD', '00:00:00', '1999-01-08 04:05:06', '-178000000 years', null, null, null, '<(1,2),3>', null, '((1,1),(3,2),(4,5))', null, null, '172.20.143.0/24', '<aa>bb</aa>'),
('false', '1', '1111', 'hello world', null, 2147483647, -128, 6.54, null, 'bbccddeeff', 'z', null, '23:59:59', '4713-01-01 BC', null, null, '[(1,1),(2,2)]', '((0,1),(2,3))', '<(100,200),300>', '(1,1),(2,3),(4,5)', null, null, '192.168.1.255/24', '192.168.1.255/32', '<aa>bb</aa>'),
('true', '1', '1111', 'aaaaaaaaaaaaaaaaaaa', 128, 128, 128, null, null, '123456789a', 'z', '2014-03-02', '00:00:00', '2004-10-19 10:23:54', '178000000 years', POINT(1000,2000), '[(1,1),(2,2)]', '((0,1),(2,3))', null, null, '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001::7344', '172.20.143.0/24', '<aa>bb</aa>'),
(null, null, null, null, 128, 0, 32767, 0.0001, 'aaaa', null, 'z', '2014-03-02', null, '2942-12-31 AD', '-178000000 years', POINT(1,2), '[(1,1),(2,2)]', '((100,200),(200,400))', null, '(1,1)', null, 'FF:89:71:45:AE:01', '172.20.143.0', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
('false', null, '000000000011100', 'aaaaaaaaaaaaaaaaaaa', -128, -128, 2147483647, null, 'aaaa', 'bbccddeeff', '', null, '00:00:00', null, '178000000 years', POINT(100,200), '[(0,0),(6,6)]', null, '<(1,2),3>', '(1,1)', null, 'FF:89:71:45:AE:01', '172.20.143.0', '172.20.143.0/24', '<aa>bb</aa>'),
('true', '1', '1111', 'hello world', 0, 0, -2147483648, null, 'aaaa', 'bbccddeeff', '', '4277-12-31 AD', '04:05:06', '1999-01-08 04:05:06', '-178000000 years', POINT(1000,2000), '[(0,0),(6,6)]', null, null, null, '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '172.20.143.0', '192.168.1.255/32', '<aa>bb</aa>'),
('false', '1', null, null, 128, 128, 0, 6.54, 'bbccddeeff', 'bbccddeeff', 'z', null, '04:05:06', '2942-12-31 AD', '-178000000 years', null, null, '((0,1),(2,3))', null, '(1,1)', '((100,123),(5,10),(7,2),(4,5))', null, '172.20.143.0', '172.20.143.0/24', null),
('false', '1', '1111', null, null, -2147483648, null, 6.54, '123456789a', '123456789a', '', null, '00:00:00', '1999-01-08 04:05:06', null, null, '[(0,0),(6,6)]', null, '<(100,200),300>', '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', null, '172.20.143.0/24', null),
('true', '0', '000000000011100', 'aaaaaaaaaaaaaaaaaaa', 0, -2147483648, -9223372036854775808, null, '123456789a', 'aaaa', '', null, '00:00:00', '2942-12-31 AD', '178000000 years', POINT(100,200), '[(1,1),(2,2)]', '((0,1),(2,3))', null, '(1,1)', '((100,123),(5,10),(7,2),(4,5))', null, '192.168.1.255/24', '172.20.143.0/24', '<aa>bb</aa>'),
('false', '1', null, 'hello world', -128, -2147483648, -128, 6.54, 'aaaa', '123456789a', 'z', '2014-03-02', '04:05:06', null, '-178000000 years', POINT(100,200), '[(1,1),(2,2)]', '((0,1),(2,3))', null, '(1,1),(2,3),(4,5)', null, null, '172.20.143.0', '192.168.1.255/32', null),
(null, null, '000000000011100', 'hello world', null, 2147483647, 2147483647, null, null, '123456789a', '', '4713-01-01 BC', '04:05:06', '2004-10-19 10:23:54', '178000000 years', POINT(100,200), '[(0,0),(6,6)]', null, '<(100,200),300>', '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', null, '2001::7344', '192.168.1.255/32', '<aa>bb</aa>'),
('true', '1', null, 'hello world', null, -32768, 128, null, 'bbccddeeff', '123456789a', 'z', '4713-01-01 BC', null, '2942-12-31 AD', null, null, null, '((100,200),(200,400))', null, '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '172.20.143.0/24', null),
('false', null, '000000000011100', 'hello world', null, null, 32767, 0.0001, '123456789a', '123456789a', null, '2014-03-02', '04:05:06', null, null, POINT(1000,2000), null, '((100,200),(200,400))', null, '(1,1)', '((1,1),(3,2),(4,5))', null, null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('true', '0', null, 'hello world', 32767, 32767, 9223372036854775807, null, '123456789a', null, repeat('b',1000), null, '04:05:06', null, null, POINT(100,200), null, null, '<(100,200),300>', null, '((100,123),(5,10),(7,2),(4,5))', null, '2001::7344', null, '<aa>bb</aa>'),
('true', '0', null, 'aaaaaaaaaaaaaaaaaaa', -32768, 32767, null, 0.0001, '123456789a', 'aaaa', repeat('b',1000), '2014-03-02', null, null, null, POINT(1000,2000), '[(1,1),(2,2)]', null, '<(100,200),300>', null, '((1,1),(3,2),(4,5))', null, null, '192.168.1.255/32', null),
('true', null, '000000000011100', 'aaaaaaaaaaaaaaaaaaa', 128, null, -128, 6.54, '123456789a', 'bbccddeeff', 'hello world', '2014-03-02', '00:00:00', '4713-01-01 BC', '178000000 years', null, null, '((100,200),(200,400))', '<(100,200),300>', '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '192.168.1.255/32', '<name>wj</name>'),
(null, null, '000000000011100', 'hello world', 32767, -32768, 128, null, null, null, repeat('b',1000), '2014-03-02', '00:00:00', '4713-01-01 BC', '178000000 years', POINT(1,2), null, '((0,1),(2,3))', null, '(1,1),(2,3),(4,5)', null, 'FF:89:71:45:AE:01', null, null, '<aa>bb</aa>'),
('true', '0', null, 'aaaaaaaaaaaaaaaaaaa', -32768, 32767, -9223372036854775808, 6.54, 'aaaa', 'bbccddeeff', null, null, '00:00:00', null, '178000000 years', POINT(1,2), null, '((0,1),(2,3))', '<(1,2),3>', null, '((100,123),(5,10),(7,2),(4,5))', null, '172.20.143.0', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('false', '0', null, 'aaaaaaaaaaaaaaaaaaa', -128, -128, 32767, 6.54, 'aaaa', 'bbccddeeff', null, '4277-12-31 AD', '23:59:59', '4713-01-01 BC', '178000000 years', POINT(1000,2000), null, '((100,200),(200,400))', null, null, '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '172.20.143.0/24', null),
(null, null, null, 'aaaaaaaaaaaaaaaaaaa', 128, -32768, 2147483647, null, '123456789a', null, 'z', '4713-01-01 BC', '04:05:06', '2004-10-19 10:23:54', '-178000000 years', null, '[(0,0),(6,6)]', null, '<(100,200),300>', '(1,1)', null, 'FF:89:71:45:AE:01', '192.168.1.255/24', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
(null, '1', null, null, null, -32768, -2147483648, 0.0001, 'bbccddeeff', 'bbccddeeff', repeat('b',1000), '4713-01-01 BC', null, '4713-01-01 BC', '178000000 years', null, '[(0,0),(6,6)]', '((100,200),(200,400))', null, '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', null, null, '192.168.1.255/32', null),
(null, '0', null, 'hello world', -32768, -2147483648, 2147483647, 0.0001, null, '123456789a', 'hello world', '4277-12-31 AD', '23:59:59', '2004-10-19 10:23:54', null, POINT(1000,2000), '[(0,0),(6,6)]', '((0,1),(2,3))', null, '(1,1)', null, null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, null),
(null, '1', '000000000011100', 'hello world', null, null, 32767, 6.54, 'aaaa', 'aaaa', null, '2014-03-02', '04:05:06', '2004-10-19 10:23:54', '178000000 years', null, '[(1,1),(2,2)]', null, '<(100,200),300>', '(1,1)', null, 'FF:89:71:45:AE:01', null, '192.168.1.255/32', '<name>wj</name>'),
('false', null, null, null, 32767, -2147483648, -9223372036854775808, 0.0001, null, '123456789a', 'hello world', null, null, '1999-01-08 04:05:06', '178000000 years', POINT(100,200), '[(0,0),(6,6)]', '((0,1),(2,3))', null, '(1,1)', '((1,1),(3,2),(4,5))', null, '2001::7344', '192.168.1.255/32', null),
('true', '0', '000000000011100', null, 0, -32768, 32767, 0.0001, 'bbccddeeff', null, 'z', '4713-01-01 BC', null, '4713-01-01 BC', '-178000000 years', null, '[(0,0),(6,6)]', '((100,200),(200,400))', '<(100,200),300>', null, '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', null, '192.168.1.255/32', '<aa>bb</aa>'),
('true', '0', '1111', 'hello world', -128, -2147483648, 128, 6.54, null, 'bbccddeeff', repeat('b',1000), '2014-03-02', '04:05:06', '4713-01-01 BC', '178000000 years', POINT(100,200), '[(1,1),(2,2)]', '((100,200),(200,400))', '<(1,2),3>', '(1,1)', null, 'FF:89:71:45:AE:01', null, '192.168.1.255/32', null),
('false', '1', null, 'hello world', 0, -32768, 32767, null, null, null, null, '4277-12-31 AD', '04:05:06', '2942-12-31 AD', '178000000 years', POINT(1,2), null, null, '<(100,200),300>', '(1,1),(2,3),(4,5)', null, null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
(null, null, null, 'aaaaaaaaaaaaaaaaaaa', -128, -128, 9223372036854775807, null, 'bbccddeeff', '123456789a', null, '4277-12-31 AD', '00:00:00', '1999-01-08 04:05:06', null, null, '[(0,0),(6,6)]', null, null, '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '192.168.1.255/32', '<aa>bb</aa>'),
('true', '0', null, null, null, -32768, -128, 0.0001, 'aaaa', 'aaaa', '', '4277-12-31 AD', '23:59:59', '2942-12-31 AD', '178000000 years', null, '[(1,1),(2,2)]', null, '<(100,200),300>', '(1,1)', null, null, '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('false', null, '000000000011100', 'hello world', null, 32767, 0, 0.0001, 'bbccddeeff', 'bbccddeeff', 'z', '2014-03-02', '23:59:59', '2004-10-19 10:23:54', '178000000 years', null, null, '((100,200),(200,400))', '<(100,200),300>', null, '((100,123),(5,10),(7,2),(4,5))', null, '192.168.1.255/24', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
(null, '0', null, 'hello world', -128, 0, 0, 0.0001, '123456789a', '123456789a', null, '4277-12-31 AD', null, '4713-01-01 BC', '-178000000 years', POINT(100,200), null, '((100,200),(200,400))', '<(1,2),3>', null, '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
(null, '0', '1111', null, 0, -2147483648, 2147483647, 6.54, null, '123456789a', null, '4277-12-31 AD', null, '2004-10-19 10:23:54', null, POINT(1000,2000), '[(0,0),(6,6)]', '((0,1),(2,3))', '<(100,200),300>', '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '192.168.1.255/24', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
('false', null, null, 'hello world', 32767, 32767, -128, 0.0001, 'aaaa', 'aaaa', null, '4277-12-31 AD', null, '1999-01-08 04:05:06', '-178000000 years', null, null, null, '<(1,2),3>', '(1,1)', null, 'FF:89:71:45:AE:01', '192.168.1.255/24', '172.20.143.0/24', null),
('true', '0', '000000000011100', 'hello world', null, -2147483648, -2147483648, null, 'aaaa', 'bbccddeeff', '', null, '23:59:59', '1999-01-08 04:05:06', '-178000000 years', POINT(1000,2000), null, null, '<(100,200),300>', null, '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
('false', null, null, 'hello world', 0, -32768, -32768, null, 'bbccddeeff', 'aaaa', 'z', '4713-01-01 BC', '04:05:06', null, null, POINT(1,2), null, '((100,200),(200,400))', null, null, '((1,1),(3,2),(4,5))', null, null, '192.168.1.255/32', '<name>wj</name>'),
(null, '0', null, 'hello world', 32767, 0, 9223372036854775807, null, '123456789a', '123456789a', 'hello world', '4713-01-01 BC', '04:05:06', null, '-178000000 years', POINT(1,2), '[(1,1),(2,2)]', '((100,200),(200,400))', '<(100,200),300>', null, null, 'FF:89:71:45:AE:01', '192.168.1.255/24', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
('true', '1', null, 'hello world', 32767, -32768, 2147483647, 6.54, 'bbccddeeff', 'aaaa', 'hello world', '2014-03-02', '23:59:59', '2942-12-31 AD', '-178000000 years', null, '[(0,0),(6,6)]', '((0,1),(2,3))', '<(100,200),300>', '(1,1)', '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, '<name>wj</name>'),
('false', null, null, 'hello world', -32768, -32768, 2147483647, 0.0001, null, '123456789a', repeat('b',1000), '4277-12-31 AD', '23:59:59', null, null, null, '[(0,0),(6,6)]', null, '<(100,200),300>', null, null, 'FF:89:71:45:AE:01', null, '192.168.1.255/32', null),
(null, null, '000000000011100', 'hello world', 0, -32768, 128, 6.54, null, 'bbccddeeff', 'hello world', '4713-01-01 BC', '04:05:06', '2942-12-31 AD', '-178000000 years', POINT(1000,2000), null, null, '<(1,2),3>', '(1,1)', '((100,123),(5,10),(7,2),(4,5))', null, '192.168.1.255/24', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
('true', '0', null, null, -128, -32768, 9223372036854775807, 0.0001, 'aaaa', '123456789a', 'z', '2014-03-02', '23:59:59', null, null, POINT(100,200), '[(0,0),(6,6)]', '((0,1),(2,3))', null, '(1,1)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, null),
(null, '1', '1111', 'hello world', -32768, null, -128, 0.0001, 'bbccddeeff', 'bbccddeeff', '', null, '04:05:06', '2942-12-31 AD', null, null, null, null, '<(100,200),300>', '(1,1),(2,3),(4,5)', null, null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
('true', '0', null, null, 0, 128, -32768, null, '123456789a', null, null, '2014-03-02', null, '1999-01-08 04:05:06', '-178000000 years', null, '[(1,1),(2,2)]', '((0,1),(2,3))', '<(100,200),300>', '(1,1),(2,3),(4,5)', null, null, '172.20.143.0', '172.20.143.0/24', null),
(null, '1', null, null, 128, 32767, 0, 6.54, 'aaaa', null, 'hello world', '4277-12-31 AD', '00:00:00', '2004-10-19 10:23:54', null, null, '[(0,0),(6,6)]', '((100,200),(200,400))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', null, null, null),
(null, null, '000000000011100', 'hello world', -32768, 32767, 0, 6.54, 'bbccddeeff', 'aaaa', null, '4277-12-31 AD', '04:05:06', '2004-10-19 10:23:54', '-178000000 years', null, '[(0,0),(6,6)]', null, '<(100,200),300>', '(1,1),(2,3),(4,5)', null, null, '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('true', '1', '000000000011100', 'aaaaaaaaaaaaaaaaaaa', 32767, 32767, 9223372036854775807, 6.54, 'bbccddeeff', 'bbccddeeff', 'z', '4713-01-01 BC', '04:05:06', '2004-10-19 10:23:54', '178000000 years', null, '[(0,0),(6,6)]', null, '<(100,200),300>', '(1,1)', null, null, null, '172.20.143.0/24', '<name>wj</name>'),
('false', null, null, null, 32767, 128, -2147483648, 0.0001, 'bbccddeeff', null, repeat('b',1000), null, '04:05:06', '2942-12-31 AD', null, POINT(1,2), null, '((100,200),(200,400))', '<(100,200),300>', '(1,1)', null, 'FF:89:71:45:AE:01', '2001::7344', null, '<name>wj</name>'),
('false', null, '000000000011100', 'hello world', -128, 32767, 0, 6.54, null, null, '', '4277-12-31 AD', null, '2004-10-19 10:23:54', null, POINT(1,2), '[(1,1),(2,2)]', null, '<(1,2),3>', null, null, 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '192.168.1.255/32', '<aa>bb</aa>'),
('true', '1', '1111', 'hello world', -128, null, 9223372036854775807, 6.54, '123456789a', 'bbccddeeff', repeat('b',1000), null, '00:00:00', null, '178000000 years', POINT(100,200), '[(0,0),(6,6)]', '((100,200),(200,400))', '<(1,2),3>', null, null, 'FF:89:71:45:AE:01', '192.168.1.255/24', '172.20.143.0/24', '<aa>bb</aa>'),
('false', '0', null, 'hello world', -32768, -2147483648, null, 0.0001, null, 'aaaa', '', null, '00:00:00', null, null, null, null, null, null, null, null, null, '172.20.143.0', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('true', null, '1111', 'hello world', 0, 128, -9223372036854775808, 0.0001, '123456789a', null, 'hello world', '2014-03-02', null, '2942-12-31 AD', null, POINT(1,2), '[(0,0),(6,6)]', '((100,200),(200,400))', null, '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '172.20.143.0', '172.20.143.0/24', '<name>wj</name>'),
('true', '1', null, 'aaaaaaaaaaaaaaaaaaa', 0, null, 128, 6.54, '123456789a', '123456789a', 'z', '4277-12-31 AD', '23:59:59', '1999-01-08 04:05:06', null, POINT(100,200), null, '((100,200),(200,400))', null, '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', null, '172.20.143.0/24', null),
('true', '1', '1111', 'hello world', -32768, -2147483648, -9223372036854775808, 0.0001, 'aaaa', 'bbccddeeff', 'z', '4713-01-01 BC', '00:00:00', null, '-178000000 years', null, '[(0,0),(6,6)]', '((0,1),(2,3))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, null),
('false', '0', null, null, -32768, 0, 128, 0.0001, 'bbccddeeff', null, 'z', '4277-12-31 AD', '23:59:59', '4713-01-01 BC', null, POINT(100,200), '[(1,1),(2,2)]', null, '<(100,200),300>', '(1,1),(2,3),(4,5)', null, null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, '<aa>bb</aa>'),
('false', '0', null, 'hello world', 0, 32767, 2147483647, 0.0001, null, null, repeat('b',1000), '4277-12-31 AD', '04:05:06', '2004-10-19 10:23:54', '178000000 years', null, '[(1,1),(2,2)]', '((100,200),(200,400))', '<(100,200),300>', null, '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '192.168.1.255/24', '192.168.1.255/32', '<aa>bb</aa>'),
('true', '0', '000000000011100', 'hello world', -32768, -32768, 128, 0.0001, 'aaaa', 'aaaa', 'z', '4277-12-31 AD', '04:05:06', '1999-01-08 04:05:06', null, POINT(100,200), null, '((0,1),(2,3))', null, null, null, 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, '<name>wj</name>'),
(null, '1', '000000000011100', null, -128, -32768, 2147483647, 6.54, null, null, repeat('b',1000), '2014-03-02', '04:05:06', '1999-01-08 04:05:06', null, POINT(1000,2000), null, null, null, '(1,1)', null, 'FF:89:71:45:AE:01', '2001::7344', '172.20.143.0/24', '<name>wj</name>'),
(null, '0', null, null, -128, 0, -9223372036854775808, null, 'aaaa', 'bbccddeeff', 'hello world', '2014-03-02', '04:05:06', '1999-01-08 04:05:06', null, null, '[(1,1),(2,2)]', '((0,1),(2,3))', null, null, null, 'FF:89:71:45:AE:01', '2001::7344', '192.168.1.255/32', '<aa>bb</aa>'),
(null, '0', '000000000011100', 'aaaaaaaaaaaaaaaaaaa', -128, 128, -32768, null, '123456789a', 'bbccddeeff', repeat('b',1000), '4277-12-31 AD', null, null, '-178000000 years', null, '[(0,0),(6,6)]', '((100,200),(200,400))', '<(1,2),3>', '(1,1)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, '<aa>bb</aa>'),
('false', null, '1111', null, 0, 2147483647, -128, 0.0001, null, 'bbccddeeff', '', null, '00:00:00', '2004-10-19 10:23:54', null, POINT(100,200), '[(1,1),(2,2)]', '((0,1),(2,3))', null, null, null, null, '172.20.143.0', '172.20.143.0/24', null),
('false', '0', null, null, -128, 32767, 2147483647, null, 'aaaa', null, repeat('b',1000), '4713-01-01 BC', '04:05:06', '2004-10-19 10:23:54', '-178000000 years', POINT(1,2), null, null, '<(1,2),3>', '(1,1)', null, 'FF:89:71:45:AE:01', null, null, '<name>wj</name>'),
(null, '1', '1111', 'aaaaaaaaaaaaaaaaaaa', -128, -32768, 0, 0.0001, 'aaaa', 'aaaa', 'z', '4277-12-31 AD', '04:05:06', '1999-01-08 04:05:06', '178000000 years', POINT(1,2), '[(0,0),(6,6)]', null, '<(1,2),3>', '(1,1)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
('true', '1', '1111', 'hello world', -32768, 0, 9223372036854775807, 6.54, 'bbccddeeff', 'bbccddeeff', repeat('b',1000), '4713-01-01 BC', null, null, '-178000000 years', POINT(100,200), '[(0,0),(6,6)]', null, '<(100,200),300>', '(1,1)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '172.20.143.0', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('true', '0', null, 'aaaaaaaaaaaaaaaaaaa', 0, null, 9223372036854775807, 6.54, 'aaaa', '123456789a', 'hello world', null, '23:59:59', '2942-12-31 AD', null, POINT(1,2), null, '((100,200),(200,400))', null, null, '((100,123),(5,10),(7,2),(4,5))', null, '172.20.143.0', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('true', '1', null, null, -32768, 2147483647, -2147483648, 6.54, 'aaaa', 'bbccddeeff', 'z', '2014-03-02', '04:05:06', '4713-01-01 BC', '178000000 years', POINT(100,200), '[(0,0),(6,6)]', null, '<(1,2),3>', null, '((1,1),(3,2),(4,5))', null, null, '172.20.143.0/24', '<name>wj</name>'),
(null, null, '1111', 'hello world', -32768, 2147483647, 2147483647, 6.54, 'bbccddeeff', '123456789a', 'hello world', '2014-03-02', '04:05:06', '2942-12-31 AD', null, POINT(1,2), null, '((100,200),(200,400))', '<(100,200),300>', null, null, 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
(null, '0', '1111', 'aaaaaaaaaaaaaaaaaaa', -128, -2147483648, null, 6.54, null, null, 'hello world', '4277-12-31 AD', '04:05:06', '4713-01-01 BC', '178000000 years', POINT(1,2), '[(0,0),(6,6)]', '((100,200),(200,400))', null, '(1,1),(2,3),(4,5)', null, 'FF:89:71:45:AE:01', null, '172.20.143.0/24', '<name>wj</name>'),
('false', '1', null, 'hello world', null, 0, -128, null, null, 'aaaa', 'hello world', '4277-12-31 AD', '00:00:00', '4713-01-01 BC', '178000000 years', POINT(1,2), null, '((100,200),(200,400))', '<(1,2),3>', '(1,1)', null, null, null, '172.20.143.0/24', '<aa>bb</aa>'),
(null, '1', '1111', null, null, 32767, 9223372036854775807, null, '123456789a', 'aaaa', repeat('b',1000), null, '00:00:00', '2942-12-31 AD', '178000000 years', POINT(1,2), '[(1,1),(2,2)]', null, '<(1,2),3>', null, '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
('true', '1', '1111', 'hello world', -128, null, -128, 0.0001, '123456789a', 'aaaa', null, '4277-12-31 AD', '23:59:59', '2942-12-31 AD', null, POINT(1000,2000), '[(1,1),(2,2)]', '((100,200),(200,400))', '<(100,200),300>', '(1,1)', null, null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, null),
(null, '1', null, null, -128, 128, 9223372036854775807, 6.54, '123456789a', null, 'z', null, '23:59:59', '2942-12-31 AD', '178000000 years', POINT(100,200), '[(1,1),(2,2)]', null, '<(100,200),300>', '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', null, null, '192.168.1.255/32', null),
('false', '1', '1111', 'aaaaaaaaaaaaaaaaaaa', -32768, -128, 2147483647, null, '123456789a', 'bbccddeeff', repeat('b',1000), '2014-03-02', '04:05:06', '1999-01-08 04:05:06', '178000000 years', POINT(100,200), '[(1,1),(2,2)]', null, '<(1,2),3>', null, '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
('false', null, '000000000011100', null, 0, 128, null, 6.54, 'bbccddeeff', 'bbccddeeff', null, '4277-12-31 AD', '04:05:06', '2004-10-19 10:23:54', null, POINT(1,2), '[(1,1),(2,2)]', '((0,1),(2,3))', null, '(1,1)', null, 'FF:89:71:45:AE:01', '172.20.143.0', '172.20.143.0/24', null),
('true', null, null, 'aaaaaaaaaaaaaaaaaaa', 128, 128, 0, 6.54, null, 'aaaa', repeat('b',1000), null, '23:59:59', '2004-10-19 10:23:54', null, POINT(1,2), '[(1,1),(2,2)]', '((100,200),(200,400))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '172.20.143.0', '192.168.1.255/32', '<name>wj</name>'),
('false', '1', null, null, -32768, 2147483647, 9223372036854775807, 6.54, 'bbccddeeff', 'aaaa', 'z', null, null, '2004-10-19 10:23:54', null, POINT(1,2), '[(0,0),(6,6)]', null, '<(100,200),300>', null, null, null, null, '172.20.143.0/24', null),
('true', null, null, 'hello world', -32768, 128, 32767, 6.54, 'aaaa', 'bbccddeeff', '', '2014-03-02', '00:00:00', null, null, POINT(1000,2000), '[(1,1),(2,2)]', null, null, '(1,1)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
('true', '1', '1111', null, -128, null, -32768, 0.0001, 'aaaa', 'bbccddeeff', null, '4277-12-31 AD', '23:59:59', '2004-10-19 10:23:54', '-178000000 years', POINT(1,2), '[(1,1),(2,2)]', null, '<(100,200),300>', '(1,1)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
(null, null, '000000000011100', 'hello world', 128, -128, -2147483648, 0.0001, 'bbccddeeff', 'bbccddeeff', 'hello world', '2014-03-02', null, '1999-01-08 04:05:06', '178000000 years', POINT(100,200), '[(1,1),(2,2)]', '((100,200),(200,400))', '<(100,200),300>', '(1,1),(2,3),(4,5)', null, 'FF:89:71:45:AE:01', null, '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
('false', '1', '000000000011100', null, null, -128, -2147483648, 6.54, '123456789a', 'aaaa', null, '4713-01-01 BC', '23:59:59', '2942-12-31 AD', null, POINT(100,200), null, null, null, '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', null, '192.168.1.255/32', '<name>wj</name>'),
('false', null, null, 'aaaaaaaaaaaaaaaaaaa', 32767, -2147483648, -128, null, 'bbccddeeff', '123456789a', null, '4277-12-31 AD', '23:59:59', '1999-01-08 04:05:06', '-178000000 years', null, null, null, null, null, null, null, '172.20.143.0', null, null),
('true', null, '000000000011100', 'hello world', 0, -32768, -2147483648, 0.0001, 'aaaa', '123456789a', '', '2014-03-02', null, '4713-01-01 BC', '178000000 years', POINT(1,2), '[(1,1),(2,2)]', '((0,1),(2,3))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', null, '<aa>bb</aa>'),
('false', '0', null, 'aaaaaaaaaaaaaaaaaaa', 32767, -128, 9223372036854775807, 6.54, 'aaaa', 'aaaa', 'z', '4277-12-31 AD', '23:59:59', '2004-10-19 10:23:54', null, POINT(1,2), '[(1,1),(2,2)]', null, null, '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', null, '2001::7344', null, '<aa>bb</aa>'),
('true', null, '1111', 'hello world', null, -2147483648, 32767, 6.54, 'bbccddeeff', null, null, '2014-03-02', '00:00:00', '1999-01-08 04:05:06', '178000000 years', POINT(1000,2000), '[(0,0),(6,6)]', null, '<(100,200),300>', null, null, null, '192.168.1.255/24', '192.168.1.255/32', '<aa>bb</aa>'),
('false', '1', '000000000011100', 'hello world', -128, -32768, -2147483648, 0.0001, 'bbccddeeff', null, repeat('b',1000), null, '04:05:06', '1999-01-08 04:05:06', null, POINT(1000,2000), '[(0,0),(6,6)]', '((100,200),(200,400))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', null, '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', null),
('true', null, null, null, -128, 2147483647, 128, 6.54, 'aaaa', null, repeat('b',1000), '2014-03-02', '00:00:00', '2942-12-31 AD', null, null, null, '((0,1),(2,3))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', null, '2001::7344', null, '<aa>bb</aa>'),
('true', '1', '000000000011100', 'aaaaaaaaaaaaaaaaaaa', -32768, 32767, -32768, 6.54, null, '123456789a', null, '4277-12-31 AD', '04:05:06', '2942-12-31 AD', '178000000 years', POINT(100,200), null, '((100,200),(200,400))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('true', null, null, 'aaaaaaaaaaaaaaaaaaa', -128, 32767, 0, 0.0001, null, '123456789a', 'hello world', '2014-03-02', '23:59:59', '1999-01-08 04:05:06', '-178000000 years', null, '[(0,0),(6,6)]', '((0,1),(2,3))', '<(1,2),3>', null, null, null, '172.20.143.0', '192.168.1.255/32', '<name>wj</name>'),
(null, '1', null, null, 128, 2147483647, null, 6.54, '123456789a', 'aaaa', 'hello world', null, '00:00:00', null, null, POINT(1,2), '[(1,1),(2,2)]', '((0,1),(2,3))', null, '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '2001::7344', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
(null, null, '1111', null, null, 32767, -32768, 6.54, '123456789a', '123456789a', null, '4277-12-31 AD', null, '4713-01-01 BC', null, POINT(1000,2000), null, '((0,1),(2,3))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', null, '2001::7344', '172.20.143.0/24', null),
('false', '1', '1111', 'aaaaaaaaaaaaaaaaaaa', -32768, -128, 9223372036854775807, 6.54, null, 'bbccddeeff', 'z', '4713-01-01 BC', '04:05:06', '4713-01-01 BC', '178000000 years', null, '[(1,1),(2,2)]', '((100,200),(200,400))', null, '(1,1)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', null, '172.20.143.0/24', null),
('false', '1', null, 'hello world', 0, 32767, 2147483647, null, null, '123456789a', null, '4277-12-31 AD', null, '2942-12-31 AD', '-178000000 years', POINT(100,200), '[(1,1),(2,2)]', '((100,200),(200,400))', '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', null, '172.20.143.0', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
(null, '0', '000000000011100', 'aaaaaaaaaaaaaaaaaaa', -32768, -128, 9223372036854775807, null, 'aaaa', '123456789a', null, '4277-12-31 AD', '00:00:00', '2942-12-31 AD', null, null, '[(1,1),(2,2)]', null, '<(1,2),3>', '(1,1),(2,3),(4,5)', null, 'FF:89:71:45:AE:01', '172.20.143.0', '172.20.143.0/24', null),
('false', null, '1111', null, 32767, -32768, -9223372036854775808, 0.0001, 'bbccddeeff', '123456789a', 'z', '4277-12-31 AD', null, '2004-10-19 10:23:54', null, null, null, null, '<(1,2),3>', '(1,1),(2,3),(4,5)', '((100,123),(5,10),(7,2),(4,5))', 'FF:89:71:45:AE:01', '172.20.143.0', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<name>wj</name>'),
('false', null, '000000000011100', 'aaaaaaaaaaaaaaaaaaa', 0, -32768, -2147483648, 6.54, '123456789a', 'aaaa', '', null, '04:05:06', '2942-12-31 AD', '-178000000 years', POINT(1000,2000), '[(1,1),(2,2)]', '((100,200),(200,400))', '<(1,2),3>', '(1,1)', '((100,123),(5,10),(7,2),(4,5))', null, null, '192.168.1.255/32', '<name>wj</name>'),
('true', null, null, 'hello world', -128, 0, -9223372036854775808, null, 'bbccddeeff', 'aaaa', null, null, null, '2942-12-31 AD', '-178000000 years', POINT(1,2), '[(1,1),(2,2)]', '((0,1),(2,3))', '<(1,2),3>', '(1,1),(2,3),(4,5)', null, 'FF:89:71:45:AE:01', '172.20.143.0', null, '<name>wj</name>'),
('false', '1', '000000000011100', 'hello world', 0, null, 9223372036854775807, 6.54, '123456789a', '123456789a', repeat('b',1000), null, '04:05:06', '2004-10-19 10:23:54', '178000000 years', POINT(1000,2000), '[(1,1),(2,2)]', '((100,200),(200,400))', '<(1,2),3>', '(1,1),(2,3),(4,5)', null, null, '172.20.143.0', '2001:db8:85a3:8d3:1319:8a2e:370:7344/128', '<aa>bb</aa>'),
('false', null, null, 'hello world', 0, 32767, 2147483647, 0.0001, 'aaaa', null, 'hello world', null, '04:05:06', '2004-10-19 10:23:54', '-178000000 years', POINT(100,200), '[(1,1),(2,2)]', '((0,1),(2,3))', '<(100,200),300>', null, null, 'FF:89:71:45:AE:01', '2001:db8:85a3:8d3:1319:8a2e:370:7344/64', '172.20.143.0/24', '<name>wj</name>'),
(null, '0', '000000000011100', null, 0, 32767, 9223372036854775807, 0.0001, 'aaaa', 'bbccddeeff', null, '4713-01-01 BC', null, null, '-178000000 years', POINT(1,2), '[(0,0),(6,6)]', '((100,200),(200,400))', null, '(1,1)', null, null, '172.20.143.0', '172.20.143.0/24', null),
(null, '1', '1111', null, -32768, 2147483647, 128, 0.0001, 'bbccddeeff', 'bbccddeeff', 'z', '2014-03-02', '23:59:59', '4713-01-01 BC', '-178000000 years', POINT(1,2), '[(0,0),(6,6)]', '((100,200),(200,400))', '<(100,200),300>', '(1,1),(2,3),(4,5)', '((1,1),(3,2),(4,5))', 'FF:89:71:45:AE:01', '2001::7344', null, '<aa>bb</aa>');