package com.pivotal.hawq.mapreduce.file;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


/**
 * This class describe file status of database.
 */
public class HAWQFileStatus
{
	protected String filePath = null;
	protected long fileLength;

	public HAWQFileStatus(String filePath, long fileLength) {
		this.filePath = filePath;
		this.fileLength = fileLength;
	}

	/**
	 * Get path string of this file
	 * 
	 * @return path
	 */
	public String getFilePath()
	{
		return filePath;
	}

	/**
	 * Get file length of this file
	 * 
	 * @return file length
	 */
	public long getFileLength()
	{
		return fileLength;
	}

}
