/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.synthetic;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.MapTaskAttemptInfo;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.ReduceTaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskInfo;
import org.apache.hadoop.yarn.sls.synthetic.SynthJobClass;
import org.apache.hadoop.yarn.sls.synthetic.SynthUtils;

public class SynthJob
implements JobStory {
    private static Log LOG = LogFactory.getLog(SynthJob.class);
    private final Configuration conf;
    private final int id;
    private static final AtomicInteger sequence = new AtomicInteger(0);
    private final String name;
    private final String queueName;
    private final SynthJobClass jobClass;
    private final long submitTime;
    private final long duration;
    private final long deadline;
    private final int numMapTasks;
    private final int numRedTasks;
    private final long mapMaxMemory;
    private final long reduceMaxMemory;
    private final long mapMaxVcores;
    private final long reduceMaxVcores;
    private final long[] mapRuntime;
    private final float[] reduceRuntime;
    private long totMapRuntime;
    private long totRedRuntime;

    public SynthJob(JDKRandomGenerator rand, Configuration conf, SynthJobClass jobClass, long actualSubmissionTime) {
        int i;
        this.conf = conf;
        this.jobClass = jobClass;
        this.duration = TimeUnit.MILLISECONDS.convert(jobClass.getDur(), TimeUnit.SECONDS);
        this.numMapTasks = jobClass.getMtasks();
        this.numRedTasks = jobClass.getRtasks();
        long tempMapMaxMemory = jobClass.getMapMaxMemory();
        this.mapMaxMemory = tempMapMaxMemory < 1024L ? 1024L : tempMapMaxMemory;
        long tempReduceMaxMemory = jobClass.getReduceMaxMemory();
        this.reduceMaxMemory = tempReduceMaxMemory < 1024L ? 1024L : tempReduceMaxMemory;
        long tempMapMaxVCores = jobClass.getMapMaxVcores();
        this.mapMaxVcores = tempMapMaxVCores < 1L ? 1L : tempMapMaxVCores;
        long tempReduceMaxVcores = jobClass.getReduceMaxVcores();
        long l = this.reduceMaxVcores = tempReduceMaxVcores < 1L ? 1L : tempReduceMaxVcores;
        if (this.numMapTasks > 0) {
            conf.setLong("mapreduce.map.memory.mb", this.mapMaxMemory);
            conf.set("mapreduce.map.java.opts", "-Xmx" + (this.mapMaxMemory - 100L) + "m");
        }
        if (this.numRedTasks > 0) {
            conf.setLong("mapreduce.reduce.memory.mb", this.reduceMaxMemory);
            conf.set("mapreduce.reduce.java.opts", "-Xmx" + (this.reduceMaxMemory - 100L) + "m");
        }
        boolean hasDeadline = rand.nextDouble() <= jobClass.jobClass.chance_of_reservation;
        LogNormalDistribution deadlineFactor = SynthUtils.getLogNormalDist(rand, jobClass.jobClass.deadline_factor_avg, jobClass.jobClass.deadline_factor_stddev);
        double deadlineFactorSample = deadlineFactor != null ? deadlineFactor.sample() : -1.0;
        this.queueName = jobClass.workload.getQueueName();
        this.submitTime = TimeUnit.MILLISECONDS.convert(actualSubmissionTime, TimeUnit.SECONDS);
        this.deadline = hasDeadline ? TimeUnit.MILLISECONDS.convert(actualSubmissionTime, TimeUnit.SECONDS) + (long)Math.ceil(deadlineFactorSample * (double)this.duration) : -1L;
        conf.set("mapreduce.job.queuename", this.queueName);
        long seed = rand.nextLong();
        rand.setSeed(seed);
        this.id = sequence.getAndIncrement();
        this.name = String.format(jobClass.getClassName() + "_%06d", this.id);
        LOG.debug((Object)(this.name + " (" + seed + ")"));
        LOG.info((Object)("JOB TIMING`: job: " + this.name + " submission:" + this.submitTime + " deadline:" + this.deadline + " duration:" + this.duration + " deadline-submission: " + (this.deadline - this.submitTime)));
        this.mapRuntime = new long[this.numMapTasks];
        for (i = 0; i < this.numMapTasks; ++i) {
            this.mapRuntime[i] = jobClass.getMapTimeSample();
            this.totMapRuntime += this.mapRuntime[i];
        }
        this.reduceRuntime = new float[this.numRedTasks];
        for (i = 0; i < this.numRedTasks; ++i) {
            this.reduceRuntime[i] = jobClass.getReduceTimeSample();
            this.totRedRuntime += (long)Math.ceil(this.reduceRuntime[i]);
        }
    }

    public boolean hasDeadline() {
        return this.deadline > 0L;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.jobClass.getUserName();
    }

    public JobID getJobID() {
        return new JobID("job_mock_" + this.name, this.id);
    }

    public Pre21JobHistoryConstants.Values getOutcome() {
        return Pre21JobHistoryConstants.Values.SUCCESS;
    }

    public long getSubmissionTime() {
        return this.submitTime;
    }

    public int getNumberMaps() {
        return this.numMapTasks;
    }

    public int getNumberReduces() {
        return this.numRedTasks;
    }

    public TaskInfo getTaskInfo(TaskType taskType, int taskNumber) {
        switch (taskType) {
            case MAP: {
                return new TaskInfo(-1L, -1, -1L, -1, this.mapMaxMemory, this.mapMaxVcores);
            }
            case REDUCE: {
                return new TaskInfo(-1L, -1, -1L, -1, this.reduceMaxMemory, this.reduceMaxVcores);
            }
        }
        throw new IllegalArgumentException("Not interested");
    }

    public InputSplit[] getInputSplits() {
        throw new UnsupportedOperationException();
    }

    public TaskAttemptInfo getTaskAttemptInfo(TaskType taskType, int taskNumber, int taskAttemptNumber) {
        switch (taskType) {
            case MAP: {
                return new MapTaskAttemptInfo(TaskStatus.State.SUCCEEDED, this.getTaskInfo(taskType, taskNumber), this.mapRuntime[taskNumber], null);
            }
            case REDUCE: {
                return new ReduceTaskAttemptInfo(TaskStatus.State.SUCCEEDED, this.getTaskInfo(taskType, taskNumber), (long)Math.round(this.reduceRuntime[taskNumber] / 3.0f), (long)Math.round(this.reduceRuntime[taskNumber] / 3.0f), (long)Math.round(this.reduceRuntime[taskNumber] / 3.0f), null);
            }
        }
        throw new UnsupportedOperationException();
    }

    public TaskAttemptInfo getMapTaskAttemptInfoAdjusted(int taskNumber, int taskAttemptNumber, int locality) {
        throw new UnsupportedOperationException();
    }

    public JobConf getJobConf() {
        return new JobConf(this.conf);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String toString() {
        return "SynthJob [\n  workload=" + this.jobClass.getWorkload().getId() + "\n" + "  jobClass=" + this.jobClass.getWorkload().getClassList().indexOf(this.jobClass) + "\n" + "  conf=" + this.conf + ",\n" + "  id=" + this.id + ",\n" + "  name=" + this.name + ",\n" + "  mapRuntime=" + Arrays.toString(this.mapRuntime) + ",\n" + "  reduceRuntime=" + Arrays.toString(this.reduceRuntime) + ",\n" + "  submitTime=" + this.submitTime + ",\n" + "  numMapTasks=" + this.numMapTasks + ",\n" + "  numRedTasks=" + this.numRedTasks + ",\n" + "  mapMaxMemory=" + this.mapMaxMemory + ",\n" + "  reduceMaxMemory=" + this.reduceMaxMemory + ",\n" + "  queueName=" + this.queueName + "\n" + "]";
    }

    public SynthJobClass getJobClass() {
        return this.jobClass;
    }

    public long getTotalSlotTime() {
        return this.totMapRuntime + this.totRedRuntime;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SynthJob)) {
            return false;
        }
        SynthJob o = (SynthJob)other;
        return Arrays.equals(this.mapRuntime, o.mapRuntime) && Arrays.equals(this.reduceRuntime, o.reduceRuntime) && this.submitTime == o.submitTime && this.numMapTasks == o.numMapTasks && this.numRedTasks == o.numRedTasks && this.mapMaxMemory == o.mapMaxMemory && this.reduceMaxMemory == o.reduceMaxMemory && this.mapMaxVcores == o.mapMaxVcores && this.reduceMaxVcores == o.reduceMaxVcores && this.queueName.equals(o.queueName) && this.jobClass.equals(o.jobClass) && this.totMapRuntime == o.totMapRuntime && this.totRedRuntime == o.totRedRuntime;
    }

    public int hashCode() {
        return this.jobClass.hashCode() * (int)this.submitTime;
    }
}

